/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple7;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.Zippable$;
import zio.logging.FileLoggerConfig;
import zio.logging.FileLoggerConfig$FileRollingPolicy$;
import zio.logging.LogFilter;
import zio.logging.LogFilter$LogLevelByNameConfig$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$;
import zio.logging.package$;
import zio.package;
import zio.prelude.Equal;
import zio.prelude.Equal$;

public final class FileLoggerConfig$
implements Serializable {
    public static final FileLoggerConfig$ MODULE$ = new FileLoggerConfig$();
    private static final Config<FileLoggerConfig> config;
    private static final Equal<FileLoggerConfig> equal;

    static {
        Config autoFlushBatchSizeConfig = Config$.MODULE$.int().nested((Function0 & Serializable)() -> "autoFlushBatchSize").withDefault((Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Config bufferedIOSizeConfig = Config$.MODULE$.int().nested((Function0 & Serializable)() -> "bufferedIOSize").optional();
        Config filterConfig = LogFilter$LogLevelByNameConfig$.MODULE$.config().nested((Function0 & Serializable)() -> "filter");
        Config charsetConfig = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)value -> MODULE$.charsetValue((String)value)).nested((Function0 & Serializable)() -> "charset").withDefault((Function0 & Serializable)() -> StandardCharsets.UTF_8);
        Config pathConfig = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)value -> MODULE$.pathValue((String)value)).nested((Function0 & Serializable)() -> "path");
        Config formatConfig = LogFormat$.MODULE$.config().nested((Function0 & Serializable)() -> "format").withDefault((Function0 & Serializable)() -> LogFormat$.MODULE$.default());
        Config rollingPolicyConfig = FileLoggerConfig$FileRollingPolicy$.MODULE$.config().nested((Function0 & Serializable)() -> "rollingPolicy").optional();
        config = pathConfig.$plus$plus((Function0 & Serializable)() -> formatConfig, Zippable$.MODULE$.Zippable2()).$plus$plus((Function0 & Serializable)() -> filterConfig, Zippable$.MODULE$.Zippable3()).$plus$plus((Function0 & Serializable)() -> charsetConfig, Zippable$.MODULE$.Zippable4()).$plus$plus((Function0 & Serializable)() -> autoFlushBatchSizeConfig, Zippable$.MODULE$.Zippable5()).$plus$plus((Function0 & Serializable)() -> bufferedIOSizeConfig, Zippable$.MODULE$.Zippable6()).$plus$plus((Function0 & Serializable)() -> rollingPolicyConfig, Zippable$.MODULE$.Zippable7()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                LogFormat format = (LogFormat)x0$1._2();
                LogFilter.LogLevelByNameConfig filter = (LogFilter.LogLevelByNameConfig)x0$1._3();
                Charset charset = (Charset)x0$1._4();
                int autoFlushBatchSize = BoxesRunTime.unboxToInt((Object)x0$1._5());
                Option bufferedIOSize = (Option)x0$1._6();
                Option rollingPolicy = (Option)x0$1._7();
                return new FileLoggerConfig(path, format, filter, charset, autoFlushBatchSize, (Option<Object>)bufferedIOSize, (Option<FileLoggerConfig.FileRollingPolicy>)rollingPolicy);
            }
            throw new MatchError(null);
        });
        equal = Equal$.MODULE$.make((Function2 & Serializable)(l, r) -> BoxesRunTime.boxToBoolean((boolean)FileLoggerConfig$.$anonfun$equal$1(l, r)));
    }

    public Charset $lessinit$greater$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int $lessinit$greater$default$5() {
        return 1;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<FileLoggerConfig.FileRollingPolicy> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    private Either<Config.Error$.InvalidData, Charset> charsetValue(String value) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Charset.forName(value));
        if (try_ instanceof Success) {
            Charset v = (Charset)((Success)try_).value();
            return scala.package$.MODULE$.Right().apply((Object)v);
        }
        if (try_ instanceof Failure) {
            return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(30).append("Expected a Charset, but found ").append(value).toString()));
        }
        throw new MatchError((Object)try_);
    }

    private Either<Config.Error$.InvalidData, Path> pathValue(String value) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Paths.get(URI.create(value)));
        if (try_ instanceof Success) {
            Path v = (Path)((Success)try_).value();
            return scala.package$.MODULE$.Right().apply((Object)v);
        }
        if (try_ instanceof Failure) {
            return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(27).append("Expected a Path, but found ").append(value).toString()));
        }
        throw new MatchError((Object)try_);
    }

    public Config<FileLoggerConfig> config() {
        return config;
    }

    public Equal<FileLoggerConfig> equal() {
        return equal;
    }

    public ZIO<Object, Config.Error, FileLoggerConfig> load(NonEmptyChunk<String> configPath) {
        return ZIO$.MODULE$.config(this.config().nested((Function0 & Serializable)() -> (String)NonEmptyChunk$.MODULE$.toChunk(configPath).head(), (Seq)NonEmptyChunk$.MODULE$.toChunk(configPath).tail()), (Object)"zio.logging.FileLoggerConfig.load(FileLoggerConfig.scala:103)");
    }

    public NonEmptyChunk<String> load$default$1() {
        return package$.MODULE$.loggerConfigPath();
    }

    public ZLayer<Object, Config.Error, FileLoggerConfig> make(NonEmptyChunk<String> configPath) {
        return ZLayer$.MODULE$.fromZIO((Function0 & Serializable)() -> MODULE$.load(configPath), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(FileLoggerConfig.class, LightTypeTag$.MODULE$.parse(164138272, "\u0004\u0000\u0001\u001czio.logging.FileLoggerConfig\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001czio.logging.FileLoggerConfig\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 30))), (Object)"zio.logging.FileLoggerConfig.make(FileLoggerConfig.scala:108)");
    }

    public NonEmptyChunk<String> make$default$1() {
        return package$.MODULE$.loggerConfigPath();
    }

    public FileLoggerConfig apply(Path destination, LogFormat format, LogFilter.LogLevelByNameConfig filter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize, Option<FileLoggerConfig.FileRollingPolicy> rollingPolicy) {
        return new FileLoggerConfig(destination, format, filter, charset, autoFlushBatchSize, bufferedIOSize, rollingPolicy);
    }

    public Charset apply$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int apply$default$5() {
        return 1;
    }

    public Option<Object> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<FileLoggerConfig.FileRollingPolicy> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<Tuple7<Path, LogFormat, LogFilter.LogLevelByNameConfig, Charset, Object, Option<Object>, Option<FileLoggerConfig.FileRollingPolicy>>> unapply(FileLoggerConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.destination(), (Object)x$0.format(), (Object)x$0.filter(), (Object)x$0.charset(), (Object)BoxesRunTime.boxToInteger((int)x$0.autoFlushBatchSize()), x$0.bufferedIOSize(), x$0.rollingPolicy()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileLoggerConfig$.class);
    }

    public static final /* synthetic */ boolean $anonfun$equal$1(FileLoggerConfig l, FileLoggerConfig r) {
        Path path = l.destination();
        Path path2 = r.destination();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            Charset charset = l.charset();
            Charset charset2 = r.charset();
            if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null) && l.autoFlushBatchSize() == r.autoFlushBatchSize()) {
                Option<Object> option = l.bufferedIOSize();
                Option<Object> option2 = r.bufferedIOSize();
                if (!(option != null ? !option.equals(option2) : option2 != null)) {
                    Option<FileLoggerConfig.FileRollingPolicy> option3 = l.rollingPolicy();
                    Option<FileLoggerConfig.FileRollingPolicy> option4 = r.rollingPolicy();
                    if (!(option3 != null ? !option3.equals(option4) : option4 != null)) {
                        LogFormat logFormat = l.format();
                        LogFormat logFormat2 = r.format();
                        if (!(logFormat != null ? !logFormat.equals(logFormat2) : logFormat2 != null) && zio.prelude.package$.MODULE$.EqualOps((Object)l.filter()).$eq$eq$eq((Object)r.filter(), LogFilter$LogLevelByNameConfig$.MODULE$.equal())) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private FileLoggerConfig$() {
    }
}

