/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.Cause;
import zio.Config;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.ZLogger;
import zio.Zippable$;
import zio.logging.LogFilter$;
import zio.logging.LogFilter$LogLevelByNameConfig$;
import zio.logging.LogGroup;

public interface LogFilter<Message> {
    public static LogFilter<Object> acceptAll() {
        return LogFilter$.MODULE$.acceptAll();
    }

    public static LogFilter<Object> causeNonEmpty() {
        return LogFilter$.MODULE$.causeNonEmpty();
    }

    public static LogFilter<Object> logLevel(Function1<LogLevel, Object> function1) {
        return LogFilter$.MODULE$.logLevel(function1);
    }

    public static LogFilter<Object> logLevel(LogLevel logLevel) {
        return LogFilter$.MODULE$.logLevel(logLevel);
    }

    public static <M> LogFilter<M> logLevelByGroup(LogGroup<M, String> logGroup, LogLevelByNameConfig logLevelByNameConfig) {
        return LogFilter$.MODULE$.logLevelByGroup(logGroup, logLevelByNameConfig);
    }

    public static <M, A> LogFilter<M> logLevelByGroup(LogLevel logLevel, LogGroup<M, A> logGroup, Function2<A, A, Object> function2, Seq<Tuple2<A, LogLevel>> seq) {
        return LogFilter$.MODULE$.logLevelByGroup(logLevel, logGroup, function2, seq);
    }

    public static <M> LogFilter<M> logLevelByGroup(LogLevel logLevel, LogGroup<M, String> logGroup, Seq<Tuple2<String, LogLevel>> seq) {
        return LogFilter$.MODULE$.logLevelByGroup(logLevel, logGroup, seq);
    }

    public static <M> LogFilter<M> logLevelByName(LogLevel logLevel, Seq<Tuple2<String, LogLevel>> seq) {
        return LogFilter$.MODULE$.logLevelByName(logLevel, seq);
    }

    public static <M> LogFilter<M> logLevelByName(LogLevelByNameConfig logLevelByNameConfig) {
        return LogFilter$.MODULE$.logLevelByName(logLevelByNameConfig);
    }

    public static Ordering<Tuple2<List<String>, LogLevel>> nameLevelOrdering() {
        return LogFilter$.MODULE$.nameLevelOrdering();
    }

    public static Function1<String, List<String>> splitNameByDot() {
        return LogFilter$.MODULE$.splitNameByDot();
    }

    public static Function2<String, LogLevel, Tuple2<List<String>, LogLevel>> splitNameByDotAndLevel() {
        return LogFilter$.MODULE$.splitNameByDotAndLevel();
    }

    public LogGroup<Message, Object> group();

    public boolean predicate(Object var1);

    public static boolean apply$(LogFilter $this, Object trace, FiberId fiberId, LogLevel logLevel, Function0 message, Cause cause, FiberRefs context, List spans, Map annotations) {
        return $this.apply(trace, fiberId, logLevel, message, (Cause<Object>)cause, context, (List<LogSpan>)spans, (Map<String, String>)annotations);
    }

    default public boolean apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<Message> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
        Object v = this.group().apply(trace, fiberId, logLevel, message, cause, context, spans, annotations);
        return this.predicate(v);
    }

    public static LogFilter $amp$amp$(LogFilter $this, LogFilter other) {
        return $this.$amp$amp(other);
    }

    default public <M extends Message> LogFilter<M> $amp$amp(LogFilter<M> other) {
        return this.and(other);
    }

    public static LogFilter $bar$bar$(LogFilter $this, LogFilter other) {
        return $this.$bar$bar(other);
    }

    default public <M extends Message> LogFilter<M> $bar$bar(LogFilter<M> other) {
        return this.or(other);
    }

    public static LogFilter and$(LogFilter $this, LogFilter other) {
        return $this.and(other);
    }

    default public <M extends Message> LogFilter<M> and(LogFilter<M> other) {
        return LogFilter$.MODULE$.apply(this.group().$plus$plus(other.group(), Zippable$.MODULE$.Zippable2()), (Function1 & Serializable)v -> {
            Tuple2 tuple2 = v;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object v1 = tuple2._1();
            Object v2 = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(v1, v2);
            Object v12 = tuple22._1();
            Object v22 = tuple22._2();
            return this.predicate(v12) && other.predicate(v22);
        });
    }

    public static LogFilter cached$(LogFilter $this) {
        return $this.cached();
    }

    default public LogFilter<Message> cached() {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        return LogFilter$.MODULE$.apply(this.group(), (Function1 & Serializable)v -> BoxesRunTime.unboxToBoolean((Object)cache.computeIfAbsent(v, _$1 -> this.predicate(v))));
    }

    public static LogFilter contramap$(LogFilter $this, Function1 f) {
        return $this.contramap(f);
    }

    default public <M> LogFilter<M> contramap(Function1<M, Message> f) {
        return LogFilter$.MODULE$.apply(this.group().contramap(f), (Function1 & Serializable)value -> this.predicate(value));
    }

    public static ZLogger filter$(LogFilter $this, ZLogger logger) {
        return $this.filter(logger);
    }

    default public <M extends Message, O> ZLogger<M, Option<O>> filter(ZLogger<M, O> logger) {
        return new ZLogger<M, Option<O>>(logger, this){
            private final ZLogger logger$1;
            private final /* synthetic */ LogFilter $outer;
            {
                this.logger$1 = logger$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Option apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0 message, Cause cause, FiberRefs context, List spans, Map annotations) {
                if (this.$outer.apply(trace, fiberId, logLevel, message, (Cause<Object>)cause, context, (List<LogSpan>)spans, (Map<String, String>)annotations)) {
                    return Some$.MODULE$.apply(this.logger$1.apply(trace, fiberId, logLevel, message, cause, context, spans, annotations));
                }
                return None$.MODULE$;
            }
        };
    }

    public static LogFilter not$(LogFilter $this) {
        return $this.not();
    }

    default public LogFilter<Message> not() {
        return LogFilter$.MODULE$.apply(this.group(), (Function1 & Serializable)v -> !this.predicate(v));
    }

    public static LogFilter or$(LogFilter $this, LogFilter other) {
        return $this.or(other);
    }

    default public <M extends Message> LogFilter<M> or(LogFilter<M> other) {
        return LogFilter$.MODULE$.apply(this.group().$plus$plus(other.group(), Zippable$.MODULE$.Zippable2()), (Function1 & Serializable)v -> {
            Tuple2 tuple2 = v;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object v1 = tuple2._1();
            Object v2 = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(v1, v2);
            Object v12 = tuple22._1();
            Object v22 = tuple22._2();
            return this.predicate(v12) || other.predicate(v22);
        });
    }

    public static LogFilter unary_$bang$(LogFilter $this) {
        return $this.unary_$bang();
    }

    default public LogFilter<Message> unary_$bang() {
        return this.not();
    }

    public static final class LogLevelByNameConfig
    implements Product,
    Serializable {
        private final LogLevel rootLevel;
        private final Map mappings;

        public static LogLevelByNameConfig apply(LogLevel logLevel, Map<String, LogLevel> map) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.apply(logLevel, map);
        }

        public static Config<LogLevelByNameConfig> config() {
            return LogFilter$LogLevelByNameConfig$.MODULE$.config();
        }

        public static LogLevelByNameConfig fromProduct(Product product) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.fromProduct(product);
        }

        public static LogLevelByNameConfig unapply(LogLevelByNameConfig logLevelByNameConfig) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.unapply(logLevelByNameConfig);
        }

        public LogLevelByNameConfig(LogLevel rootLevel, Map<String, LogLevel> mappings) {
            this.rootLevel = rootLevel;
            this.mappings = mappings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LogLevelByNameConfig)) return false;
            LogLevelByNameConfig logLevelByNameConfig = (LogLevelByNameConfig)object;
            LogLevel logLevel = this.rootLevel();
            LogLevel logLevel2 = logLevelByNameConfig.rootLevel();
            if (logLevel == null) {
                if (logLevel2 != null) {
                    return false;
                }
            } else if (!logLevel.equals(logLevel2)) return false;
            Map<String, LogLevel> map = this.mappings();
            Map<String, LogLevel> map2 = logLevelByNameConfig.mappings();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LogLevelByNameConfig;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LogLevelByNameConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "rootLevel";
            }
            if (1 == n2) {
                return "mappings";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogLevel rootLevel() {
            return this.rootLevel;
        }

        public Map<String, LogLevel> mappings() {
            return this.mappings;
        }

        public LogLevelByNameConfig copy(LogLevel rootLevel, Map<String, LogLevel> mappings) {
            return new LogLevelByNameConfig(rootLevel, mappings);
        }

        public LogLevel copy$default$1() {
            return this.rootLevel();
        }

        public Map<String, LogLevel> copy$default$2() {
            return this.mappings();
        }

        public LogLevel _1() {
            return this.rootLevel();
        }

        public Map<String, LogLevel> _2() {
            return this.mappings();
        }
    }
}

