/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple7;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.Zippable$;
import zio.logging.FileLoggerConfig;
import zio.logging.FileLoggerConfig$FileRollingPolicy$;
import zio.logging.LogFilter;
import zio.logging.LogFilter$;
import zio.logging.LogFilter$LogLevelByNameConfig$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$;

public final class FileLoggerConfig$
implements Mirror.Product,
Serializable {
    public static final FileLoggerConfig$FileRollingPolicy$ FileRollingPolicy;
    private static final Config config;
    public static final FileLoggerConfig$ MODULE$;

    private FileLoggerConfig$() {
    }

    static {
        MODULE$ = new FileLoggerConfig$();
        Config autoFlushBatchSizeConfig = Config$.MODULE$.int().nested(MODULE$::$anonfun$1).withDefault(MODULE$::$anonfun$2);
        Config bufferedIOSizeConfig = Config$.MODULE$.int().nested(MODULE$::$anonfun$3).optional();
        Config filterConfig = LogFilter$LogLevelByNameConfig$.MODULE$.config().nested(MODULE$::$anonfun$4);
        Config charsetConfig = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)value -> this.charsetValue((String)value)).nested(MODULE$::$anonfun$6).withDefault(MODULE$::$anonfun$7);
        Config pathConfig = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)value -> this.pathValue((String)value)).nested(MODULE$::$anonfun$9);
        Config formatConfig = LogFormat$.MODULE$.config().nested(MODULE$::$anonfun$10).withDefault(MODULE$::$anonfun$11);
        Config rollingPolicyConfig = FileLoggerConfig$FileRollingPolicy$.MODULE$.config().nested(MODULE$::$anonfun$12).optional();
        config = pathConfig.$plus$plus(() -> MODULE$.$init$$$anonfun$1(formatConfig), Zippable$.MODULE$.Zippable2()).$plus$plus(() -> MODULE$.$init$$$anonfun$2(filterConfig), Zippable$.MODULE$.Zippable3()).$plus$plus(() -> MODULE$.$init$$$anonfun$3(charsetConfig), Zippable$.MODULE$.Zippable4()).$plus$plus(() -> MODULE$.$init$$$anonfun$4(autoFlushBatchSizeConfig), Zippable$.MODULE$.Zippable5()).$plus$plus(() -> MODULE$.$init$$$anonfun$5(bufferedIOSizeConfig), Zippable$.MODULE$.Zippable6()).$plus$plus(() -> MODULE$.$init$$$anonfun$6(rollingPolicyConfig), Zippable$.MODULE$.Zippable7()).map((Function1 & Serializable)x$1 -> {
            Tuple7 tuple7 = x$1;
            if (tuple7 != null) {
                Path path = (Path)tuple7._1();
                LogFormat format = (LogFormat)tuple7._2();
                LogFilter.LogLevelByNameConfig filterConfig = (LogFilter.LogLevelByNameConfig)tuple7._3();
                Charset charset = (Charset)tuple7._4();
                int autoFlushBatchSize = BoxesRunTime.unboxToInt((Object)tuple7._5());
                Option bufferedIOSize = (Option)tuple7._6();
                Option rollingPolicy = (Option)tuple7._7();
                return this.apply(path, format, LogFilter$.MODULE$.logLevelByName(filterConfig), charset, autoFlushBatchSize, (Option<Object>)bufferedIOSize, (Option<FileLoggerConfig.FileRollingPolicy>)rollingPolicy);
            }
            throw new MatchError((Object)tuple7);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileLoggerConfig$.class);
    }

    public FileLoggerConfig apply(Path destination, LogFormat format, LogFilter<String> filter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize, Option<FileLoggerConfig.FileRollingPolicy> rollingPolicy) {
        return new FileLoggerConfig(destination, format, filter, charset, autoFlushBatchSize, bufferedIOSize, rollingPolicy);
    }

    public FileLoggerConfig unapply(FileLoggerConfig x$1) {
        return x$1;
    }

    public String toString() {
        return "FileLoggerConfig";
    }

    public Charset $lessinit$greater$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int $lessinit$greater$default$5() {
        return 1;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<FileLoggerConfig.FileRollingPolicy> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    private Either<Config.Error$.InvalidData, Charset> charsetValue(String value) {
        Try try_ = Try$.MODULE$.apply(() -> this.charsetValue$$anonfun$1(value));
        if (try_ instanceof Success) {
            Charset v = (Charset)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)v);
        }
        if (try_ instanceof Failure) {
            return package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(Chunk$.MODULE$.empty(), new StringBuilder(30).append("Expected a Charset, but found ").append(value).toString()));
        }
        throw new MatchError((Object)try_);
    }

    private Either<Config.Error$.InvalidData, Path> pathValue(String value) {
        Try try_ = Try$.MODULE$.apply(() -> this.pathValue$$anonfun$1(value));
        if (try_ instanceof Success) {
            Path v = (Path)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)v);
        }
        if (try_ instanceof Failure) {
            return package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(Chunk$.MODULE$.empty(), new StringBuilder(27).append("Expected a Path, but found ").append(value).toString()));
        }
        throw new MatchError((Object)try_);
    }

    public Config<FileLoggerConfig> config() {
        return config;
    }

    public FileLoggerConfig fromProduct(Product x$0) {
        return new FileLoggerConfig((Path)x$0.productElement(0), (LogFormat)x$0.productElement(1), (LogFilter)x$0.productElement(2), (Charset)x$0.productElement(3), BoxesRunTime.unboxToInt((Object)x$0.productElement(4)), (Option<Object>)((Option)x$0.productElement(5)), (Option<FileLoggerConfig.FileRollingPolicy>)((Option)x$0.productElement(6)));
    }

    private final String $anonfun$1() {
        return "autoFlushBatchSize";
    }

    private final int $anonfun$2() {
        return 1;
    }

    private final String $anonfun$3() {
        return "bufferedIOSize";
    }

    private final String $anonfun$4() {
        return "filter";
    }

    private final String $anonfun$6() {
        return "charset";
    }

    private final Charset $anonfun$7() {
        return StandardCharsets.UTF_8;
    }

    private final String $anonfun$9() {
        return "path";
    }

    private final String $anonfun$10() {
        return "format";
    }

    private final LogFormat $anonfun$11() {
        return LogFormat$.MODULE$.default();
    }

    private final String $anonfun$12() {
        return "rollingPolicy";
    }

    private final Config $init$$$anonfun$1(Config formatConfig$1) {
        return formatConfig$1;
    }

    private final Config $init$$$anonfun$2(Config filterConfig$1) {
        return filterConfig$1;
    }

    private final Config $init$$$anonfun$3(Config charsetConfig$1) {
        return charsetConfig$1;
    }

    private final Config $init$$$anonfun$4(Config autoFlushBatchSizeConfig$1) {
        return autoFlushBatchSizeConfig$1;
    }

    private final Config $init$$$anonfun$5(Config bufferedIOSizeConfig$1) {
        return bufferedIOSizeConfig$1;
    }

    private final Config $init$$$anonfun$6(Config rollingPolicyConfig$1) {
        return rollingPolicyConfig$1;
    }

    private final Charset charsetValue$$anonfun$1(String value$1) {
        return Charset.forName(value$1);
    }

    private final Path pathValue$$anonfun$1(String value$2) {
        return Paths.get(URI.create(value$2));
    }
}

