/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Trace$;
import zio.ZLogger;
import zio.logging.LogAnnotation;
import zio.logging.LogColor$;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$Pattern$;
import zio.logging.LoggerNameExtractor;
import zio.logging.internal.LogAppender;
import zio.logging.package$;
import zio.parser.Parser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LogFormat$
implements Serializable {
    public static final LogFormat$Pattern$ Pattern;
    private static final String NL;
    private static final Config config;
    private static final LogFormat bracketStart;
    private static final LogFormat bracketEnd;
    private static final LogFormat empty;
    private static final LogFormat enclosingClass;
    private static final LogFormat fiberId;
    private static final LogFormat level;
    private static final LogFormat levelSyslog;
    private static final LogFormat line;
    private static final LogFormat traceLine;
    private static final LogFormat cause;
    private static final LogFormat newLine;
    private static final LogFormat space;
    private static final LogFormat quote;
    private static final LogFormat timestamp;
    private static final LogFormat default;
    private static final LogFormat colored;
    public static final LogFormat$ MODULE$;

    private LogFormat$() {
    }

    static {
        MODULE$ = new LogFormat$();
        NL = System.lineSeparator();
        config = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)value -> {
            Either<Parser.ParserError<String>, LogFormat.Pattern> either = LogFormat$Pattern$.MODULE$.parse((String)value);
            if (either instanceof Right) {
                LogFormat.Pattern p = (LogFormat.Pattern)((Right)either).value();
                return scala.package$.MODULE$.Right().apply((Object)p.toLogFormat());
            }
            if (either instanceof Left) {
                return scala.package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(Chunk$.MODULE$.empty(), new StringBuilder(32).append("Expected a LogFormat, but found ").append((String)value).toString()));
            }
            throw new MatchError(either);
        });
        bracketStart = MODULE$.text((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$2));
        bracketEnd = MODULE$.text((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$3));
        empty = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(_$61, _$62, _$63, _$64, _$65, _$66, _$67, _$68, _$69) -> BoxedUnit.UNIT);
        enclosingClass = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, _$70, _$71, _$72, _$73, _$74, _$75, _$76) -> {
            Option option;
            Object object = trace;
            if (object != null && !(option = Trace$.MODULE$.unapply(object)).isEmpty()) {
                Tuple3 tuple3 = (Tuple3)option.get();
                String file = (String)tuple3._2();
                builder.appendText(file);
            } else {
                builder.appendText("not-available");
            }
            return BoxedUnit.UNIT;
        });
        LogFormat$.fiberId = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$77, fiberId, _$78, _$79, _$80, _$81, _$82, _$83) -> {
            builder.appendText(fiberId.threadName());
            return BoxedUnit.UNIT;
        });
        LogFormat$.level = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$84, _$85, level, _$86, _$87, _$88, _$89, _$90) -> {
            builder.appendText(level.label());
            return BoxedUnit.UNIT;
        });
        levelSyslog = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$91, _$92, level, _$93, _$94, _$95, _$96, _$97) -> {
            builder.appendText(BoxesRunTime.boxToInteger((int)level.syslog()).toString());
            return BoxedUnit.UNIT;
        });
        LogFormat$.line = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$98, _$99, _$100, line, _$101, _$102, _$103, _$104) -> {
            builder.appendText((String)line.apply());
            return BoxedUnit.UNIT;
        });
        traceLine = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, _$105, _$106, _$107, _$108, _$109, _$110, _$111) -> {
            block0: {
                Option option;
                Object object = trace;
                if (object == null || (option = Trace$.MODULE$.unapply(object)).isEmpty()) break block0;
                Tuple3 tuple3 = (Tuple3)option.get();
                int line = BoxesRunTime.unboxToInt((Object)tuple3._3());
                builder.appendNumeric(BoxesRunTime.boxToInteger((int)line));
            }
            return BoxedUnit.UNIT;
        });
        LogFormat$.cause = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$112, _$113, _$114, _$115, cause, _$116, _$117, _$118) -> {
            if (!cause.isEmpty()) {
                builder.appendCause((Cause<Object>)cause);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        newLine = MODULE$.text((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$12));
        space = MODULE$.text((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$13));
        quote = MODULE$.text((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$14));
        timestamp = MODULE$.timestamp((Function0<DateTimeFormatter>)((Function0 & Serializable)MODULE$::$init$$$anonfun$15));
        default = MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$16), MODULE$.timestamp().fixed(32)).$bar$minus$bar(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$17), MODULE$.level())).$bar$minus$bar(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$18), MODULE$.fiberId())).$bar$minus$bar(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$19), MODULE$.quoted(MODULE$.line())).$plus(MODULE$.space().$plus(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$20), MODULE$.cause())).filter(LogFilter$.MODULE$.causeNonEmpty())));
        colored = MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$21), MODULE$.timestamp().fixed(32)).color(LogColor$.MODULE$.BLUE()).$bar$minus$bar(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$22), MODULE$.level()).highlight()).$bar$minus$bar(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$23), MODULE$.fiberId()).color(LogColor$.MODULE$.WHITE())).$bar$minus$bar(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$24), MODULE$.quoted(MODULE$.line())).highlight().$plus(MODULE$.space().$plus(MODULE$.label((Function0<String>)((Function0 & Serializable)MODULE$::$init$$$anonfun$25), MODULE$.cause()).highlight()).filter(LogFilter$.MODULE$.causeNonEmpty())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogFormat$.class);
    }

    public Config<LogFormat> config() {
        return config;
    }

    public LogFormat make(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> format) {
        return builder -> new ZLogger<String, BoxedUnit>(format, builder){
            private final Function9 format$2;
            private final LogAppender builder$3;
            {
                this.format$2 = format$3;
                this.builder$3 = builder$10;
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0 message, Cause cause, FiberRefs context, List spans, Map annotations) {
                this.format$2.apply((Object)this.builder$3, trace, (Object)fiberId, (Object)logLevel, (Object)message, (Object)cause, (Object)context, (Object)spans, (Object)annotations);
            }
        };
    }

    public LogFormat loggerName(LoggerNameExtractor loggerNameExtractor, String loggerNameDefault) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, _$15, _$16, _$17, _$18, context, _$19, annotations) -> {
            String loggerName = (String)loggerNameExtractor.apply(trace, (FiberRefs)context, (Map<String, String>)annotations).getOrElse(() -> this.$anonfun$4(loggerNameDefault));
            builder.appendText(loggerName);
            return BoxedUnit.UNIT;
        });
    }

    public String loggerName$default$2() {
        return "zio-logger";
    }

    public LogFormat annotation(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$20, _$21, _$22, _$23, _$24, _$25, _$26, annotations) -> {
            annotations.get((Object)name).foreach((Function1)(JProcedure1 & Serializable)value -> builder.appendKeyValue(name, (String)value));
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat logAnnotation(LogAnnotation<A> ann) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$27, _$28, _$29, _$30, _$31, fiberRefs, _$32, _$33) -> {
            fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1)(JProcedure1 & Serializable)context -> context.get(ann).foreach((Function1)(JProcedure1 & Serializable)value -> builder.appendKeyValue(ann.name(), (String)ann.render().apply(value))));
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat annotation(LogAnnotation<A> ann) {
        return this.logAnnotation(ann);
    }

    public LogFormat anyAnnotation(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$34, _$35, _$36, _$37, _$38, fiberRefs, _$39, annotations) -> {
            annotations.get((Object)name).orElse(() -> this.anyAnnotation$$anonfun$1$$anonfun$1(name, fiberRefs)).foreach((Function1)(JProcedure1 & Serializable)value -> builder.appendKeyValue(name, (String)value));
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat annotations() {
        return this.annotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat annotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$41, _$42, _$43, _$44, _$45, _$46, _$47, annotations) -> {
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)((Iterable)annotations.filterNot((Function1 & Serializable)kv -> excludeKeys.contains(kv._1()))));
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat logAnnotations() {
        return this.logAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat logAnnotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$48, _$49, _$50, _$51, _$52, fiberRefs, _$53, _$54) -> {
            fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1)(JProcedure1 & Serializable)context -> builder.appendKeyValues((Iterable<Tuple2<String, String>>)((Iterable)context.asMap().filterNot((Function1 & Serializable)kv -> excludeKeys.contains(kv._1())))));
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat allAnnotations() {
        return this.allAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat allAnnotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$55, _$56, _$57, _$58, _$59, fiberRefs, _$60, annotations) -> {
            List keyValues = (List)((IterableOnceOps)annotations.filterNot((Function1 & Serializable)kv -> excludeKeys.contains(kv._1()))).toList().$plus$plus((IterableOnce)fiberRefs.get(package$.MODULE$.logContext()).map((Function1 & Serializable)context -> ((IterableOnceOps)context.asMap().filterNot((Function1 & Serializable)kv -> excludeKeys.contains(kv._1()))).toList()).getOrElse(this::$anonfun$7));
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)keyValues);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat bracketed(LogFormat inner) {
        return this.bracketStart().$plus(inner).$plus(this.bracketEnd());
    }

    public LogFormat bracketStart() {
        return bracketStart;
    }

    public LogFormat bracketEnd() {
        return bracketEnd;
    }

    public LogFormat empty() {
        return empty;
    }

    public LogFormat enclosingClass() {
        return enclosingClass;
    }

    public LogFormat fiberId() {
        return fiberId;
    }

    public LogFormat level() {
        return level;
    }

    public LogFormat levelSyslog() {
        return levelSyslog;
    }

    public LogFormat line() {
        return line;
    }

    public LogFormat traceLine() {
        return traceLine;
    }

    public LogFormat cause() {
        return cause;
    }

    public LogFormat ifCauseNonEmpty(LogFormat format) {
        return format.filter(LogFilter$.MODULE$.causeNonEmpty());
    }

    public LogFormat label(Function0<String> label, LogFormat value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, fiberId, logLevel, message, cause, context, spans, annotations) -> {
            Object object;
            builder.openKey();
            try {
                builder.appendText((String)label.apply());
            }
            finally {
                builder.closeKeyOpenValue();
            }
            try {
                object = value.unsafeFormat((LogAppender)builder).apply(trace, fiberId, logLevel, message, cause, context, spans, annotations);
            }
            finally {
                builder.closeValue();
            }
            return object;
        });
    }

    public LogFormat newLine() {
        return newLine;
    }

    public LogFormat space() {
        return space;
    }

    public LogFormat quote() {
        return quote;
    }

    public LogFormat quoted(LogFormat inner) {
        return this.quote().$plus(inner).$plus(this.quote());
    }

    public LogFormat span(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$119, _$120, _$121, _$122, _$123, _$124, spans, _$125) -> {
            spans.find((Function1 & Serializable)_$126 -> {
                String string = _$126.label();
                String string2 = name;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)span -> {
                String duration = BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - span.startTime())).toString();
                builder.appendKeyValue(name, new StringBuilder(2).append(duration).append("ms").toString());
            });
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat spans() {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$127, _$128, _$129, _$130, _$131, _$132, spans, _$133) -> {
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)spans.map((Function1 & Serializable)span -> {
                String duration = BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - span.startTime())).toString();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)span.label());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new StringBuilder(2).append(duration).append("ms").toString());
            }));
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat text(Function0<String> value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, _$134, _$135, _$136, _$137, _$138, _$139, _$140, _$141) -> {
            builder.appendText((String)value.apply());
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat timestamp() {
        return timestamp;
    }

    public LogFormat timestamp(Function0<DateTimeFormatter> formatter) {
        return this.text((Function0<String>)((Function0 & Serializable)() -> this.timestamp$$anonfun$1(formatter)));
    }

    public LogFormat default() {
        return default;
    }

    public LogFormat colored() {
        return colored;
    }

    private final String $init$$$anonfun$2() {
        return "[";
    }

    private final String $init$$$anonfun$3() {
        return "]";
    }

    private final String $init$$$anonfun$12() {
        return NL;
    }

    private final String $init$$$anonfun$13() {
        return " ";
    }

    private final String $init$$$anonfun$14() {
        return "\"";
    }

    private final DateTimeFormatter $init$$$anonfun$15() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    }

    private final String $init$$$anonfun$16() {
        return "timestamp";
    }

    private final String $init$$$anonfun$17() {
        return "level";
    }

    private final String $init$$$anonfun$18() {
        return "thread";
    }

    private final String $init$$$anonfun$19() {
        return "message";
    }

    private final String $init$$$anonfun$20() {
        return "cause";
    }

    private final String $init$$$anonfun$21() {
        return "timestamp";
    }

    private final String $init$$$anonfun$22() {
        return "level";
    }

    private final String $init$$$anonfun$23() {
        return "thread";
    }

    private final String $init$$$anonfun$24() {
        return "message";
    }

    private final String $init$$$anonfun$25() {
        return "cause";
    }

    private final String $anonfun$4(String loggerNameDefault$2) {
        return loggerNameDefault$2;
    }

    private final Option anyAnnotation$$anonfun$1$$anonfun$1(String name$4, FiberRefs fiberRefs$1) {
        return fiberRefs$1.get(package$.MODULE$.logContext()).flatMap((Function1 & Serializable)_$40 -> _$40.get(name$4));
    }

    private final List $anonfun$7() {
        return scala.package$.MODULE$.Nil();
    }

    private final String timestamp$$anonfun$1(Function0 formatter$2) {
        ZonedDateTime now = ZonedDateTime.now();
        return ((DateTimeFormatter)formatter$2.apply()).format(now);
    }
}

