/*
 * Decompiled with CFR 0.152.
 */
package zio.logging.internal;

import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import zio.logging.FileLoggerConfig;
import zio.logging.FileLoggerConfig$FileRollingPolicy$TimeBasedRollingPolicy$;
import zio.logging.internal.WriterProvider;
import zio.logging.internal.WriterProvider$SimpleWriterProvider$;
import zio.logging.internal.WriterProvider$TimeBasedRollingWriterProvider$;

public class FileWriter
extends Writer {
    private final int autoFlushBatchSize;
    private final WriterProvider writerProvider;
    private long entriesWritten;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileWriter(Path destination, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize, Option<FileLoggerConfig.FileRollingPolicy> rollingPolicy) {
        Product product;
        this.autoFlushBatchSize = autoFlushBatchSize;
        Option<FileLoggerConfig.FileRollingPolicy> option = rollingPolicy;
        if (option instanceof Some) {
            FileLoggerConfig.FileRollingPolicy policy = (FileLoggerConfig.FileRollingPolicy)((Some)option).value();
            FileLoggerConfig.FileRollingPolicy fileRollingPolicy = policy;
            if (!FileLoggerConfig$FileRollingPolicy$TimeBasedRollingPolicy$.MODULE$.equals(fileRollingPolicy)) throw new MatchError((Object)fileRollingPolicy);
            product = WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.apply(destination, charset, bufferedIOSize, WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.$lessinit$greater$default$4());
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            product = WriterProvider$SimpleWriterProvider$.MODULE$.apply(destination, charset, bufferedIOSize);
        }
        this.writerProvider = product;
        this.entriesWritten = 0L;
    }

    @Override
    public final void write(char[] buffer, int offset, int length) {
        this.writerProvider.writer().write(buffer, offset, length);
    }

    public final void writeln(String line) {
        Writer writer = this.writerProvider.writer();
        writer.write(line);
        writer.write(System.lineSeparator());
        ++this.entriesWritten;
        if (this.entriesWritten % (long)this.autoFlushBatchSize == 0L) {
            writer.flush();
            return;
        }
    }

    @Override
    public final void flush() {
        this.writerProvider.writer().flush();
    }

    @Override
    public final void close() {
        this.writerProvider.writer().close();
    }
}

