/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.Cause;
import zio.Config;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.NonEmptyChunk;
import zio.ZIO;
import zio.ZLogger;
import zio.Zippable$;
import zio.logging.FilteredLogger$;
import zio.logging.LogFilter$;
import zio.logging.LogFilter$AndFilter$;
import zio.logging.LogFilter$CachedFilter$;
import zio.logging.LogFilter$ConfiguredFilter$;
import zio.logging.LogFilter$GroupPredicateFilter$;
import zio.logging.LogFilter$LogLevelByNameConfig$;
import zio.logging.LogFilter$NotFilter$;
import zio.logging.LogFilter$OrFilter$;
import zio.logging.LogGroup;
import zio.prelude.Equal;

public interface LogFilter<Message> {
    public static LogFilter<Object> acceptAll() {
        return LogFilter$.MODULE$.acceptAll();
    }

    public static LogFilter<Object> causeNonEmpty() {
        return LogFilter$.MODULE$.causeNonEmpty();
    }

    public static Equal<LogFilter<?>> equal() {
        return LogFilter$.MODULE$.equal();
    }

    public static LogFilter<Object> logLevel(Function1<LogLevel, Object> function1) {
        return LogFilter$.MODULE$.logLevel(function1);
    }

    public static LogFilter<Object> logLevel(LogLevel logLevel) {
        return LogFilter$.MODULE$.logLevel(logLevel);
    }

    public static <M> LogFilter<M> logLevelByGroup(LogGroup<M, String> logGroup, LogLevelByNameConfig logLevelByNameConfig) {
        return LogFilter$.MODULE$.logLevelByGroup(logGroup, logLevelByNameConfig);
    }

    public static <M, A> LogFilter<M> logLevelByGroup(LogLevel logLevel, LogGroup<M, A> logGroup, Function2<A, A, Object> function2, Seq<Tuple2<A, LogLevel>> seq) {
        return LogFilter$.MODULE$.logLevelByGroup(logLevel, logGroup, function2, seq);
    }

    public static <M> LogFilter<M> logLevelByGroup(LogLevel logLevel, LogGroup<M, String> logGroup, Seq<Tuple2<String, LogLevel>> seq) {
        return LogFilter$.MODULE$.logLevelByGroup(logLevel, logGroup, seq);
    }

    public static <M> LogFilter<M> logLevelByName(LogLevel logLevel, Seq<Tuple2<String, LogLevel>> seq) {
        return LogFilter$.MODULE$.logLevelByName(logLevel, seq);
    }

    public static <M> LogFilter<M> logLevelByName(LogLevelByNameConfig logLevelByNameConfig) {
        return LogFilter$.MODULE$.logLevelByName(logLevelByNameConfig);
    }

    public static Ordering<Tuple2<List<String>, LogLevel>> nameLevelOrdering() {
        return LogFilter$.MODULE$.nameLevelOrdering();
    }

    public static Function2<List<String>, List<String>, Object> nameMatcher() {
        return LogFilter$.MODULE$.nameMatcher();
    }

    public static int ordinal(LogFilter<?> logFilter) {
        return LogFilter$.MODULE$.ordinal(logFilter);
    }

    public static Function1<String, List<String>> splitNameByDot() {
        return LogFilter$.MODULE$.splitNameByDot();
    }

    public static Function2<String, LogLevel, Tuple2<List<String>, LogLevel>> splitNameByDotAndLevel() {
        return LogFilter$.MODULE$.splitNameByDotAndLevel();
    }

    public LogGroup<Message, Object> group();

    public boolean predicate(Object var1);

    public static boolean apply$(LogFilter $this, Object trace, FiberId fiberId, LogLevel logLevel, Function0 message, Cause cause, FiberRefs context, List spans, Map annotations) {
        return $this.apply(trace, fiberId, logLevel, message, (Cause<Object>)cause, context, (List<LogSpan>)spans, (Map<String, String>)annotations);
    }

    default public boolean apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<Message> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
        Object v = this.group().apply(trace, fiberId, logLevel, message, cause, context, spans, annotations);
        return this.predicate(v);
    }

    public static LogFilter $amp$amp$(LogFilter $this, LogFilter other) {
        return $this.$amp$amp(other);
    }

    default public <M extends Message> LogFilter<M> $amp$amp(LogFilter<M> other) {
        return this.and(other);
    }

    public static LogFilter $bar$bar$(LogFilter $this, LogFilter other) {
        return $this.$bar$bar(other);
    }

    default public <M extends Message> LogFilter<M> $bar$bar(LogFilter<M> other) {
        return this.or(other);
    }

    public static LogFilter and$(LogFilter $this, LogFilter other) {
        return $this.and(other);
    }

    default public <M extends Message> LogFilter<M> and(LogFilter<M> other) {
        return LogFilter$AndFilter$.MODULE$.apply(this, other);
    }

    public static LogFilter cached$(LogFilter $this) {
        return $this.cached();
    }

    default public LogFilter<Message> cached() {
        LogFilter logFilter = this;
        if (logFilter instanceof CachedFilter) {
            LogFilter logFilter2;
            CachedFilter cachedFilter = LogFilter$CachedFilter$.MODULE$.unapply((CachedFilter)logFilter);
            LogFilter filter = logFilter2 = cachedFilter._1();
            return LogFilter$CachedFilter$.MODULE$.apply(filter);
        }
        return LogFilter$CachedFilter$.MODULE$.apply(this);
    }

    public static LogFilter contramap$(LogFilter $this, Function1 f) {
        return $this.contramap(f);
    }

    default public <M> LogFilter<M> contramap(Function1<M, Message> f) {
        return LogFilter$.MODULE$.apply(this.group().contramap(f), (Function1 & Serializable)value -> this.predicate(value));
    }

    public static ZLogger filter$(LogFilter $this, ZLogger logger) {
        return $this.filter(logger);
    }

    default public <M extends Message, O> ZLogger<M, Option<O>> filter(ZLogger<M, O> logger) {
        return FilteredLogger$.MODULE$.apply(logger, this);
    }

    public static LogFilter not$(LogFilter $this) {
        return $this.not();
    }

    default public LogFilter<Message> not() {
        return LogFilter$NotFilter$.MODULE$.apply(this);
    }

    public static LogFilter or$(LogFilter $this, LogFilter other) {
        return $this.or(other);
    }

    default public <M extends Message> LogFilter<M> or(LogFilter<M> other) {
        return LogFilter$OrFilter$.MODULE$.apply(this, other);
    }

    public static LogFilter unary_$bang$(LogFilter $this) {
        return $this.unary_$bang();
    }

    default public LogFilter<Message> unary_$bang() {
        return this.not();
    }

    public static final class AndFilter<M>
    implements LogFilter<M>,
    Product,
    Serializable {
        private final LogFilter first;
        private final LogFilter second;
        private final LogGroup group;

        public static Equal<AndFilter<?>> equal() {
            return LogFilter$AndFilter$.MODULE$.equal();
        }

        public static AndFilter<?> fromProduct(Product product) {
            return LogFilter$AndFilter$.MODULE$.fromProduct(product);
        }

        public static <M> AndFilter<M> unapply(AndFilter<M> andFilter) {
            return LogFilter$AndFilter$.MODULE$.unapply(andFilter);
        }

        public AndFilter(LogFilter<M> first, LogFilter<M> second) {
            this.first = first;
            this.second = second;
            this.group = first.group().$plus$plus(second.group(), Zippable$.MODULE$.Zippable2());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AndFilter)) return false;
            AndFilter andFilter = (AndFilter)object;
            LogFilter<M> logFilter = this.first();
            LogFilter<M> logFilter2 = andFilter.first();
            if (logFilter == null) {
                if (logFilter2 != null) {
                    return false;
                }
            } else if (!logFilter.equals(logFilter2)) return false;
            LogFilter<M> logFilter3 = this.second();
            LogFilter<M> logFilter4 = andFilter.second();
            if (logFilter3 == null) {
                if (logFilter4 == null) return true;
                return false;
            } else {
                if (!logFilter3.equals(logFilter4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AndFilter;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AndFilter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "first";
            }
            if (1 == n2) {
                return "second";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogFilter<M> first() {
            return this.first;
        }

        public LogFilter<M> second() {
            return this.second;
        }

        @Override
        public LogGroup<M, Tuple2<Object, Object>> group() {
            return this.group;
        }

        public boolean predicate(Tuple2<Object, Object> value) {
            Tuple2<Object, Object> tuple2 = value;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object v1 = tuple2._1();
            Object v2 = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(v1, v2);
            Object v12 = tuple22._1();
            Object v22 = tuple22._2();
            return this.first().predicate(v12) && this.second().predicate(v22);
        }

        public <M> AndFilter<M> copy(LogFilter<M> first, LogFilter<M> second) {
            return new AndFilter<M>(first, second);
        }

        public <M> LogFilter<M> copy$default$1() {
            return this.first();
        }

        public <M> LogFilter<M> copy$default$2() {
            return this.second();
        }

        public LogFilter<M> _1() {
            return this.first();
        }

        public LogFilter<M> _2() {
            return this.second();
        }
    }

    public static final class CachedFilter<M>
    implements LogFilter<M>,
    Product,
    Serializable {
        private final LogFilter filter;
        private final ConcurrentHashMap cache;

        public static Equal<CachedFilter<?>> equal() {
            return LogFilter$CachedFilter$.MODULE$.equal();
        }

        public static CachedFilter<?> fromProduct(Product product) {
            return LogFilter$CachedFilter$.MODULE$.fromProduct(product);
        }

        public static <M> CachedFilter<M> unapply(CachedFilter<M> cachedFilter) {
            return LogFilter$CachedFilter$.MODULE$.unapply(cachedFilter);
        }

        public CachedFilter(LogFilter<M> filter) {
            this.filter = filter;
            this.cache = new ConcurrentHashMap();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CachedFilter)) return false;
            CachedFilter cachedFilter = (CachedFilter)object;
            LogFilter<M> logFilter = this.filter();
            LogFilter<M> logFilter2 = cachedFilter.filter();
            if (logFilter != null) {
                if (!logFilter.equals(logFilter2)) return false;
                return true;
            }
            if (logFilter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CachedFilter;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CachedFilter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "filter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogFilter<M> filter() {
            return this.filter;
        }

        public ConcurrentHashMap<Object, Object> cache() {
            return this.cache;
        }

        @Override
        public LogGroup<M, Object> group() {
            return this.filter().group();
        }

        @Override
        public boolean predicate(Object value) {
            return BoxesRunTime.unboxToBoolean((Object)this.cache().computeIfAbsent(value, _$1 -> this.filter().predicate(value)));
        }

        public void clear() {
            this.cache().clear();
        }

        public <M> CachedFilter<M> copy(LogFilter<M> filter) {
            return new CachedFilter<M>(filter);
        }

        public <M> LogFilter<M> copy$default$1() {
            return this.filter();
        }

        public LogFilter<M> _1() {
            return this.filter();
        }
    }

    public static final class ConfiguredFilter<M, C>
    implements LogFilter<M>,
    Product,
    Serializable {
        private final Object config;
        private final Function1 make;
        private final LogFilter filter;

        public static Equal<ConfiguredFilter<?, ?>> equal() {
            return LogFilter$ConfiguredFilter$.MODULE$.equal();
        }

        public static ConfiguredFilter<?, ?> fromProduct(Product product) {
            return LogFilter$ConfiguredFilter$.MODULE$.fromProduct(product);
        }

        public static <M, C> ConfiguredFilter<M, C> unapply(ConfiguredFilter<M, C> configuredFilter) {
            return LogFilter$ConfiguredFilter$.MODULE$.unapply(configuredFilter);
        }

        public ConfiguredFilter(C config, Function1<C, LogFilter<M>> make) {
            this.config = config;
            this.make = make;
            this.filter = (LogFilter)make.apply(config);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConfiguredFilter)) return false;
            ConfiguredFilter configuredFilter = (ConfiguredFilter)object;
            if (!BoxesRunTime.equals(this.config(), configuredFilter.config())) return false;
            Function1<C, LogFilter<M>> function1 = this.make();
            Function1<C, LogFilter<M>> function12 = configuredFilter.make();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConfiguredFilter;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConfiguredFilter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "config";
            }
            if (1 == n2) {
                return "make";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public C config() {
            return (C)this.config;
        }

        public Function1<C, LogFilter<M>> make() {
            return this.make;
        }

        public LogFilter<M> filter() {
            return this.filter;
        }

        @Override
        public LogGroup<M, Object> group() {
            return this.filter().group();
        }

        @Override
        public boolean predicate(Object value) {
            return this.filter().predicate(value);
        }

        public ConfiguredFilter<M, C> witConfig(C newConfig) {
            return LogFilter$ConfiguredFilter$.MODULE$.apply(newConfig, this.make());
        }

        public <M, C> ConfiguredFilter<M, C> copy(C config, Function1<C, LogFilter<M>> make) {
            return new ConfiguredFilter<M, C>(config, make);
        }

        public <M, C> C copy$default$1() {
            return this.config();
        }

        public <M, C> Function1<C, LogFilter<M>> copy$default$2() {
            return this.make();
        }

        public C _1() {
            return this.config();
        }

        public Function1<C, LogFilter<M>> _2() {
            return this.make();
        }
    }

    public static final class GroupPredicateFilter<M, V>
    implements LogFilter<M>,
    Product,
    Serializable {
        private final LogGroup logGroup;
        private final Function1 valuePredicate;

        public static Equal<GroupPredicateFilter<?, ?>> equal() {
            return LogFilter$GroupPredicateFilter$.MODULE$.equal();
        }

        public static GroupPredicateFilter<?, ?> fromProduct(Product product) {
            return LogFilter$GroupPredicateFilter$.MODULE$.fromProduct(product);
        }

        public static <M, V> GroupPredicateFilter<M, V> unapply(GroupPredicateFilter<M, V> groupPredicateFilter) {
            return LogFilter$GroupPredicateFilter$.MODULE$.unapply(groupPredicateFilter);
        }

        public GroupPredicateFilter(LogGroup<M, V> logGroup, Function1<V, Object> valuePredicate) {
            this.logGroup = logGroup;
            this.valuePredicate = valuePredicate;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GroupPredicateFilter)) return false;
            GroupPredicateFilter groupPredicateFilter = (GroupPredicateFilter)object;
            LogGroup<M, V> logGroup = this.logGroup();
            LogGroup<M, V> logGroup2 = groupPredicateFilter.logGroup();
            if (logGroup == null) {
                if (logGroup2 != null) {
                    return false;
                }
            } else if (!logGroup.equals(logGroup2)) return false;
            Function1<V, Object> function1 = this.valuePredicate();
            Function1<V, Object> function12 = groupPredicateFilter.valuePredicate();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GroupPredicateFilter;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GroupPredicateFilter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "logGroup";
            }
            if (1 == n2) {
                return "valuePredicate";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogGroup<M, V> logGroup() {
            return this.logGroup;
        }

        public Function1<V, Object> valuePredicate() {
            return this.valuePredicate;
        }

        @Override
        public LogGroup<M, V> group() {
            return this.logGroup();
        }

        @Override
        public boolean predicate(V value) {
            return BoxesRunTime.unboxToBoolean((Object)this.valuePredicate().apply(value));
        }

        public <M, V> GroupPredicateFilter<M, V> copy(LogGroup<M, V> logGroup, Function1<V, Object> valuePredicate) {
            return new GroupPredicateFilter<M, V>(logGroup, valuePredicate);
        }

        public <M, V> LogGroup<M, V> copy$default$1() {
            return this.logGroup();
        }

        public <M, V> Function1<V, Object> copy$default$2() {
            return this.valuePredicate();
        }

        public LogGroup<M, V> _1() {
            return this.logGroup();
        }

        public Function1<V, Object> _2() {
            return this.valuePredicate();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LogLevelByNameConfig
    implements Product,
    Serializable {
        private final LogLevel rootLevel;
        private final Map mappings;

        public static LogLevelByNameConfig apply(LogLevel logLevel, Map<String, LogLevel> map) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.apply(logLevel, map);
        }

        public static LogLevelByNameConfig apply(LogLevel logLevel, Seq<Tuple2<String, LogLevel>> seq) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.apply(logLevel, seq);
        }

        public static Config<LogLevelByNameConfig> config() {
            return LogFilter$LogLevelByNameConfig$.MODULE$.config();
        }

        public static LogLevelByNameConfig default() {
            return LogFilter$LogLevelByNameConfig$.MODULE$.default();
        }

        public static Equal<LogLevelByNameConfig> equal() {
            return LogFilter$LogLevelByNameConfig$.MODULE$.equal();
        }

        public static LogLevelByNameConfig fromProduct(Product product) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.fromProduct(product);
        }

        public static ZIO<Object, Config.Error, LogLevelByNameConfig> load(NonEmptyChunk<String> nonEmptyChunk) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.load(nonEmptyChunk);
        }

        public static LogLevelByNameConfig unapply(LogLevelByNameConfig logLevelByNameConfig) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.unapply(logLevelByNameConfig);
        }

        public LogLevelByNameConfig(LogLevel rootLevel, Map<String, LogLevel> mappings) {
            this.rootLevel = rootLevel;
            this.mappings = mappings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LogLevelByNameConfig)) return false;
            LogLevelByNameConfig logLevelByNameConfig = (LogLevelByNameConfig)object;
            LogLevel logLevel = this.rootLevel();
            LogLevel logLevel2 = logLevelByNameConfig.rootLevel();
            if (logLevel == null) {
                if (logLevel2 != null) {
                    return false;
                }
            } else if (!logLevel.equals(logLevel2)) return false;
            Map<String, LogLevel> map = this.mappings();
            Map<String, LogLevel> map2 = logLevelByNameConfig.mappings();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LogLevelByNameConfig;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LogLevelByNameConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "rootLevel";
            }
            if (1 == n2) {
                return "mappings";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogLevel rootLevel() {
            return this.rootLevel;
        }

        public Map<String, LogLevel> mappings() {
            return this.mappings;
        }

        public LogLevelByNameConfig withRootLevel(LogLevel rootLevel) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.apply(rootLevel, this.mappings());
        }

        public LogLevelByNameConfig withMapping(String name, LogLevel level) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
            return LogFilter$LogLevelByNameConfig$.MODULE$.apply(this.rootLevel(), (Map<String, LogLevel>)((Map)this.mappings().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)level))));
        }

        public LogLevelByNameConfig withMappings(Map<String, LogLevel> mappings) {
            return LogFilter$LogLevelByNameConfig$.MODULE$.apply(this.rootLevel(), mappings);
        }

        public <M> LogFilter<M> toFilter() {
            return LogFilter$.MODULE$.logLevelByName(this);
        }

        public LogLevelByNameConfig copy(LogLevel rootLevel, Map<String, LogLevel> mappings) {
            return new LogLevelByNameConfig(rootLevel, mappings);
        }

        public LogLevel copy$default$1() {
            return this.rootLevel();
        }

        public Map<String, LogLevel> copy$default$2() {
            return this.mappings();
        }

        public LogLevel _1() {
            return this.rootLevel();
        }

        public Map<String, LogLevel> _2() {
            return this.mappings();
        }
    }

    public static final class NotFilter<M>
    implements LogFilter<M>,
    Product,
    Serializable {
        private final LogFilter filter;

        public static Equal<NotFilter<?>> equal() {
            return LogFilter$NotFilter$.MODULE$.equal();
        }

        public static NotFilter<?> fromProduct(Product product) {
            return LogFilter$NotFilter$.MODULE$.fromProduct(product);
        }

        public static <M> NotFilter<M> unapply(NotFilter<M> notFilter) {
            return LogFilter$NotFilter$.MODULE$.unapply(notFilter);
        }

        public NotFilter(LogFilter<M> filter) {
            this.filter = filter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotFilter)) return false;
            NotFilter notFilter = (NotFilter)object;
            LogFilter<M> logFilter = this.filter();
            LogFilter<M> logFilter2 = notFilter.filter();
            if (logFilter != null) {
                if (!logFilter.equals(logFilter2)) return false;
                return true;
            }
            if (logFilter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NotFilter;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NotFilter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "filter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogFilter<M> filter() {
            return this.filter;
        }

        @Override
        public LogGroup<M, Object> group() {
            return this.filter().group();
        }

        @Override
        public boolean predicate(Object value) {
            return !this.filter().predicate(value);
        }

        public <M> NotFilter<M> copy(LogFilter<M> filter) {
            return new NotFilter<M>(filter);
        }

        public <M> LogFilter<M> copy$default$1() {
            return this.filter();
        }

        public LogFilter<M> _1() {
            return this.filter();
        }
    }

    public static final class OrFilter<M>
    implements LogFilter<M>,
    Product,
    Serializable {
        private final LogFilter first;
        private final LogFilter second;
        private final LogGroup group;

        public static Equal<OrFilter<?>> equal() {
            return LogFilter$OrFilter$.MODULE$.equal();
        }

        public static OrFilter<?> fromProduct(Product product) {
            return LogFilter$OrFilter$.MODULE$.fromProduct(product);
        }

        public static <M> OrFilter<M> unapply(OrFilter<M> orFilter) {
            return LogFilter$OrFilter$.MODULE$.unapply(orFilter);
        }

        public OrFilter(LogFilter<M> first, LogFilter<M> second) {
            this.first = first;
            this.second = second;
            this.group = first.group().$plus$plus(second.group(), Zippable$.MODULE$.Zippable2());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OrFilter)) return false;
            OrFilter orFilter = (OrFilter)object;
            LogFilter<M> logFilter = this.first();
            LogFilter<M> logFilter2 = orFilter.first();
            if (logFilter == null) {
                if (logFilter2 != null) {
                    return false;
                }
            } else if (!logFilter.equals(logFilter2)) return false;
            LogFilter<M> logFilter3 = this.second();
            LogFilter<M> logFilter4 = orFilter.second();
            if (logFilter3 == null) {
                if (logFilter4 == null) return true;
                return false;
            } else {
                if (!logFilter3.equals(logFilter4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OrFilter;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OrFilter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "first";
            }
            if (1 == n2) {
                return "second";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LogFilter<M> first() {
            return this.first;
        }

        public LogFilter<M> second() {
            return this.second;
        }

        @Override
        public LogGroup<M, Tuple2<Object, Object>> group() {
            return this.group;
        }

        public boolean predicate(Tuple2<Object, Object> value) {
            Tuple2<Object, Object> tuple2 = value;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object v1 = tuple2._1();
            Object v2 = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(v1, v2);
            Object v12 = tuple22._1();
            Object v22 = tuple22._2();
            return this.first().predicate(v12) || this.second().predicate(v22);
        }

        public <M> OrFilter<M> copy(LogFilter<M> first, LogFilter<M> second) {
            return new OrFilter<M>(first, second);
        }

        public <M> LogFilter<M> copy$default$1() {
            return this.first();
        }

        public <M> LogFilter<M> copy$default$2() {
            return this.second();
        }

        public LogFilter<M> _1() {
            return this.first();
        }

        public LogFilter<M> _2() {
            return this.second();
        }
    }
}

