/*
 * Decompiled with CFR 0.152.
 */
package zio.logging.internal;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.logging.internal.WriterProvider$;
import zio.logging.internal.WriterProvider$SimpleWriterProvider$;
import zio.logging.internal.WriterProvider$TimeBasedRollingWriterProvider$;

public interface WriterProvider {
    public static int ordinal(WriterProvider writerProvider) {
        return WriterProvider$.MODULE$.ordinal(writerProvider);
    }

    public Writer writer();

    public static final class SimpleWriterProvider
    implements WriterProvider,
    Product,
    Serializable {
        private final Path destination;
        private final Charset charset;
        private final Option bufferedIOSize;
        private final Writer writer;

        public static SimpleWriterProvider apply(Path path, Charset charset, Option<Object> option) {
            return WriterProvider$SimpleWriterProvider$.MODULE$.apply(path, charset, option);
        }

        public static SimpleWriterProvider fromProduct(Product product) {
            return WriterProvider$SimpleWriterProvider$.MODULE$.fromProduct(product);
        }

        public static SimpleWriterProvider unapply(SimpleWriterProvider simpleWriterProvider) {
            return WriterProvider$SimpleWriterProvider$.MODULE$.unapply(simpleWriterProvider);
        }

        public SimpleWriterProvider(Path destination, Charset charset, Option<Object> bufferedIOSize) {
            Writer writer;
            this.destination = destination;
            this.charset = charset;
            this.bufferedIOSize = bufferedIOSize;
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(destination.toFile(), true), charset);
            Option<Object> option = bufferedIOSize;
            if (option instanceof Some) {
                int bufferSize = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                writer = new BufferedWriter(output, bufferSize);
            } else if (None$.MODULE$.equals(option)) {
                writer = output;
            } else {
                throw new MatchError(option);
            }
            this.writer = writer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SimpleWriterProvider)) return false;
            SimpleWriterProvider simpleWriterProvider = (SimpleWriterProvider)object;
            Path path = this.destination();
            Path path2 = simpleWriterProvider.destination();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            Charset charset = this.charset();
            Charset charset2 = simpleWriterProvider.charset();
            if (charset == null) {
                if (charset2 != null) {
                    return false;
                }
            } else if (!((Object)charset).equals(charset2)) return false;
            Option<Object> option = this.bufferedIOSize();
            Option<Object> option2 = simpleWriterProvider.bufferedIOSize();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SimpleWriterProvider;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SimpleWriterProvider";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "destination";
                }
                case 1: {
                    return "charset";
                }
                case 2: {
                    return "bufferedIOSize";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path destination() {
            return this.destination;
        }

        public Charset charset() {
            return this.charset;
        }

        public Option<Object> bufferedIOSize() {
            return this.bufferedIOSize;
        }

        @Override
        public Writer writer() {
            return this.writer;
        }

        public SimpleWriterProvider copy(Path destination, Charset charset, Option<Object> bufferedIOSize) {
            return new SimpleWriterProvider(destination, charset, bufferedIOSize);
        }

        public Path copy$default$1() {
            return this.destination();
        }

        public Charset copy$default$2() {
            return this.charset();
        }

        public Option<Object> copy$default$3() {
            return this.bufferedIOSize();
        }

        public Path _1() {
            return this.destination();
        }

        public Charset _2() {
            return this.charset();
        }

        public Option<Object> _3() {
            return this.bufferedIOSize();
        }
    }

    public static final class TimeBasedRollingWriterProvider
    implements WriterProvider,
    Product,
    Serializable {
        private final Path destination;
        private final Charset charset;
        private final Option bufferedIOSize;
        private final Function0 time;
        private LocalDateTime timeInUse;
        private Writer currentWriter;
        private final ReentrantLock lock;

        public static TimeBasedRollingWriterProvider apply(Path path, Charset charset, Option<Object> option, Function0<LocalDateTime> function0) {
            return WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.apply(path, charset, option, function0);
        }

        public static TimeBasedRollingWriterProvider fromProduct(Product product) {
            return WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.fromProduct(product);
        }

        public static Path makePath(Path path, LocalDateTime localDateTime) {
            return WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.makePath(path, localDateTime);
        }

        public static TimeBasedRollingWriterProvider unapply(TimeBasedRollingWriterProvider timeBasedRollingWriterProvider) {
            return WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.unapply(timeBasedRollingWriterProvider);
        }

        public static Function0<LocalDateTime> $lessinit$greater$default$4() {
            return WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.$lessinit$greater$default$4();
        }

        public TimeBasedRollingWriterProvider(Path destination, Charset charset, Option<Object> bufferedIOSize, Function0<LocalDateTime> time) {
            this.destination = destination;
            this.charset = charset;
            this.bufferedIOSize = bufferedIOSize;
            this.time = time;
            this.timeInUse = (LocalDateTime)time.apply();
            this.currentWriter = WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.zio$logging$internal$WriterProvider$TimeBasedRollingWriterProvider$$$makeWriter(WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.makePath(destination, this.timeInUse), charset, bufferedIOSize);
            this.lock = new ReentrantLock();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TimeBasedRollingWriterProvider)) return false;
            TimeBasedRollingWriterProvider timeBasedRollingWriterProvider = (TimeBasedRollingWriterProvider)object;
            Path path = this.destination();
            Path path2 = timeBasedRollingWriterProvider.destination();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            Charset charset = this.charset();
            Charset charset2 = timeBasedRollingWriterProvider.charset();
            if (charset == null) {
                if (charset2 != null) {
                    return false;
                }
            } else if (!((Object)charset).equals(charset2)) return false;
            Option<Object> option = this.bufferedIOSize();
            Option<Object> option2 = timeBasedRollingWriterProvider.bufferedIOSize();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Function0<LocalDateTime> function0 = this.time();
            Function0<LocalDateTime> function02 = timeBasedRollingWriterProvider.time();
            if (function0 == null) {
                if (function02 == null) return true;
                return false;
            } else {
                if (!function0.equals(function02)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TimeBasedRollingWriterProvider;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "TimeBasedRollingWriterProvider";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "destination";
                }
                case 1: {
                    return "charset";
                }
                case 2: {
                    return "bufferedIOSize";
                }
                case 3: {
                    return "time";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path destination() {
            return this.destination;
        }

        public Charset charset() {
            return this.charset;
        }

        public Option<Object> bufferedIOSize() {
            return this.bufferedIOSize;
        }

        public Function0<LocalDateTime> time() {
            return this.time;
        }

        @Override
        public Writer writer() {
            LocalDateTime newTime;
            LocalDateTime localDateTime = newTime = (LocalDateTime)this.time().apply();
            LocalDateTime localDateTime2 = this.timeInUse;
            if (localDateTime == null ? localDateTime2 != null : !((Object)localDateTime).equals(localDateTime2)) {
                this.lock.lock();
                try {
                    LocalDateTime localDateTime3 = newTime;
                    LocalDateTime localDateTime4 = this.timeInUse;
                    if (localDateTime3 == null ? localDateTime4 != null : !((Object)localDateTime3).equals(localDateTime4)) {
                        this.currentWriter.close();
                        this.currentWriter = WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.zio$logging$internal$WriterProvider$TimeBasedRollingWriterProvider$$$makeWriter(WriterProvider$TimeBasedRollingWriterProvider$.MODULE$.makePath(this.destination(), newTime), this.charset(), this.bufferedIOSize());
                        this.timeInUse = newTime;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return this.currentWriter;
        }

        public TimeBasedRollingWriterProvider copy(Path destination, Charset charset, Option<Object> bufferedIOSize, Function0<LocalDateTime> time) {
            return new TimeBasedRollingWriterProvider(destination, charset, bufferedIOSize, time);
        }

        public Path copy$default$1() {
            return this.destination();
        }

        public Charset copy$default$2() {
            return this.charset();
        }

        public Option<Object> copy$default$3() {
            return this.bufferedIOSize();
        }

        public Function0<LocalDateTime> copy$default$4() {
            return this.time();
        }

        public Path _1() {
            return this.destination();
        }

        public Charset _2() {
            return this.charset();
        }

        public Option<Object> _3() {
            return this.bufferedIOSize();
        }

        public Function0<LocalDateTime> _4() {
            return this.time();
        }
    }
}

