/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics.connectors.prometheus;

import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkLike;
import zio.ZIO;
import zio.ZIO$;
import zio.metrics.MetricKey;
import zio.metrics.MetricLabel;
import zio.metrics.MetricState;
import zio.metrics.connectors.MetricEvent;
import zio.metrics.connectors.prometheus.PrometheusEncoder;

public final class PrometheusEncoder$
implements Product,
Serializable {
    public static final PrometheusEncoder$ MODULE$ = new PrometheusEncoder$();

    static {
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ZIO<Object, Throwable, Chunk<String>> encode(MetricEvent event) {
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> MODULE$.encodeMetric((MetricKey<Object>)event.metricKey(), (MetricState<Object>)event.current(), event.timestamp()), (Object)"zio.metrics.connectors.prometheus.PrometheusEncoder.encode(PrometheusEncoder.scala:12)");
    }

    private Chunk<String> encodeMetric(MetricKey<Object> key, MetricState<Object> state, Instant timestamp) {
        String string;
        String name = key.name().replaceAll("[- \\.]", "_").trim();
        MetricState<Object> metricState = state;
        if (metricState instanceof MetricState.Counter) {
            string = "counter";
        } else if (metricState instanceof MetricState.Gauge) {
            string = "gauge";
        } else if (metricState instanceof MetricState.Histogram) {
            string = "histogram";
        } else if (metricState instanceof MetricState.Summary) {
            string = "summary";
        } else if (metricState instanceof MetricState.Frequency) {
            string = "counter";
        } else {
            throw new MatchError(metricState);
        }
        String prometheusType = string;
        String description = (String)key.description().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)d -> new StringBuilder(1).append(" ").append((String)d).toString());
        Chunk encodeHead = Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("# TYPE ").append(name).append(" ").append(prometheusType).toString(), new StringBuilder(7).append("# HELP ").append(name).append(description).toString()}));
        String encodeTimestamp = String.valueOf(BoxesRunTime.boxToLong((long)timestamp.toEpochMilli()));
        String baseLabels = PrometheusEncoder$.encodeLabels$1(key.tags());
        return encodeHead.$plus$plus(PrometheusEncoder$.encodeDetails$1(state, name, encodeTimestamp, baseLabels, key));
    }

    public String productPrefix() {
        return "PrometheusEncoder";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PrometheusEncoder$;
    }

    public int hashCode() {
        return -1366894414;
    }

    public String toString() {
        return "PrometheusEncoder";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PrometheusEncoder$.class);
    }

    private static final String encodeLabels$1(Set allLabels) {
        return (allLabels.isEmpty() ? new scala.collection.mutable.StringBuilder("") : ((scala.collection.mutable.StringBuilder)allLabels.foldLeft((Object)new scala.collection.mutable.StringBuilder(256).append("{"), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.mutable.StringBuilder sb = (scala.collection.mutable.StringBuilder)tuple2._1();
                MetricLabel l = (MetricLabel)tuple2._2();
                return sb.append(l.key()).append("=\"").append(l.value()).append("\",");
            }
            throw new MatchError((Object)tuple2);
        })).append("}")).result();
    }

    private static final String encodeExtraLabels$1(Set extraLabels, String baseLabels$1, MetricKey key$1) {
        if (extraLabels.isEmpty()) {
            return baseLabels$1;
        }
        return PrometheusEncoder$.encodeLabels$1((Set)key$1.tags().$plus$plus((IterableOnce)extraLabels));
    }

    private static final String encodeCounter$1(MetricState.Counter c, Seq extraLabels, String name$1, String encodeTimestamp$1, String baseLabels$1, MetricKey key$1) {
        return new StringBuilder(2).append(name$1).append(PrometheusEncoder$.encodeExtraLabels$1(extraLabels.toSet(), baseLabels$1, key$1)).append(" ").append(c.count()).append(" ").append(encodeTimestamp$1).toString();
    }

    private static final String encodeGauge$1(MetricState.Gauge g, String name$1, String baseLabels$1, String encodeTimestamp$1) {
        return new StringBuilder(2).append(name$1).append(baseLabels$1).append(" ").append(g.value()).append(" ").append(encodeTimestamp$1).toString();
    }

    private static final Chunk encodeHistogram$1(MetricState.Histogram h, String name$1, String encodeTimestamp$1, String baseLabels$1, MetricKey key$1) {
        return PrometheusEncoder$.encodeSamples$1(PrometheusEncoder$.sampleHistogram$1(h), "_bucket", name$1, encodeTimestamp$1, baseLabels$1, key$1);
    }

    private static final Chunk encodeSummary$1(MetricState.Summary s, String name$1, String encodeTimestamp$1, String baseLabels$1, MetricKey key$1) {
        return PrometheusEncoder$.encodeSamples$1(PrometheusEncoder$.sampleSummary$1(s), "", name$1, encodeTimestamp$1, baseLabels$1, key$1);
    }

    public static final /* synthetic */ String $anonfun$encodeMetric$5(double x$1) {
        return Double.toString(x$1);
    }

    private static final Chunk encodeSamples$1(PrometheusEncoder.SampleResult samples, String suffix, String name$1, String encodeTimestamp$1, String baseLabels$1, MetricKey key$1) {
        return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((scala.collection.mutable.StringBuilder)samples.buckets().foldLeft((Object)new scala.collection.mutable.StringBuilder(samples.buckets().size() * 100), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.mutable.StringBuilder sb = (scala.collection.mutable.StringBuilder)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Set l = (Set)tuple22._1();
                    Option v = (Option)tuple22._2();
                    return sb.append(name$1).append(suffix).append(PrometheusEncoder$.encodeExtraLabels$1(l, baseLabels$1, key$1)).append(" ").append((String)v.map((Function1 & Serializable)x$1 -> PrometheusEncoder$.$anonfun$encodeMetric$5(BoxesRunTime.unboxToDouble((Object)x$1))).getOrElse((Function0 & Serializable)() -> "NaN")).append(" ").append(encodeTimestamp$1).append("\n");
                }
            }
            throw new MatchError((Object)tuple2);
        })).toString(), new StringBuilder(6).append(name$1).append("_sum").append(baseLabels$1).append(" ").append(samples.sum()).append(" ").append(encodeTimestamp$1).toString(), new StringBuilder(8).append(name$1).append("_count").append(baseLabels$1).append(" ").append(samples.count()).append(" ").append(encodeTimestamp$1).toString(), new StringBuilder(6).append(name$1).append("_min").append(baseLabels$1).append(" ").append(samples.min()).append(" ").append(encodeTimestamp$1).toString(), new StringBuilder(6).append(name$1).append("_max").append(baseLabels$1).append(" ").append(samples.max()).append(" ").append(encodeTimestamp$1).toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$encodeMetric$7(Tuple2 x$2) {
        return x$2._1$mcD$sp() != Double.MAX_VALUE;
    }

    private static final PrometheusEncoder.SampleResult sampleHistogram$1(MetricState.Histogram h) {
        return new PrometheusEncoder.SampleResult(h.count(), h.sum(), h.min(), h.max(), (Chunk<Tuple2<Set<MetricLabel>, Option<Object>>>)((Chunk)((ChunkLike)h.buckets().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PrometheusEncoder$.$anonfun$encodeMetric$7(x$2))).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._1$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).map((Function1 & Serializable)s -> new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("le", String.valueOf(BoxesRunTime.boxToDouble((double)s._1$mcD$sp())))})), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)s._2$mcJ$sp())))).$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("le", "+Inf")}))), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)h.count()))))));
    }

    private static final PrometheusEncoder.SampleResult sampleSummary$1(MetricState.Summary s) {
        return new PrometheusEncoder.SampleResult(s.count(), s.sum(), s.min(), s.max(), (Chunk<Tuple2<Set<MetricLabel>, Option<Object>>>)s.quantiles().map((Function1 & Serializable)q -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("quantile", Double.toString(q._1$mcD$sp())), new MetricLabel("error", Double.toString(s.error()))}))), q._2())));
    }

    private static final Chunk encodeDetails$1(MetricState state$1, String name$1, String encodeTimestamp$1, String baseLabels$1, MetricKey key$1) {
        MetricState metricState = state$1;
        if (metricState instanceof MetricState.Counter) {
            MetricState.Counter counter = (MetricState.Counter)metricState;
            return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PrometheusEncoder$.encodeCounter$1(counter, (Seq)Nil$.MODULE$, name$1, encodeTimestamp$1, baseLabels$1, key$1)}));
        }
        if (metricState instanceof MetricState.Gauge) {
            MetricState.Gauge gauge = (MetricState.Gauge)metricState;
            return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PrometheusEncoder$.encodeGauge$1(gauge, name$1, baseLabels$1, encodeTimestamp$1)}));
        }
        if (metricState instanceof MetricState.Histogram) {
            MetricState.Histogram histogram = (MetricState.Histogram)metricState;
            return PrometheusEncoder$.encodeHistogram$1(histogram, name$1, encodeTimestamp$1, baseLabels$1, key$1);
        }
        if (metricState instanceof MetricState.Summary) {
            MetricState.Summary summary = (MetricState.Summary)metricState;
            return PrometheusEncoder$.encodeSummary$1(summary, name$1, encodeTimestamp$1, baseLabels$1, key$1);
        }
        if (metricState instanceof MetricState.Frequency) {
            MetricState.Frequency frequency = (MetricState.Frequency)metricState;
            return Chunk$.MODULE$.fromIterable((Iterable)frequency.occurrences().map((Function1 & Serializable)o -> PrometheusEncoder$.encodeCounter$1(new MetricState.Counter((double)o._2$mcJ$sp()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("bucket", (String)o._1())}), name$1, encodeTimestamp$1, baseLabels$1, key$1)));
        }
        throw new MatchError((Object)metricState);
    }

    private PrometheusEncoder$() {
    }
}

