/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics.connectors.statsd;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import jnr.unixsocket.UnixSocketAddress;
import scala.MatchError;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zio.Chunk;
import zio.ZIO;
import zio.metrics.connectors.statsd.DatagramSocketClient$;
import zio.metrics.connectors.statsd.DatagramSocketConfig;
import zio.metrics.connectors.statsd.SocketWriter;
import zio.metrics.connectors.statsd.StatsdClient;

public final class DatagramSocketClient {
    public static ZIO<DatagramSocketConfig, Nothing$, StatsdClient> make() {
        return DatagramSocketClient$.MODULE$.make();
    }

    public static class Live
    implements StatsdClient {
        private final SocketWriter writer;

        public Live(SocketWriter writer) {
            this.writer = writer;
        }

        @Override
        public long send(Chunk<Object> chunk) {
            Try<Object> try_ = this.writer.write(ByteBuffer.wrap((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
            if (try_ instanceof Success) {
                long value = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                return value;
            }
            if (try_ instanceof Failure) {
                return 0L;
            }
            throw new MatchError(try_);
        }
    }

    public static class UdsWriter
    implements SocketWriter {
        private final DatagramChannel channel;
        private final UnixSocketAddress address;

        public UdsWriter(DatagramChannel channel, UnixSocketAddress address) {
            this.channel = channel;
            this.address = address;
        }

        @Override
        public Try<Object> write(ByteBuffer byteBuffer) {
            return Try$.MODULE$.apply(() -> this.write$$anonfun$1(byteBuffer));
        }

        private final long write$$anonfun$1(ByteBuffer byteBuffer$1) {
            return this.channel.send(byteBuffer$1, (SocketAddress)this.address);
        }
    }
}

