/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics.connectors.statsd;

import java.io.Serializable;
import java.text.DecimalFormat;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.metrics.MetricKey;
import zio.metrics.MetricLabel;
import zio.metrics.MetricState;
import zio.metrics.connectors.MetricEvent;

public final class StatsdEncoder$
implements Product,
Serializable {
    public static final StatsdEncoder$ MODULE$ = new StatsdEncoder$();
    private static DecimalFormat format;
    private static final int BUF_PER_METRIC;
    private static volatile boolean bitmap$0;

    static {
        Product.$init$((Product)MODULE$);
        BUF_PER_METRIC = 128;
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    private int BUF_PER_METRIC() {
        return BUF_PER_METRIC;
    }

    public ZIO<Object, Throwable, Chunk<Object>> encode(MetricEvent event) {
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> MODULE$.encodeEvent(event), (Object)"zio.metrics.connectors.statsd.StatsdEncoder.encode(StatsdEncoder.scala:14)");
    }

    public Chunk<Object> encodeEvent(MetricEvent event) {
        StringBuilder stringBuilder;
        StringBuilder result = new StringBuilder(this.BUF_PER_METRIC());
        MetricState<Object> metricState = event.current();
        if (metricState instanceof MetricState.Counter) {
            stringBuilder = this.appendCounter(result, event);
        } else if (metricState instanceof MetricState.Gauge) {
            MetricState.Gauge gauge = (MetricState.Gauge)metricState;
            stringBuilder = this.appendGauge(result, event.metricKey(), gauge);
        } else if (metricState instanceof MetricState.Histogram) {
            MetricState.Histogram histogram = (MetricState.Histogram)metricState;
            stringBuilder = this.appendHistogram(result, event.metricKey(), histogram);
        } else if (metricState instanceof MetricState.Summary) {
            MetricState.Summary summary = (MetricState.Summary)metricState;
            stringBuilder = this.appendSummary(result, event.metricKey(), summary);
        } else if (metricState instanceof MetricState.Frequency) {
            MetricState.Frequency frequency = (MetricState.Frequency)metricState;
            stringBuilder = this.appendFrequency(result, event.metricKey(), frequency);
        } else {
            throw new MatchError(metricState);
        }
        return Chunk$.MODULE$.fromArray((Object)result.toString().getBytes());
    }

    private StringBuilder appendCounter(StringBuilder buf, MetricEvent event) {
        double d;
        MetricEvent metricEvent = event;
        if (metricEvent instanceof MetricEvent.New) {
            MetricEvent.New new_ = (MetricEvent.New)metricEvent;
            MetricState<Object> current = new_.current();
            d = ((MetricState.Counter)current).count();
        } else if (metricEvent instanceof MetricEvent.Unchanged) {
            d = 0.0;
        } else if (metricEvent instanceof MetricEvent.Updated) {
            MetricEvent.Updated updated = (MetricEvent.Updated)metricEvent;
            MetricState<Object> old = updated.oldState();
            MetricState<Object> current = updated.current();
            d = ((MetricState.Counter)current).count() - ((MetricState.Counter)old).count();
        } else {
            throw new MatchError((Object)metricEvent);
        }
        double delta = d;
        return this.appendMetric(buf, event.metricKey().name(), delta, "c", (Set<MetricLabel>)event.metricKey().tags(), (Seq<MetricLabel>)Nil$.MODULE$);
    }

    private StringBuilder appendGauge(StringBuilder buf, MetricKey<Object> key, MetricState.Gauge g) {
        return this.appendMetric(buf, key.name(), g.value(), "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)Nil$.MODULE$);
    }

    private StringBuilder appendHistogram(StringBuilder buf, MetricKey<Object> key, MetricState.Histogram h) {
        return (StringBuilder)h.buckets().foldLeft((Object)buf, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            StringBuilder cur;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    cur = (StringBuilder)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double boundary = tuple2._1$mcD$sp();
            long count = tuple2._2$mcJ$sp();
            String bucket = boundary < Double.MAX_VALUE ? Double.toString(boundary) : "Inf";
            StringBuilder stringBuilder = MODULE$.appendMetric(cur, key.name(), count, "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("le", bucket)}));
            return stringBuilder;
        });
    }

    private StringBuilder appendSummary(StringBuilder buf, MetricKey<Object> key, MetricState.Summary s) {
        return (StringBuilder)s.quantiles().foldLeft((Object)buf, (Function2 & Serializable)(x0$1, x1$1) -> {
            StringBuilder stringBuilder;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            StringBuilder cur = (StringBuilder)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            double q = tuple22._1$mcD$sp();
            Option v = (Option)tuple22._2();
            Option option = v;
            if (None$.MODULE$.equals(option)) {
                stringBuilder = cur;
                return stringBuilder;
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                double v2 = BoxesRunTime.unboxToDouble((Object)some.value());
                stringBuilder = MODULE$.appendMetric(buf, key.name(), v2, "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("quantile", Double.toString(q)), new MetricLabel("error", Double.toString(s.error()))}));
            }
            return stringBuilder;
        });
    }

    private StringBuilder appendFrequency(StringBuilder buf, MetricKey<Object> key, MetricState.Frequency f) {
        return (StringBuilder)f.occurrences().foldLeft((Object)buf, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            StringBuilder cur;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    cur = (StringBuilder)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String b = (String)tuple2._1();
            long c = tuple2._2$mcJ$sp();
            StringBuilder stringBuilder = MODULE$.appendMetric(cur, key.name(), c, "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{new MetricLabel("bucket", b)}));
            return stringBuilder;
        });
    }

    private StringBuilder appendMetric(StringBuilder buf, String name, double value, String metricType, Set<MetricLabel> tags, Seq<MetricLabel> extraTags) {
        StringBuilder tagBuf = new StringBuilder();
        StringBuilder withTags = this.appendTags(tagBuf, (Iterable<MetricLabel>)tags);
        StringBuilder withAllTags = this.appendTags(withTags, (Iterable<MetricLabel>)extraTags);
        StringBuilder withLF = buf.nonEmpty() ? buf.append("\n") : buf;
        StringBuilder withMetric = withLF.append(name).append(":").append(this.format().format(value)).append("|").append(metricType);
        return withAllTags.nonEmpty() ? withMetric.append("|#").append(tagBuf) : withMetric;
    }

    private StringBuilder appendTag(StringBuilder buf, MetricLabel tag) {
        Object object = buf.nonEmpty() ? buf.append(",") : BoxedUnit.UNIT;
        return buf.append(tag.key()).append(":").append(tag.value());
    }

    private StringBuilder appendTags(StringBuilder buf, Iterable<MetricLabel> tags) {
        return (StringBuilder)tags.foldLeft((Object)buf, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StringBuilder cur = (StringBuilder)tuple2._1();
            MetricLabel tag = (MetricLabel)tuple2._2();
            StringBuilder stringBuilder = MODULE$.appendTag(cur, tag);
            return stringBuilder;
        });
    }

    private DecimalFormat format$lzycompute() {
        StatsdEncoder$ statsdEncoder$ = this;
        synchronized (statsdEncoder$) {
            if (!bitmap$0) {
                format = new DecimalFormat("0.################");
                bitmap$0 = true;
            }
        }
        return format;
    }

    private DecimalFormat format() {
        return !bitmap$0 ? this.format$lzycompute() : format;
    }

    public String productPrefix() {
        return "StatsdEncoder";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StatsdEncoder$;
    }

    public int hashCode() {
        return 520522135;
    }

    public String toString() {
        return "StatsdEncoder";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StatsdEncoder$.class);
    }

    private StatsdEncoder$() {
    }
}

