/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics.connectors.internal;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import zio.DurationSyntax$;
import zio.Ref;
import zio.Schedule;
import zio.Schedule$;
import zio.Unsafe$;
import zio.ZIO;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricPair;
import zio.metrics.MetricState;
import zio.metrics.connectors.MetricEvent;
import zio.metrics.connectors.MetricEvent$;
import zio.metrics.connectors.MetricsConfig;
import zio.metrics.connectors.internal.MetricsClient$;
import zio.package$;

public abstract class MetricsClient {
    private final MetricsConfig metricsCfg;
    private final Ref<Set<MetricPair<MetricKeyType, Object>>> latestSnapshot;
    private final Function1<Iterable<MetricEvent>, ZIO<Object, Nothing$, BoxedUnit>> handler;

    public static ZIO<MetricsConfig, Nothing$, BoxedUnit> make(Function1<Iterable<MetricEvent>, ZIO<Object, Nothing$, BoxedUnit>> function1) {
        return MetricsClient$.MODULE$.make(function1);
    }

    public MetricsClient(MetricsConfig metricsCfg, Ref<Set<MetricPair<MetricKeyType, Object>>> latestSnapshot, Function1<Iterable<MetricEvent>, ZIO<Object, Nothing$, BoxedUnit>> handler) {
        this.metricsCfg = metricsCfg;
        this.latestSnapshot = latestSnapshot;
        this.handler = handler;
    }

    private ZIO<Object, Nothing$, BoxedUnit> update(Object trace) {
        return this.retrieveNext(trace).flatMap(this.handler, trace);
    }

    private ZIO<Object, Nothing$, Set<MetricEvent>> retrieveNext(Object trace) {
        return this.latestSnapshot.modify((Function1 & Serializable)old -> {
            Map<MetricKey<Object>, MetricState<Object>> oldMap = this.stateMap((Set<MetricPair<MetricKeyType, Object>>)old);
            Set next = (Set)Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> zio.internal.metrics.package$.MODULE$.metricRegistry().snapshot(u));
            Set<MetricEvent> res = this.events(oldMap, (Set<MetricPair<MetricKeyType, Object>>)next);
            return Tuple2$.MODULE$.apply(res, (Object)next);
        }, trace);
    }

    private Map<MetricKey<Object>, MetricState<Object>> stateMap(Set<MetricPair<MetricKeyType, Object>> metrics) {
        scala.collection.mutable.Map builder = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        for (MetricPair e : metrics) {
            builder.update((Object)e.metricKey(), (Object)e.metricState());
        }
        return builder.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Set<MetricEvent> events(Map<MetricKey<Object>, MetricState<Object>> oldState, Set<MetricPair<MetricKeyType, Object>> metrics) {
        return (Set)((IterableOps)metrics.map((Function1 & Serializable)mp -> MetricEvent$.MODULE$.make(mp.metricKey(), oldState.get((Object)mp.metricKey()), mp.metricState()))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    MetricEvent e = (MetricEvent)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    MetricEvent e = (MetricEvent)((Right)either).value();
                    return e;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public ZIO<Object, Nothing$, BoxedUnit> zio$metrics$connectors$internal$MetricsClient$$run(Object trace) {
        return this.update(trace).schedule(() -> this.run$$anonfun$1(trace), trace).forkDaemon(trace).unit(trace);
    }

    private final Schedule run$$anonfun$1(Object trace$1) {
        return Schedule$.MODULE$.duration(DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationInt(10))).$plus$plus(Schedule$.MODULE$.fixed(this.metricsCfg.interval()), trace$1);
    }
}

