/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.charset;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichFloat$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.IO$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.CharBuffer;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$;
import zio.nio.charset.CharsetEncoder;
import zio.nio.charset.CoderResult;
import zio.nio.charset.CoderResult$;
import zio.nio.charset.CoderResult$Overflow$;
import zio.nio.charset.CoderResult$Underflow$;
import zio.stream.ZTransducer;
import zio.stream.ZTransducer$;

public final class CharsetEncoder$ {
    public static final CharsetEncoder$ MODULE$ = new CharsetEncoder$();

    public java.nio.charset.CharsetEncoder fromJava(java.nio.charset.CharsetEncoder javaEncoder) {
        return javaEncoder;
    }

    public final float averageBytesPerChar$extension(java.nio.charset.CharsetEncoder $this) {
        return $this.averageBytesPerChar();
    }

    public final Charset charset$extension(java.nio.charset.CharsetEncoder $this) {
        return Charset$.MODULE$.fromJava($this.charset());
    }

    public final ZIO<Object, CharacterCodingException, ByteBuffer> encode$extension(java.nio.charset.CharsetEncoder $this, CharBuffer in) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(in.withJavaBuffer((Function1 & Serializable)jBuf -> IO$.MODULE$.effect((Function0 & Serializable)() -> Buffer$.MODULE$.byteFromJava($this.encode((java.nio.CharBuffer)jBuf))))), ClassTag$.MODULE$.apply(CharacterCodingException.class), CanFail$.MODULE$.canFail());
    }

    public final ZIO<Object, Nothing$, CoderResult> encode$extension(java.nio.charset.CharsetEncoder $this, CharBuffer in, ByteBuffer out, boolean endOfInput) {
        return in.withJavaBuffer((Function1 & Serializable)jIn -> out.withJavaBuffer((Function1 & Serializable)jOut -> IO$.MODULE$.effectTotal((Function0 & Serializable)() -> CoderResult$.MODULE$.fromJava($this.encode((java.nio.CharBuffer)jIn, (java.nio.ByteBuffer)jOut, endOfInput)))));
    }

    public final ZIO<Object, Nothing$, CoderResult> flush$extension(java.nio.charset.CharsetEncoder $this, ByteBuffer out) {
        return out.withJavaBuffer((Function1 & Serializable)jOut -> UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> CoderResult$.MODULE$.fromJava($this.flush((java.nio.ByteBuffer)jOut))));
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> malformedInputAction$extension(java.nio.charset.CharsetEncoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.malformedInputAction());
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onMalformedInput$extension(java.nio.charset.CharsetEncoder $this, CodingErrorAction errorAction) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.onMalformedInput(errorAction)).unit();
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> unmappableCharacterAction$extension(java.nio.charset.CharsetEncoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.unmappableCharacterAction());
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onUnmappableCharacter$extension(java.nio.charset.CharsetEncoder $this, CodingErrorAction errorAction) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.onUnmappableCharacter(errorAction)).unit();
    }

    public final float maxCharsPerByte$extension(java.nio.charset.CharsetEncoder $this) {
        return $this.maxBytesPerChar();
    }

    public final ZIO<Object, Nothing$, Chunk<Object>> replacement$extension(java.nio.charset.CharsetEncoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> Chunk$.MODULE$.fromArray((Object)$this.replacement()));
    }

    public final ZIO<Object, Nothing$, BoxedUnit> replaceWith$extension(java.nio.charset.CharsetEncoder $this, Chunk<Object> replacement) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.replaceWith((byte[])replacement.toArray((ClassTag)ClassTag$.MODULE$.Byte()))).unit();
    }

    public final ZIO<Object, Nothing$, BoxedUnit> reset$extension(java.nio.charset.CharsetEncoder $this) {
        return UIO$.MODULE$.effectTotal((Function0 & Serializable)() -> $this.reset()).unit();
    }

    public final ZTransducer<Object, CharacterCodingException, Object, Object> transducer$extension(java.nio.charset.CharsetEncoder $this, int bufSize) {
        ZManaged push = this.reset$extension($this).toManaged_().flatMap((Function1 & Serializable)x$8 -> Buffer$.MODULE$.char(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufSize / MODULE$.averageBytesPerChar$extension($this)))).toManaged_().flatMap((Function1 & Serializable)charBuffer -> Buffer$.MODULE$.byte(bufSize).toManaged_().map((Function1 & Serializable)byteBuffer -> (Function1 & Serializable)x$1 -> (ZIO)x$1.map((Function1 & Serializable)inChunk -> CharsetEncoder$.encodeChunk$1(inChunk, charBuffer, $this, byteBuffer)).getOrElse((Function0 & Serializable)() -> charBuffer.flip().$times$greater((Function0 & Serializable)() -> CharsetEncoder$.endOfInput$2($this, charBuffer, byteBuffer).flatMap((Function1 & Serializable)encodedBytes -> CharsetEncoder$.flushRemaining$1($this, byteBuffer, charBuffer).map((Function1 & Serializable)x$7 -> encodedBytes.$plus$plus(x$7)))).$less$times((Function0 & Serializable)() -> charBuffer.clear()).$less$times((Function0 & Serializable)() -> byteBuffer.clear())))));
        if (bufSize < 50) {
            return ZTransducer$.MODULE$.die((Function0 & Serializable)() -> new IllegalArgumentException(new StringBuilder(30).append("Buffer size is ").append(bufSize).append(", must be >= 50").toString()));
        }
        return ZTransducer$.MODULE$.apply(push);
    }

    public final int transducer$default$1$extension(java.nio.charset.CharsetEncoder $this) {
        return 5000;
    }

    public final int hashCode$extension(java.nio.charset.CharsetEncoder $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(java.nio.charset.CharsetEncoder $this, Object x$1) {
        boolean bl = x$1 instanceof CharsetEncoder;
        if (bl) {
            java.nio.charset.CharsetEncoder charsetEncoder = x$1 == null ? null : ((CharsetEncoder)x$1).javaEncoder();
            java.nio.charset.CharsetEncoder charsetEncoder2 = $this;
            if (!(charsetEncoder2 != null ? !charsetEncoder2.equals(charsetEncoder) : charsetEncoder != null)) {
                return true;
            }
        }
        return false;
    }

    private static final ZIO handleCoderResult$1(CoderResult coderResult, CharBuffer charBuffer$1, ByteBuffer byteBuffer$1) {
        ZIO zIO;
        boolean bl = CoderResult$Underflow$.MODULE$.equals(coderResult) ? true : CoderResult$Overflow$.MODULE$.equals(coderResult);
        if (bl) {
            zIO = charBuffer$1.compact().$times$greater((Function0 & Serializable)() -> byteBuffer$1.flip()).$times$greater((Function0 & Serializable)() -> byteBuffer$1.getChunk(byteBuffer$1.getChunk$default$1())).$less$times((Function0 & Serializable)() -> byteBuffer$1.clear());
        } else if (coderResult instanceof CoderResult.Malformed) {
            int length = ((CoderResult.Malformed)coderResult).length();
            zIO = IO$.MODULE$.fail((Function0 & Serializable)() -> new MalformedInputException(length));
        } else if (coderResult instanceof CoderResult.Unmappable) {
            int length = ((CoderResult.Unmappable)coderResult).length();
            zIO = IO$.MODULE$.fail((Function0 & Serializable)() -> new UnmappableCharacterException(length));
        } else {
            throw new MatchError((Object)coderResult);
        }
        return zIO;
    }

    public static final /* synthetic */ Tuple2 $anonfun$transducer$11(Chunk inChars$1, int bufRemaining) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = inChars$1.length() > bufRemaining ? inChars$1.splitAt(bufRemaining) : new Tuple2((Object)inChars$1, (Object)Chunk$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Chunk cfr_ignored_0 = (Chunk)tuple2._1();
        Chunk cfr_ignored_1 = (Chunk)tuple2._2();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)bufRemaining), (Object)tuple2);
    }

    private static final ZIO encodeChunk$1(Chunk inChars, CharBuffer charBuffer$1, java.nio.charset.CharsetEncoder $this$11, ByteBuffer byteBuffer$1) {
        return charBuffer$1.remaining().map((Function1 & Serializable)bufRemaining -> CharsetEncoder$.$anonfun$transducer$11(inChars, BoxesRunTime.unboxToInt((Object)bufRemaining))).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2;
            if (x$6 == null || (tuple2 = (Tuple2)x$6._2()) == null) {
                throw new MatchError(x$6);
            }
            Chunk decodeChars = (Chunk)tuple2._1();
            Chunk remainingChars = (Chunk)tuple2._2();
            ZIO zIO = charBuffer$1.putChunk(decodeChars).flatMap((Function1 & Serializable)x$5 -> charBuffer$1.flip().flatMap((Function1 & Serializable)x$4 -> MODULE$.encode$extension($this$11, charBuffer$1, byteBuffer$1, false).flatMap((Function1 & Serializable)result -> CharsetEncoder$.handleCoderResult$1(result, charBuffer$1, byteBuffer$1).flatMap((Function1 & Serializable)encodedBytes -> (remainingChars.isEmpty() ? IO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty()) : CharsetEncoder$.encodeChunk$1(remainingChars, charBuffer$1, $this$11, byteBuffer$1)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes))))));
            return zIO;
        });
    }

    private static final ZIO endOfInput$2(java.nio.charset.CharsetEncoder $this$11, CharBuffer charBuffer$1, ByteBuffer byteBuffer$1) {
        return MODULE$.encode$extension($this$11, charBuffer$1, byteBuffer$1, true).flatMap((Function1 & Serializable)result -> CharsetEncoder$.handleCoderResult$1(result, charBuffer$1, byteBuffer$1).flatMap((Function1 & Serializable)encodedBytes -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (coderResult != null && coderResult.equals(coderResult$Overflow$) ? CharsetEncoder$.endOfInput$2($this$11, charBuffer$1, byteBuffer$1) : IO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty())).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes));
        }));
    }

    private static final ZIO flushRemaining$1(java.nio.charset.CharsetEncoder $this$11, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1) {
        return MODULE$.flush$extension($this$11, byteBuffer$1).flatMap((Function1 & Serializable)result -> CharsetEncoder$.handleCoderResult$1(result, charBuffer$1, byteBuffer$1).flatMap((Function1 & Serializable)encodedBytes -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (coderResult != null && coderResult.equals(coderResult$Overflow$) ? CharsetEncoder$.flushRemaining$1($this$11, byteBuffer$1, charBuffer$1) : IO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty())).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes));
        }));
    }

    private CharsetEncoder$() {
    }
}

