/*
 * Decompiled with CFR 0.152.
 */
package zio.nio;

import java.nio.ByteOrder;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.UIO$;
import zio.ZIO;
import zio.nio.Buffer;
import zio.nio.CharBuffer;
import zio.nio.DoubleBuffer;
import zio.nio.FloatBuffer;
import zio.nio.IntBuffer;
import zio.nio.LongBuffer;
import zio.nio.ShortBuffer;

public class ByteBuffer
extends Buffer<Object> {
    private final java.nio.ByteBuffer buffer;

    public ByteBuffer(java.nio.ByteBuffer buffer) {
        this.buffer = buffer;
        super(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    @Override
    public java.nio.ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public final ZIO<Object, Nothing$, byte[]> array() {
        return UIO$.MODULE$.effectTotal(this::array$$anonfun$1);
    }

    @Override
    public final ZIO order() {
        return UIO$.MODULE$.effectTotal(this::order$$anonfun$1);
    }

    public ZIO order(ByteOrder o) {
        return UIO$.MODULE$.effectTotal(() -> this.order$$anonfun$2(o)).unit();
    }

    @Override
    public final ZIO slice() {
        return UIO$.MODULE$.effectTotal(this::slice$$anonfun$1);
    }

    @Override
    public final ZIO compact() {
        return UIO$.MODULE$.effectTotal(this::compact$$anonfun$1).unit();
    }

    @Override
    public final ZIO duplicate() {
        return UIO$.MODULE$.effectTotal(this::duplicate$$anonfun$1);
    }

    public <R, E, A> ZIO<R, E, A> withJavaBuffer(Function1<java.nio.ByteBuffer, ZIO<R, E, A>> f) {
        return (ZIO)f.apply((Object)this.buffer());
    }

    @Override
    public final ZIO get() {
        return UIO$.MODULE$.effectTotal(this::get$$anonfun$1);
    }

    @Override
    public final ZIO get(int i) {
        return UIO$.MODULE$.effectTotal(() -> this.get$$anonfun$2(i));
    }

    @Override
    public final ZIO<Object, Nothing$, Chunk<Object>> getChunk(int maxLength) {
        return UIO$.MODULE$.effectTotal(() -> this.getChunk$$anonfun$1(maxLength));
    }

    @Override
    public int getChunk$default$1() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final ZIO put(byte element) {
        return UIO$.MODULE$.effectTotal(() -> this.put$$anonfun$1(element)).unit();
    }

    @Override
    public final ZIO put(int index, byte element) {
        return UIO$.MODULE$.effectTotal(() -> this.put$$anonfun$2(index, element)).unit();
    }

    public ZIO putByteBuffer(ByteBuffer source) {
        return UIO$.MODULE$.effectTotal(() -> this.putByteBuffer$$anonfun$1(source)).unit();
    }

    @Override
    public final ZIO<Object, Nothing$, BoxedUnit> putChunkAll(Chunk<Object> chunk) {
        return UIO$.MODULE$.effectTotal(() -> this.putChunkAll$$anonfun$1(chunk)).unit();
    }

    @Override
    public final ZIO asReadOnlyBuffer() {
        return UIO$.MODULE$.effectTotal(this::asReadOnlyBuffer$$anonfun$1);
    }

    public final ZIO asCharBuffer() {
        return UIO$.MODULE$.effectTotal(this::asCharBuffer$$anonfun$1);
    }

    public final ZIO asDoubleBuffer() {
        return UIO$.MODULE$.effectTotal(this::asDoubleBuffer$$anonfun$1);
    }

    public final ZIO asFloatBuffer() {
        return UIO$.MODULE$.effectTotal(this::asFloatBuffer$$anonfun$1);
    }

    public final ZIO asIntBuffer() {
        return UIO$.MODULE$.effectTotal(this::asIntBuffer$$anonfun$1);
    }

    public final ZIO asLongBuffer() {
        return UIO$.MODULE$.effectTotal(this::asLongBuffer$$anonfun$1);
    }

    public final ZIO asShortBuffer() {
        return UIO$.MODULE$.effectTotal(this::asShortBuffer$$anonfun$1);
    }

    public final ZIO putChar(char value) {
        return UIO$.MODULE$.effectTotal(() -> this.putChar$$anonfun$1(value)).unit();
    }

    public final ZIO putChar(int index, char value) {
        return UIO$.MODULE$.effectTotal(() -> this.putChar$$anonfun$2(index, value)).unit();
    }

    public final ZIO putDouble(double value) {
        return UIO$.MODULE$.effectTotal(() -> this.putDouble$$anonfun$1(value)).unit();
    }

    public final ZIO putDouble(int index, double value) {
        return UIO$.MODULE$.effectTotal(() -> this.putDouble$$anonfun$2(index, value)).unit();
    }

    public final ZIO putFloat(float value) {
        return UIO$.MODULE$.effectTotal(() -> this.putFloat$$anonfun$1(value)).unit();
    }

    public final ZIO putFloat(int index, float value) {
        return UIO$.MODULE$.effectTotal(() -> this.putFloat$$anonfun$2(index, value)).unit();
    }

    public final ZIO putInt(int value) {
        return UIO$.MODULE$.effectTotal(() -> this.putInt$$anonfun$1(value)).unit();
    }

    public final ZIO putInt(int index, int value) {
        return UIO$.MODULE$.effectTotal(() -> this.putInt$$anonfun$2(index, value)).unit();
    }

    public final ZIO putLong(long value) {
        return UIO$.MODULE$.effectTotal(() -> this.putLong$$anonfun$1(value)).unit();
    }

    public final ZIO putLong(int index, long value) {
        return UIO$.MODULE$.effectTotal(() -> this.putLong$$anonfun$2(index, value)).unit();
    }

    public final ZIO putShort(short value) {
        return UIO$.MODULE$.effectTotal(() -> this.putShort$$anonfun$1(value)).unit();
    }

    public final ZIO putShort(int index, short value) {
        return UIO$.MODULE$.effectTotal(() -> this.putShort$$anonfun$2(index, value)).unit();
    }

    public final ZIO getChar() {
        return UIO$.MODULE$.effectTotal(this::getChar$$anonfun$1);
    }

    public final ZIO getChar(int index) {
        return UIO$.MODULE$.effectTotal(() -> this.getChar$$anonfun$2(index));
    }

    public final ZIO getDouble() {
        return UIO$.MODULE$.effectTotal(this::getDouble$$anonfun$1);
    }

    public final ZIO getDouble(int index) {
        return UIO$.MODULE$.effectTotal(() -> this.getDouble$$anonfun$2(index));
    }

    public final ZIO getFloat() {
        return UIO$.MODULE$.effectTotal(this::getFloat$$anonfun$1);
    }

    public final ZIO getFloat(int index) {
        return UIO$.MODULE$.effectTotal(() -> this.getFloat$$anonfun$2(index));
    }

    public final ZIO getInt() {
        return UIO$.MODULE$.effectTotal(this::getInt$$anonfun$1);
    }

    public final ZIO getInt(int index) {
        return UIO$.MODULE$.effectTotal(() -> this.getInt$$anonfun$2(index));
    }

    public final ZIO getLong() {
        return UIO$.MODULE$.effectTotal(this::getLong$$anonfun$1);
    }

    public final ZIO getLong(int index) {
        return UIO$.MODULE$.effectTotal(() -> this.getLong$$anonfun$2(index));
    }

    public final ZIO getShort() {
        return UIO$.MODULE$.effectTotal(this::getShort$$anonfun$1);
    }

    public final ZIO getShort(int index) {
        return UIO$.MODULE$.effectTotal(() -> this.getShort$$anonfun$2(index));
    }

    private final byte[] array$$anonfun$1() {
        return this.buffer().array();
    }

    private final ByteOrder order$$anonfun$1() {
        return this.buffer().order();
    }

    private final java.nio.ByteBuffer order$$anonfun$2(ByteOrder o$1) {
        return this.buffer().order(o$1);
    }

    private final ByteBuffer slice$$anonfun$1() {
        return new ByteBuffer(this.buffer().slice());
    }

    private final java.nio.ByteBuffer compact$$anonfun$1() {
        return this.buffer().compact();
    }

    private final ByteBuffer duplicate$$anonfun$1() {
        return new ByteBuffer(this.buffer().duplicate());
    }

    private final byte get$$anonfun$1() {
        return this.buffer().get();
    }

    private final byte get$$anonfun$2(int i$1) {
        return this.buffer().get(i$1);
    }

    private final Chunk getChunk$$anonfun$1(int maxLength$1) {
        byte[] array = new byte[package$.MODULE$.min(maxLength$1, this.buffer().remaining())];
        this.buffer().get(array);
        return Chunk$.MODULE$.fromArray((Object)array);
    }

    private final java.nio.ByteBuffer put$$anonfun$1(byte element$1) {
        return this.buffer().put(element$1);
    }

    private final java.nio.ByteBuffer put$$anonfun$2(int index$1, byte element$2) {
        return this.buffer().put(index$1, element$2);
    }

    private final java.nio.ByteBuffer putByteBuffer$$anonfun$1(ByteBuffer source$1) {
        return this.buffer().put(source$1.buffer());
    }

    private final java.nio.ByteBuffer putChunkAll$$anonfun$1(Chunk chunk$1) {
        byte[] array = (byte[])chunk$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        return this.buffer().put(array);
    }

    private final ByteBuffer asReadOnlyBuffer$$anonfun$1() {
        return new ByteBuffer(this.buffer().asReadOnlyBuffer());
    }

    private final CharBuffer asCharBuffer$$anonfun$1() {
        return new CharBuffer(this.buffer().asCharBuffer());
    }

    private final DoubleBuffer asDoubleBuffer$$anonfun$1() {
        return new DoubleBuffer(this.buffer().asDoubleBuffer());
    }

    private final FloatBuffer asFloatBuffer$$anonfun$1() {
        return new FloatBuffer(this.buffer().asFloatBuffer());
    }

    private final IntBuffer asIntBuffer$$anonfun$1() {
        return new IntBuffer(this.buffer().asIntBuffer());
    }

    private final LongBuffer asLongBuffer$$anonfun$1() {
        return new LongBuffer(this.buffer().asLongBuffer());
    }

    private final ShortBuffer asShortBuffer$$anonfun$1() {
        return new ShortBuffer(this.buffer().asShortBuffer());
    }

    private final java.nio.ByteBuffer putChar$$anonfun$1(char value$1) {
        return this.buffer().putChar(value$1);
    }

    private final java.nio.ByteBuffer putChar$$anonfun$2(int index$2, char value$2) {
        return this.buffer().putChar(index$2, value$2);
    }

    private final java.nio.ByteBuffer putDouble$$anonfun$1(double value$3) {
        return this.buffer().putDouble(value$3);
    }

    private final java.nio.ByteBuffer putDouble$$anonfun$2(int index$3, double value$4) {
        return this.buffer().putDouble(index$3, value$4);
    }

    private final java.nio.ByteBuffer putFloat$$anonfun$1(float value$5) {
        return this.buffer().putFloat(value$5);
    }

    private final java.nio.ByteBuffer putFloat$$anonfun$2(int index$4, float value$6) {
        return this.buffer().putFloat(index$4, value$6);
    }

    private final java.nio.ByteBuffer putInt$$anonfun$1(int value$7) {
        return this.buffer().putInt(value$7);
    }

    private final java.nio.ByteBuffer putInt$$anonfun$2(int index$5, int value$8) {
        return this.buffer().putInt(index$5, value$8);
    }

    private final java.nio.ByteBuffer putLong$$anonfun$1(long value$9) {
        return this.buffer().putLong(value$9);
    }

    private final java.nio.ByteBuffer putLong$$anonfun$2(int index$6, long value$10) {
        return this.buffer().putLong(index$6, value$10);
    }

    private final java.nio.ByteBuffer putShort$$anonfun$1(short value$11) {
        return this.buffer().putShort(value$11);
    }

    private final java.nio.ByteBuffer putShort$$anonfun$2(int index$7, short value$12) {
        return this.buffer().putShort(index$7, value$12);
    }

    private final char getChar$$anonfun$1() {
        return this.buffer().getChar();
    }

    private final char getChar$$anonfun$2(int index$8) {
        return this.buffer().getChar(index$8);
    }

    private final double getDouble$$anonfun$1() {
        return this.buffer().getDouble();
    }

    private final double getDouble$$anonfun$2(int index$9) {
        return this.buffer().getDouble(index$9);
    }

    private final float getFloat$$anonfun$1() {
        return this.buffer().getFloat();
    }

    private final float getFloat$$anonfun$2(int index$10) {
        return this.buffer().getFloat(index$10);
    }

    private final int getInt$$anonfun$1() {
        return this.buffer().getInt();
    }

    private final int getInt$$anonfun$2(int index$11) {
        return this.buffer().getInt(index$11);
    }

    private final long getLong$$anonfun$1() {
        return this.buffer().getLong();
    }

    private final long getLong$$anonfun$2(int index$12) {
        return this.buffer().getLong(index$12);
    }

    private final short getShort$$anonfun$1() {
        return this.buffer().getShort();
    }

    private final short getShort$$anonfun$2(int index$13) {
        return this.buffer().getShort(index$13);
    }
}

