/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Has;
import zio.IO$;
import zio.Ref$;
import zio.Schedule$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.ZRef;
import zio.clock.package;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.channels.AsynchronousByteChannel$;
import zio.nio.channels.AsynchronousFileChannel$;
import zio.nio.channels.Channel;
import zio.nio.channels.FileLock;
import zio.nio.file.Path;
import zio.nio.package$;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class AsynchronousFileChannel
implements Channel {
    private final java.nio.channels.AsynchronousFileChannel channel;

    public static AsynchronousFileChannel fromJava(java.nio.channels.AsynchronousFileChannel asynchronousFileChannel) {
        return AsynchronousFileChannel$.MODULE$.fromJava(asynchronousFileChannel);
    }

    public static ZManaged<Object, IOException, AsynchronousFileChannel> open(Path path, Seq<OpenOption> seq) {
        return AsynchronousFileChannel$.MODULE$.open(path, seq);
    }

    public static ZManaged<Object, IOException, AsynchronousFileChannel> open(Path path, Set<OpenOption> set, Option<ExecutionContextExecutorService> option, Set<FileAttribute<?>> set2) {
        return AsynchronousFileChannel$.MODULE$.open(path, set, option, set2);
    }

    public AsynchronousFileChannel(java.nio.channels.AsynchronousFileChannel channel) {
        this.channel = channel;
    }

    @Override
    public java.nio.channels.AsynchronousFileChannel channel() {
        return this.channel;
    }

    public ZIO force(boolean metaData) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcV.sp & Serializable)() -> this.force$$anonfun$1(metaData))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO lock(long position, long size, boolean shared) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$1 -> {
            c.lock(position, size, shared, BoxedUnit.UNIT, _$1);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)_$2 -> new FileLock((java.nio.channels.FileLock)_$2));
    }

    public long lock$default$1() {
        return 0L;
    }

    public long lock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean lock$default$3() {
        return false;
    }

    public ZIO read(ByteBuffer dst, long position) {
        return dst.withJavaBuffer((Function1 & Serializable)buf -> AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$3 -> {
            c.read((java.nio.ByteBuffer)buf, position, BoxedUnit.UNIT, _$3);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)_$4 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Integer2int(_$4))));
    }

    public ZIO<Object, IOException, Chunk<Object>> readChunk(int capacity, long position) {
        return Buffer$.MODULE$.byte(capacity).flatMap((Function1 & Serializable)b -> this.read((ByteBuffer)b, position).flatMap((Function1 & Serializable)x$1 -> AsynchronousFileChannel.readChunk$$anonfun$4$$anonfun$3(b, BoxesRunTime.unboxToInt((Object)x$1))));
    }

    public ZIO size() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::size$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO truncate(long size) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.truncate$$anonfun$1(size)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO tryLock(long position, long size, boolean shared) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.tryLock$$anonfun$1(position, size, shared)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public long tryLock$default$1() {
        return 0L;
    }

    public long tryLock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean tryLock$default$3() {
        return false;
    }

    public ZIO write(ByteBuffer src, long position) {
        return src.withJavaBuffer((Function1 & Serializable)buf -> AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$5 -> {
            c.write((java.nio.ByteBuffer)buf, position, BoxedUnit.UNIT, _$5);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)_$6 -> _$6));
    }

    public ZIO<Object, IOException, BoxedUnit> writeChunk(Chunk<Object> src, long position) {
        return Buffer$.MODULE$.byte(src).flatMap((Function1 & Serializable)b -> this.go$2((ByteBuffer)b, position));
    }

    public ZStream stream(long position, ZIO bufferConstruct) {
        return ZStream$.MODULE$.apply(Ref$.MODULE$.makeManaged((Object)BoxesRunTime.boxToLong((long)position)).flatMap((Function1 & Serializable)posRef -> bufferConstruct.toManaged_().map((Function1 & Serializable)buffer -> {
            ZIO doRead = posRef.get().flatMap((Function1 & Serializable)pos -> this.$anonfun$7((ZRef)posRef, (ByteBuffer)buffer, BoxesRunTime.unboxToLong((Object)pos)));
            return doRead.mapError((Function1 & Serializable)x$1 -> {
                None$ none$;
                IOException iOException = x$1;
                if (iOException instanceof EOFException) {
                    none$ = None$.MODULE$;
                } else {
                    IOException e = iOException;
                    none$ = Some$.MODULE$.apply((Object)e);
                }
                return none$;
            }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        })));
    }

    public ZIO stream$default$2() {
        return Buffer$.MODULE$.byte(5000);
    }

    public ZSink<Has<package.Clock.Service>, IOException, Object, Object, Object> sink(long position, ZIO<Object, Nothing$, ByteBuffer> bufferConstruct) {
        return ZSink$.MODULE$.apply(bufferConstruct.toManaged_().flatMap((Function1 & Serializable)buffer -> Ref$.MODULE$.makeManaged((Object)BoxesRunTime.boxToLong((long)position)).map((Function1 & Serializable)posRef -> (Function1 & Serializable)_$7 -> (ZIO)_$7.map((Function1 & Serializable)chunk -> posRef.get().flatMap((Function1 & Serializable)currentPos -> this.sink$$anonfun$7$$anonfun$6$$anonfun$6$$anonfun$6$$anonfun$6((ByteBuffer)buffer, (ZRef)posRef, (Chunk)chunk, BoxesRunTime.unboxToLong((Object)currentPos)))).getOrElse(() -> AsynchronousFileChannel.sink$$anonfun$12$$anonfun$11$$anonfun$11$$anonfun$11(position, posRef)))));
    }

    public ZIO sink$default$2() {
        return Buffer$.MODULE$.byte(5000);
    }

    private final void force$$anonfun$1(boolean metaData$1) {
        this.channel().force(metaData$1);
    }

    private static final /* synthetic */ ZIO readChunk$$anonfun$4$$anonfun$3(ByteBuffer b$1, int x$12) {
        int n = x$12;
        return b$1.flip().flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return b$1.getChunk(b$1.getChunk$default$1()).map((Function1 & Serializable)chunk -> chunk);
        });
    }

    private final long size$$anonfun$1() {
        return this.channel().size();
    }

    private final java.nio.channels.AsynchronousFileChannel truncate$$anonfun$1(long size$3) {
        return this.channel().truncate(size$3);
    }

    private final FileLock tryLock$$anonfun$1(long position$7, long size$4, boolean shared$3) {
        return new FileLock(this.channel().tryLock(position$7, size$4, shared$3));
    }

    private final /* synthetic */ ZIO go$1$$anonfun$1$$anonfun$1(ByteBuffer b$5, long pos$2, int bytesWritten$1, boolean x$1) {
        ZIO zIO;
        boolean bl = x$1;
        if (bl) {
            zIO = this.go$2(b$5, pos$2 + (long)bytesWritten$1);
        } else if (!bl) {
            zIO = IO$.MODULE$.unit();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return zIO;
    }

    private final /* synthetic */ ZIO go$4$$anonfun$3(ByteBuffer b$4, long pos$1, int bytesWritten) {
        return b$4.hasRemaining().flatMap((Function1 & Serializable)x$1 -> this.go$1$$anonfun$1$$anonfun$1(b$4, pos$1, bytesWritten, BoxesRunTime.unboxToBoolean((Object)x$1)));
    }

    private final ZIO go$2(ByteBuffer b$3, long pos) {
        return this.write(b$3, pos).flatMap((Function1 & Serializable)bytesWritten -> this.go$4$$anonfun$3(b$3, pos, BoxesRunTime.unboxToInt((Object)bytesWritten)));
    }

    private static final /* synthetic */ ZIO $anonfun$5$$anonfun$5(ZRef posRef$3, ByteBuffer buffer$2, long pos$3, int count) {
        return posRef$3.set((Object)BoxesRunTime.boxToLong((long)(pos$3 + (long)count))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return buffer$2.flip().flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return buffer$2.getChunk(buffer$2.getChunk$default$1()).flatMap((Function1 & Serializable)chunk -> buffer$2.clear().map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return chunk;
                }));
            });
        });
    }

    private final /* synthetic */ ZIO $anonfun$7(ZRef posRef$2, ByteBuffer buffer$1, long pos) {
        return this.read(buffer$1, pos).flatMap((Function1 & Serializable)count -> AsynchronousFileChannel.$anonfun$5$$anonfun$5(posRef$2, buffer$1, pos, BoxesRunTime.unboxToInt((Object)count)));
    }

    private static final /* synthetic */ ZIO $anonfun$8$$anonfun$1$$anonfun$1(ZIO x$1$1, int y) {
        return (ZIO)Function$.MODULE$.const((Object)x$1$1, (Object)BoxesRunTime.boxToInteger((int)y));
    }

    private static final /* synthetic */ ZIO $anonfun$11$$anonfun$4$$anonfun$3(ByteBuffer buffer$12, long currentPos$3, Chunk remaining$2, int count) {
        return buffer$12.clear().map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(currentPos$3 + (long)count)), (Object)remaining$2);
        });
    }

    private static final long doWrite$1$$anonfun$1$$anonfun$1(long result$1) {
        return result$1;
    }

    private final ZIO doWrite$3(ByteBuffer buffer$9, long currentPos, Chunk c) {
        ZIO x = buffer$9.putChunk(c).flatMap((Function1 & Serializable)remaining -> buffer$9.flip().flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            ZIO zIO = buffer$9.hasRemaining();
            return ZStream$.MODULE$.repeatEffectWith(this.write(buffer$9, currentPos), Schedule$.MODULE$.recurWhileM((Function1 & Serializable)y -> AsynchronousFileChannel.$anonfun$8$$anonfun$1$$anonfun$1(zIO, BoxesRunTime.unboxToInt((Object)y)))).runSum((Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)count -> AsynchronousFileChannel.$anonfun$11$$anonfun$4$$anonfun$3(buffer$9, currentPos, remaining, BoxesRunTime.unboxToInt((Object)count)));
        }));
        return x.flatMap((Function1 & Serializable)x$1 -> {
            ZIO zIO;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long l = BoxesRunTime.unboxToLong((Object)tuple2._1());
                Chunk chunk = (Chunk)tuple2._2();
                long result = l;
                Chunk remaining = chunk;
                if (remaining.isEmpty()) {
                    zIO = ZIO$.MODULE$.succeed(() -> AsynchronousFileChannel.doWrite$1$$anonfun$1$$anonfun$1(result));
                } else {
                    long result2 = l;
                    Chunk remaining2 = chunk;
                    zIO = this.doWrite$3(buffer$9, result2, remaining2);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            return zIO;
        });
    }

    private static final /* synthetic */ ZIO sink$$anonfun$5$$anonfun$4$$anonfun$4$$anonfun$4$$anonfun$4$$anonfun$4(ZRef posRef$7, long newPos) {
        return posRef$7.set((Object)BoxesRunTime.boxToLong((long)newPos)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
        });
    }

    private final /* synthetic */ ZIO sink$$anonfun$7$$anonfun$6$$anonfun$6$$anonfun$6$$anonfun$6(ByteBuffer buffer$13, ZRef posRef$6, Chunk chunk$2, long currentPos) {
        return this.doWrite$3(buffer$13, currentPos, chunk$2).catchAll((Function1 & Serializable)e -> buffer$13.getChunk(buffer$13.getChunk$default$1()).flatMap((Function1 & Serializable)_$8 -> ZSink.Push$.MODULE$.fail(e, _$8)), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).flatMap((Function1 & Serializable)newPos -> AsynchronousFileChannel.sink$$anonfun$5$$anonfun$4$$anonfun$4$$anonfun$4$$anonfun$4$$anonfun$4(posRef$6, BoxesRunTime.unboxToLong((Object)newPos)));
    }

    private static final ZIO sink$$anonfun$12$$anonfun$11$$anonfun$11$$anonfun$11(long position$15, ZRef posRef$8) {
        return posRef$8.get().flatMap((Function1 & Serializable)finalPos -> ZSink.Push$.MODULE$.emit((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)finalPos) - position$15)), Chunk$.MODULE$.empty()));
    }
}

