/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketOption;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.duration.package;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.SocketAddress;
import zio.nio.SocketAddress$;
import zio.nio.channels.AsynchronousByteChannel;
import zio.nio.channels.AsynchronousByteChannel$;
import zio.nio.channels.AsynchronousChannelGroup;
import zio.nio.channels.AsynchronousSocketChannel$;
import zio.nio.package$;

public final class AsynchronousSocketChannel
extends AsynchronousByteChannel {
    private final java.nio.channels.AsynchronousSocketChannel channel;

    public static AsynchronousSocketChannel fromJava(java.nio.channels.AsynchronousSocketChannel asynchronousSocketChannel) {
        return AsynchronousSocketChannel$.MODULE$.fromJava(asynchronousSocketChannel);
    }

    public static ZManaged open() {
        return AsynchronousSocketChannel$.MODULE$.open();
    }

    public static ZManaged open(AsynchronousChannelGroup asynchronousChannelGroup) {
        return AsynchronousSocketChannel$.MODULE$.open(asynchronousChannelGroup);
    }

    public AsynchronousSocketChannel(java.nio.channels.AsynchronousSocketChannel channel) {
        this.channel = channel;
        super(channel);
    }

    @Override
    public java.nio.channels.AsynchronousSocketChannel channel() {
        return this.channel;
    }

    public ZIO bindTo(SocketAddress address) {
        return this.bind((Option<SocketAddress>)Some$.MODULE$.apply((Object)address));
    }

    public ZIO bindAuto() {
        return this.bind((Option<SocketAddress>)None$.MODULE$);
    }

    public ZIO<Object, IOException, BoxedUnit> bind(Option<SocketAddress> address) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.bind$$anonfun$1(address)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public <T> ZIO<Object, IOException, BoxedUnit> setOption(SocketOption<T> name, T value) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.setOption$$anonfun$1(name, value)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO shutdownInput() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::shutdownInput$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO shutdownOutput() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::shutdownOutput$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO<Object, IOException, Option<SocketAddress>> remoteAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::remoteAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Object, IOException, Option<SocketAddress>> localAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::localAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO connect(SocketAddress socketAddress) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$11 -> {
            c.connect(socketAddress.jSocketAddress(), BoxedUnit.UNIT, _$11);
            return BoxedUnit.UNIT;
        }).unit();
    }

    public ZIO read(ByteBuffer dst, Duration timeout) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> (Function1 & Serializable)_$13 -> {
            channel.read(dst.buffer(), BoxesRunTime.unboxToLong((Object)package.DurationOps$.MODULE$.fold$extension(zio.duration.package$.MODULE$.DurationOps(timeout), AsynchronousSocketChannel::read$$anonfun$5$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$12 -> _$12.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$13);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)_$14 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Integer2int(_$14)));
    }

    public ZIO<Object, IOException, Chunk<Object>> readChunk(int capacity, Duration timeout) {
        return Buffer$.MODULE$.byte(capacity).flatMap((Function1 & Serializable)b -> this.read((ByteBuffer)b, timeout).flatMap((Function1 & Serializable)x$1 -> AsynchronousSocketChannel.readChunk$$anonfun$4$$anonfun$3(b, BoxesRunTime.unboxToInt((Object)x$1))));
    }

    public ZIO<Object, IOException, Object> read(List<ByteBuffer> dsts, Duration timeout) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> {
            java.nio.ByteBuffer[] a = (java.nio.ByteBuffer[])dsts.map((Function1 & Serializable)_$15 -> _$15.buffer()).toArray(ClassTag$.MODULE$.apply(java.nio.ByteBuffer.class));
            return (Function1 & Serializable)_$17 -> {
                channel.read(a, 0, a.length, BoxesRunTime.unboxToLong((Object)package.DurationOps$.MODULE$.fold$extension(zio.duration.package$.MODULE$.DurationOps(timeout), AsynchronousSocketChannel::read$$anonfun$8$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$16 -> _$16.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$17);
                return BoxedUnit.UNIT;
            };
        }).flatMap((Function1 & Serializable)_$18 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Long2long(_$18)));
    }

    public ZIO<Object, IOException, List<Chunk<Object>>> readChunks(List<Object> capacities, Duration timeout) {
        return IO$.MODULE$.foreach(capacities, (Function1 & Serializable)capacity -> Buffer$.MODULE$.byte(BoxesRunTime.unboxToInt((Object)capacity)), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)buffers -> this.read((List<ByteBuffer>)buffers, timeout).$times$greater(() -> AsynchronousSocketChannel.readChunks$$anonfun$5$$anonfun$3(buffers)));
    }

    public ZIO write(ByteBuffer src, Duration timeout) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> (Function1 & Serializable)_$20 -> {
            channel.write(src.buffer(), BoxesRunTime.unboxToLong((Object)package.DurationOps$.MODULE$.fold$extension(zio.duration.package$.MODULE$.DurationOps(timeout), AsynchronousSocketChannel::write$$anonfun$5$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$19 -> _$19.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$20);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)_$21 -> Predef$.MODULE$.Integer2int(_$21));
    }

    public ZIO<Object, IOException, BoxedUnit> writeChunk(Chunk<Object> chunk, Duration timeout) {
        return Buffer$.MODULE$.byte(chunk.length()).flatMap((Function1 & Serializable)b -> b.putChunk(chunk).flatMap((Function1 & Serializable)x$1 -> {
            Chunk chunk = x$1;
            return b.flip().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return this.write((ByteBuffer)b, timeout).map((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                    int n = x$1;
                });
            });
        }));
    }

    public ZIO<Object, IOException, Object> write(List<ByteBuffer> srcs, Duration timeout) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> {
            java.nio.ByteBuffer[] a = (java.nio.ByteBuffer[])srcs.map((Function1 & Serializable)_$22 -> _$22.buffer()).toArray(ClassTag$.MODULE$.apply(java.nio.ByteBuffer.class));
            return (Function1 & Serializable)_$24 -> {
                channel.write(a, 0, a.length, BoxesRunTime.unboxToLong((Object)package.DurationOps$.MODULE$.fold$extension(zio.duration.package$.MODULE$.DurationOps(timeout), AsynchronousSocketChannel::write$$anonfun$8$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$23 -> _$23.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$24);
                return BoxedUnit.UNIT;
            };
        }).map((Function1 & Serializable)_$25 -> Predef$.MODULE$.Long2long(_$25));
    }

    public ZIO<Object, IOException, Object> writeChunks(List<Chunk<Object>> chunks, Duration timeout) {
        return IO$.MODULE$.foreach(chunks, (Function1 & Serializable)chunk -> Buffer$.MODULE$.byte(chunk.length()).tap((Function1 & Serializable)_$26 -> _$26.putChunk(chunk)).tap((Function1 & Serializable)_$27 -> _$27.flip()), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)_$28 -> this.write((List<ByteBuffer>)_$28, timeout));
    }

    private final java.nio.channels.AsynchronousSocketChannel bind$$anonfun$1(Option address$2) {
        return this.channel().bind((java.net.SocketAddress)address$2.map((Function1 & Serializable)_$10 -> _$10.jSocketAddress()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private final java.nio.channels.AsynchronousSocketChannel setOption$$anonfun$1(SocketOption name$2, Object value$2) {
        return this.channel().setOption(name$2, value$2);
    }

    private final java.nio.channels.AsynchronousSocketChannel shutdownInput$$anonfun$1() {
        return this.channel().shutdownInput();
    }

    private final java.nio.channels.AsynchronousSocketChannel shutdownOutput$$anonfun$1() {
        return this.channel().shutdownOutput();
    }

    private final Option remoteAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getRemoteAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private final Option localAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getLocalAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private static final long read$$anonfun$5$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final /* synthetic */ ZIO readChunk$$anonfun$4$$anonfun$3(ByteBuffer b$8, int x$12) {
        int n = x$12;
        return b$8.flip().flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return b$8.getChunk(b$8.getChunk$default$1()).map((Function1 & Serializable)r -> r);
        });
    }

    private static final long read$$anonfun$8$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final ZIO readChunks$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(ByteBuffer b$10) {
        return b$10.getChunk(b$10.getChunk$default$1());
    }

    private static final ZIO readChunks$$anonfun$5$$anonfun$3(List buffers$1) {
        return IO$.MODULE$.foreach((Iterable)buffers$1, (Function1 & Serializable)b -> b.flip().$times$greater(() -> AsynchronousSocketChannel.readChunks$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(b)), BuildFrom$.MODULE$.buildFromIterableOps());
    }

    private static final long write$$anonfun$5$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final long write$$anonfun$8$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }
}

