/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.nio.channels.GatheringByteChannel;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.IO$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.ByteBuffer;
import zio.nio.SocketAddress;
import zio.nio.SocketAddress$;
import zio.nio.channels.BlockingChannel;
import zio.nio.channels.Channel;
import zio.nio.channels.DatagramChannel$;
import zio.nio.channels.GatheringByteOps;
import zio.nio.channels.ScatteringByteOps;
import zio.nio.channels.SelectableChannel;

public final class DatagramChannel
implements Channel,
BlockingChannel,
SelectableChannel {
    private ZIO provider;
    private ZIO validOps;
    private ZIO isRegistered;
    private ZIO isBlocking;
    private ZIO blockingLock;
    private final java.nio.channels.DatagramChannel channel;

    public static DatagramChannel fromJava(java.nio.channels.DatagramChannel datagramChannel) {
        return DatagramChannel$.MODULE$.fromJava(datagramChannel);
    }

    public static ZManaged open() {
        return DatagramChannel$.MODULE$.open();
    }

    public static ZManaged open(ProtocolFamily protocolFamily) {
        return DatagramChannel$.MODULE$.open(protocolFamily);
    }

    public DatagramChannel(java.nio.channels.DatagramChannel channel) {
        this.channel = channel;
        SelectableChannel.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public final ZIO provider() {
        return this.provider;
    }

    public final ZIO validOps() {
        return this.validOps;
    }

    @Override
    public final ZIO isRegistered() {
        return this.isRegistered;
    }

    @Override
    public final ZIO isBlocking() {
        return this.isBlocking;
    }

    @Override
    public final ZIO blockingLock() {
        return this.blockingLock;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$provider_$eq(ZIO x$0) {
        this.provider = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$validOps_$eq(ZIO x$0) {
        this.validOps = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$isRegistered_$eq(ZIO x$0) {
        this.isRegistered = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$isBlocking_$eq(ZIO x$0) {
        this.isBlocking = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$blockingLock_$eq(ZIO x$0) {
        this.blockingLock = x$0;
    }

    @Override
    public java.nio.channels.DatagramChannel channel() {
        return this.channel;
    }

    @Override
    public BlockingDatagramOps makeBlockingOps() {
        return new BlockingDatagramOps(this);
    }

    @Override
    public NonBlockingDatagramOps makeNonBlockingOps() {
        return new NonBlockingDatagramOps(this);
    }

    public ZIO bindTo(SocketAddress local) {
        return this.bind((Option<SocketAddress>)Some$.MODULE$.apply((Object)local));
    }

    public ZIO bindAuto() {
        return this.bind((Option<SocketAddress>)None$.MODULE$);
    }

    public ZIO<Object, IOException, BoxedUnit> bind(Option<SocketAddress> local) {
        java.net.SocketAddress addr = (java.net.SocketAddress)local.map((Function1 & Serializable)_$1 -> _$1.jSocketAddress()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.bind$$anonfun$1(addr)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO disconnect() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::disconnect$$anonfun$1).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO isConnected() {
        return UIO$.MODULE$.effectTotal(this::isConnected$$anonfun$1);
    }

    public ZIO<Object, IOException, Option<SocketAddress>> localAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::localAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Object, IOException, Option<SocketAddress>> remoteAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::remoteAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public <T> ZIO<Object, IOException, BoxedUnit> setOption(SocketOption<T> name, T value) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.setOption$$anonfun$1(name, value)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO socket() {
        return IO$.MODULE$.effectTotal(this::socket$$anonfun$1);
    }

    public static final /* synthetic */ SocketAddress zio$nio$channels$DatagramChannel$NonBlockingDatagramOps$$_$receive$$anonfun$1$$anonfun$1(java.net.SocketAddress jSocketAddress) {
        return SocketAddress$.MODULE$.fromJava(jSocketAddress);
    }

    private final java.nio.channels.DatagramChannel bind$$anonfun$1(java.net.SocketAddress addr$1) {
        return this.channel().bind(addr$1);
    }

    private final DatagramChannel disconnect$$anonfun$1() {
        return new DatagramChannel(this.channel().disconnect());
    }

    private final boolean isConnected$$anonfun$1() {
        return this.channel().isConnected();
    }

    private final Option localAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getLocalAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private final Option remoteAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getRemoteAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private final java.nio.channels.DatagramChannel setOption$$anonfun$1(SocketOption name$1, Object value$1) {
        return this.channel().setOption(name$1, value$1);
    }

    private final DatagramSocket socket$$anonfun$1() {
        return this.channel().socket();
    }

    public final class BlockingDatagramOps
    extends DatagramOps {
        private final DatagramChannel $outer;

        public BlockingDatagramOps(DatagramChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        public ZIO receive(ByteBuffer dst) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.receive$$anonfun$1(dst)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public final DatagramChannel zio$nio$channels$DatagramChannel$BlockingDatagramOps$$$outer() {
            return this.$outer;
        }

        private final SocketAddress receive$$anonfun$1(ByteBuffer dst$1) {
            return SocketAddress$.MODULE$.fromJava(this.$outer.channel().receive(dst$1.buffer()));
        }
    }

    public abstract class DatagramOps
    implements GatheringByteOps,
    ScatteringByteOps {
        private final DatagramChannel $outer;

        public DatagramOps(DatagramChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public GatheringByteChannel channel() {
            return this.$outer.channel();
        }

        public ZIO connect(SocketAddress remote) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.connect$$anonfun$1(remote)).unit());
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO send(ByteBuffer src, SocketAddress target) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.send$$anonfun$1(src, target)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public final DatagramChannel zio$nio$channels$DatagramChannel$DatagramOps$$$outer() {
            return this.$outer;
        }

        private final DatagramChannel connect$$anonfun$1(SocketAddress remote$1) {
            return new DatagramChannel(this.$outer.channel().connect(remote$1.jSocketAddress()));
        }

        private final int send$$anonfun$1(ByteBuffer src$1, SocketAddress target$1) {
            return this.$outer.channel().send(src$1.buffer(), target$1.jSocketAddress());
        }
    }

    public final class NonBlockingDatagramOps
    extends DatagramOps {
        private final DatagramChannel $outer;

        public NonBlockingDatagramOps(DatagramChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        public ZIO<Object, IOException, Option<SocketAddress>> receive(ByteBuffer dst) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.receive$$anonfun$1(dst)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public final DatagramChannel zio$nio$channels$DatagramChannel$NonBlockingDatagramOps$$$outer() {
            return this.$outer;
        }

        private final Option receive$$anonfun$1(ByteBuffer dst$2) {
            return Option$.MODULE$.apply((Object)this.$outer.channel().receive(dst$2.buffer())).map(DatagramChannel::zio$nio$channels$DatagramChannel$NonBlockingDatagramOps$$_$receive$$anonfun$1$$anonfun$1);
        }
    }
}

