/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Has;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.blocking.package;
import zio.nio.ByteBuffer;
import zio.nio.MappedByteBuffer;
import zio.nio.channels.BlockingChannel;
import zio.nio.channels.Channel;
import zio.nio.channels.FileChannel$;
import zio.nio.channels.FileLock;
import zio.nio.channels.GatheringByteOps;
import zio.nio.channels.ScatteringByteOps;
import zio.nio.file.Path;

public final class FileChannel
implements Channel,
BlockingChannel {
    private final java.nio.channels.FileChannel channel;

    public static FileChannel fromJava(java.nio.channels.FileChannel fileChannel) {
        return FileChannel$.MODULE$.fromJava(fileChannel);
    }

    public static ZManaged<Object, IOException, FileChannel> open(Path path, Seq<OpenOption> seq) {
        return FileChannel$.MODULE$.open(path, seq);
    }

    public static ZManaged<Object, IOException, FileChannel> open(Path path, Set<? extends OpenOption> set, Seq<FileAttribute<?>> seq) {
        return FileChannel$.MODULE$.open(path, set, seq);
    }

    public FileChannel(java.nio.channels.FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public java.nio.channels.FileChannel channel() {
        return this.channel;
    }

    public <R, E, A> ZIO<Has<package.Blocking.Service>, E, A> useBlocking(Function1<BlockingFileOps, ZIO<R, E, A>> f) {
        return this.nioBlocking((ZIO)f.apply((Object)new BlockingFileOps(this)));
    }

    public ZIO position() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::position$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO position(long newPosition) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.position$$anonfun$2(newPosition)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO size() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::size$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Object, IOException, Option<FileLock>> tryLock(long position, long size, boolean shared) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.effect(() -> this.tryLock$$anonfun$1(position, size, shared)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public long tryLock$default$1() {
        return 0L;
    }

    public long tryLock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean tryLock$default$3() {
        return false;
    }

    private final long position$$anonfun$1() {
        return this.channel().position();
    }

    private final java.nio.channels.FileChannel position$$anonfun$2(long newPosition$1) {
        return this.channel().position(newPosition$1);
    }

    private final long size$$anonfun$1() {
        return this.channel().size();
    }

    private final Option tryLock$$anonfun$1(long position$9, long size$4, boolean shared$2) {
        return Option$.MODULE$.apply((Object)this.channel().tryLock(position$9, size$4, shared$2)).map((Function1 & Serializable)_$1 -> new FileLock((java.nio.channels.FileLock)_$1));
    }

    public final class BlockingFileOps
    implements GatheringByteOps,
    ScatteringByteOps {
        private final FileChannel $outer;

        public BlockingFileOps(FileChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public java.nio.channels.FileChannel channel() {
            return this.$outer.channel();
        }

        public ZIO truncate(long size) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.truncate$$anonfun$1(size)).unit());
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO force(boolean metadata) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcV.sp & Serializable)() -> this.force$$anonfun$1(metadata))));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO transferTo(long position, long count, GatheringByteOps target) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.transferTo$$anonfun$1(position, count, target)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO transferFrom(ScatteringByteOps src, long position, long count) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.transferFrom$$anonfun$1(src, position, count)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO read(ByteBuffer dst, long position) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(dst.withJavaBuffer((Function1 & Serializable)buffer -> IO$.MODULE$.effect(() -> this.read$$anonfun$2$$anonfun$1(position, buffer))));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO write(ByteBuffer src, long position) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(src.withJavaBuffer((Function1 & Serializable)buffer -> IO$.MODULE$.effect(() -> this.write$$anonfun$2$$anonfun$1(position, buffer))));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO map(FileChannel.MapMode mode, long position, long size) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.map$$anonfun$1(mode, position, size)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO lock(long position, long size, boolean shared) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.lock$$anonfun$1(position, size, shared)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public long lock$default$1() {
            return 0L;
        }

        public long lock$default$2() {
            return Long.MAX_VALUE;
        }

        public boolean lock$default$3() {
            return false;
        }

        public final FileChannel zio$nio$channels$FileChannel$BlockingFileOps$$$outer() {
            return this.$outer;
        }

        private final java.nio.channels.FileChannel truncate$$anonfun$1(long size$1) {
            return this.channel().truncate(size$1);
        }

        private final void force$$anonfun$1(boolean metadata$1) {
            this.channel().force(metadata$1);
        }

        private final long transferTo$$anonfun$1(long position$1, long count$1, GatheringByteOps target$1) {
            return this.channel().transferTo(position$1, count$1, target$1.channel());
        }

        private final long transferFrom$$anonfun$1(ScatteringByteOps src$1, long position$2, long count$2) {
            return this.channel().transferFrom(src$1.channel(), position$2, count$2);
        }

        private final int read$$anonfun$2$$anonfun$1(long position$3, java.nio.ByteBuffer buffer$1) {
            return this.channel().read(buffer$1, position$3);
        }

        private final int write$$anonfun$2$$anonfun$1(long position$5, java.nio.ByteBuffer buffer$2) {
            return this.channel().write(buffer$2, position$5);
        }

        private final MappedByteBuffer map$$anonfun$1(FileChannel.MapMode mode$1, long position$7, long size$2) {
            return new MappedByteBuffer(this.channel().map(mode$1, position$7, size$2));
        }

        private final FileLock lock$$anonfun$1(long position$8, long size$3, boolean shared$1) {
            return new FileLock(this.channel().lock(position$8, size$3, shared$1));
        }
    }
}

