/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.IOCloseable;
import zio.nio.channels.SelectionKey;
import zio.nio.channels.Selector$;
import zio.nio.channels.spi.SelectorProvider;

public final class Selector
implements IOCloseable {
    private final java.nio.channels.Selector selector;
    private final ZIO isOpen;
    private final ZIO provider;
    private final ZIO keys;
    private final ZIO selectedKeys;
    private final ZIO selectNow;

    public static ZManaged open() {
        return Selector$.MODULE$.open();
    }

    public Selector(java.nio.channels.Selector selector) {
        this.selector = selector;
        this.isOpen = IO$.MODULE$.effectTotal(() -> Selector.$init$$$anonfun$1(selector));
        this.provider = IO$.MODULE$.effectTotal(() -> Selector.$init$$$anonfun$2(selector)).map((Function1 & Serializable)_$1 -> new SelectorProvider((java.nio.channels.spi.SelectorProvider)_$1));
        this.keys = IO$.MODULE$.effectTotal(() -> Selector.$init$$$anonfun$4(selector)).map((Function1 & Serializable)_$2 -> (scala.collection.immutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(_$2).asScala().toSet().map((Function1 & Serializable)_$3 -> new SelectionKey((java.nio.channels.SelectionKey)_$3)));
        this.selectedKeys = IO$.MODULE$.effectTotal(() -> Selector.$init$$$anonfun$6(selector)).map((Function1 & Serializable)_$4 -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(_$4).asScala().map((Function1 & Serializable)_$5 -> new SelectionKey((java.nio.channels.SelectionKey)_$5)));
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> Selector.$init$$$anonfun$8(selector)));
        this.selectNow = ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public java.nio.channels.Selector selector() {
        return this.selector;
    }

    public ZIO isOpen() {
        return this.isOpen;
    }

    public ZIO provider() {
        return this.provider;
    }

    public ZIO<Object, Nothing$, scala.collection.immutable.Set<SelectionKey>> keys() {
        return this.keys;
    }

    public ZIO<Object, Nothing$, scala.collection.mutable.Set<SelectionKey>> selectedKeys() {
        return this.selectedKeys;
    }

    public <R, E> ZIO<R, E, BoxedUnit> foreachSelectedKey(Function1<SelectionKey, ZIO<R, E, Object>> f) {
        return ZIO$.MODULE$.effectTotal(this::foreachSelectedKey$$anonfun$1).flatMap((Function1 & Serializable)iter -> Selector.loop$7(f, iter));
    }

    public ZIO removeKey(SelectionKey key) {
        return IO$.MODULE$.effectTotal(() -> this.removeKey$$anonfun$1(key)).unit();
    }

    public ZIO selectNow() {
        return this.selectNow;
    }

    public ZIO select(Duration timeout) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.select$$anonfun$1(timeout)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).fork().flatMap((Function1 & Serializable)_$7 -> _$7.join()).onInterrupt(this.wakeup());
    }

    public ZIO select() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::select$$anonfun$3));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).fork().flatMap((Function1 & Serializable)_$8 -> _$8.join()).onInterrupt(this.wakeup());
    }

    public ZIO wakeup() {
        return IO$.MODULE$.effectTotal(this::wakeup$$anonfun$1).unit();
    }

    @Override
    public ZIO close() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcV.sp & Serializable)this::close$$anonfun$1)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    private static final boolean $init$$$anonfun$1(java.nio.channels.Selector selector$1) {
        return selector$1.isOpen();
    }

    private static final java.nio.channels.spi.SelectorProvider $init$$$anonfun$2(java.nio.channels.Selector selector$2) {
        return selector$2.provider();
    }

    private static final Set $init$$$anonfun$4(java.nio.channels.Selector selector$3) {
        return selector$3.keys();
    }

    private static final Set $init$$$anonfun$6(java.nio.channels.Selector selector$4) {
        return selector$4.selectedKeys();
    }

    private static final int $init$$$anonfun$8(java.nio.channels.Selector selector$5) {
        return selector$5.selectNow();
    }

    private final Iterator foreachSelectedKey$$anonfun$1() {
        return this.selector().selectedKeys().iterator();
    }

    private static final boolean loop$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean _$6$1) {
        return _$6$1;
    }

    private static final void loop$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Iterator iter$5) {
        iter$5.remove();
    }

    private static final ZIO loop$3$$anonfun$3$$anonfun$3$$anonfun$3(Iterator iter$4) {
        return ZIO$.MODULE$.effectTotal((Function0)((JFunction0.mcV.sp & Serializable)() -> Selector.loop$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(iter$4)));
    }

    private static final ZIO loop$6$$anonfun$6$$anonfun$5(Function1 f$4, Iterator iter$7) {
        return Selector.loop$7(f$4, iter$7);
    }

    private static final ZIO loop$8$$anonfun$7(Function1 f$2, Iterator iter$2) {
        ZIO zIO;
        if (iter$2.hasNext()) {
            java.nio.channels.SelectionKey key = (java.nio.channels.SelectionKey)iter$2.next();
            zIO = ((ZIO)f$2.apply((Object)new SelectionKey(key))).flatMap((Function1 & Serializable)_$6 -> ZIO$.MODULE$.when(() -> Selector.loop$1$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$6)), () -> Selector.loop$3$$anonfun$3$$anonfun$3$$anonfun$3(iter$2))).$times$greater(() -> Selector.loop$6$$anonfun$6$$anonfun$5(f$2, iter$2));
        } else {
            zIO = ZIO$.MODULE$.unit();
        }
        return zIO;
    }

    private static final ZIO loop$7(Function1 f$1, Iterator iter$1) {
        return ZIO$.MODULE$.effectSuspendTotal(() -> Selector.loop$8$$anonfun$7(f$1, iter$1));
    }

    private final boolean removeKey$$anonfun$1(SelectionKey key$1) {
        return this.selector().selectedKeys().remove(key$1.selectionKey());
    }

    private final int select$$anonfun$1(Duration timeout$1) {
        return this.selector().select(timeout$1.toMillis());
    }

    private final int select$$anonfun$3() {
        return this.selector().select();
    }

    private final java.nio.channels.Selector wakeup$$anonfun$1() {
        return this.selector().wakeup();
    }

    private final void close$$anonfun$1() {
        this.selector().close();
    }
}

