/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketOption;
import java.nio.channels.GatheringByteChannel;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.SocketAddress;
import zio.nio.SocketAddress$;
import zio.nio.channels.BlockingChannel;
import zio.nio.channels.Channel;
import zio.nio.channels.GatheringByteOps;
import zio.nio.channels.ScatteringByteOps;
import zio.nio.channels.SelectableChannel;
import zio.nio.channels.SocketChannel$;

public final class SocketChannel
implements Channel,
BlockingChannel,
SelectableChannel {
    private ZIO provider;
    private ZIO validOps;
    private ZIO isRegistered;
    private ZIO isBlocking;
    private ZIO blockingLock;
    private final java.nio.channels.SocketChannel channel;

    public static SocketChannel fromJava(java.nio.channels.SocketChannel socketChannel) {
        return SocketChannel$.MODULE$.fromJava(socketChannel);
    }

    public static ZManaged open() {
        return SocketChannel$.MODULE$.open();
    }

    public static ZManaged open(SocketAddress socketAddress) {
        return SocketChannel$.MODULE$.open(socketAddress);
    }

    public SocketChannel(java.nio.channels.SocketChannel channel) {
        this.channel = channel;
        SelectableChannel.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public final ZIO provider() {
        return this.provider;
    }

    public final ZIO validOps() {
        return this.validOps;
    }

    @Override
    public final ZIO isRegistered() {
        return this.isRegistered;
    }

    @Override
    public final ZIO isBlocking() {
        return this.isBlocking;
    }

    @Override
    public final ZIO blockingLock() {
        return this.blockingLock;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$provider_$eq(ZIO x$0) {
        this.provider = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$validOps_$eq(ZIO x$0) {
        this.validOps = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$isRegistered_$eq(ZIO x$0) {
        this.isRegistered = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$isBlocking_$eq(ZIO x$0) {
        this.isBlocking = x$0;
    }

    @Override
    public void zio$nio$channels$SelectableChannel$_setter_$blockingLock_$eq(ZIO x$0) {
        this.blockingLock = x$0;
    }

    @Override
    public java.nio.channels.SocketChannel channel() {
        return this.channel;
    }

    @Override
    public BlockingSocketOps makeBlockingOps() {
        return new BlockingSocketOps(this);
    }

    @Override
    public NonBlockingSocketOps makeNonBlockingOps() {
        return new NonBlockingSocketOps(this);
    }

    public ZIO bindTo(SocketAddress address) {
        return this.bind((Option<SocketAddress>)Some$.MODULE$.apply((Object)address));
    }

    public ZIO bindAuto() {
        return this.bind((Option<SocketAddress>)None$.MODULE$);
    }

    public ZIO<Object, IOException, BoxedUnit> bind(Option<SocketAddress> local) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.bind$$anonfun$1(local)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public <T> ZIO<Object, IOException, BoxedUnit> setOption(SocketOption<T> name, T value) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.setOption$$anonfun$1(name, value)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO shutdownInput() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::shutdownInput$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO shutdownOutput() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::shutdownOutput$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
    }

    public ZIO socket() {
        return IO$.MODULE$.effectTotal(this::socket$$anonfun$1);
    }

    public ZIO isConnected() {
        return IO$.MODULE$.effectTotal(this::isConnected$$anonfun$1);
    }

    public ZIO remoteAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::remoteAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Object, IOException, Option<SocketAddress>> localAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::localAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    private final java.nio.channels.SocketChannel bind$$anonfun$1(Option local$1) {
        return this.channel().bind((java.net.SocketAddress)local$1.map((Function1 & Serializable)_$3 -> _$3.jSocketAddress()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private final java.nio.channels.SocketChannel setOption$$anonfun$1(SocketOption name$1, Object value$1) {
        return this.channel().setOption(name$1, value$1);
    }

    private final java.nio.channels.SocketChannel shutdownInput$$anonfun$1() {
        return this.channel().shutdownInput();
    }

    private final java.nio.channels.SocketChannel shutdownOutput$$anonfun$1() {
        return this.channel().shutdownOutput();
    }

    private final Socket socket$$anonfun$1() {
        return this.channel().socket();
    }

    private final boolean isConnected$$anonfun$1() {
        return this.channel().isConnected();
    }

    private final SocketAddress remoteAddress$$anonfun$1() {
        return SocketAddress$.MODULE$.fromJava(this.channel().getRemoteAddress());
    }

    private final Option localAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getLocalAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    public final class BlockingSocketOps
    extends Ops {
        private final SocketChannel $outer;

        public BlockingSocketOps(SocketChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        public ZIO connect(SocketAddress remote) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.connect$$anonfun$1(remote)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).unit();
        }

        public final SocketChannel zio$nio$channels$SocketChannel$BlockingSocketOps$$$outer() {
            return this.$outer;
        }

        private final boolean connect$$anonfun$1(SocketAddress remote$1) {
            return this.$outer.channel().connect(remote$1.jSocketAddress());
        }
    }

    public final class NonBlockingSocketOps
    extends Ops {
        private final SocketChannel $outer;

        public NonBlockingSocketOps(SocketChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        public ZIO isConnectionPending() {
            return IO$.MODULE$.effectTotal(this::isConnectionPending$$anonfun$1);
        }

        public ZIO connect(SocketAddress remote) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.connect$$anonfun$1(remote)));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public ZIO finishConnect() {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::finishConnect$$anonfun$1));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
        }

        public final SocketChannel zio$nio$channels$SocketChannel$NonBlockingSocketOps$$$outer() {
            return this.$outer;
        }

        private final boolean isConnectionPending$$anonfun$1() {
            return this.$outer.channel().isConnectionPending();
        }

        private final boolean connect$$anonfun$1(SocketAddress remote$2) {
            return this.$outer.channel().connect(remote$2.jSocketAddress());
        }

        private final boolean finishConnect$$anonfun$1() {
            return this.$outer.channel().finishConnect();
        }
    }

    public abstract class Ops
    implements GatheringByteOps,
    ScatteringByteOps {
        private final SocketChannel $outer;

        public Ops(SocketChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public GatheringByteChannel channel() {
            return this.$outer.channel();
        }

        public final SocketChannel zio$nio$channels$SocketChannel$Ops$$$outer() {
            return this.$outer;
        }
    }
}

