/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.ZManaged$;
import zio.blocking.package;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$Standard$;
import zio.nio.file.Files;
import zio.nio.file.Files$Attribute$;
import zio.nio.file.Files$AttributeNames$;
import zio.nio.file.Files$Attributes$;
import zio.nio.file.Path;
import zio.nio.file.Path$;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Files$
implements Serializable {
    public static final Files$Attribute$ Attribute;
    public static final Files$AttributeNames$ AttributeNames;
    public static final Files$Attributes$ Attributes;
    public static final Files$ MODULE$;

    private Files$() {
    }

    static {
        MODULE$ = new Files$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Files$.class);
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> newDirectoryStream(Path dir, String glob) {
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking(() -> this.$anonfun$1(dir, glob))).map((Function1 & Serializable)_$1 -> _$1.iterator());
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorManaged(managed).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public String newDirectoryStream$default$2() {
        return "*";
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> newDirectoryStream(Path dir, Function1<Path, Object> filter) {
        DirectoryStream.Filter<java.nio.file.Path> javaFilter = javaPath -> BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking(() -> this.$anonfun$4(dir, javaFilter))).map((Function1 & Serializable)_$2 -> _$2.iterator());
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorManaged(managed).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> attrs) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createFile$$anonfun$1(path, attrs)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> attrs) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createDirectory$$anonfun$1(path, attrs)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> attrs) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createDirectories$$anonfun$1(path, attrs)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempFileIn(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createTempFileIn$$anonfun$1(dir, suffix, prefix, fileAttributes)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public String createTempFileIn$default$2() {
        return ".tmp";
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempFileInManaged(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempFileIn(dir, suffix, prefix, fileAttributes), (Function1 & Serializable)_$3 -> this.deleteIfExists((Path)_$3).ignore());
    }

    public String createTempFileInManaged$default$2() {
        return ".tmp";
    }

    public Option<String> createTempFileInManaged$default$3() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileInManaged$default$4() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempFile(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createTempFile$$anonfun$1(suffix, prefix, fileAttributes)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public String createTempFile$default$1() {
        return ".tmp";
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempFileManaged(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempFile(suffix, prefix, fileAttributes), (Function1 & Serializable)_$4 -> this.deleteIfExists((Path)_$4).ignore());
    }

    public String createTempFileManaged$default$1() {
        return ".tmp";
    }

    public Option<String> createTempFileManaged$default$2() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileManaged$default$3() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempDirectory(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createTempDirectory$$anonfun$1(dir, prefix, fileAttributes)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempDirectoryManaged(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempDirectory(dir, prefix, fileAttributes), (Function1 & Serializable)_$5 -> this.deleteRecursive((Path)_$5).ignore());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> createTempDirectory(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createTempDirectory$$anonfun$2(prefix, fileAttributes)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempDirectoryManaged(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return ZManaged$.MODULE$.make(this.createTempDirectory(prefix, fileAttributes), (Function1 & Serializable)_$6 -> this.deleteRecursive((Path)_$6).ignore());
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createSymbolicLink(Path link, Path target, Seq<FileAttribute<?>> fileAttributes) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createSymbolicLink$$anonfun$1(link, target, fileAttributes)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createLink(Path link, Path existing) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.createLink$$anonfun$1(link, existing)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> delete(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.delete$$anonfun$1(path))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> deleteIfExists(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.deleteIfExists$$anonfun$1(path)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> deleteRecursive(Path path2) {
        return this.newDirectoryStream(path2, this.newDirectoryStream$default$2()).mapM((Function1 & Serializable)path -> this.delete((Path)path)).run(ZSink$.MODULE$.count()).$less$times(() -> this.deleteRecursive$$anonfun$2(path2));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> copy(Path source, Path target, Seq<CopyOption> copyOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.copy$$anonfun$1(source, target, copyOptions)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> move(Path source, Path target, Seq<CopyOption> copyOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.move$$anonfun$1(source, target, copyOptions)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> readSymbolicLink(Path link) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.readSymbolicLink$$anonfun$1(link)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, FileStore> getFileStore(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.getFileStore$$anonfun$1(path)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> isSameFile(Path path, Path path2) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.isSameFile$$anonfun$1(path, path2)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> isHidden(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.isHidden$$anonfun$1(path)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, String> probeContentType(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.probeContentType$$anonfun$1(path)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public <A extends FileAttributeView, B, E> ZIO<Has<package.Blocking.Service>, E, B> useFileAttributeView(Path path, Seq<LinkOption> linkOptions, Function1<A, ZIO<Has<package.Blocking.Service>, E, B>> f, ClassTag<A> evidence$1) {
        Class viewClass = scala.reflect.package$.MODULE$.classTag(evidence$1).runtimeClass();
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.useFileAttributeView$$anonfun$1(path, linkOptions, viewClass)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value())).flatMap(f);
    }

    public <A extends BasicFileAttributes> ZIO<Has<package.Blocking.Service>, IOException, A> readAttributes(Path path, Seq<LinkOption> linkOptions, ClassTag<A> evidence$2) {
        Class attributeClass = scala.reflect.package$.MODULE$.classTag(evidence$2).runtimeClass();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.readAttributes$$anonfun$1(path, linkOptions, attributeClass)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Exception, BoxedUnit> setAttribute(Path path, Files.Attribute attribute, Object value, Seq<LinkOption> linkOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.setAttribute$$anonfun$1(path, attribute, value, linkOptions)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> getAttribute(Path path, Files.Attribute attribute, Seq<LinkOption> linkOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.getAttribute$$anonfun$1(path, attribute, linkOptions)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, scala.collection.immutable.Map<String, Object>> readAttributes(Path path, Files.Attributes attributes, Seq<LinkOption> linkOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.readAttributes$$anonfun$2(path, attributes, linkOptions)).map((Function1 & Serializable)_$7 -> CollectionConverters$.MODULE$.MapHasAsScala(_$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, scala.collection.immutable.Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> linkOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.getPosixFilePermissions$$anonfun$1(path, linkOptions)).map((Function1 & Serializable)_$8 -> CollectionConverters$.MODULE$.SetHasAsScala(_$8).asScala().toSet()));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setPosixFilePermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.setPosixFilePermissions$$anonfun$1(path, permissions)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> linkOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.getOwner$$anonfun$1(path, linkOptions)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setOwner(Path path, UserPrincipal owner) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.setOwner$$anonfun$1(path, owner)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isSymbolicLink(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.isSymbolicLink$$anonfun$1(path)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.isDirectory$$anonfun$1(path, linkOptions)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.isRegularFile$$anonfun$1(path, linkOptions)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> linkOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.getLastModifiedTime$$anonfun$1(path, linkOptions)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime time) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.setLastModifiedTime$$anonfun$1(path, time)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> size(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.size$$anonfun$1(path)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> exists(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.exists$$anonfun$1(path, linkOptions)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> notExists(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.notExists$$anonfun$1(path, linkOptions)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isReadable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.isReadable$$anonfun$1(path)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isWritable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.isWritable$$anonfun$1(path)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isExecutable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking(() -> this.isExecutable$$anonfun$1(path)).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Chunk<Object>> readAllBytes(Path path) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.readAllBytes$$anonfun$1(path)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, List<String>> readAllLines(Path path, Charset charset) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.readAllLines$$anonfun$1(path, charset)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public Charset readAllLines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> bytes, Seq<OpenOption> openOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.writeBytes$$anonfun$1(path, bytes, openOptions)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> lines, Charset charset, scala.collection.immutable.Set<OpenOption> openOptions) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(zio.blocking.package$.MODULE$.effectBlocking(() -> this.writeLines$$anonfun$1(path, lines, charset, openOptions)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public Charset writeLines$default$3() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public scala.collection.immutable.Set<OpenOption> writeLines$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Has<package.Blocking.Service>, IOException, String> lines(Path path, Charset charset) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking(() -> this.lines$$anonfun$1(path, charset)))));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public Charset lines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> list(Path path) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking(() -> this.list$$anonfun$1(path)))).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> walk(Path path, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking(() -> this.walk$$anonfun$1(path, maxDepth, visitOptions)))).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public int walk$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> walk$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Has<package.Blocking.Service>, IOException, Path> find(Path path2, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Function2<Path, BasicFileAttributes, Object> test) {
        BiPredicate<java.nio.file.Path, BasicFileAttributes> matcher = (path, attr) -> BoxesRunTime.unboxToBoolean((Object)test.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)path), attr));
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking(() -> this.find$$anonfun$1(path2, maxDepth, visitOptions, matcher)))).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    public int find$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> find$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> copy(ZStream<Has<package.Blocking.Service>, IOException, Object> in, Path target, Seq<CopyOption> options) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(in.toInputStream((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl()).use((Function1 & Serializable)inputStream -> zio.blocking.package$.MODULE$.effectBlocking(() -> this.copy$$anonfun$3$$anonfun$1(target, options, inputStream))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    private final DirectoryStream $anonfun$1(Path dir$1, String glob$1) {
        return Files.newDirectoryStream(dir$1.javaPath(), glob$1);
    }

    private final DirectoryStream $anonfun$4(Path dir$2, DirectoryStream.Filter javaFilter$1) {
        return Files.newDirectoryStream(dir$2.javaPath(), javaFilter$1);
    }

    private final java.nio.file.Path createFile$$anonfun$1(Path path$1, Seq attrs$1) {
        return Files.createFile(path$1.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs$1, FileAttribute.class));
    }

    private final java.nio.file.Path createDirectory$$anonfun$1(Path path$2, Seq attrs$2) {
        return Files.createDirectory(path$2.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs$2, FileAttribute.class));
    }

    private final java.nio.file.Path createDirectories$$anonfun$1(Path path$3, Seq attrs$3) {
        return Files.createDirectories(path$3.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs$3, FileAttribute.class));
    }

    private final Path createTempFileIn$$anonfun$1(Path dir$3, String suffix$1, Option prefix$1, Iterable fileAttributes$1) {
        return Path$.MODULE$.fromJava(Files.createTempFile(dir$3.javaPath(), (String)prefix$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$1.toSeq(), FileAttribute.class)));
    }

    private final Path createTempFile$$anonfun$1(String suffix$2, Option prefix$2, Iterable fileAttributes$2) {
        return Path$.MODULE$.fromJava(Files.createTempFile((String)prefix$2.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$2.toSeq(), FileAttribute.class)));
    }

    private final Path createTempDirectory$$anonfun$1(Path dir$4, Option prefix$3, Iterable fileAttributes$3) {
        return Path$.MODULE$.fromJava(Files.createTempDirectory(dir$4.javaPath(), (String)prefix$3.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$3.toSeq(), FileAttribute.class)));
    }

    private final Path createTempDirectory$$anonfun$2(Option prefix$4, Iterable fileAttributes$4) {
        return Path$.MODULE$.fromJava(Files.createTempDirectory((String)prefix$4.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$4.toSeq(), FileAttribute.class)));
    }

    private final java.nio.file.Path createSymbolicLink$$anonfun$1(Path link$1, Path target$1, Seq fileAttributes$5) {
        return Files.createSymbolicLink(link$1.javaPath(), target$1.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$5, FileAttribute.class));
    }

    private final java.nio.file.Path createLink$$anonfun$1(Path link$2, Path existing$1) {
        return Files.createLink(link$2.javaPath(), existing$1.javaPath());
    }

    private final void delete$$anonfun$1(Path path$4) {
        Files.delete(path$4.javaPath());
    }

    private final boolean deleteIfExists$$anonfun$1(Path path$5) {
        return Files.deleteIfExists(path$5.javaPath());
    }

    private final ZIO deleteRecursive$$anonfun$2(Path path$6) {
        return this.delete(path$6);
    }

    private final java.nio.file.Path copy$$anonfun$1(Path source$1, Path target$2, Seq copyOptions$1) {
        return Files.copy(source$1.javaPath(), target$2.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions$1, CopyOption.class));
    }

    private final java.nio.file.Path move$$anonfun$1(Path source$2, Path target$3, Seq copyOptions$2) {
        return Files.move(source$2.javaPath(), target$3.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions$2, CopyOption.class));
    }

    private final Path readSymbolicLink$$anonfun$1(Path link$3) {
        return Path$.MODULE$.fromJava(Files.readSymbolicLink(link$3.javaPath()));
    }

    private final FileStore getFileStore$$anonfun$1(Path path$7) {
        return Files.getFileStore(path$7.javaPath());
    }

    private final boolean isSameFile$$anonfun$1(Path path$8, Path path2$1) {
        return Files.isSameFile(path$8.javaPath(), path2$1.javaPath());
    }

    private final boolean isHidden$$anonfun$1(Path path$9) {
        return Files.isHidden(path$9.javaPath());
    }

    private final String probeContentType$$anonfun$1(Path path$10) {
        return Files.probeContentType(path$10.javaPath());
    }

    private final FileAttributeView useFileAttributeView$$anonfun$1(Path path$11, Seq linkOptions$1, Class viewClass$1) {
        return Files.getFileAttributeView(path$11.javaPath(), viewClass$1, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$1, LinkOption.class));
    }

    private final BasicFileAttributes readAttributes$$anonfun$1(Path path$12, Seq linkOptions$2, Class attributeClass$1) {
        return Files.readAttributes(path$12.javaPath(), attributeClass$1, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$2, LinkOption.class));
    }

    private final java.nio.file.Path setAttribute$$anonfun$1(Path path$13, Files.Attribute attribute$1, Object value$1, Seq linkOptions$3) {
        return Files.setAttribute(path$13.javaPath(), attribute$1.toJava(), value$1, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$3, LinkOption.class));
    }

    private final Object getAttribute$$anonfun$1(Path path$14, Files.Attribute attribute$2, Seq linkOptions$4) {
        return Files.getAttribute(path$14.javaPath(), attribute$2.toJava(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$4, LinkOption.class));
    }

    private final Map readAttributes$$anonfun$2(Path path$15, Files.Attributes attributes$1, Seq linkOptions$5) {
        return Files.readAttributes(path$15.javaPath(), attributes$1.toJava(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$5, LinkOption.class));
    }

    private final java.util.Set getPosixFilePermissions$$anonfun$1(Path path$16, Seq linkOptions$6) {
        return Files.getPosixFilePermissions(path$16.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$6, LinkOption.class));
    }

    private final java.nio.file.Path setPosixFilePermissions$$anonfun$1(Path path$17, scala.collection.immutable.Set permissions$1) {
        return Files.setPosixFilePermissions(path$17.javaPath(), CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions$1).asJava());
    }

    private final UserPrincipal getOwner$$anonfun$1(Path path$18, Seq linkOptions$7) {
        return Files.getOwner(path$18.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$7, LinkOption.class));
    }

    private final java.nio.file.Path setOwner$$anonfun$1(Path path$19, UserPrincipal owner$1) {
        return Files.setOwner(path$19.javaPath(), owner$1);
    }

    private final boolean isSymbolicLink$$anonfun$1(Path path$20) {
        return Files.isSymbolicLink(path$20.javaPath());
    }

    private final boolean isDirectory$$anonfun$1(Path path$21, Seq linkOptions$8) {
        return Files.isDirectory(path$21.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$8, LinkOption.class));
    }

    private final boolean isRegularFile$$anonfun$1(Path path$22, Seq linkOptions$9) {
        return Files.isRegularFile(path$22.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$9, LinkOption.class));
    }

    private final FileTime getLastModifiedTime$$anonfun$1(Path path$23, Seq linkOptions$10) {
        return Files.getLastModifiedTime(path$23.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$10, LinkOption.class));
    }

    private final java.nio.file.Path setLastModifiedTime$$anonfun$1(Path path$24, FileTime time$1) {
        return Files.setLastModifiedTime(path$24.javaPath(), time$1);
    }

    private final long size$$anonfun$1(Path path$25) {
        return Files.size(path$25.javaPath());
    }

    private final boolean exists$$anonfun$1(Path path$26, Seq linkOptions$11) {
        return Files.exists(path$26.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$11, LinkOption.class));
    }

    private final boolean notExists$$anonfun$1(Path path$27, Seq linkOptions$12) {
        return Files.notExists(path$27.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$12, LinkOption.class));
    }

    private final boolean isReadable$$anonfun$1(Path path$28) {
        return Files.isReadable(path$28.javaPath());
    }

    private final boolean isWritable$$anonfun$1(Path path$29) {
        return Files.isWritable(path$29.javaPath());
    }

    private final boolean isExecutable$$anonfun$1(Path path$30) {
        return Files.isExecutable(path$30.javaPath());
    }

    private final Chunk readAllBytes$$anonfun$1(Path path$31) {
        return Chunk$.MODULE$.fromArray((Object)Files.readAllBytes(path$31.javaPath()));
    }

    private final List readAllLines$$anonfun$1(Path path$32, Charset charset$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(path$32.javaPath(), charset$1.javaCharset())).asScala().toList();
    }

    private final java.nio.file.Path writeBytes$$anonfun$1(Path path$33, Chunk bytes$1, Seq openOptions$1) {
        return Files.write(path$33.javaPath(), (byte[])bytes$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions$1, OpenOption.class));
    }

    private final java.nio.file.Path writeLines$$anonfun$1(Path path$34, Iterable lines$1, Charset charset$2, scala.collection.immutable.Set openOptions$2) {
        return Files.write(path$34.javaPath(), (java.lang.Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.IterableHasAsJava(lines$1).asJava(), charset$2.javaCharset(), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions$2.toSeq(), OpenOption.class));
    }

    private final Stream lines$$anonfun$1(Path path$35, Charset charset$3) {
        return Files.lines(path$35.javaPath(), charset$3.javaCharset());
    }

    private final Stream list$$anonfun$1(Path path$36) {
        return Files.list(path$36.javaPath());
    }

    private final Stream walk$$anonfun$1(Path path$37, int maxDepth$1, scala.collection.immutable.Set visitOptions$1) {
        return Files.walk(path$37.javaPath(), maxDepth$1, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions$1.toSeq(), FileVisitOption.class));
    }

    private final Stream find$$anonfun$1(Path path$38, int maxDepth$2, scala.collection.immutable.Set visitOptions$2, BiPredicate matcher$1) {
        return Files.find(path$38.javaPath(), maxDepth$2, matcher$1, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions$2.toSeq(), FileVisitOption.class));
    }

    private final long copy$$anonfun$3$$anonfun$1(Path target$4, Seq options$1, InputStream inputStream$1) {
        return Files.copy(inputStream$1, target$4.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(options$1, CopyOption.class));
    }
}

