/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Has;
import zio.ZIO;
import zio.ZManaged;
import zio.blocking.package;
import zio.nio.charset.Charset;
import zio.nio.file.Files$;
import zio.nio.file.Files$Attribute$;
import zio.nio.file.Files$AttributeNames$All$;
import zio.nio.file.Files$AttributeNames$List$;
import zio.nio.file.Files$Attributes$;
import zio.nio.file.Path;
import zio.stream.ZStream;

public final class Files {
    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> copy(Path path, Path path2, Seq<CopyOption> seq) {
        return Files$.MODULE$.copy(path, path2, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> copy(ZStream<Has<package.Blocking.Service>, IOException, Object> zStream, Path path, Seq<CopyOption> seq) {
        return Files$.MODULE$.copy(zStream, path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> seq) {
        return Files$.MODULE$.createDirectories(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> seq) {
        return Files$.MODULE$.createDirectory(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> seq) {
        return Files$.MODULE$.createFile(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createLink(Path path, Path path2) {
        return Files$.MODULE$.createLink(path, path2);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> createSymbolicLink(Path path, Path path2, Seq<FileAttribute<?>> seq) {
        return Files$.MODULE$.createSymbolicLink(path, path2, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Path> createTempDirectory(Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempDirectory(option, iterable);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Path> createTempDirectory(Path path, Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempDirectory(path, option, iterable);
    }

    public static ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempDirectoryManaged(Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempDirectoryManaged(option, iterable);
    }

    public static ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempDirectoryManaged(Path path, Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempDirectoryManaged(path, option, iterable);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Path> createTempFile(String string, Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempFile(string, option, iterable);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Path> createTempFileIn(Path path, String string, Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempFileIn(path, string, option, iterable);
    }

    public static ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempFileInManaged(Path path, String string, Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempFileInManaged(path, string, option, iterable);
    }

    public static ZManaged<Has<package.Blocking.Service>, IOException, Path> createTempFileManaged(String string, Option<String> option, Iterable<FileAttribute<?>> iterable) {
        return Files$.MODULE$.createTempFileManaged(string, option, iterable);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> delete(Path path) {
        return Files$.MODULE$.delete(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> deleteIfExists(Path path) {
        return Files$.MODULE$.deleteIfExists(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> deleteRecursive(Path path) {
        return Files$.MODULE$.deleteRecursive(path);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> exists(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.exists(path, seq);
    }

    public static ZStream<Has<package.Blocking.Service>, IOException, Path> find(Path path, int n, Set<FileVisitOption> set, Function2<Path, BasicFileAttributes, Object> function2) {
        return Files$.MODULE$.find(path, n, set, function2);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> getAttribute(Path path, Attribute attribute, Seq<LinkOption> seq) {
        return Files$.MODULE$.getAttribute(path, attribute, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, FileStore> getFileStore(Path path) {
        return Files$.MODULE$.getFileStore(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.getLastModifiedTime(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.getOwner(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.getPosixFilePermissions(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.isDirectory(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> isExecutable(Path path) {
        return Files$.MODULE$.isExecutable(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> isHidden(Path path) {
        return Files$.MODULE$.isHidden(path);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> isReadable(Path path) {
        return Files$.MODULE$.isReadable(path);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.isRegularFile(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> isSameFile(Path path, Path path2) {
        return Files$.MODULE$.isSameFile(path, path2);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> isSymbolicLink(Path path) {
        return Files$.MODULE$.isSymbolicLink(path);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> isWritable(Path path) {
        return Files$.MODULE$.isWritable(path);
    }

    public static ZStream<Has<package.Blocking.Service>, IOException, String> lines(Path path, Charset charset) {
        return Files$.MODULE$.lines(path, charset);
    }

    public static ZStream<Has<package.Blocking.Service>, IOException, Path> list(Path path) {
        return Files$.MODULE$.list(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> move(Path path, Path path2, Seq<CopyOption> seq) {
        return Files$.MODULE$.move(path, path2, seq);
    }

    public static ZStream<Has<package.Blocking.Service>, IOException, Path> newDirectoryStream(Path path, Function1<Path, Object> function1) {
        return Files$.MODULE$.newDirectoryStream(path, function1);
    }

    public static ZStream<Has<package.Blocking.Service>, IOException, Path> newDirectoryStream(Path path, String string) {
        return Files$.MODULE$.newDirectoryStream(path, string);
    }

    public static ZIO<Has<package.Blocking.Service>, Nothing$, Object> notExists(Path path, Seq<LinkOption> seq) {
        return Files$.MODULE$.notExists(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, String> probeContentType(Path path) {
        return Files$.MODULE$.probeContentType(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Chunk<Object>> readAllBytes(Path path) {
        return Files$.MODULE$.readAllBytes(path);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, List<String>> readAllLines(Path path, Charset charset) {
        return Files$.MODULE$.readAllLines(path, charset);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Map<String, Object>> readAttributes(Path path, Attributes attributes, Seq<LinkOption> seq) {
        return Files$.MODULE$.readAttributes(path, attributes, seq);
    }

    public static <A extends BasicFileAttributes> ZIO<Has<package.Blocking.Service>, IOException, A> readAttributes(Path path, Seq<LinkOption> seq, ClassTag<A> classTag) {
        return Files$.MODULE$.readAttributes(path, seq, classTag);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Path> readSymbolicLink(Path path) {
        return Files$.MODULE$.readSymbolicLink(path);
    }

    public static ZIO<Has<package.Blocking.Service>, Exception, BoxedUnit> setAttribute(Path path, Attribute attribute, Object object, Seq<LinkOption> seq) {
        return Files$.MODULE$.setAttribute(path, attribute, object, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime fileTime) {
        return Files$.MODULE$.setLastModifiedTime(path, fileTime);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setOwner(Path path, UserPrincipal userPrincipal) {
        return Files$.MODULE$.setOwner(path, userPrincipal);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> setPosixFilePermissions(Path path, Set<PosixFilePermission> set) {
        return Files$.MODULE$.setPosixFilePermissions(path, set);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, Object> size(Path path) {
        return Files$.MODULE$.size(path);
    }

    public static <A extends FileAttributeView, B, E> ZIO<Has<package.Blocking.Service>, E, B> useFileAttributeView(Path path, Seq<LinkOption> seq, Function1<A, ZIO<Has<package.Blocking.Service>, E, B>> function1, ClassTag<A> classTag) {
        return Files$.MODULE$.useFileAttributeView(path, seq, function1, classTag);
    }

    public static ZStream<Has<package.Blocking.Service>, IOException, Path> walk(Path path, int n, Set<FileVisitOption> set) {
        return Files$.MODULE$.walk(path, n, set);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> chunk, Seq<OpenOption> seq) {
        return Files$.MODULE$.writeBytes(path, chunk, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> iterable, Charset charset, Set<OpenOption> set) {
        return Files$.MODULE$.writeLines(path, iterable, charset, set);
    }

    public static String createTempFile$default$1() {
        return Files$.MODULE$.createTempFile$default$1();
    }

    public static String createTempFileManaged$default$1() {
        return Files$.MODULE$.createTempFileManaged$default$1();
    }

    public static String createTempFileIn$default$2() {
        return Files$.MODULE$.createTempFileIn$default$2();
    }

    public static String createTempFileInManaged$default$2() {
        return Files$.MODULE$.createTempFileInManaged$default$2();
    }

    public static Option<String> createTempFileManaged$default$2() {
        return Files$.MODULE$.createTempFileManaged$default$2();
    }

    public static int find$default$2() {
        return Files$.MODULE$.find$default$2();
    }

    public static Charset lines$default$2() {
        return Files$.MODULE$.lines$default$2();
    }

    public static String newDirectoryStream$default$2() {
        return Files$.MODULE$.newDirectoryStream$default$2();
    }

    public static Charset readAllLines$default$2() {
        return Files$.MODULE$.readAllLines$default$2();
    }

    public static int walk$default$2() {
        return Files$.MODULE$.walk$default$2();
    }

    public static Option<String> createTempFileInManaged$default$3() {
        return Files$.MODULE$.createTempFileInManaged$default$3();
    }

    public static Iterable<FileAttribute<?>> createTempFileManaged$default$3() {
        return Files$.MODULE$.createTempFileManaged$default$3();
    }

    public static Set<FileVisitOption> find$default$3() {
        return Files$.MODULE$.find$default$3();
    }

    public static Set<FileVisitOption> walk$default$3() {
        return Files$.MODULE$.walk$default$3();
    }

    public static Charset writeLines$default$3() {
        return Files$.MODULE$.writeLines$default$3();
    }

    public static Iterable<FileAttribute<?>> createTempFileInManaged$default$4() {
        return Files$.MODULE$.createTempFileInManaged$default$4();
    }

    public static Set<OpenOption> writeLines$default$4() {
        return Files$.MODULE$.writeLines$default$4();
    }

    public static final class Attribute
    implements Product,
    Serializable {
        private final String attributeName;
        private final String viewName;

        public static Attribute apply(String string, String string2) {
            return Files$Attribute$.MODULE$.apply(string, string2);
        }

        public static Option<Attribute> fromJava(String string) {
            return Files$Attribute$.MODULE$.fromJava(string);
        }

        public static Attribute fromProduct(Product product) {
            return Files$Attribute$.MODULE$.fromProduct(product);
        }

        public static Attribute unapply(Attribute attribute) {
            return Files$Attribute$.MODULE$.unapply(attribute);
        }

        public static String $lessinit$greater$default$2() {
            return Files$Attribute$.MODULE$.$lessinit$greater$default$2();
        }

        public Attribute(String attributeName, String viewName) {
            this.attributeName = attributeName;
            this.viewName = viewName;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Attribute)) return false;
            Attribute attribute = (Attribute)object;
            String string = this.attributeName();
            String string2 = attribute.attributeName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.viewName();
            String string4 = attribute.viewName();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Attribute;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Attribute";
        }

        public Object productElement(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = this._1();
            } else if (1 == n2) {
                string = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "attributeName";
            } else if (1 == n2) {
                string = "viewName";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String attributeName() {
            return this.attributeName;
        }

        public String viewName() {
            return this.viewName;
        }

        public String toJava() {
            return "" + this.viewName() + ":" + this.attributeName();
        }

        public Attribute copy(String attributeName, String viewName) {
            return new Attribute(attributeName, viewName);
        }

        public String copy$default$1() {
            return this.attributeName();
        }

        public String copy$default$2() {
            return this.viewName();
        }

        public String _1() {
            return this.attributeName();
        }

        public String _2() {
            return this.viewName();
        }
    }

    public static interface AttributeNames {
        public static String toJava$(AttributeNames $this) {
            return $this.toJava();
        }

        default public String toJava() {
            String string;
            AttributeNames attributeNames = this;
            if (Files$AttributeNames$All$.MODULE$.equals(attributeNames)) {
                string = "*";
            } else if (attributeNames instanceof List) {
                scala.collection.immutable.List<String> list;
                List list2 = Files$AttributeNames$List$.MODULE$.unapply((List)attributeNames);
                scala.collection.immutable.List<String> names = list = list2._1();
                string = names.mkString(",");
            } else {
                throw new MatchError((Object)attributeNames);
            }
            return string;
        }

        public static final class List
        implements AttributeNames,
        Product,
        Serializable {
            private final scala.collection.immutable.List names;

            public static List apply(scala.collection.immutable.List<String> list) {
                return Files$AttributeNames$List$.MODULE$.apply(list);
            }

            public static List fromProduct(Product product) {
                return Files$AttributeNames$List$.MODULE$.fromProduct(product);
            }

            public static List unapply(List list) {
                return Files$AttributeNames$List$.MODULE$.unapply(list);
            }

            public List(scala.collection.immutable.List<String> names) {
                this.names = names;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof List)) return false;
                List list = (List)object;
                scala.collection.immutable.List<String> list2 = this.names();
                scala.collection.immutable.List<String> list3 = list.names();
                if (list2 != null) {
                    if (!list2.equals(list3)) return false;
                    return true;
                }
                if (list3 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof List;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "List";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return this._1();
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return "names";
            }

            public scala.collection.immutable.List<String> names() {
                return this.names;
            }

            public List copy(scala.collection.immutable.List<String> names) {
                return new List(names);
            }

            public scala.collection.immutable.List<String> copy$default$1() {
                return this.names();
            }

            public scala.collection.immutable.List<String> _1() {
                return this.names();
            }
        }
    }

    public static final class Attributes
    implements Product,
    Serializable {
        private final AttributeNames attributeNames;
        private final String viewName;

        public static Attributes apply(AttributeNames attributeNames, String string) {
            return Files$Attributes$.MODULE$.apply(attributeNames, string);
        }

        public static Option<Attributes> fromJava(String string) {
            return Files$Attributes$.MODULE$.fromJava(string);
        }

        public static Attributes fromProduct(Product product) {
            return Files$Attributes$.MODULE$.fromProduct(product);
        }

        public static Attributes unapply(Attributes attributes) {
            return Files$Attributes$.MODULE$.unapply(attributes);
        }

        public static String $lessinit$greater$default$2() {
            return Files$Attributes$.MODULE$.$lessinit$greater$default$2();
        }

        public Attributes(AttributeNames attributeNames, String viewName) {
            this.attributeNames = attributeNames;
            this.viewName = viewName;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Attributes)) return false;
            Attributes attributes = (Attributes)object;
            AttributeNames attributeNames = this.attributeNames();
            AttributeNames attributeNames2 = attributes.attributeNames();
            if (attributeNames == null) {
                if (attributeNames2 != null) {
                    return false;
                }
            } else if (!attributeNames.equals(attributeNames2)) return false;
            String string = this.viewName();
            String string2 = attributes.viewName();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Attributes;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Attributes";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "attributeNames";
            } else if (1 == n2) {
                string = "viewName";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public AttributeNames attributeNames() {
            return this.attributeNames;
        }

        public String viewName() {
            return this.viewName;
        }

        public String toJava() {
            return "" + this.viewName() + ":" + this.attributeNames().toJava();
        }

        public Attributes copy(AttributeNames attributeNames, String viewName) {
            return new Attributes(attributeNames, viewName);
        }

        public AttributeNames copy$default$1() {
            return this.attributeNames();
        }

        public String copy$default$2() {
            return this.viewName();
        }

        public AttributeNames _1() {
            return this.attributeNames();
        }

        public String _2() {
            return this.viewName();
        }
    }
}

