/*
 * Decompiled with CFR 0.152.
 */
package zio.nio;

import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer;
import zio.nio.CharBuffer;
import zio.nio.DoubleBuffer;
import zio.nio.FloatBuffer;
import zio.nio.IntBuffer;
import zio.nio.LongBuffer;
import zio.nio.ShortBuffer;

public class ByteBuffer
extends Buffer<Object> {
    private final java.nio.ByteBuffer buffer;

    public ByteBuffer(java.nio.ByteBuffer buffer) {
        this.buffer = buffer;
        super(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    @Override
    public java.nio.ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public final ZIO<Object, Nothing$, byte[]> array(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.buffer().array(), trace);
    }

    @Override
    public final ZIO<Object, Nothing$, ByteOrder> order(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> this.buffer().order(), trace);
    }

    public ZIO<Object, Nothing$, BoxedUnit> order(ByteOrder o, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> this.buffer().order(o), trace).unit(trace);
    }

    @Override
    public final ZIO<Object, Nothing$, ByteBuffer> slice(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> new ByteBuffer(this.buffer().slice()), trace);
    }

    @Override
    public final ZIO<Object, Nothing$, BoxedUnit> compact(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> this.buffer().compact(), trace).unit(trace);
    }

    @Override
    public final ZIO<Object, Nothing$, ByteBuffer> duplicate(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> new ByteBuffer(this.buffer().duplicate()), trace);
    }

    public <R, E, A> ZIO<R, E, A> withJavaBuffer(Function1<java.nio.ByteBuffer, ZIO<R, E, A>> f, Object trace) {
        return (ZIO)f.apply((Object)this.buffer());
    }

    @Override
    public final ZIO<Object, Nothing$, Object> get(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> this.buffer().get(), trace);
    }

    @Override
    public final ZIO<Object, Nothing$, Object> get(int i, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> this.buffer().get(i), trace);
    }

    @Override
    public final ZIO<Object, Nothing$, Chunk<Object>> getChunk(int maxLength, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> {
            byte[] array = new byte[package$.MODULE$.min(maxLength, this.buffer().remaining())];
            this.buffer().get(array);
            return Chunk$.MODULE$.fromArray((Object)array);
        }, trace);
    }

    @Override
    public int getChunk$default$1() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final ZIO<Object, Nothing$, BoxedUnit> put(byte element, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$10 -> this.buffer().put(element), trace).unit(trace);
    }

    @Override
    public final ZIO<Object, Nothing$, BoxedUnit> put(int index, byte element, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> this.buffer().put(index, element), trace).unit(trace);
    }

    public ZIO<Object, Nothing$, BoxedUnit> putByteBuffer(ByteBuffer source, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$12 -> this.buffer().put(source.buffer()), trace).unit(trace);
    }

    @Override
    public final ZIO<Object, Nothing$, BoxedUnit> putChunkAll(Chunk<Object> chunk, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$13 -> {
            byte[] array = (byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
            return this.buffer().put(array);
        }, trace).unit(trace);
    }

    @Override
    public final ZIO<Object, Nothing$, ByteBuffer> asReadOnlyBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$14 -> new ByteBuffer(this.buffer().asReadOnlyBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, CharBuffer> asCharBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$15 -> new CharBuffer(this.buffer().asCharBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, DoubleBuffer> asDoubleBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$16 -> new DoubleBuffer(this.buffer().asDoubleBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, FloatBuffer> asFloatBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$17 -> new FloatBuffer(this.buffer().asFloatBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, IntBuffer> asIntBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$18 -> new IntBuffer(this.buffer().asIntBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, LongBuffer> asLongBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$19 -> new LongBuffer(this.buffer().asLongBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, ShortBuffer> asShortBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$20 -> new ShortBuffer(this.buffer().asShortBuffer()), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putChar(char value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$21 -> this.buffer().putChar(value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putChar(int index, char value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$22 -> this.buffer().putChar(index, value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putDouble(double value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$23 -> this.buffer().putDouble(value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putDouble(int index, double value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$24 -> this.buffer().putDouble(index, value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putFloat(float value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$25 -> this.buffer().putFloat(value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putFloat(int index, float value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$26 -> this.buffer().putFloat(index, value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putInt(int value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$27 -> this.buffer().putInt(value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putInt(int index, int value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$28 -> this.buffer().putInt(index, value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putLong(long value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$29 -> this.buffer().putLong(value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putLong(int index, long value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$30 -> this.buffer().putLong(index, value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putShort(short value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$31 -> this.buffer().putShort(value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> putShort(int index, short value, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$32 -> this.buffer().putShort(index, value), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, Object> getChar(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$33 -> this.buffer().getChar(), trace);
    }

    public final ZIO<Object, Nothing$, Object> getChar(int index, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$34 -> this.buffer().getChar(index), trace);
    }

    public final ZIO<Object, Nothing$, Object> getDouble(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$35 -> this.buffer().getDouble(), trace);
    }

    public final ZIO<Object, Nothing$, Object> getDouble(int index, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$36 -> this.buffer().getDouble(index), trace);
    }

    public final ZIO<Object, Nothing$, Object> getFloat(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$37 -> this.buffer().getFloat(), trace);
    }

    public final ZIO<Object, Nothing$, Object> getFloat(int index, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$38 -> this.buffer().getFloat(index), trace);
    }

    public final ZIO<Object, Nothing$, Object> getInt(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$39 -> this.buffer().getInt(), trace);
    }

    public final ZIO<Object, Nothing$, Object> getInt(int index, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$40 -> this.buffer().getInt(index), trace);
    }

    public final ZIO<Object, Nothing$, Object> getLong(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$41 -> this.buffer().getLong(), trace);
    }

    public final ZIO<Object, Nothing$, Object> getLong(int index, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$42 -> this.buffer().getLong(index), trace);
    }

    public final ZIO<Object, Nothing$, Object> getShort(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$43 -> this.buffer().getShort(), trace);
    }

    public final ZIO<Object, Nothing$, Object> getShort(int index, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$44 -> this.buffer().getShort(index), trace);
    }
}

