/*
 * Decompiled with CFR 0.152.
 */
package zio.nio;

import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer;

public final class LongBuffer
extends Buffer<Object> {
    private final java.nio.LongBuffer buffer;

    public LongBuffer(java.nio.LongBuffer buffer) {
        this.buffer = buffer;
        super(ClassTag$.MODULE$.apply(Long.TYPE));
    }

    @Override
    public java.nio.LongBuffer buffer() {
        return this.buffer;
    }

    @Override
    public ZIO<Object, Nothing$, long[]> array(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.buffer().array(), trace);
    }

    @Override
    public ZIO<Object, Nothing$, ByteOrder> order(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> this.buffer().order(), trace);
    }

    @Override
    public ZIO<Object, Nothing$, LongBuffer> slice(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> new LongBuffer(this.buffer().slice()), trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> compact(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> this.buffer().compact(), trace).unit(trace);
    }

    @Override
    public ZIO<Object, Nothing$, LongBuffer> duplicate(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> new LongBuffer(this.buffer().duplicate()), trace);
    }

    public <R, E, A> ZIO<R, E, A> withJavaBuffer(Function1<java.nio.LongBuffer, ZIO<R, E, A>> f, Object trace) {
        return (ZIO)f.apply((Object)this.buffer());
    }

    @Override
    public ZIO<Object, Nothing$, Object> get(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> this.buffer().get(), trace);
    }

    @Override
    public ZIO<Object, Nothing$, Object> get(int i, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> this.buffer().get(i), trace);
    }

    @Override
    public ZIO<Object, Nothing$, Chunk<Object>> getChunk(int maxLength, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> {
            long[] array = new long[package$.MODULE$.min(maxLength, this.buffer().remaining())];
            this.buffer().get(array);
            return Chunk$.MODULE$.fromArray((Object)array);
        }, trace);
    }

    @Override
    public int getChunk$default$1() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> put(long element, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> this.buffer().put(element), trace).unit(trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> put(int index, long element, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$10 -> this.buffer().put(index, element), trace).unit(trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> putChunkAll(Chunk<Object> chunk, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> {
            long[] array = (long[])chunk.toArray(ClassTag$.MODULE$.apply(Long.TYPE));
            return this.buffer().put(array);
        }, trace).unit(trace);
    }

    @Override
    public ZIO<Object, Nothing$, LongBuffer> asReadOnlyBuffer(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$12 -> new LongBuffer(this.buffer().asReadOnlyBuffer()), trace);
    }
}

