/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Ref;
import zio.Ref$;
import zio.Schedule;
import zio.Schedule$;
import zio.Scope;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.channels.AsynchronousByteChannel$;
import zio.nio.channels.AsynchronousFileChannel$;
import zio.nio.channels.Channel;
import zio.nio.channels.FileLock;
import zio.nio.file.Path;
import zio.nio.package$;
import zio.stream.ZChannel;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class AsynchronousFileChannel
implements Channel {
    private final java.nio.channels.AsynchronousFileChannel channel;

    public static AsynchronousFileChannel fromJava(java.nio.channels.AsynchronousFileChannel asynchronousFileChannel) {
        return AsynchronousFileChannel$.MODULE$.fromJava(asynchronousFileChannel);
    }

    public static ZIO<Scope, IOException, AsynchronousFileChannel> open(Path path, Seq<OpenOption> seq, Object object) {
        return AsynchronousFileChannel$.MODULE$.open(path, seq, object);
    }

    public static ZIO<Scope, IOException, AsynchronousFileChannel> open(Path path, Set<OpenOption> set, Option<ExecutionContextExecutorService> option, Set<FileAttribute<?>> set2, Object object) {
        return AsynchronousFileChannel$.MODULE$.open(path, set, option, set2, object);
    }

    public AsynchronousFileChannel(java.nio.channels.AsynchronousFileChannel channel) {
        this.channel = channel;
    }

    @Override
    public java.nio.channels.AsynchronousFileChannel channel() {
        return this.channel;
    }

    public ZIO<Object, IOException, BoxedUnit> force(boolean metaData, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> this.channel().force(metaData), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, FileLock> lock(long position, long size, boolean shared, Object trace) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$1 -> {
            c.lock(position, size, shared, BoxedUnit.UNIT, _$1);
            return BoxedUnit.UNIT;
        }, trace).map((Function1 & Serializable)_$2 -> new FileLock((java.nio.channels.FileLock)_$2), trace);
    }

    public long lock$default$1() {
        return 0L;
    }

    public long lock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean lock$default$3() {
        return false;
    }

    public ZIO<Object, IOException, Object> read(ByteBuffer dst, long position, Object trace) {
        return dst.withJavaBuffer((Function1 & Serializable)buf -> AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$3 -> {
            c.read((java.nio.ByteBuffer)buf, position, BoxedUnit.UNIT, _$3);
            return BoxedUnit.UNIT;
        }, trace).flatMap((Function1 & Serializable)_$4 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Integer2int(_$4), trace), trace), trace);
    }

    public ZIO<Object, IOException, Chunk<Object>> readChunk(int capacity, long position, Object trace) {
        return Buffer$.MODULE$.byte(capacity, trace).flatMap((Function1 & Serializable)b -> this.read((ByteBuffer)b, position, trace).flatMap((Function1 & Serializable)x$1 -> AsynchronousFileChannel.readChunk$$anonfun$1$$anonfun$1(trace, b, BoxesRunTime.unboxToInt((Object)x$1)), trace), trace);
    }

    public ZIO<Object, IOException, Object> size(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$2 -> this.channel().size(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> truncate(long size, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$3 -> this.channel().truncate(size), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public ZIO<Object, IOException, FileLock> tryLock(long position, long size, boolean shared, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$4 -> new FileLock(this.channel().tryLock(position, size, shared)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public long tryLock$default$1() {
        return 0L;
    }

    public long tryLock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean tryLock$default$3() {
        return false;
    }

    public ZIO<Object, IOException, Object> write(ByteBuffer src, long position, Object trace) {
        return src.withJavaBuffer((Function1 & Serializable)buf -> AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$5 -> {
            c.write((java.nio.ByteBuffer)buf, position, BoxedUnit.UNIT, _$5);
            return BoxedUnit.UNIT;
        }, trace).map((Function1 & Serializable)_$6 -> _$6, trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> writeChunk(Chunk<Object> src, long position, Object trace) {
        return Buffer$.MODULE$.byte(src, trace).flatMap((Function1 & Serializable)b -> this.go$1((ByteBuffer)b, position, trace), trace);
    }

    public ZStream<Object, IOException, Object> stream(long position, Object trace) {
        return this.stream(position, Buffer$.MODULE$.byte(5000, trace), trace);
    }

    public ZStream<Object, IOException, Object> stream(long position, ZIO<Object, Nothing$, ByteBuffer> bufferConstruct, Object trace) {
        boolean bl = ZStream$.MODULE$.unwrapScoped();
        return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.stream$$anonfun$1(position, bufferConstruct, trace), trace);
    }

    public ZChannel sink(long position, Object trace) {
        return this.sink(position, Buffer$.MODULE$.byte(5000, trace), trace);
    }

    public ZChannel sink(long position, ZIO<Object, Nothing$, ByteBuffer> bufferConstruct, Object trace) {
        return ZSink$.MODULE$.fromPush(bufferConstruct.flatMap((Function1 & Serializable)buffer -> Ref$.MODULE$.make(() -> AsynchronousFileChannel.sink$$anonfun$1$$anonfun$1(position), trace).map((Function1 & Serializable)posRef -> (Function1 & Serializable)_$7 -> (ZIO)_$7.map((Function1 & Serializable)chunk -> posRef.get(trace).flatMap((Function1 & Serializable)currentPos -> this.sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(trace, (ByteBuffer)buffer, (Ref)posRef, (Chunk)chunk, BoxesRunTime.unboxToLong((Object)currentPos)), trace)).getOrElse(() -> AsynchronousFileChannel.sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(position, trace, posRef)), trace), trace), trace);
    }

    private static final /* synthetic */ ZIO readChunk$$anonfun$1$$anonfun$1(Object trace$4, ByteBuffer b$1, int x$12) {
        int n = x$12;
        return b$1.flip(trace$4).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return b$1.getChunk(b$1.getChunk$default$1(), trace$4).map((Function1 & Serializable)chunk -> chunk, trace$4);
        }, trace$4);
    }

    private final /* synthetic */ ZIO go$1$$anonfun$1$$anonfun$1(ByteBuffer b$5, long pos$2, Object trace$8, int bytesWritten$1, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return this.go$1(b$5, pos$2 + (long)bytesWritten$1, trace$8);
        }
        if (!bl) {
            return ZIO$.MODULE$.unit();
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final /* synthetic */ ZIO go$1$$anonfun$1(ByteBuffer b$4, long pos$1, Object trace$7, int bytesWritten) {
        return b$4.hasRemaining(trace$7).flatMap((Function1 & Serializable)x$1 -> this.go$1$$anonfun$1$$anonfun$1(b$4, pos$1, trace$7, bytesWritten, BoxesRunTime.unboxToBoolean((Object)x$1)), trace$7);
    }

    private final ZIO go$1(ByteBuffer b$3, long pos, Object trace) {
        return this.write(b$3, pos, trace).flatMap((Function1 & Serializable)bytesWritten -> this.go$1$$anonfun$1(b$3, pos, trace, BoxesRunTime.unboxToInt((Object)bytesWritten)), trace);
    }

    private static final long stream$$anonfun$1$$anonfun$1(long position$13) {
        return position$13;
    }

    private static final /* synthetic */ ZIO $anonfun$1$$anonfun$1(Object trace$14, Ref posRef$3, ByteBuffer buffer$2, long pos$3, int count) {
        return posRef$3.set((Object)BoxesRunTime.boxToLong((long)(pos$3 + (long)count)), trace$14).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return buffer$2.flip(trace$14).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return buffer$2.getChunk(buffer$2.getChunk$default$1(), trace$14).flatMap((Function1 & Serializable)chunk -> buffer$2.clear(trace$14).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return chunk;
                }, trace$14), trace$14);
            }, trace$14);
        }, trace$14);
    }

    private final /* synthetic */ ZIO $anonfun$1(Object trace$13, Ref posRef$2, ByteBuffer buffer$1, long pos) {
        return this.read(buffer$1, pos, trace$13).flatMap((Function1 & Serializable)count -> AsynchronousFileChannel.$anonfun$1$$anonfun$1(trace$13, posRef$2, buffer$1, pos, BoxesRunTime.unboxToInt((Object)count)), trace$13);
    }

    private static final ZIO stream$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Object trace$18, ZIO doRead$1) {
        return doRead$1.mapError((Function1 & Serializable)x$1 -> {
            IOException iOException = x$1;
            if (iOException instanceof EOFException) {
                return None$.MODULE$;
            }
            IOException e = iOException;
            return Some$.MODULE$.apply((Object)e);
        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$18);
    }

    private final ZIO stream$$anonfun$1(long position$12, ZIO bufferConstruct$1, Object trace$10) {
        return Ref$.MODULE$.make(() -> AsynchronousFileChannel.stream$$anonfun$1$$anonfun$1(position$12), trace$10).flatMap((Function1 & Serializable)posRef -> bufferConstruct$1.map((Function1 & Serializable)buffer -> {
            ZIO doRead = posRef.get(trace$10).flatMap((Function1 & Serializable)pos -> this.$anonfun$1(trace$10, (Ref)posRef, (ByteBuffer)buffer, BoxesRunTime.unboxToLong((Object)pos)), trace$10);
            return ZStream$.MODULE$.repeatZIOChunkOption(() -> AsynchronousFileChannel.stream$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(trace$10, doRead), trace$10);
        }, trace$10), trace$10);
    }

    private static final long sink$$anonfun$1$$anonfun$1(long position$15) {
        return position$15;
    }

    private final ZIO $anonfun$2$$anonfun$1$$anonfun$1(ByteBuffer buffer$12, long currentPos$3, Object trace$25) {
        return this.write(buffer$12, currentPos$3, trace$25);
    }

    private static final /* synthetic */ ZIO $anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(ZIO x$1$1, int y) {
        return (ZIO)Function$.MODULE$.const((Object)x$1$1, (Object)BoxesRunTime.boxToInteger((int)y));
    }

    private static final Schedule $anonfun$2$$anonfun$1$$anonfun$2(ByteBuffer buffer$13, Object trace$26) {
        ZIO<Object, Nothing$, Object> zIO = buffer$13.hasRemaining(trace$26);
        return Schedule$.MODULE$.recurWhileZIO((Function1 & Serializable)y -> AsynchronousFileChannel.$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(zIO, BoxesRunTime.unboxToInt((Object)y)));
    }

    private static final /* synthetic */ ZIO $anonfun$2$$anonfun$1$$anonfun$3(ByteBuffer buffer$14, long currentPos$4, Object trace$27, Chunk remaining$2, int count) {
        return buffer$14.clear(trace$27).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(currentPos$4 + (long)count)), (Object)remaining$2);
        }, trace$27);
    }

    private final ZIO doWrite$1(ByteBuffer buffer$9, long currentPos, Chunk c, Object trace) {
        ZIO x = buffer$9.putChunk(c, trace).flatMap((Function1 & Serializable)remaining -> buffer$9.flip(trace).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ZStream$.MODULE$.repeatZIOWithSchedule(() -> this.$anonfun$2$$anonfun$1$$anonfun$1(buffer$9, currentPos, trace), () -> AsynchronousFileChannel.$anonfun$2$$anonfun$1$$anonfun$2(buffer$9, trace), trace).runSum((Numeric)Numeric.IntIsIntegral$.MODULE$, trace).flatMap((Function1 & Serializable)count -> AsynchronousFileChannel.$anonfun$2$$anonfun$1$$anonfun$3(buffer$9, currentPos, trace, remaining, BoxesRunTime.unboxToInt((Object)count)), trace);
        }, trace), trace);
        return x.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long l = BoxesRunTime.unboxToLong((Object)tuple2._1());
                Chunk chunk = (Chunk)tuple2._2();
                long result = l;
                Chunk remaining = chunk;
                if (remaining.isEmpty()) {
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> result, trace);
                }
                long result2 = l;
                Chunk remaining2 = chunk;
                return this.doWrite$1(buffer$9, result2, remaining2, trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace);
    }

    private static final Tuple2 sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(IOException e$2, Chunk chunk$3) {
        return Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Left().apply((Object)e$2), (Object)chunk$3);
    }

    private static final /* synthetic */ ZIO sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(Object trace$32, Ref posRef$7, long newPos) {
        return posRef$7.set((Object)BoxesRunTime.boxToLong((long)newPos), trace$32).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, trace$32);
    }

    private final /* synthetic */ ZIO sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Object trace$29, ByteBuffer buffer$16, Ref posRef$6, Chunk chunk$2, long currentPos) {
        return this.doWrite$1(buffer$16, currentPos, chunk$2, trace$29).catchAll((Function1 & Serializable)e -> buffer$16.getChunk(buffer$16.getChunk$default$1(), trace$29).flatMap((Function1 & Serializable)chunk -> ZIO$.MODULE$.fail(() -> AsynchronousFileChannel.sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(e, chunk), trace$29), trace$29), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$29).flatMap((Function1 & Serializable)newPos -> AsynchronousFileChannel.sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(trace$29, posRef$6, BoxesRunTime.unboxToLong((Object)newPos)), trace$29);
    }

    private static final Tuple2 sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(long position$19, long finalPos$1) {
        return Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(finalPos$1 - position$19))), (Object)Chunk$.MODULE$.empty());
    }

    private static final ZIO sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(long position$18, Object trace$33, Ref posRef$8) {
        return posRef$8.get(trace$33).flatMap((Function1 & Serializable)finalPos -> ZIO$.MODULE$.fail(() -> AsynchronousFileChannel.sink$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(position$18, BoxesRunTime.unboxToLong((Object)finalPos)), trace$33), trace$33);
    }
}

