/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketOption;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.DurationOps$;
import zio.Scope;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.SocketAddress;
import zio.nio.SocketAddress$;
import zio.nio.channels.AsynchronousByteChannel;
import zio.nio.channels.AsynchronousByteChannel$;
import zio.nio.channels.AsynchronousChannelGroup;
import zio.nio.channels.AsynchronousSocketChannel$;
import zio.package$;

public final class AsynchronousSocketChannel
extends AsynchronousByteChannel {
    private final java.nio.channels.AsynchronousSocketChannel channel;

    public static AsynchronousSocketChannel fromJava(java.nio.channels.AsynchronousSocketChannel asynchronousSocketChannel) {
        return AsynchronousSocketChannel$.MODULE$.fromJava(asynchronousSocketChannel);
    }

    public static ZIO<Scope, IOException, AsynchronousSocketChannel> open(AsynchronousChannelGroup asynchronousChannelGroup, Object object) {
        return AsynchronousSocketChannel$.MODULE$.open(asynchronousChannelGroup, object);
    }

    public static ZIO<Scope, IOException, AsynchronousSocketChannel> open(Object object) {
        return AsynchronousSocketChannel$.MODULE$.open(object);
    }

    public AsynchronousSocketChannel(java.nio.channels.AsynchronousSocketChannel channel) {
        this.channel = channel;
        super(channel);
    }

    @Override
    public java.nio.channels.AsynchronousSocketChannel channel() {
        return this.channel;
    }

    public ZIO<Object, IOException, BoxedUnit> bindTo(SocketAddress address, Object trace) {
        return this.bind((Option<SocketAddress>)Some$.MODULE$.apply((Object)address), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> bindAuto(Object trace) {
        return this.bind((Option<SocketAddress>)None$.MODULE$, trace);
    }

    public ZIO<Object, IOException, BoxedUnit> bind(Option<SocketAddress> address, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$9 -> this.channel().bind((java.net.SocketAddress)address.map((Function1 & Serializable)_$10 -> _$10.jSocketAddress()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public <T> ZIO<Object, IOException, BoxedUnit> setOption(SocketOption<T> name, T value, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$10 -> this.channel().setOption(name, value), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public ZIO<Object, IOException, BoxedUnit> shutdownInput(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$11 -> this.channel().shutdownInput(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public ZIO<Object, IOException, BoxedUnit> shutdownOutput(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$12 -> this.channel().shutdownOutput(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public ZIO<Object, IOException, Option<SocketAddress>> remoteAddress(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$13 -> Option$.MODULE$.apply((Object)this.channel().getRemoteAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Option<SocketAddress>> localAddress(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$14 -> Option$.MODULE$.apply((Object)this.channel().getLocalAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> connect(SocketAddress socketAddress, Object trace) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)c -> (Function1 & Serializable)_$11 -> {
            c.connect(socketAddress.jSocketAddress(), BoxedUnit.UNIT, _$11);
            return BoxedUnit.UNIT;
        }, trace).unit(trace);
    }

    public ZIO<Object, IOException, Object> read(ByteBuffer dst, Duration timeout, Object trace) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> (Function1 & Serializable)_$13 -> {
            channel.read(dst.buffer(), BoxesRunTime.unboxToLong((Object)DurationOps$.MODULE$.fold$extension(package$.MODULE$.duration2DurationOps(timeout), AsynchronousSocketChannel::read$$anonfun$3$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$12 -> _$12.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$13);
            return BoxedUnit.UNIT;
        }, trace).flatMap((Function1 & Serializable)_$14 -> zio.nio.package$.MODULE$.eofCheck(Predef$.MODULE$.Integer2int(_$14), trace), trace);
    }

    public ZIO<Object, IOException, Chunk<Object>> readChunk(int capacity, Duration timeout, Object trace) {
        return Buffer$.MODULE$.byte(capacity, trace).flatMap((Function1 & Serializable)b -> this.read((ByteBuffer)b, timeout, trace).flatMap((Function1 & Serializable)x$1 -> AsynchronousSocketChannel.readChunk$$anonfun$2$$anonfun$1(trace, b, BoxesRunTime.unboxToInt((Object)x$1)), trace), trace);
    }

    public ZIO<Object, IOException, Object> read(List<ByteBuffer> dsts, Duration timeout, Object trace) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> {
            java.nio.ByteBuffer[] a = (java.nio.ByteBuffer[])dsts.map((Function1 & Serializable)_$15 -> _$15.buffer()).toArray(ClassTag$.MODULE$.apply(java.nio.ByteBuffer.class));
            return (Function1 & Serializable)_$17 -> {
                channel.read(a, 0, a.length, BoxesRunTime.unboxToLong((Object)DurationOps$.MODULE$.fold$extension(package$.MODULE$.duration2DurationOps(timeout), AsynchronousSocketChannel::read$$anonfun$5$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$16 -> _$16.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$17);
                return BoxedUnit.UNIT;
            };
        }, trace).flatMap((Function1 & Serializable)_$18 -> zio.nio.package$.MODULE$.eofCheck(Predef$.MODULE$.Long2long(_$18), trace), trace);
    }

    public ZIO<Object, IOException, List<Chunk<Object>>> readChunks(List<Object> capacities, Duration timeout, Object trace) {
        return ZIO$.MODULE$.foreach(capacities, (Function1 & Serializable)capacity -> Buffer$.MODULE$.byte(BoxesRunTime.unboxToInt((Object)capacity), trace), BuildFrom$.MODULE$.buildFromIterableOps(), trace).flatMap((Function1 & Serializable)buffers -> this.read((List<ByteBuffer>)buffers, timeout, trace).$times$greater(() -> AsynchronousSocketChannel.readChunks$$anonfun$2$$anonfun$1(trace, buffers), trace), trace);
    }

    public ZIO<Object, IOException, Object> write(ByteBuffer src, Duration timeout, Object trace) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> (Function1 & Serializable)_$20 -> {
            channel.write(src.buffer(), BoxesRunTime.unboxToLong((Object)DurationOps$.MODULE$.fold$extension(package$.MODULE$.duration2DurationOps(timeout), AsynchronousSocketChannel::write$$anonfun$3$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$19 -> _$19.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$20);
            return BoxedUnit.UNIT;
        }, trace).map((Function1 & Serializable)_$21 -> Predef$.MODULE$.Integer2int(_$21), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> writeChunk(Chunk<Object> chunk, Duration timeout, Object trace) {
        return Buffer$.MODULE$.byte(chunk.length(), trace).flatMap((Function1 & Serializable)b -> b.putChunk(chunk, trace).flatMap((Function1 & Serializable)x$1 -> {
            Chunk chunk = x$1;
            return b.flip(trace).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.write((ByteBuffer)b, timeout, trace).map((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                    int n = x$1;
                }, trace);
            }, trace);
        }, trace), trace);
    }

    public ZIO<Object, IOException, Object> write(List<ByteBuffer> srcs, Duration timeout, Object trace) {
        return AsynchronousByteChannel$.MODULE$.effectAsyncChannel(this.channel(), (Function1 & Serializable)channel -> {
            java.nio.ByteBuffer[] a = (java.nio.ByteBuffer[])srcs.map((Function1 & Serializable)_$22 -> _$22.buffer()).toArray(ClassTag$.MODULE$.apply(java.nio.ByteBuffer.class));
            return (Function1 & Serializable)_$24 -> {
                channel.write(a, 0, a.length, BoxesRunTime.unboxToLong((Object)DurationOps$.MODULE$.fold$extension(package$.MODULE$.duration2DurationOps(timeout), AsynchronousSocketChannel::write$$anonfun$5$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$23 -> _$23.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, _$24);
                return BoxedUnit.UNIT;
            };
        }, trace).map((Function1 & Serializable)_$25 -> Predef$.MODULE$.Long2long(_$25), trace);
    }

    public ZIO<Object, IOException, Object> writeChunks(List<Chunk<Object>> chunks, Duration timeout, Object trace) {
        return ZIO$.MODULE$.foreach(chunks, (Function1 & Serializable)chunk -> Buffer$.MODULE$.byte(chunk.length(), trace).tap((Function1 & Serializable)_$26 -> _$26.putChunk(chunk, trace), trace).tap((Function1 & Serializable)_$27 -> _$27.flip(trace), trace), BuildFrom$.MODULE$.buildFromIterableOps(), trace).flatMap((Function1 & Serializable)_$28 -> this.write((List<ByteBuffer>)_$28, timeout, trace), trace);
    }

    private static final long read$$anonfun$3$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final /* synthetic */ ZIO readChunk$$anonfun$2$$anonfun$1(Object trace$33, ByteBuffer b$8, int x$12) {
        int n = x$12;
        return b$8.flip(trace$33).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return b$8.getChunk(b$8.getChunk$default$1(), trace$33).map((Function1 & Serializable)r -> r, trace$33);
        }, trace$33);
    }

    private static final long read$$anonfun$5$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final ZIO readChunks$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Object trace$40, ByteBuffer b$10) {
        return b$10.getChunk(b$10.getChunk$default$1(), trace$40);
    }

    private static final ZIO readChunks$$anonfun$2$$anonfun$1(Object trace$38, List buffers$1) {
        return ZIO$.MODULE$.foreach((Iterable)buffers$1, (Function1 & Serializable)b -> b.flip(trace$38).$times$greater(() -> AsynchronousSocketChannel.readChunks$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(trace$38, b), trace$38), BuildFrom$.MODULE$.buildFromIterableOps(), trace$38);
    }

    private static final long write$$anonfun$3$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final long write$$anonfun$5$$anonfun$1$$anonfun$1() {
        return Long.MAX_VALUE;
    }
}

