/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Scope;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.ByteBuffer;
import zio.nio.MappedByteBuffer;
import zio.nio.channels.BlockingChannel;
import zio.nio.channels.Channel;
import zio.nio.channels.FileChannel$;
import zio.nio.channels.FileLock;
import zio.nio.channels.GatheringByteOps;
import zio.nio.channels.ScatteringByteOps;
import zio.nio.file.Path;

public final class FileChannel
implements Channel,
BlockingChannel {
    private final java.nio.channels.FileChannel channel;

    public static FileChannel fromJava(java.nio.channels.FileChannel fileChannel) {
        return FileChannel$.MODULE$.fromJava(fileChannel);
    }

    public static ZIO<Scope, IOException, FileChannel> open(Path path, Seq<OpenOption> seq, Object object) {
        return FileChannel$.MODULE$.open(path, seq, object);
    }

    public static ZIO<Scope, IOException, FileChannel> open(Path path, Set<? extends OpenOption> set, Seq<FileAttribute<?>> seq, Object object) {
        return FileChannel$.MODULE$.open(path, set, seq, object);
    }

    public FileChannel(java.nio.channels.FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public java.nio.channels.FileChannel channel() {
        return this.channel;
    }

    public <R, E, A> ZIO<R, E, A> flatMapBlocking(Function1<BlockingFileOps, ZIO<R, E, A>> f, Object trace) {
        return this.nioBlocking((ZIO)f.apply((Object)new BlockingFileOps()), trace);
    }

    public ZIO<Object, IOException, Object> position(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$9 -> this.channel().position(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> position(long newPosition, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$10 -> this.channel().position(newPosition), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> size(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$11 -> this.channel().size(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Option<FileLock>> tryLock(long position, long size, boolean shared, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$12 -> Option$.MODULE$.apply((Object)this.channel().tryLock(position, size, shared)).map((Function1 & Serializable)_$1 -> new FileLock((java.nio.channels.FileLock)_$1)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public long tryLock$default$1() {
        return 0L;
    }

    public long tryLock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean tryLock$default$3() {
        return false;
    }

    public final class BlockingFileOps
    implements GatheringByteOps,
    ScatteringByteOps {
        public BlockingFileOps() {
            if (FileChannel.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public java.nio.channels.FileChannel channel() {
            return FileChannel.this.channel();
        }

        public ZIO<Object, IOException, BoxedUnit> truncate(long size, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> this.channel().truncate(size), trace).unit(trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, BoxedUnit> force(boolean metadata, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$2 -> this.channel().force(metadata), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, Object> transferTo(long position, long count, GatheringByteOps target, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$3 -> this.channel().transferTo(position, count, target.channel()), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, Object> transferFrom(ScatteringByteOps src, long position, long count, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$4 -> this.channel().transferFrom(src.channel(), position, count), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, Object> read(ByteBuffer dst, long position, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(dst.withJavaBuffer((Function1 & Serializable)buffer -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$5 -> this.channel().read((java.nio.ByteBuffer)buffer, position), trace), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, Object> write(ByteBuffer src, long position, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(src.withJavaBuffer((Function1 & Serializable)buffer -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$6 -> this.channel().write((java.nio.ByteBuffer)buffer, position), trace), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, MappedByteBuffer> map(FileChannel.MapMode mode, long position, long size, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$7 -> new MappedByteBuffer(this.channel().map(mode, position, size)), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, FileLock> lock(long position, long size, boolean shared, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$8 -> new FileLock(this.channel().lock(position, size, shared)), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public long lock$default$1() {
            return 0L;
        }

        public long lock$default$2() {
            return Long.MAX_VALUE;
        }

        public boolean lock$default$3() {
            return false;
        }

        public final /* synthetic */ FileChannel zio$nio$channels$FileChannel$BlockingFileOps$$$outer() {
            return FileChannel.this;
        }
    }
}

