/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.Serializable;
import java.nio.channels.Pipe;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.channels.Channel;
import zio.nio.channels.DatagramChannel;
import zio.nio.channels.Pipe;
import zio.nio.channels.SelectableChannel;
import zio.nio.channels.SelectionKey$Operation$;
import zio.nio.channels.Selector;
import zio.nio.channels.ServerSocketChannel;
import zio.nio.channels.SocketChannel;

public final class SelectionKey {
    private final java.nio.channels.SelectionKey selectionKey;

    public SelectionKey(java.nio.channels.SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public java.nio.channels.SelectionKey selectionKey() {
        return this.selectionKey;
    }

    public SelectableChannel channel() {
        java.nio.channels.SelectableChannel selectableChannel = this.selectionKey().channel();
        if (selectableChannel instanceof java.nio.channels.SocketChannel) {
            java.nio.channels.SocketChannel c = (java.nio.channels.SocketChannel)selectableChannel;
            return new SocketChannel(c);
        }
        if (selectableChannel instanceof java.nio.channels.ServerSocketChannel) {
            java.nio.channels.ServerSocketChannel c = (java.nio.channels.ServerSocketChannel)selectableChannel;
            return new ServerSocketChannel(c);
        }
        if (selectableChannel instanceof java.nio.channels.DatagramChannel) {
            java.nio.channels.DatagramChannel c = (java.nio.channels.DatagramChannel)selectableChannel;
            return new DatagramChannel(c);
        }
        if (selectableChannel instanceof Pipe.SinkChannel) {
            Pipe.SinkChannel c = (Pipe.SinkChannel)selectableChannel;
            return new Pipe.SinkChannel(c);
        }
        if (selectableChannel instanceof Pipe.SourceChannel) {
            Pipe.SourceChannel c = (Pipe.SourceChannel)selectableChannel;
            return new Pipe.SourceChannel(c);
        }
        java.nio.channels.SelectableChannel other = selectableChannel;
        return new Channel(other){
            private final java.nio.channels.SelectableChannel channel;
            {
                this.channel = other$1;
            }

            public java.nio.channels.SelectableChannel channel() {
                return this.channel;
            }

            public Nothing$ makeBlockingOps() {
                return Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public Nothing$ makeNonBlockingOps() {
                return Predef$.MODULE$.$qmark$qmark$qmark();
            }
        };
    }

    public <R, E, A> ZIO<R, E, A> matchChannel(Function1<Set<Operation>, PartialFunction<SelectableChannel, ZIO<R, E, A>>> matcher, Object trace) {
        return this.readyOps(trace).flatMap((Function1 & Serializable)_$1 -> (ZIO)((PartialFunction)matcher.apply(_$1)).applyOrElse((Object)this.channel(), (Function1 & Serializable)channel -> ZIO$.MODULE$.dieMessage(() -> SelectionKey.matchChannel$$anonfun$1$$anonfun$1$$anonfun$1(channel), trace)), trace);
    }

    public final Selector selector() {
        return new Selector(this.selectionKey().selector());
    }

    public final ZIO<Object, Nothing$, Object> isValid(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.selectionKey().isValid(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> cancel(Object trace) {
        return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$2 -> this.selectionKey().cancel(), trace);
    }

    public final ZIO<Object, Nothing$, Set<Operation>> interestOps(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> SelectionKey$Operation$.MODULE$.fromInt(this.selectionKey().interestOps()), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> interestOps(Set<Operation> ops, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> this.selectionKey().interestOps(SelectionKey$Operation$.MODULE$.toInt(ops)), trace).unit(trace);
    }

    public ZIO<Object, Nothing$, Set<Operation>> interested(Operation op, Object trace) {
        return this.interestOps(trace).map((Function1 & Serializable)current -> {
            Set newInterest = (Set)current.$plus((Object)op);
            return Tuple2$.MODULE$.apply(current, (Object)newInterest);
        }, trace).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Set current = (Set)tuple2._1();
                Set newInterest = (Set)tuple2._2();
                return this.interestOps((Set<Operation>)newInterest, trace).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return newInterest;
                }, trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace);
    }

    public ZIO<Object, Nothing$, Set<Operation>> notInterested(Operation op, Object trace) {
        return this.interestOps(trace).map((Function1 & Serializable)current -> {
            Set newInterest = (Set)current.$minus((Object)op);
            return Tuple2$.MODULE$.apply(current, (Object)newInterest);
        }, trace).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Set current = (Set)tuple2._1();
                Set newInterest = (Set)tuple2._2();
                return this.interestOps((Set<Operation>)newInterest, trace).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return newInterest;
                }, trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace);
    }

    public final ZIO<Object, Nothing$, Set<Operation>> readyOps(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> SelectionKey$Operation$.MODULE$.fromInt(this.selectionKey().readyOps()), trace);
    }

    public final ZIO<Object, Nothing$, Object> isReadable(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> this.selectionKey().isReadable(), trace);
    }

    public final ZIO<Object, Nothing$, Object> isWritable(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> this.selectionKey().isWritable(), trace);
    }

    public final ZIO<Object, Nothing$, Object> isConnectable(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> this.selectionKey().isConnectable(), trace);
    }

    public final ZIO<Object, Nothing$, Object> isAcceptable(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> this.selectionKey().isAcceptable(), trace);
    }

    public final ZIO<Object, Nothing$, Option<Object>> attach(Option<Object> ob, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$10 -> Option$.MODULE$.apply(this.selectionKey().attach(ob.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))), trace);
    }

    public final ZIO<Object, Nothing$, Option<Object>> attachment(Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> this.selectionKey().attachment(), trace).map((Function1 & Serializable)_$2 -> Option$.MODULE$.apply(_$2), trace);
    }

    public String toString() {
        return this.selectionKey().toString();
    }

    public int hashCode() {
        return this.selectionKey().hashCode();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof SelectionKey) {
            SelectionKey other = (SelectionKey)object;
            return this.selectionKey().equals(other.selectionKey());
        }
        return false;
    }

    private static final String matchChannel$$anonfun$1$$anonfun$1$$anonfun$1(SelectableChannel channel$1) {
        return new StringBuilder(25).append("Unexpected channel type: ").append(channel$1).toString();
    }

    public static abstract class Operation {
        private final int intVal;

        public static Set<Operation> fromInt(int n) {
            return SelectionKey$Operation$.MODULE$.fromInt(n);
        }

        public static Set<Operation> fullSet() {
            return SelectionKey$Operation$.MODULE$.fullSet();
        }

        public static int ordinal(Operation operation) {
            return SelectionKey$Operation$.MODULE$.ordinal(operation);
        }

        public static int toInt(Set<Operation> set) {
            return SelectionKey$Operation$.MODULE$.toInt(set);
        }

        public Operation(int intVal) {
            this.intVal = intVal;
        }

        public int intVal() {
            return this.intVal;
        }
    }
}

