/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.charset;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichFloat$;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.CharBuffer;
import zio.nio.charset.AutoDetect;
import zio.nio.charset.AutoDetect$Detected$;
import zio.nio.charset.AutoDetect$NotDetected$;
import zio.nio.charset.AutoDetect$NotSupported$;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$;
import zio.nio.charset.CharsetDecoder;
import zio.nio.charset.CoderResult;
import zio.nio.charset.CoderResult$;
import zio.nio.charset.CoderResult$Malformed$;
import zio.nio.charset.CoderResult$Overflow$;
import zio.nio.charset.CoderResult$Underflow$;
import zio.nio.charset.CoderResult$Unmappable$;
import zio.stream.ZChannel;
import zio.stream.ZChannel$;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class CharsetDecoder$
implements Serializable {
    public static final CharsetDecoder$ MODULE$ = new CharsetDecoder$();

    private CharsetDecoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CharsetDecoder$.class);
    }

    public java.nio.charset.CharsetDecoder fromJava(java.nio.charset.CharsetDecoder javaDecoder) {
        return javaDecoder;
    }

    public final int hashCode$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(java.nio.charset.CharsetDecoder $this, Object x$0) {
        Object object = x$0;
        if (object instanceof CharsetDecoder) {
            java.nio.charset.CharsetDecoder charsetDecoder = object == null ? null : ((CharsetDecoder)object).javaDecoder();
            java.nio.charset.CharsetDecoder charsetDecoder2 = $this;
            java.nio.charset.CharsetDecoder charsetDecoder3 = charsetDecoder;
            return !(charsetDecoder2 != null ? !charsetDecoder2.equals(charsetDecoder3) : charsetDecoder3 != null);
        }
        return false;
    }

    public final float averageCharsPerByte$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.averageCharsPerByte();
    }

    public final Charset charset$extension(java.nio.charset.CharsetDecoder $this) {
        return Charset$.MODULE$.fromJava($this.charset());
    }

    public final ZIO<Object, CharacterCodingException, CharBuffer> decode$extension(java.nio.charset.CharsetDecoder $this, ByteBuffer in, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(in.withJavaBuffer((Function1 & Serializable)jBuf -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> Buffer$.MODULE$.charFromJava($this.decode((java.nio.ByteBuffer)jBuf)), trace), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(CharacterCodingException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public final ZIO<Object, Nothing$, CoderResult> decode$extension(java.nio.charset.CharsetDecoder $this, ByteBuffer in, CharBuffer out, boolean endOfInput, Object trace) {
        return in.withJavaBuffer((Function1 & Serializable)jIn -> out.withJavaBuffer((Function1 & Serializable)jOut -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> CoderResult$.MODULE$.fromJava($this.decode((java.nio.ByteBuffer)jIn, (java.nio.CharBuffer)jOut, endOfInput)), trace), trace), trace);
    }

    public final ZIO<Object, Nothing$, AutoDetect> autoDetect$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> {
            if ($this.isAutoDetecting()) {
                return $this.isCharsetDetected() ? AutoDetect$Detected$.MODULE$.apply(Charset$.MODULE$.fromJava($this.detectedCharset())) : AutoDetect$NotDetected$.MODULE$;
            }
            return AutoDetect$NotSupported$.MODULE$;
        }, trace);
    }

    public final ZIO<Object, Nothing$, CoderResult> flush$extension(java.nio.charset.CharsetDecoder $this, CharBuffer out, Object trace) {
        return out.withJavaBuffer((Function1 & Serializable)jOut -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> CoderResult$.MODULE$.fromJava($this.flush((java.nio.CharBuffer)jOut)), trace), trace);
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> malformedInputAction$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> $this.malformedInputAction(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onMalformedInput$extension(java.nio.charset.CharsetDecoder $this, CodingErrorAction errorAction, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> $this.onMalformedInput(errorAction), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> unmappableCharacterAction$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> $this.unmappableCharacterAction(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onUnmappableCharacter$extension(java.nio.charset.CharsetDecoder $this, CodingErrorAction errorAction, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> $this.onUnmappableCharacter(errorAction), trace).unit(trace);
    }

    public final float maxCharsPerByte$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.maxCharsPerByte();
    }

    public final ZIO<Object, Nothing$, String> replacement$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> $this.replacement(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> replaceWith$extension(java.nio.charset.CharsetDecoder $this, String replacement, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$10 -> $this.replaceWith(replacement), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> reset$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> $this.reset(), trace).unit(trace);
    }

    public final ZPipeline<Object, CharacterCodingException, Object, Object> transducer$extension(java.nio.charset.CharsetDecoder $this, int bufSize, Object trace) {
        if (bufSize < 50) {
            return ZPipeline$.MODULE$.fromChannel(() -> this.transducer$extension$$anonfun$1(bufSize, trace));
        }
        return ZPipeline$.MODULE$.fromPush(() -> this.transducer$extension$$anonfun$2($this, bufSize, trace), trace);
    }

    public final int transducer$default$1$extension(java.nio.charset.CharsetDecoder $this) {
        return 5000;
    }

    private final ZIO handleCoderResult$1$$anonfun$1(CharBuffer charBuffer$2, Object trace$8) {
        return charBuffer$2.flip(trace$8);
    }

    private final ZIO handleCoderResult$1$$anonfun$2(CharBuffer charBuffer$3, Object trace$9) {
        return charBuffer$3.getChunk(charBuffer$3.getChunk$default$1(), trace$9);
    }

    private final ZIO handleCoderResult$1$$anonfun$3(CharBuffer charBuffer$4, Object trace$10) {
        return charBuffer$4.clear(trace$10);
    }

    private final MalformedInputException handleCoderResult$1$$anonfun$4(int length$1) {
        return new MalformedInputException(length$1);
    }

    private final UnmappableCharacterException handleCoderResult$1$$anonfun$5(int length$2) {
        return new UnmappableCharacterException(length$2);
    }

    private final ZIO handleCoderResult$1(ByteBuffer byteBuffer$2, CharBuffer charBuffer$1, CoderResult coderResult, Object trace) {
        CoderResult coderResult2 = coderResult;
        if (CoderResult$Underflow$.MODULE$.equals(coderResult2) || CoderResult$Overflow$.MODULE$.equals(coderResult2)) {
            return byteBuffer$2.compact(trace).$times$greater(() -> this.handleCoderResult$1$$anonfun$1(charBuffer$1, trace), trace).$times$greater(() -> this.handleCoderResult$1$$anonfun$2(charBuffer$1, trace), trace).$less$times(() -> this.handleCoderResult$1$$anonfun$3(charBuffer$1, trace), trace);
        }
        if (coderResult2 instanceof CoderResult.Malformed) {
            int n;
            CoderResult.Malformed malformed = CoderResult$Malformed$.MODULE$.unapply((CoderResult.Malformed)coderResult2);
            int length = n = malformed._1();
            return ZIO$.MODULE$.fail(() -> this.handleCoderResult$1$$anonfun$4(length), trace);
        }
        if (coderResult2 instanceof CoderResult.Unmappable) {
            int n;
            CoderResult.Unmappable unmappable = CoderResult$Unmappable$.MODULE$.unapply((CoderResult.Unmappable)coderResult2);
            int length = n = unmappable._1();
            return ZIO$.MODULE$.fail(() -> this.handleCoderResult$1$$anonfun$5(length), trace);
        }
        throw new MatchError((Object)coderResult2);
    }

    private final /* synthetic */ Tuple2 decodeChunk$1$$anonfun$1(Chunk inBytes$1, int bufRemaining) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = inBytes$1.length() > bufRemaining ? inBytes$1.splitAt(bufRemaining) : Tuple2$.MODULE$.apply((Object)inBytes$1, (Object)Chunk$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Chunk decodeBytes = (Chunk)tuple2._1();
        Chunk remainingBytes = (Chunk)tuple2._2();
        Tuple2 $1$ = tuple2;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)decodeBytes, (Object)remainingBytes);
        Tuple2 $1$2 = (Tuple2)tuple3._1();
        Chunk decodeBytes2 = (Chunk)tuple3._2();
        Chunk remainingBytes2 = (Chunk)tuple3._3();
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)bufRemaining), (Object)$1$2);
    }

    private final ZIO decodeChunk$1(java.nio.charset.CharsetDecoder $this$22, ByteBuffer byteBuffer$5, CharBuffer charBuffer$7, Chunk inBytes, Object trace) {
        return byteBuffer$5.remaining(trace).map((Function1 & Serializable)bufRemaining -> this.decodeChunk$1$$anonfun$1(inBytes, BoxesRunTime.unboxToInt((Object)bufRemaining)), trace).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                int bufRemaining = BoxesRunTime.unboxToInt((Object)tuple2._1());
                if (tuple22 != null) {
                    Chunk decodeBytes = (Chunk)tuple22._1();
                    Chunk remainingBytes = (Chunk)tuple22._2();
                    return byteBuffer$5.putChunk(decodeBytes, trace).flatMap((Function1 & Serializable)x$12 -> {
                        Chunk chunk = x$12;
                        return byteBuffer$5.flip(trace).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.decode$extension($this$22, byteBuffer$5, charBuffer$7, false, trace).flatMap((Function1 & Serializable)result -> this.handleCoderResult$1(byteBuffer$5, charBuffer$7, (CoderResult)result, trace).flatMap((Function1 & Serializable)decodedChars -> (remainingBytes.isEmpty() ? ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$12 -> Chunk$.MODULE$.empty(), trace) : this.decodeChunk$1($this$22, byteBuffer$5, charBuffer$7, remainingBytes, trace)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace), trace), trace);
                        }, trace);
                    }, trace);
                }
            }
            throw new MatchError((Object)tuple2);
        }, trace);
    }

    private final ZIO endOfInput$4(java.nio.charset.CharsetDecoder $this$29, ByteBuffer byteBuffer$12, CharBuffer charBuffer$14, Object trace) {
        return this.decode$extension($this$29, byteBuffer$12, charBuffer$14, true, trace).flatMap((Function1 & Serializable)result -> this.handleCoderResult$1(byteBuffer$12, charBuffer$14, (CoderResult)result, trace).flatMap((Function1 & Serializable)decodedChars -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (!(coderResult != null ? !coderResult.equals(coderResult$Overflow$) : coderResult$Overflow$ != null) ? this.endOfInput$4($this$29, byteBuffer$12, charBuffer$14, trace) : ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$13 -> Chunk$.MODULE$.empty(), trace)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace);
        }, trace), trace);
    }

    private final ZIO flushRemaining$1(java.nio.charset.CharsetDecoder $this$34, ByteBuffer byteBuffer$17, CharBuffer charBuffer$19, Object trace) {
        return this.flush$extension($this$34, charBuffer$19, trace).flatMap((Function1 & Serializable)result -> this.handleCoderResult$1(byteBuffer$17, charBuffer$19, (CoderResult)result, trace).flatMap((Function1 & Serializable)decodedChars -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (!(coderResult != null ? !coderResult.equals(coderResult$Overflow$) : coderResult$Overflow$ != null) ? this.flushRemaining$1($this$34, byteBuffer$17, charBuffer$19, trace) : ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$14 -> Chunk$.MODULE$.empty(), trace)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace);
        }, trace), trace);
    }

    private final ZIO push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(java.nio.charset.CharsetDecoder $this$32, Object trace$21, ByteBuffer byteBuffer$15, CharBuffer charBuffer$17) {
        return this.endOfInput$4($this$32, byteBuffer$15, charBuffer$17, trace$21).flatMap((Function1 & Serializable)decodedChars -> this.flushRemaining$1($this$32, byteBuffer$15, charBuffer$17, trace$21).map((Function1 & Serializable)_$2 -> decodedChars.$plus$plus(_$2), trace$21), trace$21);
    }

    private final ZIO push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Object trace$25, ByteBuffer byteBuffer$20) {
        return byteBuffer$20.clear(trace$25);
    }

    private final ZIO push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$3(Object trace$26, CharBuffer charBuffer$22) {
        return charBuffer$22.clear(trace$26);
    }

    private final ZIO push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(java.nio.charset.CharsetDecoder $this$28, Object trace$18, ByteBuffer byteBuffer$11, CharBuffer charBuffer$13) {
        return byteBuffer$11.flip(trace$18).$times$greater(() -> this.push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1($this$28, trace$18, byteBuffer$11, charBuffer$13), trace$18).$less$times(() -> this.push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(trace$18, byteBuffer$11), trace$18).$less$times(() -> this.push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$3(trace$18, charBuffer$13), trace$18);
    }

    private final ZIO push$1(java.nio.charset.CharsetDecoder $this$16, int bufSize$1, Object trace) {
        return this.reset$extension($this$16, trace).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Buffer$.MODULE$.byte(bufSize$1, trace).flatMap((Function1 & Serializable)byteBuffer -> Buffer$.MODULE$.char(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufSize$1 * this.averageCharsPerByte$extension($this$16))), trace).map((Function1 & Serializable)charBuffer -> (Function1 & Serializable)_$1 -> (ZIO)_$1.map((Function1 & Serializable)inChunk -> this.decodeChunk$1($this$16, (ByteBuffer)byteBuffer, (CharBuffer)charBuffer, (Chunk)inChunk, trace)).getOrElse(() -> this.push$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2($this$16, trace, byteBuffer, charBuffer)), trace), trace);
        }, trace);
    }

    private final IllegalArgumentException transducer$extension$$anonfun$1$$anonfun$1$$anonfun$1(int bufSize$6) {
        return new IllegalArgumentException(new StringBuilder(30).append("Buffer size is ").append(bufSize$6).append(", must be >= 50").toString());
    }

    private final ZIO transducer$extension$$anonfun$1$$anonfun$1(int bufSize$5, Object trace$28) {
        return ZIO$.MODULE$.die(() -> this.transducer$extension$$anonfun$1$$anonfun$1$$anonfun$1(bufSize$5), trace$28);
    }

    private final ZChannel transducer$extension$$anonfun$1(int bufSize$4, Object trace$27) {
        return ZChannel$.MODULE$.fromZIO(() -> this.transducer$extension$$anonfun$1$$anonfun$1(bufSize$4, trace$27), trace$27);
    }

    private final ZIO transducer$extension$$anonfun$2(java.nio.charset.CharsetDecoder $this$37, int bufSize$7, Object trace$29) {
        return this.push$1($this$37, bufSize$7, trace$29);
    }
}

