/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.function.BiPredicate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.Scope;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$Standard$;
import zio.nio.file.Files;
import zio.nio.file.Files$Attribute$;
import zio.nio.file.Files$AttributeNames$;
import zio.nio.file.Files$Attributes$;
import zio.nio.file.Path;
import zio.nio.file.Path$;
import zio.stream.ZChannel;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Files$
implements Serializable {
    public static final Files$Attribute$ Attribute;
    public static final Files$AttributeNames$ AttributeNames;
    public static final Files$Attributes$ Attributes;
    public static final Files$ MODULE$;

    private Files$() {
    }

    static {
        MODULE$ = new Files$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Files$.class);
    }

    public ZStream<Object, IOException, Path> newDirectoryStream(Path dir, String glob, Object trace) {
        ZIO scoped = ZIO$.MODULE$.fromAutoCloseable(() -> this.$anonfun$1(dir, glob, trace), trace).map((Function1 & Serializable)_$1 -> _$1.iterator(), trace);
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorScoped(() -> this.newDirectoryStream$$anonfun$1(scoped), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public String newDirectoryStream$default$2() {
        return "*";
    }

    public ZStream<Object, IOException, Path> newDirectoryStream(Path dir, Function1<Path, Object> filter, Object trace) {
        DirectoryStream.Filter<java.nio.file.Path> javaFilter = javaPath -> BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        ZIO scoped = ZIO$.MODULE$.fromAutoCloseable(() -> this.$anonfun$4(dir, trace, javaFilter), trace).map((Function1 & Serializable)_$2 -> _$2.iterator(), trace);
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorScoped(() -> this.newDirectoryStream$$anonfun$3(scoped), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$5 -> Files.createFile(path.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs, FileAttribute.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$6 -> Files.createDirectory(path.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs, FileAttribute.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$7 -> Files.createDirectories(path.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs, FileAttribute.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Path> createTempFileIn(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$8 -> Path$.MODULE$.fromJava(Files.createTempFile(dir.javaPath(), (String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix, (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes.toSeq(), FileAttribute.class))), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public String createTempFileIn$default$2() {
        return ".tmp";
    }

    public ZIO<Scope, IOException, Path> createTempFileInScoped(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease(() -> this.createTempFileInScoped$$anonfun$1(dir, suffix, prefix, fileAttributes, trace), (Function1 & Serializable)_$3 -> this.deleteIfExists((Path)_$3, trace).ignore(trace), trace);
    }

    public String createTempFileInScoped$default$2() {
        return ".tmp";
    }

    public Option<String> createTempFileInScoped$default$3() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileInScoped$default$4() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Object, IOException, Path> createTempFile(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$9 -> Path$.MODULE$.fromJava(Files.createTempFile((String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix, (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes.toSeq(), FileAttribute.class))), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public String createTempFile$default$1() {
        return ".tmp";
    }

    public ZIO<Scope, IOException, Path> createTempFileScoped(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease(() -> this.createTempFileScoped$$anonfun$1(suffix, prefix, fileAttributes, trace), (Function1 & Serializable)_$4 -> this.deleteIfExists((Path)_$4, trace).ignore(trace), trace);
    }

    public String createTempFileScoped$default$1() {
        return ".tmp";
    }

    public Option<String> createTempFileScoped$default$2() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileScoped$default$3() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Object, IOException, Path> createTempDirectory(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$10 -> Path$.MODULE$.fromJava(Files.createTempDirectory(dir.javaPath(), (String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes.toSeq(), FileAttribute.class))), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Scope, IOException, Path> createTempDirectoryScoped(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease(() -> this.createTempDirectoryScoped$$anonfun$1(dir, prefix, fileAttributes, trace), (Function1 & Serializable)_$5 -> this.deleteRecursive((Path)_$5, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, Path> createTempDirectory(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$11 -> Path$.MODULE$.fromJava(Files.createTempDirectory((String)prefix.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes.toSeq(), FileAttribute.class))), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Scope, IOException, Path> createTempDirectoryScoped(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease(() -> this.createTempDirectoryScoped$$anonfun$3(prefix, fileAttributes, trace), (Function1 & Serializable)_$6 -> this.deleteRecursive((Path)_$6, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createSymbolicLink(Path link, Path target, Seq<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$12 -> Files.createSymbolicLink(link.javaPath(), target.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes, FileAttribute.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createLink(Path link, Path existing, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$13 -> Files.createLink(link.javaPath(), existing.javaPath()), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> delete(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$14 -> Files.delete(path.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> deleteIfExists(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$15 -> Files.deleteIfExists(path.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> deleteRecursive(Path path2, Object trace) {
        return this.newDirectoryStream(path2, this.newDirectoryStream$default$2(), trace).mapZIO((Function1 & Serializable)path -> this.delete((Path)path, trace), trace).run((Function0 & Serializable)() -> new ZSink(this.deleteRecursive$$anonfun$2(trace)), trace).$less$times(() -> this.deleteRecursive$$anonfun$3(path2, trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> copy(Path source, Path target, Seq<CopyOption> copyOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$16 -> Files.copy(source.javaPath(), target.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> move(Path source, Path target, Seq<CopyOption> copyOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$17 -> Files.move(source.javaPath(), target.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Path> readSymbolicLink(Path link, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$18 -> Path$.MODULE$.fromJava(Files.readSymbolicLink(link.javaPath())), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, FileStore> getFileStore(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$19 -> Files.getFileStore(path.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> isSameFile(Path path, Path path2, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$20 -> Files.isSameFile(path.javaPath(), path2.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> isHidden(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$21 -> Files.isHidden(path.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, String> probeContentType(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$22 -> Files.probeContentType(path.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public <A extends FileAttributeView, B, E> ZIO<Object, E, B> useFileAttributeView(Path path, Seq<LinkOption> linkOptions, Function1<A, ZIO<Object, E, B>> f, ClassTag<A> evidence$1, Object trace) {
        Class viewClass = scala.reflect.package$.MODULE$.classTag(evidence$1).runtimeClass();
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$23 -> Files.getFileAttributeView(path.javaPath(), viewClass, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).flatMap(f, trace);
    }

    public <A extends BasicFileAttributes> ZIO<Object, IOException, A> readAttributes(Path path, Seq<LinkOption> linkOptions, ClassTag<A> evidence$2, Object trace) {
        Class attributeClass = scala.reflect.package$.MODULE$.classTag(evidence$2).runtimeClass();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$24 -> Files.readAttributes(path.javaPath(), attributeClass, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Exception, BoxedUnit> setAttribute(Path path, Files.Attribute attribute, Object value, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$25 -> Files.setAttribute(path.javaPath(), attribute.toJava(), value, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> getAttribute(Path path, Files.Attribute attribute, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$26 -> Files.getAttribute(path.javaPath(), attribute.toJava(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Map<String, Object>> readAttributes(Path path, Files.Attributes attributes, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$27 -> Files.readAttributes(path.javaPath(), attributes.toJava(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).map((Function1 & Serializable)_$7 -> CollectionConverters$.MODULE$.MapHasAsScala(_$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, scala.collection.immutable.Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$28 -> Files.getPosixFilePermissions(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).map((Function1 & Serializable)_$8 -> CollectionConverters$.MODULE$.SetHasAsScala(_$8).asScala().toSet(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setPosixFilePermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$29 -> Files.setPosixFilePermissions(path.javaPath(), CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions).asJava()), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$30 -> Files.getOwner(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setOwner(Path path, UserPrincipal owner, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$31 -> Files.setOwner(path.javaPath(), owner), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isSymbolicLink(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$32 -> Files.isSymbolicLink(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$33 -> Files.isDirectory(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$34 -> Files.isRegularFile(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$35 -> Files.getLastModifiedTime(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime time, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$36 -> Files.setLastModifiedTime(path.javaPath(), time), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> size(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$37 -> Files.size(path.javaPath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> exists(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$38 -> Files.exists(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> notExists(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$39 -> Files.notExists(path.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isReadable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$40 -> Files.isReadable(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isWritable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$41 -> Files.isWritable(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isExecutable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$42 -> Files.isExecutable(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Chunk<Object>> readAllBytes(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$43 -> Chunk$.MODULE$.fromArray((Object)Files.readAllBytes(path.javaPath())), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, List<String>> readAllLines(Path path, Charset charset, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$44 -> CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(path.javaPath(), charset.javaCharset())).asScala().toList(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public Charset readAllLines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZIO<Object, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> bytes, Seq<OpenOption> openOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$45 -> Files.write(path.javaPath(), (byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions, OpenOption.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> lines, Charset charset, scala.collection.immutable.Set<OpenOption> openOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$46 -> Files.write(path.javaPath(), (java.lang.Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.IterableHasAsJava(lines).asJava(), charset.javaCharset(), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions.toSeq(), OpenOption.class)), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public Charset writeLines$default$3() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public scala.collection.immutable.Set<OpenOption> writeLines$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Object, IOException, String> lines(Path path, Charset charset, Object trace) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped(() -> this.lines$$anonfun$1(path, charset, trace), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public Charset lines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZStream<Object, IOException, Path> list(Path path, Object trace) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped(() -> this.list$$anonfun$1(path, trace), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZStream<Object, IOException, Path> walk(Path path, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Object trace) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped(() -> this.walk$$anonfun$1(path, maxDepth, visitOptions, trace), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public int walk$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> walk$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Object, IOException, Path> find(Path path2, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Function2<Path, BasicFileAttributes, Object> test, Object trace) {
        BiPredicate<java.nio.file.Path, BasicFileAttributes> matcher = (path, attr) -> BoxesRunTime.unboxToBoolean((Object)test.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)path), attr));
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped(() -> this.find$$anonfun$1(path2, maxDepth, visitOptions, trace, matcher), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public int find$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> find$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZIO<Object, IOException, Object> copy(ZStream<Object, IOException, Object> in, Path target, Seq<CopyOption> options, Object trace) {
        boolean bl = ZIO$.MODULE$.scoped();
        return ZIO.ScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.copy$$anonfun$2(in, target, options, trace), trace);
    }

    private final ZIO $anonfun$1(Path dir$1, String glob$1, Object trace$1) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$3 -> Files.newDirectoryStream(dir$1.javaPath(), glob$1), trace$1);
    }

    private final ZIO newDirectoryStream$$anonfun$1(ZIO scoped$1) {
        return scoped$1;
    }

    private final ZIO $anonfun$4(Path dir$3, Object trace$2, DirectoryStream.Filter javaFilter$1) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$4 -> Files.newDirectoryStream(dir$3.javaPath(), javaFilter$1), trace$2);
    }

    private final ZIO newDirectoryStream$$anonfun$3(ZIO scoped$2) {
        return scoped$2;
    }

    private final ZIO createTempFileInScoped$$anonfun$1(Path dir$6, String suffix$2, Option prefix$2, Iterable fileAttributes$2, Object trace$3) {
        return this.createTempFileIn(dir$6, suffix$2, (Option<String>)prefix$2, fileAttributes$2, trace$3);
    }

    private final ZIO createTempFileScoped$$anonfun$1(String suffix$4, Option prefix$4, Iterable fileAttributes$4, Object trace$5) {
        return this.createTempFile(suffix$4, (Option<String>)prefix$4, fileAttributes$4, trace$5);
    }

    private final ZIO createTempDirectoryScoped$$anonfun$1(Path dir$8, Option prefix$6, Iterable fileAttributes$6, Object trace$7) {
        return this.createTempDirectory(dir$8, (Option<String>)prefix$6, fileAttributes$6, trace$7);
    }

    private final ZIO createTempDirectoryScoped$$anonfun$3(Option prefix$8, Iterable fileAttributes$8, Object trace$9) {
        return this.createTempDirectory((Option<String>)prefix$8, fileAttributes$8, trace$9);
    }

    private final ZChannel deleteRecursive$$anonfun$2(Object trace$12) {
        return ZSink$.MODULE$.count(trace$12);
    }

    private final ZIO deleteRecursive$$anonfun$3(Path path$6, Object trace$13) {
        return this.delete(path$6, trace$13);
    }

    private final ZIO lines$$anonfun$1$$anonfun$1(Path path$36, Charset charset$4, Object trace$15) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$47 -> Files.lines(path$36.javaPath(), charset$4.javaCharset()), trace$15);
    }

    private final ZIO lines$$anonfun$1(Path path$35, Charset charset$3, Object trace$14) {
        return ZIO$.MODULE$.fromAutoCloseable(() -> this.lines$$anonfun$1$$anonfun$1(path$35, charset$3, trace$14), trace$14);
    }

    private final ZIO list$$anonfun$1$$anonfun$1(Path path$39, Object trace$17) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$48 -> Files.list(path$39.javaPath()), trace$17);
    }

    private final ZIO list$$anonfun$1(Path path$38, Object trace$16) {
        return ZIO$.MODULE$.fromAutoCloseable(() -> this.list$$anonfun$1$$anonfun$1(path$38, trace$16), trace$16);
    }

    private final ZIO walk$$anonfun$1$$anonfun$1(Path path$42, int maxDepth$2, scala.collection.immutable.Set visitOptions$2, Object trace$19) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$49 -> Files.walk(path$42.javaPath(), maxDepth$2, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions$2.toSeq(), FileVisitOption.class)), trace$19);
    }

    private final ZIO walk$$anonfun$1(Path path$41, int maxDepth$1, scala.collection.immutable.Set visitOptions$1, Object trace$18) {
        return ZIO$.MODULE$.fromAutoCloseable(() -> this.walk$$anonfun$1$$anonfun$1(path$41, maxDepth$1, visitOptions$1, trace$18), trace$18);
    }

    private final ZIO find$$anonfun$1$$anonfun$1(Path path$45, int maxDepth$5, scala.collection.immutable.Set visitOptions$5, Object trace$21, BiPredicate matcher$2) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$50 -> Files.find(path$45.javaPath(), maxDepth$5, matcher$2, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions$5.toSeq(), FileVisitOption.class)), trace$21);
    }

    private final ZIO find$$anonfun$1(Path path$44, int maxDepth$4, scala.collection.immutable.Set visitOptions$4, Object trace$20, BiPredicate matcher$1) {
        return ZIO$.MODULE$.fromAutoCloseable(() -> this.find$$anonfun$1$$anonfun$1(path$44, maxDepth$4, visitOptions$4, trace$20, matcher$1), trace$20);
    }

    private final ZIO copy$$anonfun$2(ZStream in$1, Path target$4, Seq options$1, Object trace$22) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(in$1.toInputStream((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), trace$22).flatMap((Function1 & Serializable)inputStream -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$51 -> Files.copy(inputStream, target$4.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(options$1, CopyOption.class)), trace$22), trace$22));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$22);
    }
}

