/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.file.FileSystem;
import zio.nio.file.FileSystem$;
import zio.nio.file.Files$;
import zio.nio.file.Path$;
import zio.nio.file.WatchKey;
import zio.nio.file.WatchService;
import zio.nio.file.Watchable;

public final class Path
implements Watchable {
    private final java.nio.file.Path javaPath;

    public static Path fromJava(java.nio.file.Path path) {
        return Path$.MODULE$.fromJava(path);
    }

    public Path(java.nio.file.Path javaPath) {
        this.javaPath = javaPath;
    }

    public java.nio.file.Path javaPath() {
        return this.javaPath;
    }

    public FileSystem filesystem() {
        return FileSystem$.MODULE$.fromJava(this.javaPath().getFileSystem());
    }

    public boolean isAbsolute() {
        return this.javaPath().isAbsolute();
    }

    public Option<Path> root() {
        return Option$.MODULE$.apply((Object)this.javaPath().getRoot()).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath));
    }

    public Path filename() {
        return new Path(this.javaPath().getFileName());
    }

    public Option<Path> parent() {
        return Option$.MODULE$.apply((Object)this.javaPath().getParent()).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath));
    }

    public int nameCount() {
        return this.javaPath().getNameCount();
    }

    public Path apply(int index) {
        return Path$.MODULE$.fromJava(this.javaPath().getName(index));
    }

    public Path subpath(int beginIndex, int endIndex) {
        return Path$.MODULE$.fromJava(this.javaPath().subpath(beginIndex, endIndex));
    }

    public boolean startsWith(Path other) {
        return this.javaPath().startsWith(other.javaPath());
    }

    public boolean endsWith(Path other) {
        return this.javaPath().endsWith(other.javaPath());
    }

    public Path normalize() {
        return Path$.MODULE$.fromJava(this.javaPath().normalize());
    }

    public Path $div(Path other) {
        return Path$.MODULE$.fromJava(this.javaPath().resolve(other.javaPath()));
    }

    public Path $div(String other) {
        return Path$.MODULE$.fromJava(this.javaPath().resolve(other));
    }

    public Path resolveSibling(Path other) {
        return Path$.MODULE$.fromJava(this.javaPath().resolveSibling(other.javaPath()));
    }

    public Path relativize(Path other) {
        return Path$.MODULE$.fromJava(this.javaPath().relativize(other.javaPath()));
    }

    public ZIO<Object, IOError, URI> toUri(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$1 -> this.javaPath().toUri(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOError.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOError, Path> toAbsolutePath(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$2 -> Path$.MODULE$.fromJava(this.javaPath().toAbsolutePath()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOError.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Path> toRealPath(Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$3 -> Path$.MODULE$.fromJava(this.javaPath().toRealPath((LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class))), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public File toFile() {
        return this.javaPath().toFile();
    }

    public List<Path> elements() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.javaPath().iterator()).asScala().map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)).toList();
    }

    public ZIO<Object, IOException, Chunk<WatchKey>> registerTree(WatchService watcher, Iterable<WatchEvent.Kind<?>> events, int maxDepth, Iterable<WatchEvent.Modifier> modifiers, Object trace) {
        return Files$.MODULE$.find(this, maxDepth, Files$.MODULE$.find$default$3(), (Function2<Path, BasicFileAttributes, Object>)(Function2 & Serializable)(_$1, a) -> a.isDirectory(), trace).mapZIO((Function1 & Serializable)dir -> dir.register(watcher, (Iterable)events, modifiers.toSeq(), trace), trace).runCollect(trace);
    }

    public int registerTree$default$3() {
        return Integer.MAX_VALUE;
    }

    public Iterable<WatchEvent.Modifier> registerTree$default$4() {
        return (Iterable)package$.MODULE$.Iterable().empty();
    }

    @Override
    public java.nio.file.Watchable javaWatchable() {
        return this.javaPath();
    }

    public int hashCode() {
        return this.javaPath().hashCode();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof Path) {
            Path other = (Path)object;
            return this.javaPath().equals(other.javaPath());
        }
        return false;
    }

    public String toString() {
        return this.javaPath().toString();
    }
}

