/*
 * Decompiled with CFR 0.152.
 */
package zio.telemetry.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import java.util.concurrent.ConcurrentHashMap;
import scala.Option;
import scala.runtime.BoxedUnit;
import zio.Exit;
import zio.Fiber;
import zio.FiberId;
import zio.Supervisor;
import zio.Unsafe;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;

public final class PropagatingSupervisor
extends Supervisor<BoxedUnit> {
    private final ConcurrentHashMap<FiberId, Span> storage = new ConcurrentHashMap();

    public ZIO value(Object trace) {
        return ZIO$.MODULE$.unit();
    }

    public <R, E, A> void onStart(ZEnvironment<R> environment, ZIO<R, E, A> effect, Option<Fiber.Runtime<Object, Object>> parent, Fiber.Runtime<E, A> fiber, Unsafe unsafe) {
        Span span = Span.current();
        if (span != null) {
            this.storage.put((FiberId)fiber.id(), span);
        } else {
            this.storage.put((FiberId)fiber.id(), Span.fromContext((Context)Context.root()));
        }
    }

    public <R, E, A> void onEnd(Exit<E, A> value, Fiber.Runtime<E, A> fiber, Unsafe unsafe) {
        this.storage.remove(fiber.id());
        Context.root().makeCurrent();
    }

    public <E, A> void onSuspend(Fiber.Runtime<E, A> fiber, Unsafe unsafe) {
        Span span = Span.current();
        Span span2 = span != null ? this.storage.put((FiberId)fiber.id(), span) : this.storage.put((FiberId)fiber.id(), Span.fromContext((Context)Context.root()));
        Context.root().makeCurrent();
    }

    public <E, A> void onResume(Fiber.Runtime<E, A> fiber, Unsafe unsafe) {
        Span span = this.storage.get(fiber.id());
        if (span != null) {
            span.makeCurrent();
        }
    }
}

