/*
 * Decompiled with CFR 0.152.
 */
package zio.parser.internal;

import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import zio.parser.Parser;
import zio.parser.Parser$End$;
import zio.parser.Parser$Index$;
import zio.parser.Regex;
import zio.parser.Regex$Succeed$;
import zio.parser.internal.Debug;

public final class Debug$ {
    public static final Debug$ MODULE$ = new Debug$();
    private static final Debug.DebugPrinterState initialState = new Debug.DebugPrinterState(0, Predef$.MODULE$.Map().empty(), 0);

    private Debug.DebugPrinterState initialState() {
        return initialState;
    }

    public Debug.DebugPrinterState printParserTree(Parser<?, ?, ?> syntax, Debug.DebugPrinterState state) {
        Option option;
        block28: {
            while (true) {
                if ((option = state.visited().get(syntax)) instanceof Some) {
                    int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    this.printIndented(new StringBuilder(3).append("#[").append(id).append("]").toString(), state);
                    return state;
                }
                if (!None$.MODULE$.equals(option)) break block28;
                if (syntax instanceof Parser.Lazy) {
                    Function0 inner = ((Parser.Lazy)syntax).inner();
                    this.printIndented("Lazy", state);
                    state = state.visit(syntax).in();
                    syntax = (Parser)inner.apply();
                    continue;
                }
                if (syntax instanceof Parser.Succeed) {
                    Object value = ((Parser.Succeed)syntax).value();
                    this.printIndented(new StringBuilder(8).append("Succeed(").append(value).toString(), state);
                    return state;
                }
                if (syntax instanceof Parser.Fail) {
                    Object failure = ((Parser.Fail)syntax).failure();
                    this.printIndented(new StringBuilder(5).append("Fail(").append(failure).toString(), state);
                    return state;
                }
                if (syntax instanceof Parser.Failed) {
                    Parser.ParserError failure = ((Parser.Failed)syntax).failure();
                    this.printIndented(new StringBuilder(7).append("Failed(").append(failure).toString(), state);
                    return state;
                }
                if (syntax instanceof Parser.Named) {
                    Parser.Named named = (Parser.Named)syntax;
                    Parser inner = named.parser();
                    String name = named.name();
                    this.printIndented(new StringBuilder(7).append("Named(").append(name).append(")").toString(), state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.SkipRegex) {
                    Parser.SkipRegex skipRegex = (Parser.SkipRegex)syntax;
                    Regex regex = skipRegex.regex();
                    Option onFailure = skipRegex.onFailure();
                    this.printIndented(new StringBuilder(11).append("SkipRegex(").append(onFailure).append(")").toString(), state);
                    this.printRegexTree(regex, state.visit(syntax).in());
                    return state;
                }
                if (syntax instanceof Parser.ParseRegex) {
                    Parser.ParseRegex parseRegex = (Parser.ParseRegex)syntax;
                    Regex regex = parseRegex.regex();
                    Option onFailure = parseRegex.onFailure();
                    this.printIndented(new StringBuilder(12).append("ParseRegex(").append(onFailure).append(")").toString(), state);
                    this.printRegexTree(regex, state.visit(syntax).in());
                    return state;
                }
                if (syntax instanceof Parser.ParseRegexLastChar) {
                    Parser.ParseRegexLastChar parseRegexLastChar = (Parser.ParseRegexLastChar)syntax;
                    Regex regex = parseRegexLastChar.regex();
                    Option onFailure = parseRegexLastChar.onFailure();
                    this.printIndented(new StringBuilder(20).append("ParseRegexLastChar(").append(onFailure).append(")").toString(), state);
                    this.printRegexTree(regex, state.visit(syntax).in());
                    return state;
                }
                if (syntax instanceof Parser.TransformEither) {
                    Parser inner = ((Parser.TransformEither)syntax).parser();
                    this.printIndented("TransformEither", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.Transform) {
                    Parser inner = ((Parser.Transform)syntax).parser();
                    this.printIndented("Transform", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.Ignore) {
                    Parser.Ignore ignore = (Parser.Ignore)syntax;
                    Parser inner = ignore.parser();
                    Object to = ignore.to();
                    this.printIndented(new StringBuilder(8).append("Ignore(").append(to).append(")").toString(), state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.CaptureString) {
                    Parser inner = ((Parser.CaptureString)syntax).parser();
                    this.printIndented("CaptureString", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.Zip) {
                    Parser.Zip zip = (Parser.Zip)syntax;
                    Parser left = zip.left();
                    Parser right = zip.right();
                    this.printIndented("Zip", state);
                    Debug.DebugPrinterState leftSt = this.printParserTree(left, state.visit(syntax).in());
                    state = state.mergeVisited(leftSt).in();
                    syntax = right;
                    continue;
                }
                if (syntax instanceof Parser.ZipLeft) {
                    Parser.ZipLeft zipLeft = (Parser.ZipLeft)syntax;
                    Parser left = zipLeft.left();
                    Parser right = zipLeft.right();
                    this.printIndented("ZipLeft", state);
                    Debug.DebugPrinterState leftSt = this.printParserTree(left, state.visit(syntax).in());
                    state = state.mergeVisited(leftSt).in();
                    syntax = right;
                    continue;
                }
                if (syntax instanceof Parser.ZipRight) {
                    Parser.ZipRight zipRight = (Parser.ZipRight)syntax;
                    Parser left = zipRight.left();
                    Parser right = zipRight.right();
                    this.printIndented("ZipRight", state);
                    Debug.DebugPrinterState leftSt = this.printParserTree(left, state.visit(syntax).in());
                    state = state.mergeVisited(leftSt).in();
                    syntax = right;
                    continue;
                }
                if (syntax instanceof Parser.FlatMap) {
                    Parser inner = ((Parser.FlatMap)syntax).parser();
                    this.printIndented("FlatMap", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.OrElseEither) {
                    Parser.OrElseEither orElseEither = (Parser.OrElseEither)syntax;
                    Parser left = orElseEither.left();
                    Parser right = orElseEither.right();
                    this.printIndented("OrElseEither", state);
                    Debug.DebugPrinterState leftSt = this.printParserTree(left, state.visit(syntax).in());
                    state = state.mergeVisited(leftSt).in();
                    syntax = right;
                    continue;
                }
                if (syntax instanceof Parser.OrElse) {
                    Parser.OrElse orElse = (Parser.OrElse)syntax;
                    Parser left = orElse.left();
                    Parser right = orElse.right();
                    this.printIndented("OrElse", state);
                    Debug.DebugPrinterState leftSt = this.printParserTree(left, state.visit(syntax).in());
                    state = state.mergeVisited(leftSt).in();
                    syntax = right;
                    continue;
                }
                if (syntax instanceof Parser.Optional) {
                    Parser inner = ((Parser.Optional)syntax).parser();
                    this.printIndented("Optional", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.Repeat) {
                    Parser.Repeat repeat = (Parser.Repeat)syntax;
                    Parser inner = repeat.parser();
                    int min = repeat.min();
                    Option<Object> max = repeat.max();
                    this.printIndented(new StringBuilder(10).append("Repeat(").append(min).append(", ").append(max).append(")").toString(), state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.Backtrack) {
                    Parser inner = ((Parser.Backtrack)syntax).parser();
                    this.printIndented("Backtrack", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.SetAutoBacktrack) {
                    Parser.SetAutoBacktrack setAutoBacktrack = (Parser.SetAutoBacktrack)syntax;
                    Parser inner = setAutoBacktrack.parser();
                    boolean enabled = setAutoBacktrack.enabled();
                    this.printIndented(new StringBuilder(18).append("SetAutoBacktrack(").append(enabled).append(")").toString(), state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (syntax instanceof Parser.MapError) {
                    Parser inner = ((Parser.MapError)syntax).parser();
                    this.printIndented("MapError", state);
                    state = state.visit(syntax).in();
                    syntax = inner;
                    continue;
                }
                if (!(syntax instanceof Parser.Not)) break;
                Parser inner = ((Parser.Not)syntax).parser();
                this.printIndented("Not", state);
                state = state.visit(syntax).in();
                syntax = inner;
            }
            if (Parser$Index$.MODULE$.equals(syntax)) {
                this.printIndented("Index", state);
                return state;
            }
            if (Parser$End$.MODULE$.equals(syntax)) {
                this.printIndented("End", state);
                return state;
            }
            if (syntax instanceof Parser.Passthrough) {
                this.printIndented("Passthrough", state);
                return state;
            }
            throw new MatchError(syntax);
        }
        throw new MatchError((Object)option);
    }

    public Debug.DebugPrinterState printParserTree$default$2() {
        return this.initialState();
    }

    private Debug.DebugPrinterState printRegexTree(Regex regex, Debug.DebugPrinterState state) {
        while (true) {
            if (Regex$Succeed$.MODULE$.equals(regex)) {
                this.printIndented("<Succeed>", state);
                return state;
            }
            if (regex instanceof Regex.OneOf) {
                this.printIndented("<OneOf>", state);
                return state;
            }
            if (regex instanceof Regex.Sequence) {
                Regex.Sequence sequence = (Regex.Sequence)regex;
                Regex first = sequence.first();
                Regex second = sequence.second();
                this.printIndented("<Sequence>", state);
                this.printRegexTree(first, state.in());
                state = state.in();
                regex = second;
                continue;
            }
            if (regex instanceof Regex.Repeat) {
                Regex.Repeat repeat = (Regex.Repeat)regex;
                Regex regex2 = repeat.regex();
                Option<Object> min = repeat.min();
                Option<Object> max = repeat.max();
                this.printIndented(new StringBuilder(12).append("<Repeat(").append(min).append(", ").append(max).append(")>").toString(), state);
                state = state.in();
                regex = regex2;
                continue;
            }
            if (regex instanceof Regex.Or) {
                Regex.Or or = (Regex.Or)regex;
                Regex left = or.left();
                Regex right = or.right();
                this.printIndented("<Or>", state);
                this.printRegexTree(left, state.in());
                state = state.in();
                regex = right;
                continue;
            }
            if (!(regex instanceof Regex.And)) break;
            Regex.And and = (Regex.And)regex;
            Regex left = and.left();
            Regex right = and.right();
            this.printIndented("<And>", state);
            this.printRegexTree(left, state.in());
            state = state.in();
            regex = right;
        }
        throw new MatchError((Object)regex);
    }

    private void printIndented(String str, Debug.DebugPrinterState state) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append("[").append(state.lastId()).append("] ").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), state.indent())).append(str).toString());
    }

    private Debug$() {
    }
}

