/*
 * Decompiled with CFR 0.152.
 */
package zio.prelude;

import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.prelude.Commutative;
import zio.prelude.Debug;
import zio.prelude.Derive;
import zio.prelude.Equal;
import zio.prelude.Hash;
import zio.prelude.NonEmptyList;
import zio.prelude.NonEmptyList$;
import zio.prelude.NonEmptySortedSet$;

public final class NonEmptySortedSet<A> {
    private final SortedSet set;

    public static <A> Commutative<NonEmptySortedSet<A>> NonEmptySortedSetCommutativeIdempotent(Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.NonEmptySortedSetCommutativeIdempotent(ordering);
    }

    public static <A> Debug<NonEmptySortedSet<A>> NonEmptySortedSetDebug(Debug<A> debug) {
        return NonEmptySortedSet$.MODULE$.NonEmptySortedSetDebug(debug);
    }

    public static Derive<NonEmptySortedSet, Equal> NonEmptySortedSetDeriveEqual() {
        return NonEmptySortedSet$.MODULE$.NonEmptySortedSetDeriveEqual();
    }

    public static <A> Hash<NonEmptySortedSet<A>> NonEmptySortedSetHashPartialOrd() {
        return NonEmptySortedSet$.MODULE$.NonEmptySortedSetHashPartialOrd();
    }

    public static <A> NonEmptySortedSet<A> apply(A a, Iterable<A> iterable, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.apply(a, iterable, ordering);
    }

    public static <A> NonEmptySortedSet<A> apply(A a, Seq<A> seq, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.apply(a, seq, ordering);
    }

    public static <A> Option<NonEmptySortedSet<A>> fromIterableOption(Iterable<A> iterable, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.fromIterableOption(iterable, ordering);
    }

    public static <A> NonEmptySortedSet<A> fromNonEmptyChunk(NonEmptyChunk<A> nonEmptyChunk, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.fromNonEmptyChunk(nonEmptyChunk, ordering);
    }

    public static <A> NonEmptySortedSet<A> fromNonEmptyList(NonEmptyList<A> nonEmptyList, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.fromNonEmptyList(nonEmptyList, ordering);
    }

    public static <A> NonEmptySortedSet<A> fromSet(A a, SortedSet<A> sortedSet, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.fromSet(a, sortedSet, ordering);
    }

    public static <A> Option<NonEmptySortedSet<A>> fromSetOption(SortedSet<A> sortedSet, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.fromSetOption(sortedSet, ordering);
    }

    public static <A> NonEmptySortedSet<A> single(A a, Ordering<A> ordering) {
        return NonEmptySortedSet$.MODULE$.single(a, ordering);
    }

    public static <A> Some<Tuple2<A, SortedSet<A>>> unapply(NonEmptySortedSet<A> nonEmptySortedSet) {
        return NonEmptySortedSet$.MODULE$.unapply(nonEmptySortedSet);
    }

    public NonEmptySortedSet(SortedSet<A> set) {
        this.set = set;
    }

    private SortedSet<A> set() {
        return this.set;
    }

    public SortedSet<A> toSet() {
        return this.set();
    }

    public Tuple2<A, SortedSet<A>> peel() {
        return Tuple2$.MODULE$.apply(this.set().head(), this.set().tail());
    }

    public Tuple2<A, Option<NonEmptySortedSet<A>>> peelNonEmpty() {
        Tuple2<A, SortedSet<A>> tuple2 = this.peel();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object head = tuple2._1();
        SortedSet tail = (SortedSet)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(head, (Object)tail);
        Object head2 = tuple22._1();
        SortedSet tail2 = (SortedSet)tuple22._2();
        if (tail2.isEmpty()) {
            return Tuple2$.MODULE$.apply(head2, (Object)None$.MODULE$);
        }
        return Tuple2$.MODULE$.apply(head2, (Object)Some$.MODULE$.apply(new NonEmptySortedSet<A>(tail2)));
    }

    public NonEmptyChunk<A> toNonEmptyChunk() {
        Tuple2<A, SortedSet<A>> tuple2 = this.peel();
        if (tuple2 != null) {
            Object head = tuple2._1();
            SortedSet tail = (SortedSet)tuple2._2();
            return NonEmptyChunk$.MODULE$.fromIterable(head, (Iterable)tail);
        }
        throw new MatchError(tuple2);
    }

    public NonEmptyList<A> toNonEmptyList() {
        Tuple2<A, SortedSet<A>> tuple2 = this.peel();
        if (tuple2 != null) {
            Object head = tuple2._1();
            SortedSet tail = (SortedSet)tuple2._2();
            return NonEmptyList$.MODULE$.fromIterable(head, tail);
        }
        throw new MatchError(tuple2);
    }

    public NonEmptySortedSet<A> $plus(A elem) {
        return new NonEmptySortedSet<A>((SortedSet)this.set().$plus(elem));
    }

    public NonEmptySortedSet<A> union(SortedSet<A> that) {
        return new NonEmptySortedSet<A>((SortedSet)this.set().union(that));
    }

    public NonEmptySortedSet<A> $plus$plus(Iterable<A> elems) {
        return new NonEmptySortedSet<A>((SortedSet)this.set().$plus$plus(elems));
    }

    public NonEmptySortedSet<A> add(A elem) {
        return this.$plus(elem);
    }

    public SortedSet<A> remove(A elem) {
        return (SortedSet)this.set().$minus(elem);
    }

    public Option<NonEmptySortedSet<A>> removeNonEmpty(A elem) {
        SortedSet newSet = (SortedSet)this.set().$minus(elem);
        if (newSet.nonEmpty()) {
            return Some$.MODULE$.apply(new NonEmptySortedSet<A>(newSet));
        }
        return None$.MODULE$;
    }

    public Option<NonEmptySortedSet<A>> tailNonEmpty() {
        return (Option)this.peelNonEmpty()._2();
    }

    public <B> NonEmptySortedSet<B> map(Function1<A, B> f, Ordering<B> sOrdering) {
        return new NonEmptySortedSet<A>((SortedSet)this.set().map(f, sOrdering));
    }

    public int hashCode() {
        return this.set().hashCode() ^ NonEmptySortedSet$.zio$prelude$NonEmptySortedSet$$$NonEmptySortedSetSeed;
    }

    public boolean equals(Object that) {
        Object that2;
        Object object = that;
        if (object instanceof Object && this == (that2 = object)) {
            return true;
        }
        if (object instanceof NonEmptySortedSet) {
            NonEmptySortedSet that3 = (NonEmptySortedSet)object;
            SortedSet<A> sortedSet = this.set();
            SortedSet<A> sortedSet2 = that3.toSet();
            return !(sortedSet != null ? !sortedSet.equals(sortedSet2) : sortedSet2 != null);
        }
        return false;
    }

    public String toString() {
        return new StringBuilder(8).append("NonEmpty").append(this.set()).toString();
    }
}

