/*
 * Decompiled with CFR 0.152.
 */
package zio.sbt;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.process.package$;
import zio.ZIO;
import zio.ZIO$;
import zio.sbt.WebsiteUtils;

public final class WebsiteUtils$ {
    public static WebsiteUtils$ MODULE$;

    static {
        new WebsiteUtils$();
    }

    public String removeYamlHeader(String markdown) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])markdown.split("\n"))).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WebsiteUtils$.$anonfun$removeYamlHeader$1(x$1))))).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WebsiteUtils$.$anonfun$removeYamlHeader$2(x$2))))).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WebsiteUtils$.$anonfun$removeYamlHeader$3(x$3))))).mkString("\n");
    }

    public ZIO<Object, Throwable, String> readFile(String pathname) {
        return ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> {
            BufferedSource source = Source$.MODULE$.fromFile(new File(pathname), Codec$.MODULE$.fallbackSystemCodec());
            String result = source.getLines().mkString("\n");
            source.close();
            return result;
        }, (Object)"zio.sbt.WebsiteUtils.readFile(WebsiteUtils.scala:42)");
    }

    public String githubBadge(String githubUser, String githubRepo, String projectName) {
        String githubBadge = new StringBuilder(50).append("https://img.shields.io/github/stars/").append(githubUser).append("/").append(githubRepo).append("?style=social").toString();
        String repoUrl = new StringBuilder(20).append("https://github.com/").append(githubUser).append("/").append(githubRepo).toString();
        return new StringBuilder(9).append("[![").append(projectName).append("](").append(githubBadge).append(")](").append(repoUrl).append(")").toString();
    }

    public String javadocBadge(String groupId, String artifactId) {
        String badge = new StringBuilder(39).append("https://javadoc.io/badge2/").append(groupId).append("/").append(artifactId).append("/javadoc.svg").toString();
        String javadocUrl = new StringBuilder(24).append("https://javadoc.io/doc/").append(groupId).append("/").append(artifactId).toString();
        return new StringBuilder(16).append("[![javadoc](").append(badge).append(")](").append(javadocUrl).append(")").toString();
    }

    public String discord() {
        return "[![Chat on Discord!](https://img.shields.io/discord/629491597070827530?logo=discord)](https://discord.gg/2ccFBr4)";
    }

    public String ciBadge(String githubUser, String githubRepo, String workflowName) {
        String ci = workflowName.replaceAll(" ", "%20");
        return new StringBuilder(54).append("![CI Badge](https://github.com/").append(githubUser).append("/").append(githubRepo).append("/workflows/").append(ci).append("/badge.svg)").toString();
    }

    public String snapshotBadge(String groupId, String artifact) {
        String badge = new StringBuilder(85).append("https://img.shields.io/nexus/s/https/oss.sonatype.org/").append(groupId).append("/").append(artifact).append(".svg?label=Sonatype%20Snapshot").toString();
        String link = new StringBuilder(58).append("https://oss.sonatype.org/content/repositories/snapshots/").append(groupId.replace('.', '/')).append("/").append(artifact).append("/").toString();
        return new StringBuilder(27).append("[![Sonatype Snapshots](").append(badge).append(")](").append(link).append(")").toString();
    }

    public String releaseBadge(String groupId, String artifact) {
        String badge = new StringBuilder(84).append("https://img.shields.io/nexus/r/https/oss.sonatype.org/").append(groupId).append("/").append(artifact).append(".svg?label=Sonatype%20Release").toString();
        String link = new StringBuilder(57).append("https://oss.sonatype.org/content/repositories/releases/").append(groupId.replace('.', '/')).append("/").append(artifact).append("/").toString();
        return new StringBuilder(26).append("[![Sonatype Releases](").append(badge).append(")](").append(link).append(")").toString();
    }

    public String projectStageBadge(WebsiteUtils.ProjectStage stage) {
        return new StringBuilder(9).append("[![").append(stage.name()).append("](").append(stage.badge()).append(")](").append(stage.stagePage()).append(")").toString();
    }

    public String generateProjectBadges(WebsiteUtils.ProjectStage projectStage, String groupId, String artifactId, String docsArtifactId, String githubUser, String githubRepo, String projectName, String ciWorkflowName) {
        String stage = this.projectStageBadge(projectStage);
        String ci = this.ciBadge(githubUser, githubRepo, ciWorkflowName);
        String snapshot = this.snapshotBadge(groupId, artifactId);
        String github = this.githubBadge(githubUser, githubRepo, projectName);
        Option<String> option = this.releaseVersion((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$4 -> {
            WebsiteUtils$.$anonfun$generateProjectBadges$1(x$4);
            return BoxedUnit.UNIT;
        });
        if (option instanceof Some) {
            String release = this.releaseBadge(groupId, artifactId);
            String javadoc = this.javadocBadge(groupId, docsArtifactId);
            return new StringBuilder(5).append(stage).append(" ").append(ci).append(" ").append(release).append(" ").append(snapshot).append(" ").append(javadoc).append(" ").append(github).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return new StringBuilder(3).append(stage).append(" ").append(ci).append(" ").append(snapshot).append(" ").append(github).toString();
        }
        throw new MatchError(option);
    }

    public ZIO<Object, Throwable, BoxedUnit> generateReadme(String projectName, String banner, String introduction, String documentation, String codeOfConduct, String contribution, String support, String license, String acknowledgement, String credits, String maintainers) {
        String commentSection = new StringOps(Predef$.MODULE$.augmentString("|[//]: # (This file was autogenerated using `zio-sbt-website` plugin via `sbt generateReadme` command.)\n         |[//]: # (So please do not edit it manually. Instead, change \"docs/index.md\" file or sbt setting keys)\n         |[//]: # (e.g. \"readmeDocumentation\" and \"readmeSupport\".)\n         |")).stripMargin();
        String introductionSection = new StringBuilder(6).append("\n# ").append(projectName).append("\n\n").append(introduction).append("\n").toString();
        String creditsSection = new StringOps(Predef$.MODULE$.augmentString(credits)).nonEmpty() ? new StringBuilder(14).append("\n## Credits\n\n").append(credits).append("\n").toString() : "";
        String supportSection = new StringBuilder(14).append("\n## Support\n\n").append(support).append("\n").toString();
        String codeOfConductSection = new StringBuilder(22).append("\n## Code of Conduct\n\n").append(codeOfConduct).append("\n").toString();
        String contributingSection = new StringBuilder(19).append("\n## Contributing\n\n").append(contribution).append("\n").toString();
        String documentationSection = new StringBuilder(20).append("\n## Documentation\n\n").append(documentation).append("\n").toString();
        String maintainersSection = new StringOps(Predef$.MODULE$.augmentString(maintainers)).nonEmpty() ? new StringBuilder(18).append("\n## Maintainers\n\n").append(maintainers).append("\n").toString() : "";
        String acknowledgementSection = new StringOps(Predef$.MODULE$.augmentString(acknowledgement)).nonEmpty() ? new StringBuilder(22).append("\n## Acknowledgement\n\n").append(acknowledgement).append("\n").toString() : "";
        String licenseSection = new StringBuilder(14).append("\n## License\n\n").append(license).append("\n").toString();
        String readme = new StringBuilder(0).append(commentSection).append(banner).append(introductionSection).append(documentationSection).append(contributingSection).append(codeOfConductSection).append(supportSection).append(maintainersSection).append(creditsSection).append(acknowledgementSection).append(licenseSection).toString();
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.write(Paths.get("README.md", new String[0]), readme.getBytes(StandardCharsets.UTF_8), new OpenOption[0]), (Object)"zio.sbt.WebsiteUtils.generateReadme(WebsiteUtils.scala:156)");
    }

    public Option<String> releaseVersion(Function1<String, BoxedUnit> logger) {
        try {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.stringToProcess("git tag --sort=committerdate").$bang$bang().split("\n"))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("v"))))).lastOption().map((Function1 & Serializable & scala.Serializable)x$6 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$6)).tail());
        }
        catch (Exception exception) {
            logger.apply((Object)"Could not determine release version from git tags, will return 'None' instead.  This is most likely a result of this project not having a git repo initialized.  See previous log messages for more detail.");
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeYamlHeader$1(String x$1) {
        String string = x$1;
        String string2 = "---";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$removeYamlHeader$2(String x$2) {
        String string = x$2;
        String string2 = "---";
        return string == null || !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$removeYamlHeader$3(String x$3) {
        String string = x$3;
        String string2 = "---";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$generateProjectBadges$1(String x$4) {
    }

    private WebsiteUtils$() {
        MODULE$ = this;
    }
}

