/*
 * Decompiled with CFR 0.152.
 */
package zio.schema;

import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import zio.Chunk;
import zio.ChunkLike;
import zio.schema.CachedDeriver;
import zio.schema.CachedDeriver$;
import zio.schema.CachedDeriver$CacheKey$;
import zio.schema.CachedDeriver$CacheKey$PrimitiveAlias$;
import zio.schema.Deriver;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;

public class CachedDeriver<F>
implements Deriver<F> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CachedDeriver.class.getDeclaredField("cached$lzy1"));
    private volatile Object cached$lzy1;
    private final Deriver<F> deriver;
    private final Cache cache;

    public static <F> Deriver<F> apply(Deriver<F> deriver, Cache<F> cache) {
        return CachedDeriver$.MODULE$.apply(deriver, cache);
    }

    public static <F> Cache<F> createCache() {
        return CachedDeriver$.MODULE$.createCache();
    }

    public CachedDeriver(Deriver<F> deriver, Cache<F> cache) {
        this.deriver = deriver;
        this.cache = cache;
        Deriver.$init$(this);
    }

    @Override
    public Deriver cached() {
        Object object = this.cached$lzy1;
        if (object instanceof Deriver) {
            return (Deriver)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Deriver)this.cached$lzyINIT1();
    }

    private Object cached$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cached$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Deriver deriver = null;
                    try {
                        deriver = Deriver.cached$(this);
                        object2 = deriver == null ? LazyVals.NullValue$.MODULE$ : deriver;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cached$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return deriver;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    @Override
    public <A> F deriveRecord(Schema.Record<A> record, Function0<Chunk<Deriver.WrappedF<F, ?>>> fields, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)record, (Function0<F>)((Function0 & Serializable)() -> this.deriveRecord$$anonfun$1(record, fields, summoned)));
    }

    @Override
    public <A> F deriveEnum(Schema.Enum<A> enum_, Function0<Chunk<Deriver.WrappedF<F, ?>>> cases, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)enum_, (Function0<F>)((Function0 & Serializable)() -> this.deriveEnum$$anonfun$1(enum_, cases, summoned)));
    }

    @Override
    public <A> F derivePrimitive(StandardType<A> st, Function0<Option<F>> summoned) {
        return this.cached(Schema$.MODULE$.primitive(st), () -> this.derivePrimitive$$anonfun$1(st, summoned));
    }

    @Override
    public <A, U> F derivePrimitiveAlias(StandardType<U> st, Function0<Option<F>> summoned, ClassTag<A> evidence$1) {
        CacheKey.PrimitiveAlias key = CachedDeriver$CacheKey$PrimitiveAlias$.MODULE$.apply(st, (ClassTag)Predef$.MODULE$.implicitly(evidence$1));
        Option<F> option = this.cache().get(key);
        if (None$.MODULE$.equals(option)) {
            return this.cache().put(key, this.deriver.derivePrimitiveAlias(st, summoned, evidence$1));
        }
        if (option instanceof Some) {
            Object g = ((Some)option).value();
            return (F)g;
        }
        throw new MatchError(option);
    }

    @Override
    public <A> F deriveOption(Schema.Optional<A> option, Function0<F> inner, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)option, (Function0<F>)((Function0 & Serializable)() -> this.deriveOption$$anonfun$1(option, inner, summoned)));
    }

    @Override
    public <C, A> F deriveSequence(Schema.Sequence<Object, A, ?> sequence, Function0<F> inner, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)sequence, (Function0<F>)((Function0 & Serializable)() -> this.deriveSequence$$anonfun$1(sequence, inner, summoned)));
    }

    @Override
    public <K, V> F deriveMap(Schema.Map<K, V> map, Function0<F> key, Function0<F> value, Function0<Option<F>> summoned) {
        return this.cached((Schema)map, (Function0<F>)((Function0 & Serializable)() -> this.deriveMap$$anonfun$1(map, key, value, summoned)));
    }

    @Override
    public <A, B> F deriveEither(Schema.Either<A, B> either, Function0<F> left, Function0<F> right, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)either, (Function0<F>)((Function0 & Serializable)() -> this.deriveEither$$anonfun$1(either, left, right, summoned)));
    }

    @Override
    public <A> F deriveSet(Schema.Set<A> set, Function0<F> inner, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)set, (Function0<F>)((Function0 & Serializable)() -> this.deriveSet$$anonfun$1(set, inner, summoned)));
    }

    @Override
    public <A, B> F deriveTransformedRecord(Schema.Record<A> record, Schema.Transform<A, B, ?> transform, Function0<Chunk<Deriver.WrappedF<F, ?>>> fields, Function0<Option<F>> summoned) {
        return this.cached((Schema<A>)transform, (Function0<F>)((Function0 & Serializable)() -> this.deriveTransformedRecord$$anonfun$1(record, transform, fields, summoned)));
    }

    @Override
    public <T> F deriveTupleN(Function0<Chunk<Tuple2<Schema<?>, Deriver.WrappedF<F, ?>>>> schemasAndInstances, Function0<Option<F>> summoned) {
        Schema<?> zipped = this.zippedTupleSchema(((ChunkLike)schemasAndInstances.apply()).map((Function1 & Serializable)_$3 -> (Schema)_$3._1()));
        return this.cached(zipped, () -> this.deriveTupleN$$anonfun$1(schemasAndInstances, summoned));
    }

    private <A> F cached(Schema<A> schema, Function0<F> f) {
        CacheKey<A> key = CachedDeriver$CacheKey$.MODULE$.fromSchema(schema);
        Option<F> option = this.cache().get(key);
        if (None$.MODULE$.equals(option)) {
            return (F)this.cache().put(key, f.apply());
        }
        if (option instanceof Some) {
            Object g = ((Some)option).value();
            return (F)g;
        }
        throw new MatchError(option);
    }

    private Schema<?> zippedTupleSchema(Chunk<Schema<?>> schemas) {
        return (Schema)schemas.reduceLeft((Function2 & Serializable)(a, b) -> a.zip(b));
    }

    private final Object deriveRecord$$anonfun$1(Schema.Record record$1, Function0 fields$1, Function0 summoned$1) {
        return this.deriver.deriveRecord(record$1, fields$1, summoned$1);
    }

    private final Object deriveEnum$$anonfun$1(Schema.Enum enum$1, Function0 cases$1, Function0 summoned$2) {
        return this.deriver.deriveEnum(enum$1, cases$1, summoned$2);
    }

    private final Object derivePrimitive$$anonfun$1(StandardType st$1, Function0 summoned$3) {
        return this.deriver.derivePrimitive(st$1, summoned$3);
    }

    private final Object deriveOption$$anonfun$1(Schema.Optional option$1, Function0 inner$1, Function0 summoned$4) {
        return this.deriver.deriveOption(option$1, inner$1, summoned$4);
    }

    private final Object deriveSequence$$anonfun$1(Schema.Sequence sequence$1, Function0 inner$2, Function0 summoned$5) {
        return this.deriver.deriveSequence(sequence$1, inner$2, summoned$5);
    }

    private final Object deriveMap$$anonfun$1(Schema.Map map$1, Function0 key$1, Function0 value$1, Function0 summoned$6) {
        return this.deriver.deriveMap(map$1, key$1, value$1, summoned$6);
    }

    private final Object deriveEither$$anonfun$1(Schema.Either either$1, Function0 left$1, Function0 right$1, Function0 summoned$7) {
        return this.deriver.deriveEither(either$1, left$1, right$1, summoned$7);
    }

    private final Object deriveSet$$anonfun$1(Schema.Set set$1, Function0 inner$3, Function0 summoned$8) {
        return this.deriver.deriveSet(set$1, inner$3, summoned$8);
    }

    private final Object deriveTransformedRecord$$anonfun$1(Schema.Record record$2, Schema.Transform transform$1, Function0 fields$2, Function0 summoned$9) {
        return this.deriver.deriveTransformedRecord(record$2, transform$1, fields$2, summoned$9);
    }

    private final Object deriveTupleN$$anonfun$1(Function0 schemasAndInstances$1, Function0 summoned$10) {
        return this.deriver.deriveTupleN(schemasAndInstances$1, summoned$10);
    }

    public static class Cache<F> {
        private final ConcurrentMap<CacheKey<?>, Object> map;

        public Cache(ConcurrentMap<CacheKey<?>, Object> map) {
            this.map = map;
        }

        public <A> Option<F> get(CacheKey<A> schema) {
            return Option$.MODULE$.apply(this.map.get(schema)).map((Function1 & Serializable)_$5 -> _$5);
        }

        public <A> F put(CacheKey<A> schema, F value) {
            this.map.put(schema, value);
            return value;
        }

        public int size() {
            return this.map.size();
        }
    }

    public static interface CacheKey<A> {
        public static <A> CacheKey<A> fromSchema(Schema<A> schema) {
            return CachedDeriver$CacheKey$.MODULE$.fromSchema(schema);
        }

        public static <A> CacheKey<A> fromStandardType(StandardType<A> standardType) {
            return CachedDeriver$CacheKey$.MODULE$.fromStandardType(standardType);
        }

        public static int ordinal(CacheKey<?> cacheKey) {
            return CachedDeriver$CacheKey$.MODULE$.ordinal(cacheKey);
        }
    }
}

