/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.codec;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe$;
import zio.schema.Fallback;
import zio.schema.MutableSchemaBasedValueBuilder;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;
import zio.schema.annotation.fieldDefaultValue;
import zio.schema.annotation.fieldDefaultValue$;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.DecodeError;
import zio.schema.codec.FieldMapping;
import zio.schema.codec.FieldMappingCache;
import zio.schema.codec.ProtobufCodec;
import zio.schema.codec.ProtobufCodec$;
import zio.schema.codec.ProtobufCodec$DecoderContext$;
import zio.schema.codec.ProtobufCodec$EncoderContext$;
import zio.schema.codec.ProtobufCodec$Protobuf$;
import zio.schema.codec.ProtobufCodec$Protobuf$WireType$Bit32$;
import zio.schema.codec.ProtobufCodec$Protobuf$WireType$Bit64$;
import zio.schema.codec.ProtobufCodec$Protobuf$WireType$EndGroup$;
import zio.schema.codec.ProtobufCodec$Protobuf$WireType$LengthDelimited$;
import zio.schema.codec.ProtobufCodec$Protobuf$WireType$StartGroup$;
import zio.schema.codec.ProtobufCodec$Protobuf$WireType$VarInt$;
import zio.schema.codec.fieldNumber$;

public final class ProtobufCodec {
    public static <A> BinaryCodec<A> protobufCodec(Schema<A> schema) {
        return ProtobufCodec$.MODULE$.protobufCodec(schema);
    }

    public static class Decoder
    implements MutableSchemaBasedValueBuilder<Object, DecoderContext> {
        private final DecoderState state;
        private final FieldMappingCache fieldMappingCache;
        private final DecoderContext initialContext;

        public Decoder(Chunk<Object> chunk) {
            this.state = new DecoderState(chunk, 0);
            this.fieldMappingCache = new FieldMappingCache();
            this.initialContext = ProtobufCodec$DecoderContext$.MODULE$.apply((Option<Object>)None$.MODULE$, false, (Option<DecoderContext>)None$.MODULE$, false);
        }

        public <A> Either<DecodeError, A> decode(Schema<A> schema) {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(this.create(schema));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof MutableSchemaBasedValueBuilder.CreateValueFromSchemaError) {
                    MutableSchemaBasedValueBuilder.CreateValueFromSchemaError createValueFromSchemaError = MutableSchemaBasedValueBuilder.CreateValueFromSchemaError$.MODULE$.unapply((MutableSchemaBasedValueBuilder.CreateValueFromSchemaError)throwable2);
                    Object object = createValueFromSchemaError._1();
                    Throwable throwable3 = createValueFromSchemaError._2();
                    Throwable cause = throwable3;
                    Throwable throwable4 = cause;
                    if (throwable4 instanceof DecodeError) {
                        DecodeError error = (DecodeError)throwable4;
                        right = package$.MODULE$.Left().apply((Object)error);
                    } else {
                        right = package$.MODULE$.Left().apply((Object)DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)cause, Cause$.MODULE$.fail$default$2()), cause.getMessage()));
                    }
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable5;
                    Throwable err = throwable5 = (Throwable)option.get();
                    right = package$.MODULE$.Left().apply((Object)DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)err, Cause$.MODULE$.fail$default$2()), err.getMessage()));
                }
                throw throwable;
            }
            return right;
        }

        private <A> A createTypedPrimitive(DecoderContext context, StandardType<A> standardType) {
            return (A)this.createPrimitive(context, standardType);
        }

        public Object createPrimitive(DecoderContext context, StandardType<?> typ) {
            StandardType<?> standardType = typ;
            if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                return BoxedUnit.UNIT;
            }
            if (StandardType.StringType$.MODULE$.equals(standardType)) {
                return this.stringDecoder(context);
            }
            if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToBoolean((this.varIntDecoder(context) != 0L ? 1 : 0) != 0);
            }
            if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToShort((short)Predef$.MODULE$.long2Long(this.varIntDecoder(context)).shortValue());
            }
            if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                if (!context.directByteEncoding()) {
                    return BoxesRunTime.boxToByte((byte)Predef$.MODULE$.long2Long(this.varIntDecoder(context)).byteValue());
                }
                if (context.directByteEncoding()) {
                    byte result = this.state.peek();
                    this.state.move(1);
                    return BoxesRunTime.boxToByte((byte)result);
                }
            }
            if (StandardType.IntType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToInteger((int)Predef$.MODULE$.long2Long(this.varIntDecoder(context)).intValue());
            }
            if (StandardType.LongType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToLong((long)this.varIntDecoder(context));
            }
            if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToFloat((float)this.floatDecoder(context));
            }
            if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToDouble((double)this.doubleDecoder(context));
            }
            if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                Chunk<Object> bytes = this.binaryDecoder(context);
                return new BigInteger((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
            }
            if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                BigInteger unscaled = (BigInteger)this.createTypedPrimitive(this.rawFieldDecoder(context, 1), (StandardType)StandardType.BigIntegerType$.MODULE$);
                int precision = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 2), (StandardType)StandardType.IntType$.MODULE$));
                int scale = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 3), (StandardType)StandardType.IntType$.MODULE$));
                MathContext ctx = new MathContext(precision);
                return new BigDecimal(unscaled, scale, ctx);
            }
            if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                return this.binaryDecoder(context);
            }
            if (StandardType.CharType$.MODULE$.equals(standardType)) {
                return BoxesRunTime.boxToCharacter((char)this.stringDecoder(context).charAt(0));
            }
            if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                UUID uUID;
                String uuid = this.stringDecoder(context);
                try {
                    uUID = UUID.fromString(uuid);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        throw DecodeError.MalformedField$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.UUIDType$.MODULE$), new StringBuilder(20).append("Invalid UUID string ").append(uuid).toString());
                    }
                    throw throwable;
                }
                return uUID;
            }
            if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                return DayOfWeek.of(Predef$.MODULE$.long2Long(this.varIntDecoder(context)).intValue());
            }
            if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                return Month.of(Predef$.MODULE$.long2Long(this.varIntDecoder(context)).intValue());
            }
            if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                int month = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 1), (StandardType)StandardType.IntType$.MODULE$));
                int day = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 2), (StandardType)StandardType.IntType$.MODULE$));
                return MonthDay.of(month, day);
            }
            if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                int years = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 1), (StandardType)StandardType.IntType$.MODULE$));
                int months = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 2), (StandardType)StandardType.IntType$.MODULE$));
                int days = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 3), (StandardType)StandardType.IntType$.MODULE$));
                return Period.of(years, months, days);
            }
            if (StandardType.YearType$.MODULE$.equals(standardType)) {
                return Year.of(Predef$.MODULE$.long2Long(this.varIntDecoder(context)).intValue());
            }
            if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                int year = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 1), (StandardType)StandardType.IntType$.MODULE$));
                int month = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 2), (StandardType)StandardType.IntType$.MODULE$));
                return YearMonth.of(year, month);
            }
            if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                return ZoneId.of(this.stringDecoder(context));
            }
            if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                return ZoneOffset.ofTotalSeconds(Predef$.MODULE$.long2Long(this.varIntDecoder(context)).intValue());
            }
            if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                long seconds = BoxesRunTime.unboxToLong(this.createTypedPrimitive(this.rawFieldDecoder(context, 1), (StandardType)StandardType.LongType$.MODULE$));
                int nanos = BoxesRunTime.unboxToInt(this.createTypedPrimitive(this.rawFieldDecoder(context, 2), (StandardType)StandardType.IntType$.MODULE$));
                return Duration.ofSeconds(seconds, nanos);
            }
            if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                return Instant.parse(this.stringDecoder(context));
            }
            if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                return LocalDate.parse(this.stringDecoder(context));
            }
            if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                return LocalTime.parse(this.stringDecoder(context));
            }
            if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                return LocalDateTime.parse(this.stringDecoder(context));
            }
            if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                return OffsetTime.parse(this.stringDecoder(context));
            }
            if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                return OffsetDateTime.parse(this.stringDecoder(context));
            }
            if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
                return ZonedDateTime.parse(this.stringDecoder(context));
            }
            if (StandardType.CurrencyType$.MODULE$.equals(standardType)) {
                return Currency.getInstance(this.stringDecoder(context));
            }
            StandardType<?> st = standardType;
            return this.fail(context, new StringBuilder(27).append("Unsupported primitive type ").append(st).toString());
        }

        public DecoderContext startCreatingRecord(DecoderContext context, Schema.Record<?> record) {
            return context;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MutableSchemaBasedValueBuilder.ReadingFieldResult<DecoderContext> startReadingField(DecoderContext context, Schema.Record<?> record, int index) {
            MutableSchemaBasedValueBuilder.ReadingFieldResult$.UpdateContext updateContext;
            if (this.state.length(context) <= 0) {
                return MutableSchemaBasedValueBuilder.ReadingFieldResult$.Finished$.MODULE$.apply();
            }
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 == null) throw new MatchError(tuple2);
            Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
            int fieldNumber2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            FieldMapping fieldMapping = this.fieldMappingCache.get(record);
            Option option = fieldMapping.fieldNumberToIndex().get((Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            if (option instanceof Some) {
                DecoderContext decoderContext;
                int index2 = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (!record.fields().isDefinedAt(index2)) throw DecodeError.ExtraFields$.MODULE$.apply("Unknown", new StringBuilder(63).append("Failed to decode record. Schema does not contain field number ").append(fieldNumber2).append(".").toString());
                Protobuf.WireType wireType = wt;
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    int n;
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int width = n = lengthDelimited._1();
                    decoderContext = context.limitedTo(this.state, width);
                } else {
                    decoderContext = context;
                }
                updateContext = MutableSchemaBasedValueBuilder.ReadingFieldResult$.ReadField$.MODULE$.apply((Object)decoderContext, index2);
                return (MutableSchemaBasedValueBuilder.ReadingFieldResult)updateContext;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                Protobuf.WireType wireType = wt;
                if (ProtobufCodec$Protobuf$WireType$VarInt$.MODULE$.equals(wireType)) {
                    this.varIntDecoder(context);
                    updateContext = MutableSchemaBasedValueBuilder.ReadingFieldResult$.UpdateContext$.MODULE$.apply((Object)context);
                    return (MutableSchemaBasedValueBuilder.ReadingFieldResult)updateContext;
                } else if (ProtobufCodec$Protobuf$WireType$Bit64$.MODULE$.equals(wireType)) {
                    this.state.move(8);
                    updateContext = MutableSchemaBasedValueBuilder.ReadingFieldResult$.UpdateContext$.MODULE$.apply((Object)context);
                    return (MutableSchemaBasedValueBuilder.ReadingFieldResult)updateContext;
                } else if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    int n;
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int width = n = lengthDelimited._1();
                    this.state.move(width);
                    updateContext = MutableSchemaBasedValueBuilder.ReadingFieldResult$.UpdateContext$.MODULE$.apply((Object)context);
                    return (MutableSchemaBasedValueBuilder.ReadingFieldResult)updateContext;
                } else {
                    if (!ProtobufCodec$Protobuf$WireType$Bit32$.MODULE$.equals(wireType)) throw DecodeError.ExtraFields$.MODULE$.apply("Unknown", new StringBuilder(89).append("Failed to decode record. Schema does not contain field number ").append(fieldNumber2).append(" and it's length is unknown").toString());
                    this.state.move(4);
                    updateContext = MutableSchemaBasedValueBuilder.ReadingFieldResult$.UpdateContext$.MODULE$.apply((Object)context);
                }
            }
            return (MutableSchemaBasedValueBuilder.ReadingFieldResult)updateContext;
        }

        public Object createRecord(DecoderContext context, Schema.Record<?> record, Chunk<Tuple2<Object, Object>> values) {
            return Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> {
                Object[] array = new Object[record.fields().length()];
                boolean[] mask = (boolean[])Array$.MODULE$.fill(record.fields().length(), this::$anonfun$4, ClassTag$.MODULE$.apply(Boolean.TYPE));
                record.fields().zipWithIndex().withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Schema.Field field = (Schema.Field)tuple2._1();
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        return true;
                    }
                    return false;
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Schema.Field field = (Schema.Field)tuple2._1();
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        Option defaultValue = field.annotations().collectFirst((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(Object x) {
                                Object object = x;
                                if (object instanceof fieldDefaultValue) {
                                    Object object2;
                                    fieldDefaultValue fieldDefaultValue2 = fieldDefaultValue$.MODULE$.unapply((fieldDefaultValue)object);
                                    Object defaultValue = object2 = fieldDefaultValue2._1();
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(Object x, Function1 function1) {
                                Object object = x;
                                if (object instanceof fieldDefaultValue) {
                                    Object object2;
                                    fieldDefaultValue fieldDefaultValue2 = fieldDefaultValue$.MODULE$.unapply((fieldDefaultValue)object);
                                    Object defaultValue = object2 = fieldDefaultValue2._1();
                                    return defaultValue;
                                }
                                return function1.apply(x);
                            }
                        });
                        Option option = defaultValue;
                        if (option instanceof Some) {
                            Object defaultValue2;
                            array$1[index] = defaultValue2 = ((Some)option).value();
                            mask$1[index] = true;
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)tuple2);
                });
                values.withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        Object value = tuple2._2();
                        return true;
                    }
                    return false;
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        Object value = tuple2._2();
                        if (index < array.length) {
                            array$2[index] = value;
                            mask$2[index] = true;
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                Object object = Predef$.MODULE$.booleanArrayOps(mask);
                if (ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)set -> this.createRecord$$anonfun$1$$anonfun$5(BoxesRunTime.unboxToBoolean((Object)set)))) {
                    Either either = record.construct(Chunk$.MODULE$.fromArray((Object)array), u);
                    if (either instanceof Right) {
                        Object result = ((Right)either).value();
                        return result;
                    }
                    if (either instanceof Left) {
                        String message = (String)((Left)either).value();
                        throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), message);
                    }
                    throw new MatchError((Object)either);
                }
                Object object2 = Predef$.MODULE$.booleanArrayOps(mask);
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object2, (IterableOnce)record.fields()));
                Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object3, (Function1 & Serializable)_$3 -> !BoxesRunTime.unboxToBoolean((Object)_$3._1())));
                throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), new StringBuilder(41).append("Failed to decode record. Missing fields: ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)_$4 -> (Schema.Field)_$4._2(), ClassTag$.MODULE$.apply(Schema.Field.class))).mkString(", ")).toString());
            });
        }

        public Tuple2<DecoderContext, Object> startCreatingEnum(DecoderContext context, Chunk<Schema.Case<?, ?>> cases) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                int fieldNumber2 = n;
                if (fieldNumber2 <= cases.length()) {
                    Protobuf.WireType wireType = wt;
                    if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                        int n2;
                        Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                        int width = n2 = lengthDelimited._1();
                        return Tuple2$.MODULE$.apply((Object)context.limitedTo(this.state, width), (Object)BoxesRunTime.boxToInteger((int)(fieldNumber2 - 1)));
                    }
                    return Tuple2$.MODULE$.apply((Object)context, (Object)BoxesRunTime.boxToInteger((int)(fieldNumber2 - 1)));
                }
                int fieldNumber3 = n;
                throw DecodeError.MissingField$.MODULE$.apply(((Schema.Case)cases.apply(fieldNumber3 - 1)).schema(), new StringBuilder(68).append("Failed to decode enumeration. Schema does not contain field number ").append(fieldNumber3).append(".").toString());
            }
            throw new MatchError(tuple2);
        }

        public Object createEnum(DecoderContext context, Chunk<Schema.Case<?, ?>> cases, int index, Object value) {
            return value;
        }

        public Option<DecoderContext> startCreatingSequence(DecoderContext context, Schema.Sequence<?, ?, ?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wireType = (Protobuf.WireType)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int n2 = lengthDelimited._1();
                    if (0 == n2 && 1 == n) {
                        return None$.MODULE$;
                    }
                    int width = n2;
                    if (2 == n) {
                        DecoderContext decoderContext = context.limitedTo(this.state, width);
                        boolean bl = ProtobufCodec$Protobuf$.MODULE$.canBePacked(schema.elementSchema());
                        Option<Object> option = decoderContext.copy$default$1();
                        Option<DecoderContext> option2 = decoderContext.copy$default$3();
                        boolean bl2 = decoderContext.copy$default$4();
                        return Some$.MODULE$.apply((Object)decoderContext.copy(option, bl, option2, bl2));
                    }
                }
                Protobuf.WireType wt = wireType;
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(59).append("Invalid wire type (").append(wt).append(") or field number (").append(fieldNumber2).append(") for packed sequence").toString());
            }
            throw new MatchError(tuple2);
        }

        public DecoderContext startCreatingOneSequenceElement(DecoderContext context, Schema.Sequence<?, ?, ?> schema) {
            if (context.packed()) {
                Schema schema2 = schema.elementSchema();
                Schema schema3 = Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.ByteType$.MODULE$));
                if (!(schema2 != null ? !schema2.equals(schema3) : schema3 != null)) {
                    return context.copy(context.copy$default$1(), context.copy$default$2(), context.copy$default$3(), true);
                }
                return context;
            }
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                Protobuf.WireType wireType = wt;
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    int n;
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int elemWidth = n = lengthDelimited._1();
                    return context.limitedTo(this.state, elemWidth);
                }
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(45).append("Unexpected wire type ").append(wt).append(" for non-packed sequence").toString());
            }
            throw new MatchError(tuple2);
        }

        public boolean finishedCreatingOneSequenceElement(DecoderContext context, int index) {
            return this.state.length(context) > 0;
        }

        public Object createSequence(DecoderContext context, Schema.Sequence<?, ?, ?> schema, Chunk<Object> values) {
            return schema.fromChunk().apply(values);
        }

        public Option<DecoderContext> startCreatingDictionary(DecoderContext context, Schema.Map<?, ?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wireType = (Protobuf.WireType)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int n2 = lengthDelimited._1();
                    if (0 == n2 && 1 == n) {
                        return None$.MODULE$;
                    }
                    int width = n2;
                    if (2 == n) {
                        DecoderContext decoderContext = context.limitedTo(this.state, width);
                        boolean bl = ProtobufCodec$Protobuf$.MODULE$.canBePacked(schema.keySchema().zip(schema.valueSchema()));
                        Option<Object> option = decoderContext.copy$default$1();
                        Option<DecoderContext> option2 = decoderContext.copy$default$3();
                        boolean bl2 = decoderContext.copy$default$4();
                        return Some$.MODULE$.apply((Object)decoderContext.copy(option, bl, option2, bl2));
                    }
                }
                Protobuf.WireType wt = wireType;
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(59).append("Invalid wire type (").append(wt).append(") or field number (").append(fieldNumber2).append(") for packed sequence").toString());
            }
            throw new MatchError(tuple2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DecoderContext startCreatingOneDictionaryElement(DecoderContext context, Schema.Map<?, ?> schema) {
            DecoderContext decoderContext;
            if (context.packed()) {
                decoderContext = context;
            } else {
                int n;
                Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
                if (tuple2 == null) throw new MatchError(tuple2);
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                Protobuf.WireType wireType = wt;
                if (!(wireType instanceof Protobuf.WireType.LengthDelimited)) throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(45).append("Unexpected wire type ").append(wt).append(" for non-packed sequence").toString());
                Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                int elemWidth = n = lengthDelimited._1();
                decoderContext = context.limitedTo(this.state, elemWidth);
            }
            DecoderContext elemContext = decoderContext;
            DecoderContext decoderContext2 = this.enterFirstTupleElement(elemContext, (Schema<?>)schema);
            Some some = Some$.MODULE$.apply((Object)elemContext);
            Option<Object> option = decoderContext2.copy$default$1();
            boolean bl = decoderContext2.copy$default$2();
            boolean bl2 = decoderContext2.copy$default$4();
            return decoderContext2.copy(option, bl, (Option<DecoderContext>)some, bl2);
        }

        public DecoderContext startCreatingOneDictionaryValue(DecoderContext context, Schema.Map<?, ?> schema) {
            return this.enterSecondTupleElement((DecoderContext)context.dictionaryElementContext().getOrElse(() -> this.startCreatingOneDictionaryValue$$anonfun$1(context)), (Schema<?>)schema);
        }

        public boolean finishedCreatingOneDictionaryElement(DecoderContext context, Schema.Map<?, ?> schema, int index) {
            return this.state.length(context) > 0;
        }

        public Object createDictionary(DecoderContext context, Schema.Map<?, ?> schema, Chunk<Tuple2<Object, Object>> values) {
            return values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Option<DecoderContext> startCreatingSet(DecoderContext context, Schema.Set<?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wireType = (Protobuf.WireType)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int n2 = lengthDelimited._1();
                    if (0 == n2 && 1 == n) {
                        return None$.MODULE$;
                    }
                    int width = n2;
                    if (2 == n) {
                        DecoderContext decoderContext = context.limitedTo(this.state, width);
                        boolean bl = ProtobufCodec$Protobuf$.MODULE$.canBePacked(schema.elementSchema());
                        Option<Object> option = decoderContext.copy$default$1();
                        Option<DecoderContext> option2 = decoderContext.copy$default$3();
                        boolean bl2 = decoderContext.copy$default$4();
                        return Some$.MODULE$.apply((Object)decoderContext.copy(option, bl, option2, bl2));
                    }
                }
                Protobuf.WireType wt = wireType;
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(59).append("Invalid wire type (").append(wt).append(") or field number (").append(fieldNumber2).append(") for packed sequence").toString());
            }
            throw new MatchError(tuple2);
        }

        public DecoderContext startCreatingOneSetElement(DecoderContext context, Schema.Set<?> schema) {
            if (context.packed()) {
                return context;
            }
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                Protobuf.WireType wireType = wt;
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    int n;
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int elemWidth = n = lengthDelimited._1();
                    return context.limitedTo(this.state, elemWidth);
                }
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(45).append("Unexpected wire type ").append(wt).append(" for non-packed sequence").toString());
            }
            throw new MatchError(tuple2);
        }

        public boolean finishedCreatingOneSetElement(DecoderContext context, Schema.Set<?> schema, int index) {
            return this.state.length(context) > 0;
        }

        public Object createSet(DecoderContext context, Schema.Set<?> schema, Chunk<Object> values) {
            return values.toSet();
        }

        public Option<DecoderContext> startCreatingOptional(DecoderContext context, Schema.Optional<?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wireType = (Protobuf.WireType)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                    Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                    int n2 = lengthDelimited._1();
                    if (0 == n2 && 1 == n) {
                        return None$.MODULE$;
                    }
                    int width = n2;
                    if (2 == n) {
                        return Some$.MODULE$.apply((Object)context.limitedTo(this.state, width));
                    }
                }
                if (2 == n) {
                    return Some$.MODULE$.apply((Object)context);
                }
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(32).append("Invalid field number ").append(fieldNumber2).append(" for option").toString());
            }
            throw new MatchError(tuple2);
        }

        public Object createOptional(DecoderContext context, Schema.Optional<?> schema, Option<Object> value) {
            return value;
        }

        public Either<DecoderContext, DecoderContext> startCreatingEither(DecoderContext context, Schema.Either<?, ?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                int fieldNumber2 = n;
                if (fieldNumber2 == 1) {
                    return package$.MODULE$.Left().apply((Object)context);
                }
                int fieldNumber3 = n;
                if (fieldNumber3 == 2) {
                    return package$.MODULE$.Right().apply((Object)context);
                }
                int fieldNumber4 = n;
                throw DecodeError.ExtraFields$.MODULE$.apply(BoxesRunTime.boxToInteger((int)fieldNumber4).toString(), new StringBuilder(34).append("Invalid field number (").append(fieldNumber4).append(") for either").toString());
            }
            throw new MatchError(tuple2);
        }

        public Object createEither(DecoderContext context, Schema.Either<?, ?> schema, Either<Object, Object> value) {
            return value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Fallback<DecoderContext, DecoderContext> startCreatingFallback(DecoderContext context, Schema.Fallback<?, ?> schema) {
            Fallback.Left left;
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 == null) throw DecodeError.ExtraFields$.MODULE$.apply(fieldNumber$.MODULE$.toString(), new StringBuilder(36).append("Invalid field number (").append(fieldNumber$.MODULE$).append(") for fallback").toString());
            int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
            int fieldNumber2 = n;
            if (fieldNumber2 == 1) {
                left = Fallback.Left$.MODULE$.apply((Object)context);
                return (Fallback)left;
            } else {
                int fieldNumber3 = n;
                if (fieldNumber3 == 2) {
                    left = Fallback.Right$.MODULE$.apply((Object)context);
                    return (Fallback)left;
                } else {
                    int fieldNumber4 = n;
                    if (fieldNumber4 != 3) throw DecodeError.ExtraFields$.MODULE$.apply(fieldNumber$.MODULE$.toString(), new StringBuilder(36).append("Invalid field number (").append(fieldNumber$.MODULE$).append(") for fallback").toString());
                    left = Fallback.Both$.MODULE$.apply((Object)context, (Object)context);
                }
            }
            return (Fallback)left;
        }

        public DecoderContext startReadingRightFallback(DecoderContext context, Schema.Fallback<?, ?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                if (2 == n) {
                    Protobuf.WireType wireType = wt;
                    if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                        int n2;
                        Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                        int width = n2 = lengthDelimited._1();
                        return context.limitedTo(this.state, width);
                    }
                    return context;
                }
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(48).append("Invalid field number ").append(fieldNumber2).append(" for fallback's right field").toString());
            }
            throw new MatchError(tuple2);
        }

        public Object createFallback(DecoderContext context, Schema.Fallback<?, ?> schema, Fallback<Object, Object> value) {
            if (schema.fullDecode()) {
                return value;
            }
            return value.simplify();
        }

        public DecoderContext startCreatingTuple(DecoderContext context, Schema.Tuple2<?, ?> schema) {
            return this.enterFirstTupleElement(context, (Schema<?>)schema);
        }

        private DecoderContext enterFirstTupleElement(DecoderContext context, Schema<?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                if (1 == n) {
                    Protobuf.WireType wireType = wt;
                    if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                        int n2;
                        Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                        int width = n2 = lengthDelimited._1();
                        return context.limitedTo(this.state, width);
                    }
                    return context;
                }
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(45).append("Invalid field number ").append(fieldNumber2).append(" for tuple's first field").toString());
            }
            throw new MatchError(tuple2);
        }

        public DecoderContext startReadingSecondTupleElement(DecoderContext context, Schema.Tuple2<?, ?> schema) {
            return this.enterSecondTupleElement(context, (Schema<?>)schema);
        }

        private DecoderContext enterSecondTupleElement(DecoderContext context, Schema<?> schema) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                if (2 == n) {
                    Protobuf.WireType wireType = wt;
                    if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                        int n2;
                        Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                        int width = n2 = lengthDelimited._1();
                        return context.limitedTo(this.state, width);
                    }
                    return context;
                }
                int fieldNumber2 = n;
                throw DecodeError.MalformedField$.MODULE$.apply(schema, new StringBuilder(46).append("Invalid field number ").append(fieldNumber2).append(" for tuple's second field").toString());
            }
            throw new MatchError(tuple2);
        }

        public Object createTuple(DecoderContext context, Schema.Tuple2<?, ?> schema, Object left, Object right) {
            return Tuple2$.MODULE$.apply(left, right);
        }

        public Option<Object> createDynamic(DecoderContext context) {
            return None$.MODULE$;
        }

        public Object transform(DecoderContext context, Object value, Function1<Object, Either<String, Object>> f, Schema<?> schema) {
            Either either = (Either)f.apply(value);
            if (either instanceof Left) {
                String value2 = (String)((Left)either).value();
                throw DecodeError.MalformedField$.MODULE$.apply(schema, value2);
            }
            if (either instanceof Right) {
                Object value3 = ((Right)either).value();
                return value3;
            }
            throw new MatchError((Object)either);
        }

        public Object fail(DecoderContext context, String message) {
            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), message);
        }

        public DecoderContext initialContext() {
            return this.initialContext;
        }

        public Tuple2<Protobuf.WireType, Object> keyDecoder(DecoderContext context) {
            long key = this.varIntDecoder(context);
            int fieldNumber2 = (int)(key >>> 3);
            if (fieldNumber2 < 1) {
                throw DecodeError.ExtraFields$.MODULE$.apply(BoxesRunTime.boxToInteger((int)fieldNumber2).toString(), new StringBuilder(42).append("Failed decoding key. Invalid field number ").append(fieldNumber2).toString());
            }
            long l = key & 7L;
            if (0L == l) {
                return Tuple2$.MODULE$.apply((Object)ProtobufCodec$Protobuf$WireType$VarInt$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            }
            if (1L == l) {
                return Tuple2$.MODULE$.apply((Object)ProtobufCodec$Protobuf$WireType$Bit64$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            }
            if (2L == l) {
                long length = this.varIntDecoder(context);
                return Tuple2$.MODULE$.apply((Object)ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.apply((int)length), (Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            }
            if (3L == l) {
                return Tuple2$.MODULE$.apply((Object)ProtobufCodec$Protobuf$WireType$StartGroup$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            }
            if (4L == l) {
                return Tuple2$.MODULE$.apply((Object)ProtobufCodec$Protobuf$WireType$EndGroup$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            }
            if (5L == l) {
                return Tuple2$.MODULE$.apply((Object)ProtobufCodec$Protobuf$WireType$Bit32$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)fieldNumber2));
            }
            long n = l;
            throw DecodeError.ExtraFields$.MODULE$.apply(BoxesRunTime.boxToInteger((int)fieldNumber2).toString(), new StringBuilder(39).append("Failed decoding key. Unknown wire type ").append(n).toString());
        }

        private DecoderContext rawFieldDecoder(DecoderContext context, int expectedFieldNumber) {
            Tuple2<Protobuf.WireType, Object> tuple2 = this.keyDecoder(context);
            if (tuple2 != null) {
                Protobuf.WireType wt = (Protobuf.WireType)tuple2._1();
                int fieldNumber2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (fieldNumber2 == expectedFieldNumber) {
                    Protobuf.WireType wireType = wt;
                    if (wireType instanceof Protobuf.WireType.LengthDelimited) {
                        int n;
                        Protobuf.WireType.LengthDelimited lengthDelimited = ProtobufCodec$Protobuf$WireType$LengthDelimited$.MODULE$.unapply((Protobuf.WireType.LengthDelimited)wireType);
                        int width = n = lengthDelimited._1();
                        return context.limitedTo(this.state, width);
                    }
                    return context;
                }
            }
            throw DecodeError.ExtraFields$.MODULE$.apply("Unknown", new StringBuilder(63).append("Failed to decode record. Schema does not contain field number ").append(expectedFieldNumber).append(".").toString());
        }

        private float floatDecoder(DecoderContext context) {
            if (this.state.length(context) < 4) {
                throw DecodeError.MalformedField$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.FloatType$.MODULE$), new StringBuilder(51).append("Invalid number of bytes for Float. Expected 4, got ").append(this.state.length(context)).toString());
            }
            Chunk<Object> bytes = this.state.read(4);
            return ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))).order(ByteOrder.LITTLE_ENDIAN).getFloat();
        }

        private double doubleDecoder(DecoderContext context) {
            if (this.state.length(context) < 8) {
                throw DecodeError.MalformedField$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.DoubleType$.MODULE$), new StringBuilder(52).append("Invalid number of bytes for Double. Expected 8, got ").append(this.state.length(context)).toString());
            }
            Chunk<Object> bytes = this.state.read(8);
            return ByteBuffer.wrap((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        }

        private String stringDecoder(DecoderContext context) {
            Chunk<Object> bytes = this.state.all(context);
            return new String((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), StandardCharsets.UTF_8);
        }

        private long varIntDecoder(DecoderContext context) {
            int maxLength = this.state.length(context);
            if (maxLength == 0) {
                throw DecodeError.MalformedField$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.LongType$.MODULE$), "Failed to decode VarInt. Unexpected end of chunk");
            }
            int count = 0;
            boolean done = false;
            long result = 0L;
            while (count < maxLength && !done) {
                byte by = this.state.peek();
                result |= (long)(by & 0x7F) << count * 7;
                this.state.move(1);
                if ((by & 0x80) == 0) {
                    done = true;
                    continue;
                }
                ++count;
            }
            if (!done) {
                throw DecodeError.MalformedField$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.LongType$.MODULE$), "Failed to decode VarInt. No byte within the range 0 - 127 are present");
            }
            return result;
        }

        private Chunk<Object> binaryDecoder(DecoderContext context) {
            return this.state.all(context);
        }

        public Chunk<Object> remainder() {
            return this.state.peek(ProtobufCodec$DecoderContext$.MODULE$.apply((Option<Object>)None$.MODULE$, false, (Option<DecoderContext>)None$.MODULE$, false));
        }

        private final boolean $anonfun$4() {
            return false;
        }

        private final /* synthetic */ boolean createRecord$$anonfun$1$$anonfun$5(boolean set) {
            return set;
        }

        private final DecoderContext startCreatingOneDictionaryValue$$anonfun$1(DecoderContext context$1) {
            return context$1;
        }
    }

    public static final class DecoderContext
    implements Product,
    Serializable {
        private final Option limit;
        private final boolean packed;
        private final Option dictionaryElementContext;
        private final boolean directByteEncoding;

        public static DecoderContext apply(Option<Object> option, boolean bl, Option<DecoderContext> option2, boolean bl2) {
            return ProtobufCodec$DecoderContext$.MODULE$.apply(option, bl, option2, bl2);
        }

        public static DecoderContext fromProduct(Product product) {
            return ProtobufCodec$DecoderContext$.MODULE$.fromProduct(product);
        }

        public static DecoderContext unapply(DecoderContext decoderContext) {
            return ProtobufCodec$DecoderContext$.MODULE$.unapply(decoderContext);
        }

        public DecoderContext(Option<Object> limit, boolean packed, Option<DecoderContext> dictionaryElementContext, boolean directByteEncoding) {
            this.limit = limit;
            this.packed = packed;
            this.dictionaryElementContext = dictionaryElementContext;
            this.directByteEncoding = directByteEncoding;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.limit()));
            n = Statics.mix((int)n, (int)(this.packed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.dictionaryElementContext()));
            n = Statics.mix((int)n, (int)(this.directByteEncoding() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DecoderContext)) return false;
            DecoderContext decoderContext = (DecoderContext)object;
            if (this.packed() != decoderContext.packed()) return false;
            if (this.directByteEncoding() != decoderContext.directByteEncoding()) return false;
            Option<Object> option = this.limit();
            Option<Object> option2 = decoderContext.limit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<DecoderContext> option3 = this.dictionaryElementContext();
            Option<DecoderContext> option4 = decoderContext.dictionaryElementContext();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DecoderContext;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "DecoderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "limit";
                }
                case 1: {
                    return "packed";
                }
                case 2: {
                    return "dictionaryElementContext";
                }
                case 3: {
                    return "directByteEncoding";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Object> limit() {
            return this.limit;
        }

        public boolean packed() {
            return this.packed;
        }

        public Option<DecoderContext> dictionaryElementContext() {
            return this.dictionaryElementContext;
        }

        public boolean directByteEncoding() {
            return this.directByteEncoding;
        }

        public DecoderContext limitedTo(DecoderState state, int w) {
            return this.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(state.currentPosition() + w))), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public DecoderContext copy(Option<Object> limit, boolean packed, Option<DecoderContext> dictionaryElementContext, boolean directByteEncoding) {
            return new DecoderContext(limit, packed, dictionaryElementContext, directByteEncoding);
        }

        public Option<Object> copy$default$1() {
            return this.limit();
        }

        public boolean copy$default$2() {
            return this.packed();
        }

        public Option<DecoderContext> copy$default$3() {
            return this.dictionaryElementContext();
        }

        public boolean copy$default$4() {
            return this.directByteEncoding();
        }

        public Option<Object> _1() {
            return this.limit();
        }

        public boolean _2() {
            return this.packed();
        }

        public Option<DecoderContext> _3() {
            return this.dictionaryElementContext();
        }

        public boolean _4() {
            return this.directByteEncoding();
        }
    }

    public static final class DecoderState {
        private final Chunk<Object> chunk;
        private int position;

        public DecoderState(Chunk<Object> chunk, int position) {
            this.chunk = chunk;
            this.position = position;
        }

        private int position() {
            return this.position;
        }

        private void position_$eq(int x$0) {
            this.position = x$0;
        }

        public int length(DecoderContext context) {
            return BoxesRunTime.unboxToInt((Object)context.limit().getOrElse(this::length$$anonfun$1)) - this.position();
        }

        public Chunk<Object> read(int count) {
            int oldPosition = this.position();
            this.position_$eq(this.position() + count);
            return this.chunk.slice(oldPosition, this.position());
        }

        public Chunk<Object> all(DecoderContext context) {
            return this.read(this.length(context));
        }

        public Chunk<Object> peek(DecoderContext context) {
            return this.chunk.slice(this.position(), this.position() + this.length(context));
        }

        public byte peek() {
            return this.chunk.byte(this.position(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public void move(int count) {
            this.position_$eq(this.position() + count);
        }

        public int currentPosition() {
            return this.position();
        }

        private final int length$$anonfun$1() {
            return this.chunk.length();
        }
    }

    public static final class EncoderContext
    implements Product,
    Serializable {
        private final Option fieldNumber;
        private final boolean directByteEncoding;

        public static EncoderContext apply(Option<Object> option, boolean bl) {
            return ProtobufCodec$EncoderContext$.MODULE$.apply(option, bl);
        }

        public static EncoderContext fromProduct(Product product) {
            return ProtobufCodec$EncoderContext$.MODULE$.fromProduct(product);
        }

        public static EncoderContext unapply(EncoderContext encoderContext) {
            return ProtobufCodec$EncoderContext$.MODULE$.unapply(encoderContext);
        }

        public EncoderContext(Option<Object> fieldNumber2, boolean directByteEncoding) {
            this.fieldNumber = fieldNumber2;
            this.directByteEncoding = directByteEncoding;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.fieldNumber()));
            n = Statics.mix((int)n, (int)(this.directByteEncoding() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EncoderContext)) return false;
            EncoderContext encoderContext = (EncoderContext)object;
            if (this.directByteEncoding() != encoderContext.directByteEncoding()) return false;
            Option<Object> option = this.fieldNumber();
            Option<Object> option2 = encoderContext.fieldNumber();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EncoderContext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "EncoderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fieldNumber";
            }
            if (1 == n2) {
                return "directByteEncoding";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Object> fieldNumber() {
            return this.fieldNumber;
        }

        public boolean directByteEncoding() {
            return this.directByteEncoding;
        }

        public EncoderContext copy(Option<Object> fieldNumber2, boolean directByteEncoding) {
            return new EncoderContext(fieldNumber2, directByteEncoding);
        }

        public Option<Object> copy$default$1() {
            return this.fieldNumber();
        }

        public boolean copy$default$2() {
            return this.directByteEncoding();
        }

        public Option<Object> _1() {
            return this.fieldNumber();
        }

        public boolean _2() {
            return this.directByteEncoding();
        }
    }
}

