/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.meta;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.runtime.RichInt$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike;
import zio.ChunkLike$;
import zio.constraintless.TypeList;
import zio.schema.TypeId;
import zio.schema.meta.ExtensibleMetaSchema;
import zio.schema.meta.NodePath$;
import zio.schema.meta.NodePath$NodePathSyntax$;

public final class AstRenderer$ {
    public static AstRenderer$ MODULE$;
    private final int INDENT_STEP;

    static {
        new AstRenderer$();
    }

    private int INDENT_STEP() {
        return this.INDENT_STEP;
    }

    public String render(ExtensibleMetaSchema<?> ast) {
        if (ast instanceof ExtensibleMetaSchema.Value) {
            ExtensibleMetaSchema.Value value = (ExtensibleMetaSchema.Value)ast;
            return this.renderValue(value, 0, (Option<String>)None$.MODULE$);
        }
        if (ast instanceof ExtensibleMetaSchema.FailNode) {
            ExtensibleMetaSchema.FailNode failNode = (ExtensibleMetaSchema.FailNode)ast;
            return this.renderFail(failNode, 0, (Option<String>)None$.MODULE$);
        }
        if (ast instanceof ExtensibleMetaSchema.Product) {
            ExtensibleMetaSchema.Product product = (ExtensibleMetaSchema.Product)ast;
            Chunk fields = product.fields();
            boolean optional2 = product.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("product");
            if (optional2) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)fields.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$1, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (ast instanceof ExtensibleMetaSchema.Tuple) {
            ExtensibleMetaSchema.Tuple tuple2 = (ExtensibleMetaSchema.Tuple)ast;
            ExtensibleMetaSchema left = tuple2.left();
            ExtensibleMetaSchema right = tuple2.right();
            boolean optional3 = tuple2.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("tuple");
            if (optional3) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$2, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (ast instanceof ExtensibleMetaSchema.Sum) {
            ExtensibleMetaSchema.Sum sum = (ExtensibleMetaSchema.Sum)ast;
            Chunk cases = sum.cases();
            boolean optional4 = sum.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("enum");
            if (optional4) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)cases.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$3, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (ast instanceof ExtensibleMetaSchema.Either) {
            ExtensibleMetaSchema.Either either2 = (ExtensibleMetaSchema.Either)ast;
            ExtensibleMetaSchema left = either2.left();
            ExtensibleMetaSchema right = either2.right();
            boolean optional5 = either2.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("either");
            if (optional5) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$4, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (ast instanceof ExtensibleMetaSchema.ListNode) {
            ExtensibleMetaSchema.ListNode listNode = (ExtensibleMetaSchema.ListNode)ast;
            ExtensibleMetaSchema items = listNode.item();
            boolean optional6 = listNode.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("list");
            if (optional6) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("item", items)})).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$5, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (ast instanceof ExtensibleMetaSchema.Dictionary) {
            ExtensibleMetaSchema.Dictionary dictionary = (ExtensibleMetaSchema.Dictionary)ast;
            ExtensibleMetaSchema keys = dictionary.keys();
            ExtensibleMetaSchema values = dictionary.values();
            boolean optional7 = dictionary.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append("map");
            if (optional7) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("keys", keys), new ExtensibleMetaSchema.Labelled("values", values)})).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$6, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (ast instanceof ExtensibleMetaSchema.Ref) {
            ExtensibleMetaSchema.Ref ref = (ExtensibleMetaSchema.Ref)ast;
            Chunk refPath = ref.refPath();
            boolean optional8 = ref.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append(new StringBuilder(4).append("ref#").append(refPath).toString());
            if (optional8) {
                buffer.append("?");
            }
            return buffer.toString();
        }
        if (ast instanceof ExtensibleMetaSchema.Known) {
            ExtensibleMetaSchema.Known known = (ExtensibleMetaSchema.Known)ast;
            TypeId typeId = known.typeId();
            boolean optional9 = known.optional();
            StringBuffer buffer = new StringBuffer();
            buffer.append(typeId.toString());
            if (optional9) {
                buffer.append("?");
            }
            return buffer.toString();
        }
        throw new MatchError(ast);
    }

    public <BuiltIn extends TypeList> String renderField(ExtensibleMetaSchema.Labelled<BuiltIn> labelled, int indent) {
        StringBuffer buffer = new StringBuffer();
        ExtensibleMetaSchema<BuiltIn> extensibleMetaSchema = labelled.schema();
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Value) {
            ExtensibleMetaSchema.Value value = (ExtensibleMetaSchema.Value)extensibleMetaSchema;
            return this.renderValue(value, indent, (Option<String>)new Some((Object)labelled.label()));
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.FailNode) {
            ExtensibleMetaSchema.FailNode failNode = (ExtensibleMetaSchema.FailNode)extensibleMetaSchema;
            return this.renderFail(failNode, indent, (Option<String>)new Some((Object)labelled.label()));
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Product) {
            ExtensibleMetaSchema.Product product = (ExtensibleMetaSchema.Product)extensibleMetaSchema;
            Chunk fields = product.fields();
            boolean optional2 = product.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(8).append(labelled.label()).append(": record").toString());
            if (optional2) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)fields.map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$7, indent + MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Tuple) {
            ExtensibleMetaSchema.Tuple tuple2 = (ExtensibleMetaSchema.Tuple)extensibleMetaSchema;
            ExtensibleMetaSchema left = tuple2.left();
            ExtensibleMetaSchema right = tuple2.right();
            boolean optional3 = tuple2.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(7).append(labelled.label()).append(": tuple").toString());
            if (optional3) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$8, indent + MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Sum) {
            ExtensibleMetaSchema.Sum sum = (ExtensibleMetaSchema.Sum)extensibleMetaSchema;
            Chunk cases = sum.cases();
            boolean optional4 = sum.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(6).append(labelled.label()).append(": enum").toString());
            if (optional4) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)cases.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$9, indent + MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Either) {
            ExtensibleMetaSchema.Either either2 = (ExtensibleMetaSchema.Either)extensibleMetaSchema;
            ExtensibleMetaSchema left = either2.left();
            ExtensibleMetaSchema right = either2.right();
            boolean optional5 = either2.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(8).append(labelled.label()).append(": either").toString());
            if (optional5) {
                buffer.append("?");
            }
            return buffer.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("left", left), new ExtensibleMetaSchema.Labelled("right", right)})).map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$10, indent + MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.ListNode) {
            ExtensibleMetaSchema.ListNode listNode = (ExtensibleMetaSchema.ListNode)extensibleMetaSchema;
            ExtensibleMetaSchema items = listNode.item();
            boolean optional6 = listNode.optional();
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append(new StringBuilder(6).append(labelled.label()).append(": list").toString());
            if (optional6) {
                buffer2.append("?");
            }
            return buffer2.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("item", items)})).map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$11, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Dictionary) {
            ExtensibleMetaSchema.Dictionary dictionary = (ExtensibleMetaSchema.Dictionary)extensibleMetaSchema;
            ExtensibleMetaSchema keys = dictionary.keys();
            ExtensibleMetaSchema values = dictionary.values();
            boolean optional7 = dictionary.optional();
            StringBuffer buffer3 = new StringBuffer();
            buffer3.append(new StringBuilder(5).append(labelled.label()).append(": map").toString());
            if (optional7) {
                buffer3.append("?");
            }
            return buffer3.append("\n").append(((ChunkLike)Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtensibleMetaSchema.Labelled[]{new ExtensibleMetaSchema.Labelled("keys", keys), new ExtensibleMetaSchema.Labelled("values", values)})).map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.renderField((ExtensibleMetaSchema.Labelled)x$12, MODULE$.INDENT_STEP()), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.apply()))).mkString("\n")).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Ref) {
            ExtensibleMetaSchema.Ref ref = (ExtensibleMetaSchema.Ref)extensibleMetaSchema;
            Chunk refPath = ref.refPath();
            boolean optional8 = ref.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(2).append(labelled.label()).append(": ").toString());
            if (optional8) {
                buffer.append("?");
            }
            return buffer.append(new StringBuilder(6).append("{ref#").append(NodePath$NodePathSyntax$.MODULE$.render$extension(NodePath$.MODULE$.NodePathSyntax(refPath))).append("}").toString()).toString();
        }
        if (extensibleMetaSchema instanceof ExtensibleMetaSchema.Known) {
            ExtensibleMetaSchema.Known known = (ExtensibleMetaSchema.Known)extensibleMetaSchema;
            TypeId typeId = known.typeId();
            boolean optional9 = known.optional();
            this.pad(buffer, indent);
            buffer.append(new StringBuilder(2).append(labelled.label()).append(": ").toString());
            buffer.append(typeId.toString());
            if (optional9) {
                buffer.append("?");
            }
            return buffer.toString();
        }
        throw new MatchError(extensibleMetaSchema);
    }

    public String renderValue(ExtensibleMetaSchema.Value<?> value, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable & scala.Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        if (value.optional()) {
            buffer.append("?");
        }
        return buffer.append(value.valueType().tag()).toString();
    }

    public String renderFail(ExtensibleMetaSchema.FailNode<?> fail2, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable & scala.Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        if (fail2.optional()) {
            buffer.append("?");
        }
        return buffer.append(new StringBuilder(6).append("FAIL: ").append(fail2.message()).toString()).toString();
    }

    private StringBuffer pad(StringBuffer buffer, int indent) {
        if (indent > 0) {
            buffer.append("|");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), indent).foreach((Function1 & Serializable & scala.Serializable)_ -> buffer.append("-"));
        }
        return buffer;
    }

    private AstRenderer$() {
        MODULE$ = this;
        this.INDENT_STEP = 2;
    }
}

