/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.validation;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import zio.schema.validation.Regex;
import zio.schema.validation.Regex$Digit$;
import zio.schema.validation.Regex$Empty$;
import zio.schema.validation.Regex$Letter$;

public final class Regex$ {
    public static Regex$ MODULE$;
    private final Regex digit;
    private final Regex digitNonZero;
    private final Regex letter;
    private final Regex digitOrLetter;
    private final Regex hexDigit;
    private final Regex hexDigitNonZero;

    static {
        new Regex$();
    }

    public Regex between(char minChar, char maxChar) {
        return new Regex.Between(minChar, maxChar);
    }

    public Regex filter(Function1<Object, Object> f) {
        return new Regex.CharacterSet((Set<Object>)((TraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('\u0000')).to((Object)BoxesRunTime.boxToCharacter((char)'\uffff')).filter(f)).toSet());
    }

    public Regex literal(String str) {
        return new Regex.Literal(str);
    }

    public Regex oneOf(Seq<Object> chars) {
        return new Regex.CharacterSet((Set<Object>)chars.toSet());
    }

    public Regex digit() {
        return this.digit;
    }

    public Regex digitNonZero() {
        return this.digitNonZero;
    }

    public Regex letter() {
        return this.letter;
    }

    public Regex digitOrLetter() {
        return this.digitOrLetter;
    }

    public Regex hexDigit() {
        return this.hexDigit;
    }

    public Regex hexDigitNonZero() {
        return this.hexDigitNonZero;
    }

    private String escapeChar(char ch) {
        switch (ch) {
            case '.': {
                return "\\.";
            }
            case '^': {
                return "\\^";
            }
            case '$': {
                return "\\$";
            }
            case '|': {
                return "\\|";
            }
            case '*': {
                return "\\*";
            }
            case '+': {
                return "\\+";
            }
            case '?': {
                return "\\?";
            }
            case '(': {
                return "\\(";
            }
            case ')': {
                return "\\)";
            }
            case '[': {
                return "\\[";
            }
            case ']': {
                return "\\]";
            }
            case '{': {
                return "\\{";
            }
            case '}': {
                return "\\}";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.toString(ch);
    }

    public String toRegexString(Regex regex) {
        return this.loop$1(regex);
    }

    private final String loop$1(Regex regex) {
        boolean bl = false;
        Regex.CharacterSet characterSet = null;
        boolean bl2 = false;
        Regex.Repeat repeat = null;
        if (regex instanceof Regex.CharacterSet) {
            bl = true;
            characterSet = (Regex.CharacterSet)regex;
            Set<Object> elem = characterSet.set();
            if (elem.size() == 1) {
                return this.escapeChar(BoxesRunTime.unboxToChar((Object)elem.head()));
            }
        }
        if (bl) {
            return ((TraversableOnce)((List)characterSet.set().toList().sorted((Ordering)Ordering.Char$.MODULE$)).map((Function1 & Serializable & scala.Serializable)ch -> Regex$.MODULE$.escapeChar(BoxesRunTime.unboxToChar((Object)ch)), List$.MODULE$.canBuildFrom())).mkString("[", "", "]");
        }
        if (regex instanceof Regex.Literal) {
            String str = ((Regex.Literal)regex).str();
            String escaped = (String)new StringOps(Predef$.MODULE$.augmentString(str)).flatMap((Function1 & Serializable & scala.Serializable)ch -> new StringOps(Predef$.MODULE$.augmentString(Regex$.MODULE$.escapeChar(BoxesRunTime.unboxToChar((Object)ch)))), Predef$.MODULE$.StringCanBuildFrom());
            return new StringBuilder(2).append("(").append(escaped).append(")").toString();
        }
        if (regex instanceof Regex.Between) {
            Regex.Between between = (Regex.Between)regex;
            char start = between.start();
            char end = between.end();
            String escapedStart = this.escapeChar(start);
            String escapedEnd = this.escapeChar(end);
            return new StringBuilder(3).append("[").append(escapedStart).append("-").append(escapedEnd).append("]").toString();
        }
        if (regex instanceof Regex.Repeat) {
            int n;
            bl2 = true;
            repeat = (Regex.Repeat)regex;
            Regex regex2 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option2 = repeat.max();
            if (option instanceof Some && 0 == (n = BoxesRunTime.unboxToInt((Object)((Some)option).value())) && None$.MODULE$.equals(option2)) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex2)).append(")*").toString();
            }
        }
        if (bl2) {
            int n;
            Regex regex3 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option3 = repeat.max();
            if (option instanceof Some && 1 == (n = BoxesRunTime.unboxToInt((Object)((Some)option).value())) && None$.MODULE$.equals(option3)) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex3)).append(")+").toString();
            }
        }
        if (bl2) {
            int n;
            Regex regex4 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option4 = repeat.max();
            if (None$.MODULE$.equals(option) && option4 instanceof Some && 1 == (n = BoxesRunTime.unboxToInt((Object)((Some)option4).value()))) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex4)).append(")?").toString();
            }
        }
        if (bl2) {
            Regex regex5 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option5 = repeat.max();
            if (option instanceof Some) {
                int m;
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option5 instanceof Some && n == (m = BoxesRunTime.unboxToInt((Object)((Some)option5).value()))) {
                    return new StringBuilder(4).append("(").append(this.loop$1(regex5)).append("){").append(n).append("}").toString();
                }
            }
        }
        if (bl2) {
            Regex regex6 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option6 = repeat.max();
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (None$.MODULE$.equals(option6)) {
                    return new StringBuilder(5).append("(").append(this.loop$1(regex6)).append("){").append(n).append(",}").toString();
                }
            }
        }
        if (bl2) {
            Regex regex7 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option7 = repeat.max();
            if (None$.MODULE$.equals(option) && option7 instanceof Some) {
                int m = BoxesRunTime.unboxToInt((Object)((Some)option7).value());
                return new StringBuilder(6).append("(").append(this.loop$1(regex7)).append("){0,").append(m).append("}").toString();
            }
        }
        if (bl2) {
            Regex regex8 = repeat.regex();
            Option<Object> option = repeat.min();
            Option<Object> option8 = repeat.max();
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option8 instanceof Some) {
                    int m = BoxesRunTime.unboxToInt((Object)((Some)option8).value());
                    return new StringBuilder(5).append("(").append(this.loop$1(regex8)).append("){").append(n).append(",").append(m).append("}").toString();
                }
            }
        }
        if (bl2) {
            Option<Object> option = repeat.min();
            Option<Object> option9 = repeat.max();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option9)) {
                throw new IllegalArgumentException("Cannot have no repeat count");
            }
        }
        if (Regex$Empty$.MODULE$.equals(regex)) {
            return "";
        }
        if (regex instanceof Regex.Alternate) {
            Regex.Alternate alternate = (Regex.Alternate)regex;
            Regex left = alternate.left();
            Regex right = alternate.right();
            return new StringBuilder(7).append("((").append(this.loop$1(left)).append(")|(").append(this.loop$1(right)).append("))").toString();
        }
        if (Regex$Letter$.MODULE$.equals(regex)) {
            return "[a-zA-Z]";
        }
        if (Regex$Digit$.MODULE$.equals(regex)) {
            return "\\d";
        }
        if (regex instanceof Regex.Sequence) {
            Regex.Sequence sequence = (Regex.Sequence)regex;
            Regex first = sequence.first();
            Regex second = sequence.second();
            return new StringBuilder(0).append(this.loop$1(first)).append(this.loop$1(second)).toString();
        }
        throw new MatchError((Object)regex);
    }

    private Regex$() {
        MODULE$ = this;
        this.digit = Regex$Digit$.MODULE$;
        this.digitNonZero = this.between('1', '9');
        this.letter = Regex$Letter$.MODULE$;
        this.digitOrLetter = this.digit().$bar(this.letter());
        this.hexDigit = Regex$Digit$.MODULE$.$bar(this.between('a', 'f')).$bar(this.between('A', 'F'));
        this.hexDigitNonZero = this.digitNonZero().$bar(this.between('a', 'f')).$bar(this.between('A', 'F'));
    }
}

