/*
 * Decompiled with CFR 0.152.
 */
package zio.schema;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Currency;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.schema.Differ;
import zio.schema.Differ$LCSDiff$;
import zio.schema.DynamicValue;
import zio.schema.Fallback;
import zio.schema.Patch;
import zio.schema.Patch$;
import zio.schema.ProductDiffer$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.StandardType$BigDecimalType$;
import zio.schema.StandardType$BigIntegerType$;
import zio.schema.StandardType$BinaryType$;
import zio.schema.StandardType$BoolType$;
import zio.schema.StandardType$ByteType$;
import zio.schema.StandardType$CharType$;
import zio.schema.StandardType$CurrencyType$;
import zio.schema.StandardType$DayOfWeekType$;
import zio.schema.StandardType$DoubleType$;
import zio.schema.StandardType$DurationType$;
import zio.schema.StandardType$FloatType$;
import zio.schema.StandardType$InstantType$;
import zio.schema.StandardType$IntType$;
import zio.schema.StandardType$LocalDateTimeType$;
import zio.schema.StandardType$LocalDateType$;
import zio.schema.StandardType$LocalTimeType$;
import zio.schema.StandardType$LongType$;
import zio.schema.StandardType$MonthDayType$;
import zio.schema.StandardType$MonthType$;
import zio.schema.StandardType$OffsetDateTimeType$;
import zio.schema.StandardType$OffsetTimeType$;
import zio.schema.StandardType$PeriodType$;
import zio.schema.StandardType$ShortType$;
import zio.schema.StandardType$StringType$;
import zio.schema.StandardType$UUIDType$;
import zio.schema.StandardType$UnitType$;
import zio.schema.StandardType$YearMonthType$;
import zio.schema.StandardType$YearType$;
import zio.schema.StandardType$ZoneIdType$;
import zio.schema.StandardType$ZoneOffsetType$;
import zio.schema.StandardType$ZonedDateTimeType$;

public final class Differ$ {
    public static Differ$ MODULE$;
    private final Differ<Period> period;
    private final Differ<Year> year;
    private final Differ<YearMonth> yearMonth;
    private final Differ<ZoneOffset> zoneOffset;
    private final Differ<DayOfWeek> dayOfWeek;
    private final Differ<Month> month;
    private final Differ<MonthDay> monthDay;
    private final Differ<BigInteger> bigInt;
    private final Differ<BigDecimal> bigDecimal;
    private final Differ<Currency> currency;
    private final Differ<String> string;

    static {
        new Differ$();
    }

    /*
     * WARNING - void declaration
     */
    public <A> Differ<A> fromSchema(Schema<A> schema) {
        while (true) {
            StandardType standardType;
            StandardType standardType2;
            StandardType standardType3;
            StandardType standardType4;
            StandardType standardType5;
            StandardType standardType6;
            StandardType standardType7;
            StandardType standardType8;
            StandardType standardType9;
            StandardType standardType10;
            StandardType standardType11;
            StandardType standardType12;
            StandardType standardType13;
            StandardType standardType14;
            StandardType standardType15;
            StandardType standardType16;
            StandardType standardType17;
            StandardType standardType18;
            StandardType standardType19;
            StandardType standardType20;
            StandardType standardType21;
            StandardType standardType22;
            StandardType standardType23;
            StandardType standardType24;
            StandardType standardType25;
            StandardType standardType26;
            StandardType standardType27;
            StandardType standardType28;
            StandardType standardType29;
            StandardType standardType30;
            boolean bl = false;
            Schema.Primitive primitive = null;
            if (schema instanceof Schema.Primitive) {
                bl = true;
                primitive = (Schema.Primitive)schema;
                StandardType standardType31 = primitive.standardType();
                if (StandardType$UnitType$.MODULE$.equals(standardType31)) {
                    return this.unit();
                }
            }
            if (bl && StandardType$BinaryType$.MODULE$.equals(standardType30 = primitive.standardType())) {
                return this.binary();
            }
            if (bl && StandardType$IntType$.MODULE$.equals(standardType29 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.IntIsIntegral$.MODULE$);
            }
            if (bl && StandardType$ByteType$.MODULE$.equals(standardType28 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.ByteIsIntegral$.MODULE$);
            }
            if (bl && StandardType$ShortType$.MODULE$.equals(standardType27 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.ShortIsIntegral$.MODULE$);
            }
            if (bl && StandardType$DoubleType$.MODULE$.equals(standardType26 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.DoubleIsFractional$.MODULE$);
            }
            if (bl && StandardType$FloatType$.MODULE$.equals(standardType25 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.FloatIsFractional$.MODULE$);
            }
            if (bl && StandardType$LongType$.MODULE$.equals(standardType24 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.LongIsIntegral$.MODULE$);
            }
            if (bl && StandardType$CharType$.MODULE$.equals(standardType23 = primitive.standardType())) {
                return this.numeric((Numeric<A>)Numeric.CharIsIntegral$.MODULE$);
            }
            if (bl && StandardType$BoolType$.MODULE$.equals(standardType22 = primitive.standardType())) {
                return this.bool();
            }
            if (bl && StandardType$BigDecimalType$.MODULE$.equals(standardType21 = primitive.standardType())) {
                return this.bigDecimal();
            }
            if (bl && StandardType$BigIntegerType$.MODULE$.equals(standardType20 = primitive.standardType())) {
                return this.bigInt();
            }
            if (bl && StandardType$StringType$.MODULE$.equals(standardType19 = primitive.standardType())) {
                return this.string();
            }
            if (bl && StandardType$UUIDType$.MODULE$.equals(standardType18 = primitive.standardType())) {
                return this.string().transformOrFail((Function1 & Serializable & scala.Serializable)uuid -> package$.MODULE$.Right().apply((Object)uuid.toString()), (Function1 & Serializable & scala.Serializable)s -> {
                    try {
                        return package$.MODULE$.Right().apply((Object)UUID.fromString(s));
                    }
                    catch (Throwable e) {
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(22).append((String)s).append(" is not a valid UUID: ").append(e.getMessage()).toString());
                    }
                });
            }
            if (bl && StandardType$ZoneIdType$.MODULE$.equals(standardType17 = primitive.standardType())) {
                return this.string().transformOrFail((Function1 & Serializable & scala.Serializable)zoneId -> package$.MODULE$.Right().apply((Object)zoneId.getId()), (Function1 & Serializable & scala.Serializable)s -> {
                    try {
                        return package$.MODULE$.Right().apply((Object)ZoneId.of(s));
                    }
                    catch (Throwable e) {
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(24).append((String)s).append(" is not a valid ZoneId: ").append(e.getMessage()).toString());
                    }
                });
            }
            if (bl && StandardType$DayOfWeekType$.MODULE$.equals(standardType16 = primitive.standardType())) {
                return this.dayOfWeek();
            }
            if (bl && StandardType$PeriodType$.MODULE$.equals(standardType15 = primitive.standardType())) {
                return this.period();
            }
            if (bl && StandardType$MonthType$.MODULE$.equals(standardType14 = primitive.standardType())) {
                return this.month();
            }
            if (bl && StandardType$MonthDayType$.MODULE$.equals(standardType13 = primitive.standardType())) {
                return this.monthDay();
            }
            if (bl && StandardType$YearType$.MODULE$.equals(standardType12 = primitive.standardType())) {
                return this.year();
            }
            if (bl && StandardType$YearMonthType$.MODULE$.equals(standardType11 = primitive.standardType())) {
                return this.yearMonth();
            }
            if (bl && StandardType$LocalDateType$.MODULE$.equals(standardType10 = primitive.standardType())) {
                return this.localDate();
            }
            if (bl && StandardType$InstantType$.MODULE$.equals(standardType9 = primitive.standardType())) {
                return this.instant();
            }
            if (bl && StandardType$DurationType$.MODULE$.equals(standardType8 = primitive.standardType())) {
                return this.duration();
            }
            if (bl && StandardType$LocalTimeType$.MODULE$.equals(standardType7 = primitive.standardType())) {
                return this.localTime();
            }
            if (bl && StandardType$LocalDateTimeType$.MODULE$.equals(standardType6 = primitive.standardType())) {
                return this.localDateTime();
            }
            if (bl && StandardType$OffsetTimeType$.MODULE$.equals(standardType5 = primitive.standardType())) {
                return this.offsetTime();
            }
            if (bl && StandardType$OffsetDateTimeType$.MODULE$.equals(standardType4 = primitive.standardType())) {
                return this.offsetDateTime();
            }
            if (bl && StandardType$ZonedDateTimeType$.MODULE$.equals(standardType3 = primitive.standardType())) {
                return this.zonedDateTime();
            }
            if (bl && StandardType$ZoneOffsetType$.MODULE$.equals(standardType2 = primitive.standardType())) {
                return this.zoneOffset();
            }
            if (bl && StandardType$CurrencyType$.MODULE$.equals(standardType = primitive.standardType())) {
                return this.string().transformOrFail((Function1 & Serializable & scala.Serializable)currency -> package$.MODULE$.Right().apply((Object)currency.toString()), (Function1 & Serializable & scala.Serializable)s -> {
                    try {
                        return package$.MODULE$.Right().apply((Object)Currency.getInstance(s));
                    }
                    catch (Throwable e) {
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(26).append((String)s).append(" is not a valid Currency: ").append(e.getMessage()).toString());
                    }
                });
            }
            if (schema instanceof Schema.Tuple2) {
                Schema.Tuple2 tuple2 = (Schema.Tuple2)schema;
                Schema leftSchema = tuple2.left();
                Schema rightSchema = tuple2.right();
                return this.fromSchema(leftSchema).$less$times$greater(this.fromSchema(rightSchema));
            }
            if (schema instanceof Schema.Optional) {
                Schema schema2 = ((Schema.Optional)schema).schema();
                return this.fromSchema(schema2).optional();
            }
            if (schema instanceof Schema.Sequence) {
                Schema.Sequence sequence = (Schema.Sequence)schema;
                Schema schema3 = sequence.elementSchema();
                Function1 g = sequence.fromChunk();
                Function1 f = sequence.toChunk();
                return this.fromSchema(schema3).chunk().transform(f, g);
            }
            if (schema instanceof Schema.NonEmptySequence) {
                Schema.NonEmptySequence nonEmptySequence = (Schema.NonEmptySequence)schema;
                Schema schema4 = nonEmptySequence.elementSchema();
                Function1 f = nonEmptySequence.toChunk();
                return this.fromSchema(schema4).chunk().transform(f, nonEmptySequence.fromChunk());
            }
            if (schema instanceof Schema.Set) {
                Schema s2 = ((Schema.Set)schema).elementSchema();
                return this.set(s2);
            }
            if (schema instanceof Schema.Map) {
                Schema.Map map2 = (Schema.Map)schema;
                Schema k = map2.keySchema();
                Schema v = map2.valueSchema();
                return this.map(k, v);
            }
            if (schema instanceof Schema.NonEmptyMap) {
                Schema.NonEmptyMap nonEmptyMap = (Schema.NonEmptyMap)schema;
                Schema k = nonEmptyMap.keySchema();
                Schema v = nonEmptyMap.valueSchema();
                if (k != null && v != null) {
                    return this.map(k, v).transform((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toMap(), (Function1 & Serializable & scala.Serializable)map -> nonEmptyMap.fromMap(map));
                }
            }
            if (schema instanceof Schema.Either) {
                Schema.Either either2 = (Schema.Either)schema;
                Schema leftSchema = either2.left();
                Schema rightSchema = either2.right();
                return this.either(this.fromSchema(leftSchema), this.fromSchema(rightSchema));
            }
            if (schema instanceof Schema.Fallback) {
                Schema.Fallback fallback2 = (Schema.Fallback)schema;
                Schema leftSchema = fallback2.left();
                Schema rightSchema = fallback2.right();
                return this.fallback(this.fromSchema(leftSchema), this.fromSchema(rightSchema));
            }
            if (!(schema instanceof Schema.Lazy)) break;
            schema = ((Schema.Lazy)schema).schema();
        }
        if (schema instanceof Schema.Transform) {
            Schema.Transform transform2 = (Schema.Transform)schema;
            Schema schema5 = transform2.schema();
            Function1 g = transform2.f();
            Function1 f = transform2.g();
            return this.fromSchema(schema5).transformOrFail(f, g);
        }
        if (schema instanceof Schema.Fail) {
            return this.fail();
        }
        if (schema instanceof Schema.GenericRecord) {
            Schema.GenericRecord genericRecord = (Schema.GenericRecord)schema;
            return this.record(genericRecord);
        }
        if (schema instanceof Schema.CaseClass0) {
            Schema.CaseClass0 caseClass0 = (Schema.CaseClass0)schema;
            return ProductDiffer$.MODULE$.product0(caseClass0);
        }
        if (schema instanceof Schema.CaseClass1) {
            Schema.CaseClass1 caseClass1 = (Schema.CaseClass1)schema;
            return ProductDiffer$.MODULE$.product1(caseClass1);
        }
        if (schema instanceof Schema.CaseClass2) {
            Schema.CaseClass2 caseClass2 = (Schema.CaseClass2)schema;
            return ProductDiffer$.MODULE$.product2(caseClass2);
        }
        if (schema instanceof Schema.CaseClass3) {
            Schema.CaseClass3 caseClass3 = (Schema.CaseClass3)schema;
            return ProductDiffer$.MODULE$.product3(caseClass3);
        }
        if (schema instanceof Schema.CaseClass4) {
            Schema.CaseClass4 caseClass4 = (Schema.CaseClass4)schema;
            return ProductDiffer$.MODULE$.product4(caseClass4);
        }
        if (schema instanceof Schema.CaseClass5) {
            Schema.CaseClass5 caseClass5 = (Schema.CaseClass5)schema;
            return ProductDiffer$.MODULE$.product5(caseClass5);
        }
        if (schema instanceof Schema.CaseClass6) {
            Schema.CaseClass6 caseClass6 = (Schema.CaseClass6)schema;
            return ProductDiffer$.MODULE$.product6(caseClass6);
        }
        if (schema instanceof Schema.CaseClass7) {
            Schema.CaseClass7 caseClass7 = (Schema.CaseClass7)schema;
            return ProductDiffer$.MODULE$.product7(caseClass7);
        }
        if (schema instanceof Schema.CaseClass8) {
            Schema.CaseClass8 caseClass8 = (Schema.CaseClass8)schema;
            return ProductDiffer$.MODULE$.product8(caseClass8);
        }
        if (schema instanceof Schema.CaseClass9) {
            Schema.CaseClass9 caseClass9 = (Schema.CaseClass9)schema;
            return ProductDiffer$.MODULE$.product9(caseClass9);
        }
        if (schema instanceof Schema.CaseClass10) {
            Schema.CaseClass10 caseClass10 = (Schema.CaseClass10)schema;
            return ProductDiffer$.MODULE$.product10(caseClass10);
        }
        if (schema instanceof Schema.CaseClass11) {
            Schema.CaseClass11 caseClass11 = (Schema.CaseClass11)schema;
            return ProductDiffer$.MODULE$.product11(caseClass11);
        }
        if (schema instanceof Schema.CaseClass12) {
            Schema.CaseClass12 caseClass12 = (Schema.CaseClass12)schema;
            return ProductDiffer$.MODULE$.product12(caseClass12);
        }
        if (schema instanceof Schema.CaseClass13) {
            Schema.CaseClass13 caseClass13 = (Schema.CaseClass13)schema;
            return ProductDiffer$.MODULE$.product13(caseClass13);
        }
        if (schema instanceof Schema.CaseClass14) {
            Schema.CaseClass14 caseClass14 = (Schema.CaseClass14)schema;
            return ProductDiffer$.MODULE$.product14(caseClass14);
        }
        if (schema instanceof Schema.CaseClass15) {
            Schema.CaseClass15 caseClass15 = (Schema.CaseClass15)schema;
            return ProductDiffer$.MODULE$.product15(caseClass15);
        }
        if (schema instanceof Schema.CaseClass16) {
            Schema.CaseClass16 caseClass16 = (Schema.CaseClass16)schema;
            return ProductDiffer$.MODULE$.product16(caseClass16);
        }
        if (schema instanceof Schema.CaseClass17) {
            Schema.CaseClass17 caseClass17 = (Schema.CaseClass17)schema;
            return ProductDiffer$.MODULE$.product17(caseClass17);
        }
        if (schema instanceof Schema.CaseClass18) {
            Schema.CaseClass18 caseClass18 = (Schema.CaseClass18)schema;
            return ProductDiffer$.MODULE$.product18(caseClass18);
        }
        if (schema instanceof Schema.CaseClass19) {
            Schema.CaseClass19 caseClass19 = (Schema.CaseClass19)schema;
            return ProductDiffer$.MODULE$.product19(caseClass19);
        }
        if (schema instanceof Schema.CaseClass20) {
            Schema.CaseClass20 caseClass20 = (Schema.CaseClass20)schema;
            return ProductDiffer$.MODULE$.product20(caseClass20);
        }
        if (schema instanceof Schema.CaseClass21) {
            Schema.CaseClass21 caseClass21 = (Schema.CaseClass21)schema;
            return ProductDiffer$.MODULE$.product21(caseClass21);
        }
        if (schema instanceof Schema.CaseClass22) {
            Schema.CaseClass22 caseClass22 = (Schema.CaseClass22)schema;
            return ProductDiffer$.MODULE$.product22(caseClass22);
        }
        if (schema instanceof Schema.Enum1) {
            Schema.Case c = ((Schema.Enum1)schema).case1();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c}));
        }
        if (schema instanceof Schema.Enum2) {
            Schema.Enum2 enum2 = (Schema.Enum2)schema;
            Schema.Case c1 = enum2.case1();
            Schema.Case c2 = enum2.case2();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2}));
        }
        if (schema instanceof Schema.Enum3) {
            Schema.Enum3 enum3 = (Schema.Enum3)schema;
            Schema.Case c1 = enum3.case1();
            Schema.Case c2 = enum3.case2();
            Schema.Case c3 = enum3.case3();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3}));
        }
        if (schema instanceof Schema.Enum4) {
            Schema.Enum4 enum4 = (Schema.Enum4)schema;
            Schema.Case c1 = enum4.case1();
            Schema.Case c2 = enum4.case2();
            Schema.Case c3 = enum4.case3();
            Schema.Case c4 = enum4.case4();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4}));
        }
        if (schema instanceof Schema.Enum5) {
            Schema.Enum5 enum5 = (Schema.Enum5)schema;
            Schema.Case c1 = enum5.case1();
            Schema.Case c2 = enum5.case2();
            Schema.Case c3 = enum5.case3();
            Schema.Case c4 = enum5.case4();
            Schema.Case c5 = enum5.case5();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5}));
        }
        if (schema instanceof Schema.Enum6) {
            Schema.Enum6 enum6 = (Schema.Enum6)schema;
            Schema.Case c1 = enum6.case1();
            Schema.Case c2 = enum6.case2();
            Schema.Case c3 = enum6.case3();
            Schema.Case c4 = enum6.case4();
            Schema.Case c5 = enum6.case5();
            Schema.Case c6 = enum6.case6();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6}));
        }
        if (schema instanceof Schema.Enum7) {
            Schema.Enum7 enum7 = (Schema.Enum7)schema;
            Schema.Case c1 = enum7.case1();
            Schema.Case c2 = enum7.case2();
            Schema.Case c3 = enum7.case3();
            Schema.Case c4 = enum7.case4();
            Schema.Case c5 = enum7.case5();
            Schema.Case c6 = enum7.case6();
            Schema.Case c7 = enum7.case7();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7}));
        }
        if (schema instanceof Schema.Enum8) {
            Schema.Enum8 enum8 = (Schema.Enum8)schema;
            Schema.Case c1 = enum8.case1();
            Schema.Case c2 = enum8.case2();
            Schema.Case c3 = enum8.case3();
            Schema.Case c4 = enum8.case4();
            Schema.Case c5 = enum8.case5();
            Schema.Case c6 = enum8.case6();
            Schema.Case c7 = enum8.case7();
            Schema.Case c8 = enum8.case8();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8}));
        }
        if (schema instanceof Schema.Enum9) {
            Schema.Enum9 enum9 = (Schema.Enum9)schema;
            Schema.Case c1 = enum9.case1();
            Schema.Case c2 = enum9.case2();
            Schema.Case c3 = enum9.case3();
            Schema.Case c4 = enum9.case4();
            Schema.Case c5 = enum9.case5();
            Schema.Case c6 = enum9.case6();
            Schema.Case c7 = enum9.case7();
            Schema.Case c8 = enum9.case8();
            Schema.Case c9 = enum9.case9();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9}));
        }
        if (schema instanceof Schema.Enum10) {
            Schema.Enum10 enum10 = (Schema.Enum10)schema;
            Schema.Case c1 = enum10.case1();
            Schema.Case c2 = enum10.case2();
            Schema.Case c3 = enum10.case3();
            Schema.Case c4 = enum10.case4();
            Schema.Case c5 = enum10.case5();
            Schema.Case c6 = enum10.case6();
            Schema.Case c7 = enum10.case7();
            Schema.Case c8 = enum10.case8();
            Schema.Case c9 = enum10.case9();
            Schema.Case c10 = enum10.case10();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10}));
        }
        if (schema instanceof Schema.Enum11) {
            Schema.Enum11 enum11 = (Schema.Enum11)schema;
            Schema.Case c1 = enum11.case1();
            Schema.Case c2 = enum11.case2();
            Schema.Case c3 = enum11.case3();
            Schema.Case c4 = enum11.case4();
            Schema.Case c5 = enum11.case5();
            Schema.Case c6 = enum11.case6();
            Schema.Case c7 = enum11.case7();
            Schema.Case c8 = enum11.case8();
            Schema.Case c9 = enum11.case9();
            Schema.Case c10 = enum11.case10();
            Schema.Case c11 = enum11.case11();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11}));
        }
        if (schema instanceof Schema.Enum12) {
            Schema.Enum12 enum12 = (Schema.Enum12)schema;
            Schema.Case c1 = enum12.case1();
            Schema.Case c2 = enum12.case2();
            Schema.Case c3 = enum12.case3();
            Schema.Case c4 = enum12.case4();
            Schema.Case c5 = enum12.case5();
            Schema.Case c6 = enum12.case6();
            Schema.Case c7 = enum12.case7();
            Schema.Case c8 = enum12.case8();
            Schema.Case c9 = enum12.case9();
            Schema.Case c10 = enum12.case10();
            Schema.Case c11 = enum12.case11();
            Schema.Case c12 = enum12.case12();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12}));
        }
        if (schema instanceof Schema.Enum13) {
            Schema.Enum13 enum13 = (Schema.Enum13)schema;
            Schema.Case c1 = enum13.case1();
            Schema.Case c2 = enum13.case2();
            Schema.Case c3 = enum13.case3();
            Schema.Case c4 = enum13.case4();
            Schema.Case c5 = enum13.case5();
            Schema.Case c6 = enum13.case6();
            Schema.Case c7 = enum13.case7();
            Schema.Case c8 = enum13.case8();
            Schema.Case c9 = enum13.case9();
            Schema.Case c10 = enum13.case10();
            Schema.Case c11 = enum13.case11();
            Schema.Case c12 = enum13.case12();
            Schema.Case c13 = enum13.case13();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13}));
        }
        if (schema instanceof Schema.Enum14) {
            Schema.Enum14 enum14 = (Schema.Enum14)schema;
            Schema.Case c1 = enum14.case1();
            Schema.Case c2 = enum14.case2();
            Schema.Case c3 = enum14.case3();
            Schema.Case c4 = enum14.case4();
            Schema.Case c5 = enum14.case5();
            Schema.Case c6 = enum14.case6();
            Schema.Case c7 = enum14.case7();
            Schema.Case c8 = enum14.case8();
            Schema.Case c9 = enum14.case9();
            Schema.Case c10 = enum14.case10();
            Schema.Case c11 = enum14.case11();
            Schema.Case c12 = enum14.case12();
            Schema.Case c13 = enum14.case13();
            Schema.Case c14 = enum14.case14();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14}));
        }
        if (schema instanceof Schema.Enum15) {
            Schema.Enum15 enum15 = (Schema.Enum15)schema;
            Schema.Case c1 = enum15.case1();
            Schema.Case c2 = enum15.case2();
            Schema.Case c3 = enum15.case3();
            Schema.Case c4 = enum15.case4();
            Schema.Case c5 = enum15.case5();
            Schema.Case c6 = enum15.case6();
            Schema.Case c7 = enum15.case7();
            Schema.Case c8 = enum15.case8();
            Schema.Case c9 = enum15.case9();
            Schema.Case c10 = enum15.case10();
            Schema.Case c11 = enum15.case11();
            Schema.Case c12 = enum15.case12();
            Schema.Case c13 = enum15.case13();
            Schema.Case c14 = enum15.case14();
            Schema.Case c15 = enum15.case15();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15}));
        }
        if (schema instanceof Schema.Enum16) {
            Schema.Enum16 enum16 = (Schema.Enum16)schema;
            Schema.Case c1 = enum16.case1();
            Schema.Case c2 = enum16.case2();
            Schema.Case c3 = enum16.case3();
            Schema.Case c4 = enum16.case4();
            Schema.Case c5 = enum16.case5();
            Schema.Case c6 = enum16.case6();
            Schema.Case c7 = enum16.case7();
            Schema.Case c8 = enum16.case8();
            Schema.Case c9 = enum16.case9();
            Schema.Case c10 = enum16.case10();
            Schema.Case c11 = enum16.case11();
            Schema.Case c12 = enum16.case12();
            Schema.Case c13 = enum16.case13();
            Schema.Case c14 = enum16.case14();
            Schema.Case c15 = enum16.case15();
            Schema.Case c16 = enum16.case16();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16}));
        }
        if (schema instanceof Schema.Enum17) {
            Schema.Enum17 enum17 = (Schema.Enum17)schema;
            Schema.Case c1 = enum17.case1();
            Schema.Case c2 = enum17.case2();
            Schema.Case c3 = enum17.case3();
            Schema.Case c4 = enum17.case4();
            Schema.Case c5 = enum17.case5();
            Schema.Case c6 = enum17.case6();
            Schema.Case c7 = enum17.case7();
            Schema.Case c8 = enum17.case8();
            Schema.Case c9 = enum17.case9();
            Schema.Case c10 = enum17.case10();
            Schema.Case c11 = enum17.case11();
            Schema.Case c12 = enum17.case12();
            Schema.Case c13 = enum17.case13();
            Schema.Case c14 = enum17.case14();
            Schema.Case c15 = enum17.case15();
            Schema.Case c16 = enum17.case16();
            Schema.Case c17 = enum17.case17();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17}));
        }
        if (schema instanceof Schema.Enum18) {
            void c18;
            void c17;
            void c16;
            void c15;
            void c14;
            void c13;
            void c12;
            void c11;
            void c10;
            void c9;
            void c8;
            void c7;
            void c6;
            void c5;
            void c4;
            void c3;
            void c2;
            void c1;
            Schema.Enum18 enum18 = (Schema.Enum18)schema;
            Schema.Case case_ = enum18.case1();
            Schema.Case case_2 = enum18.case2();
            Schema.Case case_3 = enum18.case3();
            Schema.Case case_4 = enum18.case4();
            Schema.Case case_5 = enum18.case5();
            Schema.Case case_6 = enum18.case6();
            Schema.Case case_7 = enum18.case7();
            Schema.Case case_8 = enum18.case8();
            Schema.Case case_9 = enum18.case9();
            Schema.Case case_10 = enum18.case10();
            Schema.Case case_11 = enum18.case11();
            Schema.Case case_12 = enum18.case12();
            Schema.Case case_13 = enum18.case13();
            Schema.Case case_14 = enum18.case14();
            Schema.Case case_15 = enum18.case15();
            Schema.Case case_16 = enum18.case16();
            Schema.Case case_17 = enum18.case17();
            Schema.Case case_18 = enum18.case18();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18}));
        }
        if (schema instanceof Schema.Enum19) {
            void c19;
            void c18;
            void c17;
            void c16;
            void c15;
            void c14;
            void c13;
            void c12;
            void c11;
            void c10;
            void c9;
            void c8;
            void c7;
            void c6;
            void c5;
            void c4;
            void c3;
            void c2;
            void c1;
            Schema.Enum19 enum19 = (Schema.Enum19)schema;
            Schema.Case case_ = enum19.case1();
            Schema.Case case_19 = enum19.case2();
            Schema.Case case_20 = enum19.case3();
            Schema.Case case_21 = enum19.case4();
            Schema.Case case_22 = enum19.case5();
            Schema.Case case_23 = enum19.case6();
            Schema.Case case_24 = enum19.case7();
            Schema.Case case_25 = enum19.case8();
            Schema.Case case_26 = enum19.case9();
            Schema.Case case_27 = enum19.case10();
            Schema.Case case_28 = enum19.case11();
            Schema.Case case_29 = enum19.case12();
            Schema.Case case_30 = enum19.case13();
            Schema.Case case_31 = enum19.case14();
            Schema.Case case_32 = enum19.case15();
            Schema.Case case_33 = enum19.case16();
            Schema.Case case_34 = enum19.case17();
            Schema.Case case_35 = enum19.case18();
            Schema.Case case_36 = enum19.case19();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19}));
        }
        if (schema instanceof Schema.Enum20) {
            void c20;
            void c19;
            void c18;
            void c17;
            void c16;
            void c15;
            void c14;
            void c13;
            void c12;
            void c11;
            void c10;
            void c9;
            void c8;
            void c7;
            void c6;
            void c5;
            void c4;
            void c3;
            void c2;
            void c1;
            Schema.Enum20 enum20 = (Schema.Enum20)schema;
            Schema.Case case_ = enum20.case1();
            Schema.Case case_37 = enum20.case2();
            Schema.Case case_38 = enum20.case3();
            Schema.Case case_39 = enum20.case4();
            Schema.Case case_40 = enum20.case5();
            Schema.Case case_41 = enum20.case6();
            Schema.Case case_42 = enum20.case7();
            Schema.Case case_43 = enum20.case8();
            Schema.Case case_44 = enum20.case9();
            Schema.Case case_45 = enum20.case10();
            Schema.Case case_46 = enum20.case11();
            Schema.Case case_47 = enum20.case12();
            Schema.Case case_48 = enum20.case13();
            Schema.Case case_49 = enum20.case14();
            Schema.Case case_50 = enum20.case15();
            Schema.Case case_51 = enum20.case16();
            Schema.Case case_52 = enum20.case17();
            Schema.Case case_53 = enum20.case18();
            Schema.Case case_54 = enum20.case19();
            Schema.Case case_55 = enum20.case20();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20}));
        }
        if (schema instanceof Schema.Enum21) {
            void c21;
            void c20;
            void c19;
            void c18;
            void c17;
            void c16;
            void c15;
            void c14;
            void c13;
            void c12;
            void c11;
            void c10;
            void c9;
            void c8;
            void c7;
            void c6;
            void c5;
            void c4;
            void c3;
            void c2;
            void c1;
            Schema.Enum21 enum21 = (Schema.Enum21)schema;
            Schema.Case case_ = enum21.case1();
            Schema.Case case_56 = enum21.case2();
            Schema.Case case_57 = enum21.case3();
            Schema.Case case_58 = enum21.case4();
            Schema.Case case_59 = enum21.case5();
            Schema.Case case_60 = enum21.case6();
            Schema.Case case_61 = enum21.case7();
            Schema.Case case_62 = enum21.case8();
            Schema.Case case_63 = enum21.case9();
            Schema.Case case_64 = enum21.case10();
            Schema.Case case_65 = enum21.case11();
            Schema.Case case_66 = enum21.case12();
            Schema.Case case_67 = enum21.case13();
            Schema.Case case_68 = enum21.case14();
            Schema.Case case_69 = enum21.case15();
            Schema.Case case_70 = enum21.case16();
            Schema.Case case_71 = enum21.case17();
            Schema.Case case_72 = enum21.case18();
            Schema.Case case_73 = enum21.case19();
            Schema.Case case_74 = enum21.case20();
            Schema.Case case_75 = enum21.case21();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21}));
        }
        if (schema instanceof Schema.Enum22) {
            void c22;
            void c21;
            void c20;
            void c19;
            void c18;
            void c17;
            void c16;
            void c15;
            void c14;
            void c13;
            void c12;
            void c11;
            void c10;
            void c9;
            void c8;
            void c7;
            void c6;
            void c5;
            void c4;
            void c3;
            void c2;
            void c1;
            Schema.Enum22 enum22 = (Schema.Enum22)schema;
            Schema.Case case_ = enum22.case1();
            Schema.Case case_76 = enum22.case2();
            Schema.Case case_77 = enum22.case3();
            Schema.Case case_78 = enum22.case4();
            Schema.Case case_79 = enum22.case5();
            Schema.Case case_80 = enum22.case6();
            Schema.Case case_81 = enum22.case7();
            Schema.Case case_82 = enum22.case8();
            Schema.Case case_83 = enum22.case9();
            Schema.Case case_84 = enum22.case10();
            Schema.Case case_85 = enum22.case11();
            Schema.Case case_86 = enum22.case12();
            Schema.Case case_87 = enum22.case13();
            Schema.Case case_88 = enum22.case14();
            Schema.Case case_89 = enum22.case15();
            Schema.Case case_90 = enum22.case16();
            Schema.Case case_91 = enum22.case17();
            Schema.Case case_92 = enum22.case18();
            Schema.Case case_93 = enum22.case19();
            Schema.Case case_94 = enum22.case20();
            Schema.Case case_95 = enum22.case21();
            Schema.Case case_96 = enum22.case22();
            return this.enumN((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Case[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22}));
        }
        if (schema instanceof Schema.EnumN) {
            void cs;
            Object c = ((Schema.EnumN)schema).caseSet();
            return this.enumN(cs.toSeq());
        }
        if (schema instanceof Schema.Dynamic) {
            return this.dynamicValue();
        }
        throw new MatchError(schema);
    }

    public Differ<BoxedUnit> unit() {
        return new Differ<BoxedUnit>(){

            public <B> Differ<Tuple2<BoxedUnit, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<BoxedUnit, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, BoxedUnit> f, Function1<BoxedUnit, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, BoxedUnit>> f, Function1<BoxedUnit, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<BoxedUnit>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<BoxedUnit>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<BoxedUnit> apply(BoxedUnit thisValue, BoxedUnit thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$unit$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<Chunk<Object>> binary() {
        return Differ$LCSDiff$.MODULE$.apply();
    }

    public Differ<DynamicValue> dynamicValue() {
        return new Differ<DynamicValue>(){

            public <B> Differ<Tuple2<DynamicValue, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<DynamicValue, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, DynamicValue> f, Function1<DynamicValue, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, DynamicValue>> f, Function1<DynamicValue, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<DynamicValue>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<DynamicValue>> optional() {
                return Differ.optional$(this);
            }

            public Patch<DynamicValue> apply(DynamicValue thisValue, DynamicValue thatValue) {
                return Patch$.MODULE$.notComparable();
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<Object> bool() {
        return new Differ<Object>(){

            public <B> Differ<Tuple2<Object, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Object, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Object> f, Function1<Object, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Object>> f, Function1<Object, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Object>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Object>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Object> apply(boolean thisValue, boolean thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$bool$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public <K, V> Differ<Map<K, V>> map(Schema<K> keySchema, Schema<V> valueSchema) {
        return Differ$LCSDiff$.MODULE$.map();
    }

    public <A> Differ<Set<A>> set(Schema<A> schema) {
        return Differ$LCSDiff$.MODULE$.set();
    }

    public <A> Differ<A> numeric(Numeric<A> numeric2) {
        return new Differ<A>(numeric2){
            private final Numeric numeric$1;

            public <B> Differ<Tuple2<A, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<A, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, A> f, Function1<A, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, A>> f, Function1<A, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<A>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<A>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<A> apply(A thisValue, A thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$numeric$1(thisValue, thatValue, this.numeric$1);
            }
            {
                this.numeric$1 = numeric$1;
                Differ.$init$(this);
            }
        };
    }

    public Differ<Period> period() {
        return this.period;
    }

    public Differ<Year> year() {
        return this.year;
    }

    public Differ<YearMonth> yearMonth() {
        return this.yearMonth;
    }

    public Differ<LocalDate> localDate() {
        return new Differ<LocalDate>(){

            public <B> Differ<Tuple2<LocalDate, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<LocalDate, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, LocalDate> f, Function1<LocalDate, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, LocalDate>> f, Function1<LocalDate, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<LocalDate>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<LocalDate>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<LocalDate> apply(LocalDate thisValue, LocalDate thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$localDate$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<Instant> instant() {
        return new Differ<Instant>(){

            public <B> Differ<Tuple2<Instant, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Instant, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Instant> f, Function1<Instant, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Instant>> f, Function1<Instant, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Instant>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Instant>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Instant> apply(Instant thisValue, Instant thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$instant$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<Duration> duration() {
        return new Differ<Duration>(){

            public <B> Differ<Tuple2<Duration, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Duration, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Duration> f, Function1<Duration, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Duration>> f, Function1<Duration, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Duration>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Duration>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Duration> apply(Duration thisValue, Duration thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$duration$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<LocalTime> localTime() {
        return new Differ<LocalTime>(){

            public <B> Differ<Tuple2<LocalTime, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<LocalTime, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, LocalTime> f, Function1<LocalTime, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, LocalTime>> f, Function1<LocalTime, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<LocalTime>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<LocalTime>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<LocalTime> apply(LocalTime thisValue, LocalTime thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$localTime$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<LocalDateTime> localDateTime() {
        return new Differ<LocalDateTime>(){

            public <B> Differ<Tuple2<LocalDateTime, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<LocalDateTime, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, LocalDateTime> f, Function1<LocalDateTime, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, LocalDateTime>> f, Function1<LocalDateTime, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<LocalDateTime>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<LocalDateTime>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<LocalDateTime> apply(LocalDateTime thisValue, LocalDateTime thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$localDateTime$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<OffsetTime> offsetTime() {
        return new Differ<OffsetTime>(){

            public <B> Differ<Tuple2<OffsetTime, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<OffsetTime, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, OffsetTime> f, Function1<OffsetTime, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, OffsetTime>> f, Function1<OffsetTime, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<OffsetTime>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<OffsetTime>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<OffsetTime> apply(OffsetTime thisValue, OffsetTime thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$offsetTime$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<OffsetDateTime> offsetDateTime() {
        return new Differ<OffsetDateTime>(){

            public <B> Differ<Tuple2<OffsetDateTime, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<OffsetDateTime, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, OffsetDateTime> f, Function1<OffsetDateTime, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, OffsetDateTime>> f, Function1<OffsetDateTime, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<OffsetDateTime>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<OffsetDateTime>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<OffsetDateTime> apply(OffsetDateTime thisValue, OffsetDateTime thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$offsetDateTime$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<ZonedDateTime> zonedDateTime() {
        return new Differ<ZonedDateTime>(){

            public <B> Differ<Tuple2<ZonedDateTime, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<ZonedDateTime, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, ZonedDateTime> f, Function1<ZonedDateTime, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, ZonedDateTime>> f, Function1<ZonedDateTime, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<ZonedDateTime>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<ZonedDateTime>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<ZonedDateTime> apply(ZonedDateTime thisValue, ZonedDateTime thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$zonedDateTime$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<ZoneOffset> zoneOffset() {
        return this.zoneOffset;
    }

    public Differ<DayOfWeek> dayOfWeek() {
        return this.dayOfWeek;
    }

    public Differ<Month> month() {
        return this.month;
    }

    public Differ<MonthDay> monthDay() {
        return this.monthDay;
    }

    public Differ<BigInteger> bigInt() {
        return this.bigInt;
    }

    public Differ<BigDecimal> bigDecimal() {
        return this.bigDecimal;
    }

    public Differ<Currency> currency() {
        return this.currency;
    }

    public <A, B> Differ<Tuple2<A, B>> tuple(Differ<A> left, Differ<B> right) {
        return new Differ<Tuple2<A, B>>(left, right){
            private final Differ left$1;
            private final Differ right$1;

            public <B> Differ<Tuple2<Tuple2<A, B>, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Tuple2<A, B>, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Tuple2<A, B>> f, Function1<Tuple2<A, B>, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Tuple2<A, B>>> f, Function1<Tuple2<A, B>, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Tuple2<A, B>>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Tuple2<A, B>>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Tuple2<A, B>> apply(Tuple2<A, B> thisValue, Tuple2<A, B> thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$tuple$1(thisValue, thatValue, this.left$1, this.right$1);
            }
            {
                this.left$1 = left$1;
                this.right$1 = right$1;
                Differ.$init$(this);
            }
        };
    }

    public <A, B> Differ<Either<A, B>> either(Differ<A> left, Differ<B> right) {
        return this.instancePartial((PartialFunction<Tuple2<A, A>, Patch<A>>)new scala.Serializable(left, right){
            public static final long serialVersionUID = 0L;
            private final Differ left$2;
            private final Differ right$2;

            public final <A1 extends Tuple2<Either<A, B>, Either<A, B>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    Either either2 = (Either)x1._1();
                    Either either3 = (Either)x1._2();
                    if (either2 instanceof Left) {
                        Object l = ((Left)either2).value();
                        if (either3 instanceof Left) {
                            Object r = ((Left)either3).value();
                            return (B1)new Patch.EitherDiff<A, B>(package$.MODULE$.Left().apply(this.left$2.apply(l, r)));
                        }
                    }
                }
                if (x1 != null) {
                    Either either4 = (Either)x1._1();
                    Either either5 = (Either)x1._2();
                    if (either4 instanceof Right) {
                        Object l = ((Right)either4).value();
                        if (either5 instanceof Right) {
                            Object r = ((Right)either5).value();
                            return (B1)new Patch.EitherDiff<A, B>(package$.MODULE$.Right().apply(this.right$2.apply(l, r)));
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Either<A, B>, Either<A, B>> x1) {
                if (x1 != null) {
                    Either either2 = (Either)x1._1();
                    Either either3 = (Either)x1._2();
                    if (either2 instanceof Left && either3 instanceof Left) {
                        return true;
                    }
                }
                if (x1 != null) {
                    Either either4 = (Either)x1._1();
                    Either either5 = (Either)x1._2();
                    if (either4 instanceof Right && either5 instanceof Right) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.left$2 = left$2;
                this.right$2 = right$2;
            }
        });
    }

    public <A, B> Differ<Fallback<A, B>> fallback(Differ<A> left, Differ<B> right) {
        return this.instancePartial((PartialFunction<Tuple2<A, A>, Patch<A>>)new scala.Serializable(left, right){
            public static final long serialVersionUID = 0L;
            private final Differ left$3;
            private final Differ right$3;

            public final <A1 extends Tuple2<Fallback<A, B>, Fallback<A, B>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    Fallback fallback2 = (Fallback)x1._1();
                    Fallback fallback3 = (Fallback)x1._2();
                    if (fallback2 instanceof Fallback.Left) {
                        A l = ((Fallback.Left)fallback2).left();
                        if (fallback3 instanceof Fallback.Left) {
                            A r = ((Fallback.Left)fallback3).left();
                            return (B1)new Patch.Fallback<A, B>(new Fallback.Left<Patch<A>, Patch<B>>(this.left$3.apply(l, r)));
                        }
                    }
                }
                if (x1 != null) {
                    Fallback fallback4 = (Fallback)x1._1();
                    Fallback fallback5 = (Fallback)x1._2();
                    if (fallback4 instanceof Fallback.Right) {
                        B l = ((Fallback.Right)fallback4).right();
                        if (fallback5 instanceof Fallback.Right) {
                            B r = ((Fallback.Right)fallback5).right();
                            return (B1)new Patch.Fallback<A, B>(new Fallback.Right<Patch<A>, Patch<B>>(this.right$3.apply(l, r)));
                        }
                    }
                }
                if (x1 != null) {
                    Fallback fallback6 = (Fallback)x1._1();
                    Fallback fallback7 = (Fallback)x1._2();
                    if (fallback6 instanceof Fallback.Both) {
                        Fallback.Both both = (Fallback.Both)fallback6;
                        A l1 = both.left();
                        B r1 = both.right();
                        if (fallback7 instanceof Fallback.Both) {
                            Fallback.Both both2 = (Fallback.Both)fallback7;
                            A l2 = both2.left();
                            B r2 = both2.right();
                            return (B1)new Patch.Fallback<A, B>(new Fallback.Both<Patch<A>, Patch<B>>(this.left$3.apply(l1, l2), this.right$3.apply(r1, r2)));
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Fallback<A, B>, Fallback<A, B>> x1) {
                if (x1 != null) {
                    Fallback fallback2 = (Fallback)x1._1();
                    Fallback fallback3 = (Fallback)x1._2();
                    if (fallback2 instanceof Fallback.Left && fallback3 instanceof Fallback.Left) {
                        return true;
                    }
                }
                if (x1 != null) {
                    Fallback fallback4 = (Fallback)x1._1();
                    Fallback fallback5 = (Fallback)x1._2();
                    if (fallback4 instanceof Fallback.Right && fallback5 instanceof Fallback.Right) {
                        return true;
                    }
                }
                if (x1 != null) {
                    Fallback fallback6 = (Fallback)x1._1();
                    Fallback fallback7 = (Fallback)x1._2();
                    if (fallback6 instanceof Fallback.Both && fallback7 instanceof Fallback.Both) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.left$3 = left$3;
                this.right$3 = right$3;
            }
        });
    }

    public <A> Differ<A> identical() {
        return new Differ<A>(){

            public <B> Differ<Tuple2<A, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<A, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, A> f, Function1<A, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, A>> f, Function1<A, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<A>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<A>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<A> apply(A thisValue, A thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$identical$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public <A> Differ<A> fail() {
        return new Differ<A>(){

            public <B> Differ<Tuple2<A, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<A, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, A> f, Function1<A, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, A>> f, Function1<A, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<A>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<A>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<A> apply(A thisValue, A thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$fail$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
    }

    public Differ<ListMap<String, ?>> record(Schema.Record<ListMap<String, ?>> schema) {
        return new Differ<ListMap<String, ?>>(schema){
            private final Schema.Record schema$1;

            public <B> Differ<Tuple2<ListMap<String, ?>, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<ListMap<String, ?>, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, ListMap<String, ?>> f, Function1<ListMap<String, ?>, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, ListMap<String, ?>>> f, Function1<ListMap<String, ?>, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<ListMap<String, ?>>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<ListMap<String, ?>>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<ListMap<String, ?>> apply(ListMap<String, ?> thisValue, ListMap<String, ?> thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$record$1(thisValue, thatValue, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
                Differ.$init$(this);
            }
        };
    }

    private <Z> boolean conformsToStructure(ListMap<String, ?> map, Chunk<Schema.Field<Z, ?>> structure) {
        return BoxesRunTime.unboxToBoolean((Object)structure.foldRight((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Differ$.$anonfun$conformsToStructure$1(map, x0$1, BoxesRunTime.unboxToBoolean((Object)x1$1)))));
    }

    public <Z> Differ<Z> enumN(Seq<Schema.Case<Z, ?>> cases) {
        return new Differ<Z>(cases){
            private final Seq cases$1;

            public <B> Differ<Tuple2<Z, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Z, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Z> f, Function1<Z, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Z>> f, Function1<Z, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Z>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Z>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Z> apply(Z thisValue, Z thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$enumN$1(thisValue, thatValue, this.cases$1);
            }
            {
                this.cases$1 = cases$1;
                Differ.$init$(this);
            }
        };
    }

    public Differ<Tuple2<String, ?>> enumeration(ListMap<String, Schema<?>> structure) {
        return this.instancePartial((PartialFunction)new scala.Serializable(structure){
            public static final long serialVersionUID = 0L;
            private final ListMap structure$1;

            public final <A1 extends Tuple2<Tuple2<String, ?>, Tuple2<String, ?>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    Tuple2 tuple2 = (Tuple2)x1._1();
                    Tuple2 tuple22 = (Tuple2)x1._2();
                    if (tuple2 != null) {
                        String thisKey = (String)tuple2._1();
                        Object thisValue = tuple2._2();
                        if (tuple22 != null) {
                            String thatKey = (String)tuple22._1();
                            Object thatValue = tuple22._2();
                            String string = thisKey;
                            if (!(string != null ? !string.equals(thatKey) : thatKey != null)) {
                                return (B1)((Patch)this.structure$1.get((Object)thisKey).map((Function1 & Serializable & scala.Serializable)x$15 -> Differ$.MODULE$.fromSchema(x$15).apply(thisValue, thatValue)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Patch$.MODULE$.notComparable()));
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Tuple2<String, ?>, Tuple2<String, ?>> x1) {
                if (x1 != null) {
                    Tuple2 tuple2 = (Tuple2)x1._1();
                    Tuple2 tuple22 = (Tuple2)x1._2();
                    if (tuple2 != null) {
                        String thisKey = (String)tuple2._1();
                        if (tuple22 != null) {
                            String thatKey = (String)tuple22._1();
                            String string = thisKey;
                            if (!(string != null ? !string.equals(thatKey) : thatKey != null)) {
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
            {
                this.structure$1 = structure$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.lang.Object java.lang.Object zio.schema.Schema ), $anonfun$applyOrElse$6()}, serializedLambda);
            }
        });
    }

    public Differ<String> string() {
        return this.string;
    }

    public <A> Differ<A> instancePartial(PartialFunction<Tuple2<A, A>, Patch<A>> f) {
        return new Differ<A>(f){
            private final PartialFunction f$3;

            public <B> Differ<Tuple2<A, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<A, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, A> f, Function1<A, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, A>> f, Function1<A, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<A>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<A>> optional() {
                return Differ.optional$(this);
            }

            public Patch<A> apply(A thisValue, A thatValue) {
                return (Patch)this.f$3.applyOrElse((Object)new Tuple2(thisValue, thatValue), (Function1 & Serializable & scala.Serializable)x$16 -> Patch$.MODULE$.notComparable());
            }
            {
                this.f$3 = f$3;
                Differ.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$unit$1(BoxedUnit x$7, BoxedUnit x$8) {
        return Patch$.MODULE$.identical();
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$bool$1(boolean thisBool, boolean thatBool) {
        if (thisBool ^ thatBool) {
            return new Patch.Bool(thisBool ^ thatBool);
        }
        return Patch$.MODULE$.identical();
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$numeric$1(Object thisValue, Object thatValue, Numeric numeric$1) {
        Object object = numeric$1.minus(thisValue, thatValue);
        if (BoxesRunTime.equals((Object)object, (Object)numeric$1.zero())) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Number<Object>(object, numeric$1);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$period$1(Period thisPeriod, Period thatPeriod) {
        Period period = thisPeriod;
        if (!(period != null ? !((Object)period).equals(thatPeriod) : thatPeriod != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<Period>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisPeriod.getDays() - thatPeriod.getDays(), thisPeriod.getMonths() - thatPeriod.getMonths(), thisPeriod.getYears() - thatPeriod.getYears()})), StandardType$PeriodType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$year$1(Year thisYear, Year thatYear) {
        Year year = thisYear;
        if (!(year != null ? !((Object)year).equals(thatYear) : thatYear != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<Year>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisYear.getValue() - thatYear.getValue()})), StandardType$YearType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$yearMonth$1(YearMonth thisYearMonth, YearMonth thatYearMonth) {
        YearMonth yearMonth = thisYearMonth;
        if (!(yearMonth != null ? !((Object)yearMonth).equals(thatYearMonth) : thatYearMonth != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<YearMonth>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisYearMonth.getLong(ChronoField.PROLEPTIC_MONTH) - thatYearMonth.getLong(ChronoField.PROLEPTIC_MONTH)})), StandardType$YearMonthType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$localDate$1(LocalDate thisLocalDate, LocalDate thatLocalDate) {
        LocalDate localDate2 = thisLocalDate;
        if (!(localDate2 != null ? !((Object)localDate2).equals(thatLocalDate) : thatLocalDate != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<LocalDate>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisLocalDate.toEpochDay() - thatLocalDate.toEpochDay()})), StandardType$LocalDateType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$instant$1(Instant thisInstant, Instant thatInstant) {
        Instant instant2 = thisInstant;
        if (!(instant2 != null ? !((Object)instant2).equals(thatInstant) : thatInstant != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<Instant>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisInstant.getEpochSecond() - thatInstant.getEpochSecond(), thisInstant.getNano() - thatInstant.getNano()})), StandardType$InstantType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$duration$1(Duration thisDuration, Duration thatDuration) {
        Duration duration2 = thisDuration;
        if (!(duration2 != null ? !((Object)duration2).equals(thatDuration) : thatDuration != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<Duration>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisDuration.getSeconds() - thatDuration.getSeconds(), thisDuration.getNano() - thatDuration.getNano()})), StandardType$DurationType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$localTime$1(LocalTime thisLocalTime, LocalTime thatLocalTime) {
        LocalTime localTime2 = thisLocalTime;
        if (!(localTime2 != null ? !((Object)localTime2).equals(thatLocalTime) : thatLocalTime != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<LocalTime>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisLocalTime.toNanoOfDay() - thatLocalTime.toNanoOfDay()})), StandardType$LocalTimeType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$localDateTime$1(LocalDateTime thisLocalDateTime, LocalDateTime thatLocalDateTime) {
        LocalDateTime localDateTime2 = thisLocalDateTime;
        if (!(localDateTime2 != null ? !((Object)localDateTime2).equals(thatLocalDateTime) : thatLocalDateTime != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<LocalDateTime>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisLocalDateTime.toLocalDate().toEpochDay() - thatLocalDateTime.toLocalDate().toEpochDay(), thisLocalDateTime.toLocalTime().toNanoOfDay() - thatLocalDateTime.toLocalTime().toNanoOfDay()})), StandardType$LocalDateTimeType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$offsetTime$1(OffsetTime thisOffsetTime, OffsetTime thatOffsetTime) {
        OffsetTime offsetTime2 = thisOffsetTime;
        if (!(offsetTime2 != null ? !((Object)offsetTime2).equals(thatOffsetTime) : thatOffsetTime != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<OffsetTime>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisOffsetTime.toLocalTime().toNanoOfDay() - thatOffsetTime.toLocalTime().toNanoOfDay(), thisOffsetTime.getOffset().getTotalSeconds() - thatOffsetTime.getOffset().getTotalSeconds()})), StandardType$OffsetTimeType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$offsetDateTime$1(OffsetDateTime thisOffsetDateTime, OffsetDateTime thatOffsetDateTime) {
        OffsetDateTime offsetDateTime2 = thisOffsetDateTime;
        if (!(offsetDateTime2 != null ? !((Object)offsetDateTime2).equals(thatOffsetDateTime) : thatOffsetDateTime != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<OffsetDateTime>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thisOffsetDateTime.toLocalDate().toEpochDay() - thatOffsetDateTime.toLocalDate().toEpochDay(), thisOffsetDateTime.toLocalTime().toNanoOfDay() - thatOffsetDateTime.toLocalTime().toNanoOfDay(), thisOffsetDateTime.getOffset().getTotalSeconds() - thatOffsetDateTime.getOffset().getTotalSeconds()})), StandardType$OffsetDateTimeType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$zonedDateTime$1(ZonedDateTime thisZonedDateTime, ZonedDateTime thatZonedDateTime) {
        ZonedDateTime zonedDateTime2 = thisZonedDateTime;
        if (!(zonedDateTime2 != null ? !((Object)zonedDateTime2).equals(thatZonedDateTime) : thatZonedDateTime != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.ZonedDateTime(MODULE$.localDateTime().apply(thisZonedDateTime.toLocalDateTime(), thatZonedDateTime.toLocalDateTime()), MODULE$.string().apply(thisZonedDateTime.getZone().getId(), thatZonedDateTime.getZone().getId()));
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$zoneOffset$1(ZoneOffset thisOffset, ZoneOffset thatOffset) {
        if (thisOffset.getTotalSeconds() == thatOffset.getTotalSeconds()) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<ZoneOffset>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thatOffset.getTotalSeconds() - thisOffset.getTotalSeconds()})), StandardType$ZoneOffsetType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$dayOfWeek$1(DayOfWeek thisDay, DayOfWeek thatDay) {
        DayOfWeek dayOfWeek = thisDay;
        if (!(dayOfWeek != null ? !dayOfWeek.equals(thatDay) : thatDay != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<DayOfWeek>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thatDay.getValue() - thisDay.getValue()})), StandardType$DayOfWeekType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$month$1(Month thisMonth, Month thatMonth) {
        Month month = thisMonth;
        if (!(month != null ? !month.equals(thatMonth) : thatMonth != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<Month>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{thatMonth.getValue() - thisMonth.getValue()})), StandardType$MonthType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$monthDay$1(MonthDay thisMonthDay, MonthDay thatMonthDay) {
        MonthDay monthDay = thisMonthDay;
        if (!(monthDay != null ? !((Object)monthDay).equals(thatMonthDay) : thatMonthDay != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Temporal<MonthDay>((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{ChronoUnit.DAYS.between(thisMonthDay.atYear(2001), thatMonthDay.atYear(2001)), ChronoUnit.DAYS.between(thisMonthDay.atYear(2000), thatMonthDay.atYear(2000))})), StandardType$MonthDayType$.MODULE$);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$bigInt$1(BigInteger thisValue, BigInteger thatValue) {
        BigInteger bigInteger = thisValue.subtract(thatValue);
        if (BoxesRunTime.equalsNumNum((Number)BigInteger.ZERO, (Number)bigInteger)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.BigInt(bigInteger);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$bigDecimal$1(BigDecimal thisValue, BigDecimal thatValue) {
        MathContext thatCtx = new MathContext(thatValue.precision());
        BigDecimal bigDecimal = thisValue.round(thatCtx).subtract(thatValue, MathContext.UNLIMITED);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.BigDecimal(bigDecimal, thatValue.precision());
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$currency$1(Currency thisValue, Currency thatValue) {
        Currency currency = thisValue;
        if (!(currency != null ? !currency.equals(thatValue) : thatValue != null)) {
            return Patch$.MODULE$.identical();
        }
        return new Patch.Currency(thatValue);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$tuple$1(Tuple2 thisValue, Tuple2 thatValue, Differ left$1, Differ right$1) {
        Tuple2 tuple2 = new Tuple2((Object)thisValue, (Object)thatValue);
        Tuple2 tuple22 = thisValue;
        Tuple2 tuple23 = thatValue;
        if (tuple22 != null) {
            Object thisA = tuple22._1();
            Object thisB = tuple22._2();
            if (tuple23 != null) {
                Object thatA = tuple23._1();
                Object thatB = tuple23._2();
                return left$1.apply(thisA, thatA).$less$times$greater(right$1.apply(thisB, thatB));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$identical$1(Object x$9, Object x$10) {
        return Patch$.MODULE$.identical();
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$fail$1(Object x$11, Object x$12) {
        return Patch$.MODULE$.notComparable();
    }

    public static final /* synthetic */ boolean $anonfun$record$3(Tuple2 x$13) {
        return !((Patch)x$13._2()).isComparable();
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$record$1(ListMap thisValue, ListMap thatValue, Schema.Record schema$1) {
        if (!MODULE$.conformsToStructure(thisValue, schema$1.fields()) || !MODULE$.conformsToStructure(thatValue, schema$1.fields())) {
            return Patch$.MODULE$.notComparable();
        }
        List list = (List)((List)((IterableLike)thisValue.toList().zip((GenIterable)thatValue.toList(), List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 tuple2 = (Tuple2)x0$1._1();
                int fieldIndex = x0$1._2$mcI$sp();
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String thisKey = (String)tuple22._1();
                        Object thisValue = tuple22._2();
                        if (tuple23 != null) {
                            Object thatValue = tuple23._2();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)thisKey), MODULE$.fromSchema(((Schema.Field)schema$1.fields().apply(fieldIndex)).schema()).apply(thisValue, thatValue));
                        }
                    }
                }
            }
            throw new MatchError(x0$1);
        }, List$.MODULE$.canBuildFrom());
        if (list.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Differ$.$anonfun$record$3(x$13)))) {
            return Patch$.MODULE$.notComparable();
        }
        return new Patch.Record(ListMap$.MODULE$.empty().$plus$plus((GenTraversableOnce)list), schema$1).orIdentical();
    }

    public static final /* synthetic */ boolean $anonfun$conformsToStructure$2(Object x$14) {
        return x$14 instanceof Object;
    }

    public static final /* synthetic */ boolean $anonfun$conformsToStructure$1(ListMap map$1, Schema.Field x0$1, boolean x1$1) {
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)x1$1);
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)bl);
        if (!x1$1) {
            return false;
        }
        if (x0$1 != null) {
            return map$1.get((Object)x0$1.name()).exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)Differ$.$anonfun$conformsToStructure$2(x$14)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Patch zio$schema$Differ$$$anonfun$enumN$1(Object thisZ, Object thatZ, Seq cases$1) {
        return (Patch)((Option)cases$1.foldRight((Object)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 instanceof Some) {
                return (Some)x1$1;
            }
            if (x0$1 != null) {
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1.deconstructOption(thisZ)), x0$1.deconstructOption(thatZ));
                if (tuple22 != null) {
                    Option option = (Option)tuple22._1();
                    Option option2 = (Option)tuple22._2();
                    if (option instanceof Some) {
                        Object thisA = ((Some)option).value();
                        if (option2 instanceof Some) {
                            Object thatA = ((Some)option2).value();
                            Differ subtypeDiffer = MODULE$.fromSchema(x0$1.schema()).transform((Function1 & Serializable & scala.Serializable)z -> x0$1.deconstruct(z), (Function1 & Serializable & scala.Serializable)a -> a);
                            return new Some(subtypeDiffer.apply(thisA, thatA));
                        }
                    }
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> Patch$.MODULE$.notComparable());
    }

    private Differ$() {
        MODULE$ = this;
        this.period = new Differ<Period>(){

            public <B> Differ<Tuple2<Period, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Period, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Period> f, Function1<Period, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Period>> f, Function1<Period, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Period>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Period>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Period> apply(Period thisValue, Period thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$period$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.year = new Differ<Year>(){

            public <B> Differ<Tuple2<Year, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Year, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Year> f, Function1<Year, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Year>> f, Function1<Year, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Year>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Year>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Year> apply(Year thisValue, Year thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$year$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.yearMonth = new Differ<YearMonth>(){

            public <B> Differ<Tuple2<YearMonth, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<YearMonth, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, YearMonth> f, Function1<YearMonth, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, YearMonth>> f, Function1<YearMonth, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<YearMonth>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<YearMonth>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<YearMonth> apply(YearMonth thisValue, YearMonth thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$yearMonth$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.zoneOffset = new Differ<ZoneOffset>(){

            public <B> Differ<Tuple2<ZoneOffset, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<ZoneOffset, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, ZoneOffset> f, Function1<ZoneOffset, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, ZoneOffset>> f, Function1<ZoneOffset, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<ZoneOffset>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<ZoneOffset>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<ZoneOffset> apply(ZoneOffset thisValue, ZoneOffset thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$zoneOffset$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.dayOfWeek = new Differ<DayOfWeek>(){

            public <B> Differ<Tuple2<DayOfWeek, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<DayOfWeek, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, DayOfWeek> f, Function1<DayOfWeek, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, DayOfWeek>> f, Function1<DayOfWeek, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<DayOfWeek>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<DayOfWeek>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<DayOfWeek> apply(DayOfWeek thisValue, DayOfWeek thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$dayOfWeek$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.month = new Differ<Month>(){

            public <B> Differ<Tuple2<Month, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Month, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Month> f, Function1<Month, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Month>> f, Function1<Month, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Month>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Month>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Month> apply(Month thisValue, Month thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$month$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.monthDay = new Differ<MonthDay>(){

            public <B> Differ<Tuple2<MonthDay, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<MonthDay, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, MonthDay> f, Function1<MonthDay, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, MonthDay>> f, Function1<MonthDay, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<MonthDay>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<MonthDay>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<MonthDay> apply(MonthDay thisValue, MonthDay thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$monthDay$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.bigInt = new Differ<BigInteger>(){

            public <B> Differ<Tuple2<BigInteger, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<BigInteger, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, BigInteger> f, Function1<BigInteger, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, BigInteger>> f, Function1<BigInteger, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<BigInteger>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<BigInteger>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<BigInteger> apply(BigInteger thisValue, BigInteger thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$bigInt$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.bigDecimal = new Differ<BigDecimal>(){

            public <B> Differ<Tuple2<BigDecimal, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<BigDecimal, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, BigDecimal> f, Function1<BigDecimal, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, BigDecimal>> f, Function1<BigDecimal, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<BigDecimal>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<BigDecimal>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<BigDecimal> apply(BigDecimal thisValue, BigDecimal thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$bigDecimal$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.currency = new Differ<Currency>(){

            public <B> Differ<Tuple2<Currency, B>> $less$times$greater(Differ<B> that) {
                return Differ.$less$times$greater$(this, that);
            }

            public <B> Differ<Tuple2<Currency, B>> zip(Differ<B> that) {
                return Differ.zip$(this, that);
            }

            public <B> Differ<B> transform(Function1<B, Currency> f, Function1<Currency, B> g) {
                return Differ.transform$(this, f, g);
            }

            public <B> Differ<B> transformOrFail(Function1<B, Either<String, Currency>> f, Function1<Currency, Either<String, B>> g) {
                return Differ.transformOrFail$(this, f, g);
            }

            public Differ<Chunk<Currency>> chunk() {
                return Differ.chunk$(this);
            }

            public Differ<Option<Currency>> optional() {
                return Differ.optional$(this);
            }

            public final Patch<Currency> apply(Currency thisValue, Currency thatValue) {
                return Differ$.zio$schema$Differ$$$anonfun$currency$1(thisValue, thatValue);
            }
            {
                Differ.$init$(this);
            }
        };
        this.string = Differ$LCSDiff$.MODULE$.string();
    }
}

