/*
 * Decompiled with CFR 0.152.
 */
package zio.schema;

import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.Chunk$;
import zio.schema.DynamicValue;
import zio.schema.DynamicValue$Record$;
import zio.schema.Patch$;
import zio.schema.Patch$BigDecimal$;
import zio.schema.Patch$BigInt$;
import zio.schema.Patch$Bool$;
import zio.schema.Patch$EitherDiff$;
import zio.schema.Patch$Identical$;
import zio.schema.Patch$LCS$;
import zio.schema.Patch$NotComparable$;
import zio.schema.Patch$Number$;
import zio.schema.Patch$Record$;
import zio.schema.Patch$SchemaMigration$;
import zio.schema.Patch$Temporal$;
import zio.schema.Patch$Total$;
import zio.schema.Patch$Transform$;
import zio.schema.Patch$Tuple$;
import zio.schema.Patch$ZonedDateTime$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.StandardType$DayOfWeekType$;
import zio.schema.StandardType$DurationType$;
import zio.schema.StandardType$InstantType$;
import zio.schema.StandardType$LocalDateTimeType$;
import zio.schema.StandardType$LocalDateType$;
import zio.schema.StandardType$LocalTimeType$;
import zio.schema.StandardType$MonthDayType$;
import zio.schema.StandardType$MonthType$;
import zio.schema.StandardType$OffsetDateTimeType$;
import zio.schema.StandardType$OffsetTimeType$;
import zio.schema.StandardType$PeriodType$;
import zio.schema.StandardType$YearMonthType$;
import zio.schema.StandardType$YearType$;
import zio.schema.StandardType$ZoneOffsetType$;
import zio.schema.StandardType$ZonedDateTimeType$;
import zio.schema.TypeId;
import zio.schema.diff.Edit;
import zio.schema.diff.Edit$;
import zio.schema.diff.Edit$Delete$;
import zio.schema.diff.Edit$Insert$;
import zio.schema.diff.Edit$Keep$;
import zio.schema.meta.Migration;

public interface Patch<A> {
    public static <A> Identical<A> identical() {
        return Patch$.MODULE$.identical();
    }

    public static <A> NotComparable<A> notComparable() {
        return Patch$.MODULE$.notComparable();
    }

    public static Patch $less$times$greater$(Patch $this, Patch that) {
        return $this.$less$times$greater(that);
    }

    default public <B> Patch<Tuple2<A, B>> $less$times$greater(Patch<B> that) {
        return this.zip(that);
    }

    public static Patch zip$(Patch $this, Patch that) {
        return $this.zip(that);
    }

    default public <B> Patch<Tuple2<A, B>> zip(Patch<B> that) {
        return Patch$Tuple$.MODULE$.apply(this, that);
    }

    public Either<String, A> patch(A var1);

    public Patch<A> invert();

    public static boolean isIdentical$(Patch $this) {
        return $this.isIdentical();
    }

    default public boolean isIdentical() {
        return false;
    }

    public static boolean isComparable$(Patch $this) {
        return $this.isComparable();
    }

    default public boolean isComparable() {
        return true;
    }

    public static final class BigDecimal
    implements Patch<java.math.BigDecimal>,
    Product,
    Serializable {
        private final java.math.BigDecimal distance;
        private final int precision;

        public static BigDecimal apply(java.math.BigDecimal bigDecimal, int n) {
            return Patch$BigDecimal$.MODULE$.apply(bigDecimal, n);
        }

        public static BigDecimal fromProduct(Product product) {
            return Patch$BigDecimal$.MODULE$.fromProduct(product);
        }

        public static BigDecimal unapply(BigDecimal bigDecimal) {
            return Patch$BigDecimal$.MODULE$.unapply(bigDecimal);
        }

        public BigDecimal(java.math.BigDecimal distance, int precision) {
            this.distance = distance;
            this.precision = precision;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.distance()));
            n = Statics.mix((int)n, (int)this.precision());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BigDecimal)) return false;
            BigDecimal bigDecimal = (BigDecimal)object;
            if (this.precision() != bigDecimal.precision()) return false;
            if (!BoxesRunTime.equals((Object)this.distance(), (Object)bigDecimal.distance())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BigDecimal;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BigDecimal";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "distance";
            }
            if (1 == n2) {
                return "precision";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public java.math.BigDecimal distance() {
            return this.distance;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public Either<String, java.math.BigDecimal> patch(java.math.BigDecimal input) {
            MathContext mc = new MathContext(this.precision());
            return package$.MODULE$.Right().apply((Object)input.round(mc).subtract(this.distance(), mc));
        }

        @Override
        public Patch<java.math.BigDecimal> invert() {
            return Patch$BigDecimal$.MODULE$.apply(this.distance().negate(), this.precision());
        }

        public BigDecimal copy(java.math.BigDecimal distance, int precision) {
            return new BigDecimal(distance, precision);
        }

        public java.math.BigDecimal copy$default$1() {
            return this.distance();
        }

        public int copy$default$2() {
            return this.precision();
        }

        public java.math.BigDecimal _1() {
            return this.distance();
        }

        public int _2() {
            return this.precision();
        }
    }

    public static final class BigInt
    implements Patch<BigInteger>,
    Product,
    Serializable {
        private final BigInteger distance;

        public static BigInt apply(BigInteger bigInteger) {
            return Patch$BigInt$.MODULE$.apply(bigInteger);
        }

        public static BigInt fromProduct(Product product) {
            return Patch$BigInt$.MODULE$.fromProduct(product);
        }

        public static BigInt unapply(BigInt bigInt) {
            return Patch$BigInt$.MODULE$.unapply(bigInt);
        }

        public BigInt(BigInteger distance) {
            this.distance = distance;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BigInt)) return false;
            BigInt bigInt = (BigInt)object;
            if (!BoxesRunTime.equals((Object)this.distance(), (Object)bigInt.distance())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BigInt;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BigInt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "distance";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BigInteger distance() {
            return this.distance;
        }

        @Override
        public Either<String, BigInteger> patch(BigInteger input) {
            return package$.MODULE$.Right().apply((Object)input.subtract(this.distance()));
        }

        @Override
        public Patch<BigInteger> invert() {
            return Patch$BigInt$.MODULE$.apply(this.distance().negate());
        }

        public BigInt copy(BigInteger distance) {
            return new BigInt(distance);
        }

        public BigInteger copy$default$1() {
            return this.distance();
        }

        public BigInteger _1() {
            return this.distance();
        }
    }

    public static final class Bool
    implements Patch<Object>,
    Product,
    Serializable {
        private final boolean xor;

        public static Bool apply(boolean bl) {
            return Patch$Bool$.MODULE$.apply(bl);
        }

        public static Bool fromProduct(Product product) {
            return Patch$Bool$.MODULE$.fromProduct(product);
        }

        public static Bool unapply(Bool bool) {
            return Patch$Bool$.MODULE$.unapply(bool);
        }

        public Bool(boolean xor) {
            this.xor = xor;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.xor() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bool)) return false;
            Bool bool = (Bool)object;
            if (this.xor() != bool.xor()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bool;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Bool";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "xor";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean xor() {
            return this.xor;
        }

        @Override
        public Either<String, Object> patch(boolean a) {
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)(a ^ this.xor())));
        }

        @Override
        public Patch<Object> invert() {
            return this;
        }

        public Bool copy(boolean xor) {
            return new Bool(xor);
        }

        public boolean copy$default$1() {
            return this.xor();
        }

        public boolean _1() {
            return this.xor();
        }
    }

    public static final class EitherDiff<A, B>
    implements Patch<Either<A, B>>,
    Product,
    Serializable {
        private final Either diff;

        public static <A, B> EitherDiff<A, B> apply(Either<Patch<A>, Patch<B>> either) {
            return Patch$EitherDiff$.MODULE$.apply(either);
        }

        public static EitherDiff<?, ?> fromProduct(Product product) {
            return Patch$EitherDiff$.MODULE$.fromProduct(product);
        }

        public static <A, B> EitherDiff<A, B> unapply(EitherDiff<A, B> eitherDiff) {
            return Patch$EitherDiff$.MODULE$.unapply(eitherDiff);
        }

        public EitherDiff(Either<Patch<A>, Patch<B>> diff) {
            this.diff = diff;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EitherDiff)) return false;
            EitherDiff eitherDiff = (EitherDiff)object;
            Either<Patch<A>, Patch<B>> either = this.diff();
            Either<Patch<A>, Patch<B>> either2 = eitherDiff.diff();
            if (either != null) {
                if (!either.equals(either2)) return false;
                return true;
            }
            if (either2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EitherDiff;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EitherDiff";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "diff";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Either<Patch<A>, Patch<B>> diff() {
            return this.diff;
        }

        @Override
        public boolean isIdentical() {
            return BoxesRunTime.unboxToBoolean((Object)this.diff().fold((Function1 & Serializable)_$2 -> _$2.isIdentical(), (Function1 & Serializable)_$3 -> _$3.isIdentical()));
        }

        @Override
        public boolean isComparable() {
            return BoxesRunTime.unboxToBoolean((Object)this.diff().fold((Function1 & Serializable)_$4 -> _$4.isComparable(), (Function1 & Serializable)_$5 -> _$5.isComparable()));
        }

        @Override
        public Either<String, Either<A, B>> patch(Either<A, B> input) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(input, this.diff());
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Either either2 = (Either)tuple2._2();
                if (either instanceof Left && either2 instanceof Right) {
                    return package$.MODULE$.Left().apply((Object)"Cannot apply a right diff to a left value");
                }
                if (either instanceof Right && either2 instanceof Left) {
                    return package$.MODULE$.Left().apply((Object)"Cannot apply a left diff to a right value");
                }
                if (either instanceof Left) {
                    Object in = ((Left)either).value();
                    if (either2 instanceof Left) {
                        Patch diff = (Patch)((Left)either2).value();
                        return diff.patch(in).map((Function1 & Serializable)_$6 -> package$.MODULE$.Left().apply(_$6));
                    }
                }
                if (either instanceof Right) {
                    Object in = ((Right)either).value();
                    if (either2 instanceof Right) {
                        Patch diff = (Patch)((Right)either2).value();
                        return diff.patch(in).map((Function1 & Serializable)_$7 -> package$.MODULE$.Right().apply(_$7));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }

        @Override
        public Patch<Either<A, B>> invert() {
            Either<Patch<A>, Patch<B>> either = this.diff();
            if (either instanceof Left) {
                Patch value = (Patch)((Left)either).value();
                return Patch$EitherDiff$.MODULE$.apply(package$.MODULE$.Left().apply(value.invert()));
            }
            if (either instanceof Right) {
                Patch value = (Patch)((Right)either).value();
                return Patch$EitherDiff$.MODULE$.apply(package$.MODULE$.Right().apply(value.invert()));
            }
            throw new MatchError(either);
        }

        public <A, B> EitherDiff<A, B> copy(Either<Patch<A>, Patch<B>> diff) {
            return new EitherDiff<A, B>(diff);
        }

        public <A, B> Either<Patch<A>, Patch<B>> copy$default$1() {
            return this.diff();
        }

        public Either<Patch<A>, Patch<B>> _1() {
            return this.diff();
        }
    }

    public static final class Identical<A>
    implements Patch<A>,
    Product,
    Serializable {
        public static <A> Identical<A> apply() {
            return Patch$Identical$.MODULE$.apply();
        }

        public static Identical<?> fromProduct(Product product) {
            return Patch$Identical$.MODULE$.fromProduct(product);
        }

        public static <A> boolean unapply(Identical<A> identical) {
            return Patch$Identical$.MODULE$.unapply(identical);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Identical)) return false;
            Identical identical = (Identical)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Identical;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "Identical";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Either<String, A> patch(A a) {
            return package$.MODULE$.Right().apply(a);
        }

        @Override
        public boolean isIdentical() {
            return true;
        }

        @Override
        public Patch<A> invert() {
            return this;
        }

        public <A> Identical<A> copy() {
            return new Identical<A>();
        }
    }

    public static final class LCS<A>
    implements Patch<Chunk<A>>,
    Product,
    Serializable {
        private final Chunk edits;

        public static <A> LCS<A> apply(Chunk<Edit<A>> chunk) {
            return Patch$LCS$.MODULE$.apply(chunk);
        }

        public static LCS<?> fromProduct(Product product) {
            return Patch$LCS$.MODULE$.fromProduct(product);
        }

        public static <A> LCS<A> unapply(LCS<A> lCS) {
            return Patch$LCS$.MODULE$.unapply(lCS);
        }

        public LCS(Chunk<Edit<A>> edits) {
            this.edits = edits;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LCS)) return false;
            LCS lCS = (LCS)object;
            Chunk<Edit<A>> chunk = this.edits();
            Chunk<Edit<A>> chunk2 = lCS.edits();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LCS;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LCS";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "edits";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<Edit<A>> edits() {
            return this.edits;
        }

        @Override
        public Either<String, Chunk<A>> patch(Chunk<A> as) {
            return this.calc$1(as.toList(), this.edits().toList(), (List)package$.MODULE$.Nil());
        }

        @Override
        public Patch<Chunk<A>> invert() {
            return Patch$LCS$.MODULE$.apply(this.edits().map((Function1 & Serializable)edit -> Edit$.MODULE$.invert(edit)));
        }

        public <A> LCS<A> copy(Chunk<Edit<A>> edits) {
            return new LCS<A>(edits);
        }

        public <A> Chunk<Edit<A>> copy$default$1() {
            return this.edits();
        }

        public Chunk<Edit<A>> _1() {
            return this.edits();
        }

        private final Either calc$1(List in, List edits, List result) {
            Tuple2 tuple2;
            while ((tuple2 = Tuple2$.MODULE$.apply((Object)in, (Object)edits)) != null) {
                List list = (List)tuple2._1();
                List list2 = (List)tuple2._2();
                if (list instanceof .colon.colon) {
                    List list3 = ((.colon.colon)list).next$access$1();
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list4 = list2;
                    if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(52).append("Incorrect Patch - no instructions for these items: ").append(in.mkString()).append(".").toString());
                    }
                    Object h = ((.colon.colon)list).head();
                    if (list2 instanceof .colon.colon) {
                        Edit.Delete delete;
                        Object a;
                        Object s;
                        Edit edit = (Edit)((.colon.colon)list2).head();
                        List list5 = ((.colon.colon)list2).next$access$1();
                        if (edit instanceof Edit.Delete && !BoxesRunTime.equals(s = (a = (delete = Edit$Delete$.MODULE$.unapply((Edit.Delete)edit))._1()), (Object)h)) {
                            return package$.MODULE$.Left().apply((Object)new StringBuilder(36).append("Cannot Delete ").append(s).append(" - current letter is ").append(h).append(".").toString());
                        }
                    }
                }
                Nil$ nil$ = package$.MODULE$.Nil();
                List list6 = list;
                if (!(nil$ != null ? !nil$.equals(list6) : list6 != null) && list2 instanceof .colon.colon) {
                    Edit edit = (Edit)((.colon.colon)list2).head();
                    List list7 = ((.colon.colon)list2).next$access$1();
                    if (edit instanceof Edit.Delete) {
                        Object a;
                        Edit.Delete delete = Edit$Delete$.MODULE$.unapply((Edit.Delete)edit);
                        Object s = a = delete._1();
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(41).append("Cannot Delete ").append(s).append(" - no items left to delete.").toString());
                    }
                }
                if (list instanceof .colon.colon) {
                    List list8;
                    .colon.colon colon2 = (.colon.colon)list;
                    List t = list8 = colon2.next$access$1();
                    if (list2 instanceof .colon.colon) {
                        Edit.Keep keep;
                        Object a;
                        Object s;
                        .colon.colon colon3 = (.colon.colon)list2;
                        Edit edit = (Edit)colon3.head();
                        List list9 = colon3.next$access$1();
                        if (edit instanceof Edit.Delete) {
                            Edit.Delete delete = Edit$Delete$.MODULE$.unapply((Edit.Delete)edit);
                            Object a2 = delete._1();
                            List tail = list9;
                            List list10 = t;
                            List list11 = tail;
                            in = list10;
                            edits = list11;
                            continue;
                        }
                        Object h = colon2.head();
                        if (edit instanceof Edit.Keep && !BoxesRunTime.equals(s = (a = (keep = Edit$Keep$.MODULE$.unapply((Edit.Keep)edit))._1()), (Object)h)) {
                            return package$.MODULE$.Left().apply((Object)new StringBuilder(34).append("Cannot Keep ").append(s).append(" - current letter is ").append(h).append(".").toString());
                        }
                    }
                }
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list12 = list;
                if (!(nil$2 != null ? !nil$2.equals(list12) : list12 != null) && list2 instanceof .colon.colon) {
                    Edit edit = (Edit)((.colon.colon)list2).head();
                    List list13 = ((.colon.colon)list2).next$access$1();
                    if (edit instanceof Edit.Keep) {
                        Object a;
                        Edit.Keep keep = Edit$Keep$.MODULE$.unapply((Edit.Keep)edit);
                        Object s = a = keep._1();
                        return package$.MODULE$.Left().apply((Object)new StringBuilder(37).append("Cannot Keep ").append(s).append(" - no items left to keep.").toString());
                    }
                }
                if (list instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list;
                    List list14 = colon4.next$access$1();
                    Object h = colon4.head();
                    List t = list14;
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon5 = (.colon.colon)list2;
                        List list15 = colon5.next$access$1();
                        if (colon5.head() instanceof Edit.Keep) {
                            Edit.Keep keep = Edit$Keep$.MODULE$.unapply((Edit.Keep)colon5.head());
                            Object a = keep._1();
                            List tail = list15;
                            List list16 = t;
                            List list17 = tail;
                            List list18 = (List)result.$colon$plus(h);
                            in = list16;
                            edits = list17;
                            result = list18;
                            continue;
                        }
                    }
                }
                List in2 = list;
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list2;
                    Edit edit = (Edit)colon6.head();
                    List list19 = colon6.next$access$1();
                    if (edit instanceof Edit.Insert) {
                        Object a;
                        Edit.Insert insert = Edit$Insert$.MODULE$.unapply((Edit.Insert)edit);
                        Object s = a = insert._1();
                        List tail = list19;
                        List list20 = in2;
                        List list21 = tail;
                        List list22 = (List)result.$colon$plus(s);
                        in = list20;
                        edits = list21;
                        result = list22;
                        continue;
                    }
                }
                Nil$ nil$3 = package$.MODULE$.Nil();
                List list23 = list;
                if (nil$3 != null ? !nil$3.equals(list23) : list23 != null) break;
                Nil$ nil$4 = package$.MODULE$.Nil();
                List list24 = list2;
                if (nil$4 != null ? !nil$4.equals(list24) : list24 != null) break;
                return package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.fromIterable((Iterable)result));
            }
            throw new MatchError((Object)tuple2);
        }
    }

    public static final class NotComparable<A>
    implements Patch<A>,
    Product,
    Serializable {
        public static <A> NotComparable<A> apply() {
            return Patch$NotComparable$.MODULE$.apply();
        }

        public static NotComparable<?> fromProduct(Product product) {
            return Patch$NotComparable$.MODULE$.fromProduct(product);
        }

        public static <A> boolean unapply(NotComparable<A> notComparable) {
            return Patch$NotComparable$.MODULE$.unapply(notComparable);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotComparable)) return false;
            NotComparable notComparable = (NotComparable)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NotComparable;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "NotComparable";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Either<String, A> patch(A input) {
            return package$.MODULE$.Left().apply((Object)"Non-comparable diff cannot be applied");
        }

        @Override
        public boolean isComparable() {
            return false;
        }

        @Override
        public Patch<A> invert() {
            return this;
        }

        public <A> NotComparable<A> copy() {
            return new NotComparable<A>();
        }
    }

    public static final class Number<A>
    implements Patch<A>,
    Product,
    Serializable {
        private final Object distance;
        private final Numeric<A> ev;

        public static <A> Number<A> apply(A a, Numeric<A> numeric) {
            return Patch$Number$.MODULE$.apply(a, numeric);
        }

        public static <A> Number<A> unapply(Number<A> number) {
            return Patch$Number$.MODULE$.unapply(number);
        }

        public Number(A distance, Numeric<A> ev) {
            this.distance = distance;
            this.ev = ev;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Number)) return false;
            Number number = (Number)object;
            if (!BoxesRunTime.equals(this.distance(), number.distance())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Number;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Number";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "distance";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public A distance() {
            return (A)this.distance;
        }

        @Override
        public Either<String, A> patch(A input) {
            return package$.MODULE$.Right().apply(this.ev.minus(input, this.distance()));
        }

        @Override
        public Patch<A> invert() {
            return Patch$Number$.MODULE$.apply(this.ev.negate(this.distance()), this.ev);
        }

        public <A> Number<A> copy(A distance, Numeric<A> ev) {
            return new Number<A>(distance, ev);
        }

        public <A> A copy$default$1() {
            return this.distance();
        }

        public A _1() {
            return this.distance();
        }
    }

    public static final class Record<R>
    implements Patch<R>,
    Product,
    Serializable {
        private final ListMap differences;
        private final Schema.Record schema;

        public static <R> Record<R> apply(ListMap<String, Patch<?>> listMap, Schema.Record<R> record) {
            return Patch$Record$.MODULE$.apply(listMap, record);
        }

        public static Record<?> fromProduct(Product product) {
            return Patch$Record$.MODULE$.fromProduct(product);
        }

        public static <R> Record<R> unapply(Record<R> record) {
            return Patch$Record$.MODULE$.unapply(record);
        }

        public Record(ListMap<String, Patch<?>> differences, Schema.Record<R> schema) {
            this.differences = differences;
            this.schema = schema;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Record)) return false;
            Record record = (Record)object;
            ListMap<String, Patch<?>> listMap = this.differences();
            ListMap<String, Patch<?>> listMap2 = record.differences();
            if (listMap == null) {
                if (listMap2 != null) {
                    return false;
                }
            } else if (!listMap.equals(listMap2)) return false;
            Schema.Record<R> record2 = this.schema();
            Schema.Record<R> record3 = record.schema();
            if (record2 == null) {
                if (record3 == null) return true;
                return false;
            } else {
                if (!record2.equals(record3)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Record;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Record";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "differences";
            }
            if (1 == n2) {
                return "schema";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ListMap<String, Patch<?>> differences() {
            return this.differences;
        }

        public Schema.Record<R> schema() {
            return this.schema;
        }

        @Override
        public boolean isIdentical() {
            return this.differences().forall((Function1 & Serializable)_$8 -> ((Patch)_$8._2()).isIdentical());
        }

        @Override
        public boolean isComparable() {
            return this.differences().forall((Function1 & Serializable)_$9 -> ((Patch)_$9._2()).isComparable());
        }

        @Override
        public Either<String, R> patch(R input) {
            Left left;
            Chunk<Schema.Field<R, ?>> structure = this.schema().fields();
            DynamicValue dynamicValue = this.schema().toDynamic(input);
            if (dynamicValue instanceof DynamicValue.Record) {
                DynamicValue.Record record = DynamicValue$Record$.MODULE$.unapply((DynamicValue.Record)dynamicValue);
                TypeId typeId = record._1();
                ListMap<String, DynamicValue> listMap = record._2();
                TypeId name = typeId;
                ListMap<String, DynamicValue> values = listMap;
                left = ((Either)this.differences().foldLeft((Object)package$.MODULE$.Right().apply(values), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Either either = (Either)tuple2._1();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (either instanceof Right) {
                            ListMap record = (ListMap)((Right)either).value();
                            if (tuple22 != null) {
                                String key = (String)tuple22._1();
                                Patch diff = (Patch)tuple22._2();
                                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)structure.find((Function1 & Serializable)_$10 -> {
                                    String string = _$10.name();
                                    String string2 = key;
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }).map((Function1 & Serializable)_$11 -> _$11.schema()), (Object)values.get((Object)key));
                                if (tuple23 != null) {
                                    Schema schema;
                                    Option option = (Option)tuple23._1();
                                    Option option2 = (Option)tuple23._2();
                                    if (option instanceof Some && (schema = (Schema)((Some)option).value()) instanceof Schema) {
                                        Schema schema2 = schema;
                                        if (option2 instanceof Some) {
                                            DynamicValue oldValue = (DynamicValue)((Some)option2).value();
                                            Either oldVal = oldValue.toTypedValue(schema2);
                                            Either either2 = oldVal.flatMap((Function1 & Serializable)v -> diff.patch(v)).map((Function1 & Serializable)v -> schema2.toDynamic(v));
                                            if (either2 instanceof Left) {
                                                String error = (String)((Left)either2).value();
                                                return package$.MODULE$.Left().apply((Object)error);
                                            }
                                            if (either2 instanceof Right) {
                                                DynamicValue newValue = (DynamicValue)((Right)either2).value();
                                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                                                return package$.MODULE$.Right().apply((Object)record.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newValue)));
                                            }
                                            throw new MatchError((Object)either2);
                                        }
                                    }
                                }
                                return package$.MODULE$.Left().apply((Object)new StringBuilder(47).append("Values=").append(values).append(" and structure=").append(structure).append(" have incompatible shape.").toString());
                            }
                        }
                        if (either instanceof Left) {
                            String string = (String)((Left)either).value();
                            return package$.MODULE$.Left().apply((Object)string);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })).map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply((Object)name, r));
            } else {
                DynamicValue dv = dynamicValue;
                left = package$.MODULE$.Left().apply((Object)new StringBuilder(66).append("Failed to apply record diff. Unexpected dynamic value for record: ").append(dv).toString());
            }
            Left patchedDynamicValue = left;
            return patchedDynamicValue.flatMap((Function1 & Serializable)newValues -> this.schema().fromDynamic(DynamicValue$Record$.MODULE$.apply((TypeId)newValues._1(), (ListMap<String, DynamicValue>)((ListMap)newValues._2()))));
        }

        public Patch<R> orIdentical() {
            return (Patch)(this.differences().values().forall((Function1 & Serializable)_$12 -> _$12.isIdentical()) ? Patch$.MODULE$.identical() : this);
        }

        @Override
        public Patch<R> invert() {
            ListMap inverted = (ListMap)this.differences().foldLeft((Object)ListMap$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    ListMap map = (ListMap)tuple2._1();
                    if (tuple22 != null) {
                        String key = (String)tuple22._1();
                        Patch value = (Patch)tuple22._2();
                        return map.updated((Object)key, value.invert());
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return Patch$Record$.MODULE$.apply(inverted, this.schema());
        }

        public <R> Record<R> copy(ListMap<String, Patch<?>> differences, Schema.Record<R> schema) {
            return new Record<R>(differences, schema);
        }

        public <R> ListMap<String, Patch<?>> copy$default$1() {
            return this.differences();
        }

        public <R> Schema.Record<R> copy$default$2() {
            return this.schema();
        }

        public ListMap<String, Patch<?>> _1() {
            return this.differences();
        }

        public Schema.Record<R> _2() {
            return this.schema();
        }
    }

    public static final class SchemaMigration
    implements Patch<Schema<?>>,
    Product,
    Serializable {
        private final Chunk migrations;

        public static SchemaMigration apply(Chunk<Migration> chunk) {
            return Patch$SchemaMigration$.MODULE$.apply(chunk);
        }

        public static SchemaMigration fromProduct(Product product) {
            return Patch$SchemaMigration$.MODULE$.fromProduct(product);
        }

        public static SchemaMigration unapply(SchemaMigration schemaMigration) {
            return Patch$SchemaMigration$.MODULE$.unapply(schemaMigration);
        }

        public SchemaMigration(Chunk<Migration> migrations) {
            this.migrations = migrations;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SchemaMigration)) return false;
            SchemaMigration schemaMigration = (SchemaMigration)object;
            Chunk<Migration> chunk = this.migrations();
            Chunk<Migration> chunk2 = schemaMigration.migrations();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SchemaMigration;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SchemaMigration";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "migrations";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<Migration> migrations() {
            return this.migrations;
        }

        @Override
        public Either<String, Schema<?>> patch(Schema<?> input) {
            return package$.MODULE$.Left().apply((Object)"Schema migrations cannot be applied");
        }

        public Patch<Schema<?>> orIdentical() {
            return (Patch)(this.migrations().isEmpty() ? Patch$.MODULE$.identical() : this);
        }

        @Override
        public Patch<Schema<?>> invert() {
            return Patch$SchemaMigration$.MODULE$.apply((Chunk<Migration>)((Chunk)this.migrations().reverse()));
        }

        public SchemaMigration copy(Chunk<Migration> migrations) {
            return new SchemaMigration(migrations);
        }

        public Chunk<Migration> copy$default$1() {
            return this.migrations();
        }

        public Chunk<Migration> _1() {
            return this.migrations();
        }
    }

    public static final class Temporal<A>
    implements Patch<A>,
    Product,
    Serializable {
        private final List distances;
        private final StandardType tpe;

        public static <A> Temporal<A> apply(List<Object> list, StandardType<A> standardType) {
            return Patch$Temporal$.MODULE$.apply(list, standardType);
        }

        public static Temporal<?> fromProduct(Product product) {
            return Patch$Temporal$.MODULE$.fromProduct(product);
        }

        public static <A> Temporal<A> unapply(Temporal<A> temporal) {
            return Patch$Temporal$.MODULE$.unapply(temporal);
        }

        public Temporal(List<Object> distances, StandardType<A> tpe) {
            this.distances = distances;
            this.tpe = tpe;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Temporal)) return false;
            Temporal temporal = (Temporal)object;
            List<Object> list = this.distances();
            List<Object> list2 = temporal.distances();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            StandardType<A> standardType = this.tpe();
            StandardType<A> standardType2 = temporal.tpe();
            if (standardType == null) {
                if (standardType2 == null) return true;
                return false;
            } else {
                if (!standardType.equals(standardType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Temporal;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Temporal";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "distances";
            }
            if (1 == n2) {
                return "tpe";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Object> distances() {
            return this.distances;
        }

        public StandardType<A> tpe() {
            return this.tpe;
        }

        @Override
        public Either<String, A> patch(A a) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.tpe(), this.distances());
            if (tuple2 != null) {
                StandardType standardType = (StandardType)tuple2._1();
                List list = (List)tuple2._2();
                if (standardType == StandardType$YearType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon2.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list3 = list2;
                    if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                        return package$.MODULE$.Right().apply((Object)Year.of(((Year)a).getValue() - (int)distance));
                    }
                }
                if (standardType == StandardType$YearMonthType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list;
                    List list4 = colon3.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon3.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list5 = list4;
                    if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                        return package$.MODULE$.Right().apply((Object)YearMonth.now().with(ChronoField.PROLEPTIC_MONTH, ((YearMonth)a).getLong(ChronoField.PROLEPTIC_MONTH) - distance));
                    }
                }
                if (standardType == StandardType$ZonedDateTimeType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list;
                    List list6 = colon4.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon4.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list7 = list6;
                    if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                        return package$.MODULE$.Right().apply((Object)LocalDate.ofEpochDay(((LocalDate)a).toEpochDay() - distance));
                    }
                }
                if (standardType == StandardType$InstantType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list;
                    List list8 = colon5.next$access$1();
                    long dist1 = BoxesRunTime.unboxToLong((Object)colon5.head());
                    if (list8 instanceof .colon.colon) {
                        .colon.colon colon6 = (.colon.colon)list8;
                        List list9 = colon6.next$access$1();
                        long dist2 = BoxesRunTime.unboxToLong((Object)colon6.head());
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list10 = list9;
                        if (!(nil$ != null ? !nil$.equals(list10) : list10 != null)) {
                            return package$.MODULE$.Right().apply((Object)Instant.ofEpochSecond(((Instant)a).getEpochSecond() - dist1, (long)((Instant)a).getNano() - dist2));
                        }
                    }
                }
                if (standardType == StandardType$LocalTimeType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon7 = (.colon.colon)list;
                    List list11 = colon7.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon7.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list12 = list11;
                    if (!(nil$ != null ? !nil$.equals(list12) : list12 != null)) {
                        return package$.MODULE$.Right().apply((Object)LocalTime.ofNanoOfDay(((LocalTime)a).toNanoOfDay() - distance));
                    }
                }
                if (standardType == StandardType$LocalDateTimeType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon8 = (.colon.colon)list;
                    List list13 = colon8.next$access$1();
                    long dist1 = BoxesRunTime.unboxToLong((Object)colon8.head());
                    if (list13 instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list13;
                        List list14 = colon9.next$access$1();
                        long dist2 = BoxesRunTime.unboxToLong((Object)colon9.head());
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list15 = list14;
                        if (!(nil$ != null ? !nil$.equals(list15) : list15 != null)) {
                            return package$.MODULE$.Right().apply((Object)LocalDateTime.of(LocalDate.ofEpochDay(((LocalDateTime)a).toLocalDate().toEpochDay() - dist1), LocalTime.ofNanoOfDay(((LocalDateTime)a).toLocalTime().toNanoOfDay() - dist2)));
                        }
                    }
                }
                if (standardType == StandardType$OffsetTimeType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon10 = (.colon.colon)list;
                    List list16 = colon10.next$access$1();
                    long dist1 = BoxesRunTime.unboxToLong((Object)colon10.head());
                    if (list16 instanceof .colon.colon) {
                        .colon.colon colon11 = (.colon.colon)list16;
                        List list17 = colon11.next$access$1();
                        long dist2 = BoxesRunTime.unboxToLong((Object)colon11.head());
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list18 = list17;
                        if (!(nil$ != null ? !nil$.equals(list18) : list18 != null)) {
                            return package$.MODULE$.Right().apply((Object)OffsetTime.of(LocalTime.ofNanoOfDay(((OffsetTime)a).toLocalTime().toNanoOfDay() - dist1), ZoneOffset.ofTotalSeconds(((OffsetTime)a).getOffset().getTotalSeconds() - (int)dist2)));
                        }
                    }
                }
                if (standardType == StandardType$OffsetDateTimeType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon12 = (.colon.colon)list;
                    List list19 = colon12.next$access$1();
                    long dist1 = BoxesRunTime.unboxToLong((Object)colon12.head());
                    if (list19 instanceof .colon.colon) {
                        .colon.colon colon13 = (.colon.colon)list19;
                        List list20 = colon13.next$access$1();
                        long dist2 = BoxesRunTime.unboxToLong((Object)colon13.head());
                        if (list20 instanceof .colon.colon) {
                            .colon.colon colon14 = (.colon.colon)list20;
                            List list21 = colon14.next$access$1();
                            long dist3 = BoxesRunTime.unboxToLong((Object)colon14.head());
                            Nil$ nil$ = package$.MODULE$.Nil();
                            List list22 = list21;
                            if (!(nil$ != null ? !nil$.equals(list22) : list22 != null)) {
                                return package$.MODULE$.Right().apply((Object)OffsetDateTime.of(LocalDate.ofEpochDay(((OffsetDateTime)a).toLocalDate().toEpochDay() - dist1), LocalTime.ofNanoOfDay(((OffsetDateTime)a).toLocalTime().toNanoOfDay() - dist2), ZoneOffset.ofTotalSeconds(((OffsetDateTime)a).getOffset().getTotalSeconds() - (int)dist3)));
                            }
                        }
                    }
                }
                if (standardType == StandardType$PeriodType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon15 = (.colon.colon)list;
                    List list23 = colon15.next$access$1();
                    long dayAdjustment = BoxesRunTime.unboxToLong((Object)colon15.head());
                    if (list23 instanceof .colon.colon) {
                        .colon.colon colon16 = (.colon.colon)list23;
                        List list24 = colon16.next$access$1();
                        long monthAdjustment = BoxesRunTime.unboxToLong((Object)colon16.head());
                        if (list24 instanceof .colon.colon) {
                            .colon.colon colon17 = (.colon.colon)list24;
                            List list25 = colon17.next$access$1();
                            long yearAdjustment = BoxesRunTime.unboxToLong((Object)colon17.head());
                            Nil$ nil$ = package$.MODULE$.Nil();
                            List list26 = list25;
                            if (!(nil$ != null ? !nil$.equals(list26) : list26 != null)) {
                                Left left;
                                try {
                                    left = package$.MODULE$.Right().apply((Object)Period.of(((Period)a).getYears() - (int)yearAdjustment, ((Period)a).getMonths() - (int)monthAdjustment, ((Period)a).getDays() - (int)dayAdjustment));
                                }
                                catch (Throwable throwable) {
                                    left = package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Invalid java.time.Period diff ").append(this).toString());
                                }
                                return left;
                            }
                        }
                    }
                }
                if (standardType == StandardType$ZoneOffsetType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon18 = (.colon.colon)list;
                    List list27 = colon18.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon18.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list28 = list27;
                    if (!(nil$ != null ? !nil$.equals(list28) : list28 != null)) {
                        Right right;
                        try {
                            right = package$.MODULE$.Right().apply((Object)ZoneOffset.ofTotalSeconds(((ZoneOffset)a).getTotalSeconds() + (int)distance));
                        }
                        catch (Throwable t) {
                            right = package$.MODULE$.Left().apply((Object)new StringBuilder(27).append("Patched offset is invalid: ").append(t.getMessage()).toString());
                        }
                        return right;
                    }
                }
                if (standardType == StandardType$DayOfWeekType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon19 = (.colon.colon)list;
                    List list29 = colon19.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon19.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list30 = list29;
                    if (!(nil$ != null ? !nil$.equals(list30) : list30 != null)) {
                        return package$.MODULE$.Right().apply((Object)((DayOfWeek)a).plus(distance));
                    }
                }
                if (standardType == StandardType$MonthType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon20 = (.colon.colon)list;
                    List list31 = colon20.next$access$1();
                    long distance = BoxesRunTime.unboxToLong((Object)colon20.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list32 = list31;
                    if (!(nil$ != null ? !nil$.equals(list32) : list32 != null)) {
                        return package$.MODULE$.Right().apply((Object)((Month)a).plus(distance));
                    }
                }
                if (standardType == StandardType$DurationType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon21 = (.colon.colon)list;
                    List list33 = colon21.next$access$1();
                    long dist1 = BoxesRunTime.unboxToLong((Object)colon21.head());
                    if (list33 instanceof .colon.colon) {
                        .colon.colon colon22 = (.colon.colon)list33;
                        List list34 = colon22.next$access$1();
                        long dist2 = BoxesRunTime.unboxToLong((Object)colon22.head());
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list35 = list34;
                        if (!(nil$ != null ? !nil$.equals(list35) : list35 != null)) {
                            return package$.MODULE$.Right().apply((Object)Duration.ofSeconds(((Duration)a).getSeconds() - dist1, (long)((Duration)a).getNano() - dist2));
                        }
                    }
                }
                if (standardType == StandardType$MonthDayType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon23 = (.colon.colon)list;
                    List list36 = colon23.next$access$1();
                    long regDiff = BoxesRunTime.unboxToLong((Object)colon23.head());
                    if (list36 instanceof .colon.colon) {
                        List list37 = ((.colon.colon)list36).next$access$1();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list38 = list37;
                        if (!(nil$ != null ? !nil$.equals(list38) : list38 != null)) {
                            return package$.MODULE$.Right().apply((Object)MonthDay.from(ChronoUnit.DAYS.addTo(((MonthDay)a).atYear(2001), regDiff)));
                        }
                    }
                }
                if (standardType == StandardType$LocalDateType$.MODULE$ && list instanceof .colon.colon) {
                    .colon.colon colon24 = (.colon.colon)list;
                    List list39 = colon24.next$access$1();
                    long dist = BoxesRunTime.unboxToLong((Object)colon24.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list40 = list39;
                    if (!(nil$ != null ? !nil$.equals(list40) : list40 != null)) {
                        return package$.MODULE$.Right().apply((Object)LocalDate.ofEpochDay(((LocalDate)a).toEpochDay() - dist));
                    }
                }
                StandardType s = standardType;
                return package$.MODULE$.Left().apply((Object)new StringBuilder(46).append("Cannot apply temporal diff to value with type ").append(s).toString());
            }
            throw new MatchError((Object)tuple2);
        }

        @Override
        public Patch<A> invert() {
            return Patch$Temporal$.MODULE$.apply((List<Object>)this.distances().map((Function1)(JFunction1.mcJJ.sp & Serializable)_$1 -> -_$1), this.tpe());
        }

        public <A> Temporal<A> copy(List<Object> distances, StandardType<A> tpe) {
            return new Temporal<A>(distances, tpe);
        }

        public <A> List<Object> copy$default$1() {
            return this.distances();
        }

        public <A> StandardType<A> copy$default$2() {
            return this.tpe();
        }

        public List<Object> _1() {
            return this.distances();
        }

        public StandardType<A> _2() {
            return this.tpe();
        }
    }

    public static final class Total<A>
    implements Patch<A>,
    Product,
    Serializable {
        private final Object value;

        public static <A> Total<A> apply(A a) {
            return Patch$Total$.MODULE$.apply(a);
        }

        public static Total<?> fromProduct(Product product) {
            return Patch$Total$.MODULE$.fromProduct(product);
        }

        public static <A> Total<A> unapply(Total<A> total) {
            return Patch$Total$.MODULE$.unapply(total);
        }

        public Total(A value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Total)) return false;
            Total total = (Total)object;
            if (!BoxesRunTime.equals(this.value(), total.value())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Total;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Total";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public A value() {
            return (A)this.value;
        }

        @Override
        public Either<String, A> patch(A input) {
            return package$.MODULE$.Right().apply(this.value());
        }

        @Override
        public Patch<A> invert() {
            return Patch$Total$.MODULE$.apply(this.value());
        }

        public <A> Total<A> copy(A value) {
            return new Total<A>(value);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public A _1() {
            return this.value();
        }
    }

    public static final class Transform<A, B>
    implements Patch<B>,
    Product,
    Serializable {
        private final Patch patch;
        private final Function1 f;
        private final Function1 g;

        public static <A, B> Transform<A, B> apply(Patch<A> patch, Function1<A, Either<String, B>> function1, Function1<B, Either<String, A>> function12) {
            return Patch$Transform$.MODULE$.apply(patch, function1, function12);
        }

        public static Transform<?, ?> fromProduct(Product product) {
            return Patch$Transform$.MODULE$.fromProduct(product);
        }

        public static <A, B> Transform<A, B> unapply(Transform<A, B> transform) {
            return Patch$Transform$.MODULE$.unapply(transform);
        }

        public Transform(Patch<A> patch, Function1<A, Either<String, B>> f, Function1<B, Either<String, A>> g) {
            this.patch = patch;
            this.f = f;
            this.g = g;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Transform)) return false;
            Transform transform = (Transform)object;
            Patch<A> patch = this.patch();
            Patch<A> patch2 = transform.patch();
            if (patch == null) {
                if (patch2 != null) {
                    return false;
                }
            } else if (!patch.equals(patch2)) return false;
            Function1<A, Either<String, B>> function1 = this.f();
            Function1<A, Either<String, B>> function12 = transform.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<B, Either<String, A>> function13 = this.g();
            Function1<B, Either<String, A>> function14 = transform.g();
            if (function13 == null) {
                if (function14 == null) return true;
                return false;
            } else {
                if (!function13.equals(function14)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Transform;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Transform";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "patch";
                }
                case 1: {
                    return "f";
                }
                case 2: {
                    return "g";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Patch<A> patch() {
            return this.patch;
        }

        public Function1<A, Either<String, B>> f() {
            return this.f;
        }

        public Function1<B, Either<String, A>> g() {
            return this.g;
        }

        @Override
        public boolean isIdentical() {
            return this.patch().isIdentical();
        }

        @Override
        public boolean isComparable() {
            return this.patch().isComparable();
        }

        @Override
        public Either<String, B> patch(B input) {
            return ((Either)this.g().apply(input)).flatMap((Function1 & Serializable)a -> this.patch().patch(a).flatMap((Function1 & Serializable)a1 -> ((Either)this.f().apply(a1)).map((Function1 & Serializable)b -> b)));
        }

        @Override
        public Patch<B> invert() {
            return Patch$Transform$.MODULE$.apply(this.patch().invert(), this.f(), this.g());
        }

        public <A, B> Transform<A, B> copy(Patch<A> patch, Function1<A, Either<String, B>> f, Function1<B, Either<String, A>> g) {
            return new Transform<A, B>(patch, f, g);
        }

        public <A, B> Patch<A> copy$default$1() {
            return this.patch();
        }

        public <A, B> Function1<A, Either<String, B>> copy$default$2() {
            return this.f();
        }

        public <A, B> Function1<B, Either<String, A>> copy$default$3() {
            return this.g();
        }

        public Patch<A> _1() {
            return this.patch();
        }

        public Function1<A, Either<String, B>> _2() {
            return this.f();
        }

        public Function1<B, Either<String, A>> _3() {
            return this.g();
        }
    }

    public static final class Tuple<A, B>
    implements Patch<Tuple2<A, B>>,
    Product,
    Serializable {
        private final Patch leftDifference;
        private final Patch rightDifference;

        public static <A, B> Tuple<A, B> apply(Patch<A> patch, Patch<B> patch2) {
            return Patch$Tuple$.MODULE$.apply(patch, patch2);
        }

        public static Tuple<?, ?> fromProduct(Product product) {
            return Patch$Tuple$.MODULE$.fromProduct(product);
        }

        public static <A, B> Tuple<A, B> unapply(Tuple<A, B> tuple) {
            return Patch$Tuple$.MODULE$.unapply(tuple);
        }

        public Tuple(Patch<A> leftDifference, Patch<B> rightDifference) {
            this.leftDifference = leftDifference;
            this.rightDifference = rightDifference;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Tuple)) return false;
            Tuple tuple = (Tuple)object;
            Patch<A> patch = this.leftDifference();
            Patch<A> patch2 = tuple.leftDifference();
            if (patch == null) {
                if (patch2 != null) {
                    return false;
                }
            } else if (!patch.equals(patch2)) return false;
            Patch<B> patch3 = this.rightDifference();
            Patch<B> patch4 = tuple.rightDifference();
            if (patch3 == null) {
                if (patch4 == null) return true;
                return false;
            } else {
                if (!patch3.equals(patch4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Tuple;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Tuple";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "leftDifference";
            }
            if (1 == n2) {
                return "rightDifference";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Patch<A> leftDifference() {
            return this.leftDifference;
        }

        public Patch<B> rightDifference() {
            return this.rightDifference;
        }

        @Override
        public boolean isIdentical() {
            return this.leftDifference().isIdentical() && this.rightDifference().isIdentical();
        }

        @Override
        public Either<String, Tuple2<A, B>> patch(Tuple2<A, B> input) {
            return this.leftDifference().patch(input._1()).flatMap((Function1 & Serializable)l -> this.rightDifference().patch(input._2()).map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply(l, r)));
        }

        @Override
        public Patch<Tuple2<A, B>> invert() {
            return Patch$Tuple$.MODULE$.apply(this.leftDifference().invert(), this.rightDifference().invert());
        }

        public <A, B> Tuple<A, B> copy(Patch<A> leftDifference, Patch<B> rightDifference) {
            return new Tuple<A, B>(leftDifference, rightDifference);
        }

        public <A, B> Patch<A> copy$default$1() {
            return this.leftDifference();
        }

        public <A, B> Patch<B> copy$default$2() {
            return this.rightDifference();
        }

        public Patch<A> _1() {
            return this.leftDifference();
        }

        public Patch<B> _2() {
            return this.rightDifference();
        }
    }

    public static final class ZonedDateTime
    implements Patch<java.time.ZonedDateTime>,
    Product,
    Serializable {
        private final Patch localDateTimeDiff;
        private final Patch zoneIdDiff;

        public static ZonedDateTime apply(Patch<LocalDateTime> patch, Patch<String> patch2) {
            return Patch$ZonedDateTime$.MODULE$.apply(patch, patch2);
        }

        public static ZonedDateTime fromProduct(Product product) {
            return Patch$ZonedDateTime$.MODULE$.fromProduct(product);
        }

        public static ZonedDateTime unapply(ZonedDateTime zonedDateTime) {
            return Patch$ZonedDateTime$.MODULE$.unapply(zonedDateTime);
        }

        public ZonedDateTime(Patch<LocalDateTime> localDateTimeDiff, Patch<String> zoneIdDiff) {
            this.localDateTimeDiff = localDateTimeDiff;
            this.zoneIdDiff = zoneIdDiff;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ZonedDateTime)) return false;
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            Patch<LocalDateTime> patch = this.localDateTimeDiff();
            Patch<LocalDateTime> patch2 = zonedDateTime.localDateTimeDiff();
            if (patch == null) {
                if (patch2 != null) {
                    return false;
                }
            } else if (!patch.equals(patch2)) return false;
            Patch<String> patch3 = this.zoneIdDiff();
            Patch<String> patch4 = zonedDateTime.zoneIdDiff();
            if (patch3 == null) {
                if (patch4 == null) return true;
                return false;
            } else {
                if (!patch3.equals(patch4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ZonedDateTime;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ZonedDateTime";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localDateTimeDiff";
            }
            if (1 == n2) {
                return "zoneIdDiff";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Patch<LocalDateTime> localDateTimeDiff() {
            return this.localDateTimeDiff;
        }

        public Patch<String> zoneIdDiff() {
            return this.zoneIdDiff;
        }

        @Override
        public Either<String, java.time.ZonedDateTime> patch(java.time.ZonedDateTime input) {
            return this.localDateTimeDiff().patch(input.toLocalDateTime()).flatMap((Function1 & Serializable)patchedLocalDateTime -> this.zoneIdDiff().patch(input.getZone().getId()).flatMap((Function1 & Serializable)patchedZoneId -> this.liftedTree1$1((LocalDateTime)patchedLocalDateTime, (String)patchedZoneId).map((Function1 & Serializable)patched -> patched)));
        }

        @Override
        public Patch<java.time.ZonedDateTime> invert() {
            return Patch$ZonedDateTime$.MODULE$.apply(this.localDateTimeDiff().invert(), this.zoneIdDiff().invert());
        }

        public ZonedDateTime copy(Patch<LocalDateTime> localDateTimeDiff, Patch<String> zoneIdDiff) {
            return new ZonedDateTime(localDateTimeDiff, zoneIdDiff);
        }

        public Patch<LocalDateTime> copy$default$1() {
            return this.localDateTimeDiff();
        }

        public Patch<String> copy$default$2() {
            return this.zoneIdDiff();
        }

        public Patch<LocalDateTime> _1() {
            return this.localDateTimeDiff();
        }

        public Patch<String> _2() {
            return this.zoneIdDiff();
        }

        private final Either liftedTree1$1(LocalDateTime patchedLocalDateTime$2, String patchedZoneId$1) {
            Right right;
            try {
                right = package$.MODULE$.Right().apply((Object)java.time.ZonedDateTime.of(patchedLocalDateTime$2, ZoneId.of(patchedZoneId$1)));
            }
            catch (Throwable e) {
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("Patched ZonedDateTime is not valid. Patched values ").append(patchedLocalDateTime$2).append(", ").append(patchedZoneId$1).append(". Error=").append(e.getMessage()).toString());
            }
            return right;
        }
    }
}

