/*
 * Decompiled with CFR 0.152.
 */
package zio.stream;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.time.Duration;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.Clock$;
import zio.Duration;
import zio.Duration$;
import zio.DurationOps$;
import zio.Exit;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Random$;
import zio.Schedule;
import zio.Scope;
import zio.ZIO;
import zio.ZIO$;
import zio.Zippable$;
import zio.internal.SingleThreadedRingBuffer;
import zio.package$;
import zio.stream.Take;
import zio.stream.ZChannel;
import zio.stream.ZChannel$;
import zio.stream.ZChannel$UnwrapScopedPartiallyApplied$;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$EnvironmentWithPipelinePartiallyApplied$;
import zio.stream.ZPipeline$ServiceWithPipelinePartiallyApplied$;
import zio.stream.ZPipeline$UnwrapScopedPartiallyApplied$;
import zio.stream.ZPipelinePlatformSpecificConstructors;
import zio.stream.ZSink;
import zio.stream.ZStream;
import zio.stream.compression.CompressionException;
import zio.stream.compression.CompressionLevel;
import zio.stream.compression.CompressionStrategy;
import zio.stream.compression.FlushMode;
import zio.stream.encoding.EncodingException;
import zio.stream.encoding.EncodingException$;
import zio.stream.internal.CharacterSet$;
import zio.stream.internal.CharacterSet$BOM$;

public final class ZPipeline$
implements ZPipelinePlatformSpecificConstructors {
    public static final ZPipeline$ MODULE$ = new ZPipeline$();

    static {
        ZPipelinePlatformSpecificConstructors.$init$(MODULE$);
    }

    @Override
    public ZPipeline<Object, Nothing$, Object, Object> deflate(Function0<Object> bufferSize, Function0<Object> noWrap, Function0<CompressionLevel> level, Function0<CompressionStrategy> strategy, Function0<FlushMode> flushMode, Object trace) {
        return ZPipelinePlatformSpecificConstructors.deflate$(this, bufferSize, noWrap, level, strategy, flushMode, trace);
    }

    @Override
    public int deflate$default$1() {
        return ZPipelinePlatformSpecificConstructors.deflate$default$1$(this);
    }

    @Override
    public boolean deflate$default$2() {
        return ZPipelinePlatformSpecificConstructors.deflate$default$2$(this);
    }

    @Override
    public CompressionLevel deflate$default$3() {
        return ZPipelinePlatformSpecificConstructors.deflate$default$3$(this);
    }

    @Override
    public CompressionStrategy deflate$default$4() {
        return ZPipelinePlatformSpecificConstructors.deflate$default$4$(this);
    }

    @Override
    public FlushMode deflate$default$5() {
        return ZPipelinePlatformSpecificConstructors.deflate$default$5$(this);
    }

    @Override
    public ZPipeline<Object, CompressionException, Object, Object> inflate(Function0<Object> bufferSize, Function0<Object> noWrap, Object trace) {
        return ZPipelinePlatformSpecificConstructors.inflate$(this, bufferSize, noWrap, trace);
    }

    @Override
    public int inflate$default$1() {
        return ZPipelinePlatformSpecificConstructors.inflate$default$1$(this);
    }

    @Override
    public boolean inflate$default$2() {
        return ZPipelinePlatformSpecificConstructors.inflate$default$2$(this);
    }

    @Override
    public ZPipeline<Object, Nothing$, Object, Object> gzip(Function0<Object> bufferSize, Function0<CompressionLevel> level, Function0<CompressionStrategy> strategy, Function0<FlushMode> flushMode, Object trace) {
        return ZPipelinePlatformSpecificConstructors.gzip$(this, bufferSize, level, strategy, flushMode, trace);
    }

    @Override
    public int gzip$default$1() {
        return ZPipelinePlatformSpecificConstructors.gzip$default$1$(this);
    }

    @Override
    public CompressionLevel gzip$default$2() {
        return ZPipelinePlatformSpecificConstructors.gzip$default$2$(this);
    }

    @Override
    public CompressionStrategy gzip$default$3() {
        return ZPipelinePlatformSpecificConstructors.gzip$default$3$(this);
    }

    @Override
    public FlushMode gzip$default$4() {
        return ZPipelinePlatformSpecificConstructors.gzip$default$4$(this);
    }

    @Override
    public <Env> ZPipeline<Object, CompressionException, Object, Object> gunzip(Function0<Object> bufferSize, Object trace) {
        return ZPipelinePlatformSpecificConstructors.gunzip$(this, bufferSize, trace);
    }

    @Override
    public <Env> int gunzip$default$1() {
        return ZPipelinePlatformSpecificConstructors.gunzip$default$1$(this);
    }

    @Override
    public <Env> ZPipeline<Object, CompressionException, Object, Object> gunzipAuto(Function0<Object> bufferSize, Object trace) {
        return ZPipelinePlatformSpecificConstructors.gunzipAuto$(this, bufferSize, trace);
    }

    @Override
    public <Env> int gunzipAuto$default$1() {
        return ZPipelinePlatformSpecificConstructors.gunzipAuto$default$1$(this);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> aggregateAsync(Function0<ZSink<Env, Err, In, In, Out>> sink, Object trace) {
        return this.fromFunction((Function1 & Serializable)x$2 -> x$2.aggregateAsync(sink, trace), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> aggregateAsyncWithin(Function0<ZSink<Env, Err, In, In, Out>> sink, Function0<Schedule<Env, Option<Out>, Object>> schedule2, Object trace) {
        return this.fromFunction((Function1 & Serializable)x$3 -> x$3.aggregateAsyncWithin(sink, schedule2, trace), trace);
    }

    public <Env, Err, In, Out, Out2> ZPipeline<Env, Err, In, Either<Out2, Out>> aggregateAsyncWithinEither(Function0<ZSink<Env, Err, In, In, Out>> sink, Function0<Schedule<Env, Option<Out>, Out2>> schedule2, Object trace) {
        return this.fromFunction((Function1 & Serializable)x$4 -> x$4.aggregateAsyncWithinEither(sink, schedule2, trace), trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, In> apply(Object trace) {
        return this.identity(trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, In> append(Function0<Chunk<In>> values, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.write(values.apply(), trace), trace));
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> branchAfter(Function0<Object> n, Function1<Chunk<In>, ZPipeline<Env, Err, In, Out>> f, Object trace) {
        return this.suspend((Function0 & Serializable)() -> MODULE$.fromChannel((Function0 & Serializable)() -> ZPipeline$.bufferring$1(Chunk$.MODULE$.empty(), n, trace, f)));
    }

    public <Err, In> ZPipeline<Object, Err, In, In> changes(Object trace) {
        return this.changesWith((Function2 & Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean((boolean)ZPipeline$.$anonfun$changes$2(x$6, x$7)), trace);
    }

    public <Err, In> ZPipeline<Object, Err, In, In> changesWith(Function2<In, In, Object> f, Object trace) {
        return new ZPipeline(ZPipeline$.writer$1((Option)None$.MODULE$, f, trace));
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> changesWithZIO(Function2<In, In, ZIO<Env, Err, Object>> f, Object trace) {
        return new ZPipeline(ZPipeline$.writer$2((Option)None$.MODULE$, f, trace));
    }

    public <In> ZPipeline<Object, Nothing$, In, Chunk<In>> chunks(Object trace) {
        return this.mapChunks((Function1 & Serializable)x$11 -> Chunk$.MODULE$.single(x$11), trace);
    }

    public <In, Out> ZPipeline<Object, Nothing$, In, Out> collect(PartialFunction<In, Out> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).mapOut((Function1 & Serializable)x$12 -> x$12.collect(f), trace));
    }

    public <Err, A, B> ZPipeline<Object, Err, Either<A, B>, A> collectLeft(Object trace) {
        return this.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<A, B>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Left) {
                    return (B1)((Left)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Either<A, B> x1) {
                return x1 instanceof Left;
            }
        }, trace);
    }

    public <Err, A> ZPipeline<Object, Err, Option<A>, A> collectSome(Object trace) {
        return this.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Some) {
                    return (B1)((Some)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<A> x1) {
                return x1 instanceof Some;
            }
        }, trace);
    }

    public <A, B> ZPipeline<Object, Nothing$, Exit<B, A>, A> collectSuccess(Object trace) {
        return this.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Exit<B, A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Exit.Success) {
                    return (B1)((Exit.Success)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Exit<B, A> x1) {
                return x1 instanceof Exit.Success;
            }
        }, trace);
    }

    public <Err, A, B> ZPipeline<Object, Err, Either<A, B>, B> collectRight(Object trace) {
        return this.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<A, B>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Right) {
                    return (B1)((Right)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Either<A, B> x1) {
                return x1 instanceof Right;
            }
        }, trace);
    }

    public <Err, In, Out> ZPipeline<Object, Err, In, Out> collectWhile(PartialFunction<In, Out> pf, Object trace) {
        LazyRef loop$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.loop$1(loop$lzy, pf, trace));
    }

    public <Err, A, B> ZPipeline<Object, Err, Either<A, B>, A> collectWhileLeft(Object trace) {
        return this.collectWhile((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<A, B>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Left) {
                    return (B1)((Left)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Either<A, B> x1) {
                return x1 instanceof Left;
            }
        }, trace);
    }

    public <Err, A, B> ZPipeline<Object, Err, Either<A, B>, B> collectWhileRight(Object trace) {
        return this.collectWhile((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<A, B>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Right) {
                    return (B1)((Right)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Either<A, B> x1) {
                return x1 instanceof Right;
            }
        }, trace);
    }

    public <Err, A> ZPipeline<Object, Err, Option<A>, A> collectWhileSome(Object trace) {
        return this.collectWhile((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Some) {
                    return (B1)((Some)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<A> x1) {
                return x1 instanceof Some;
            }
        }, trace);
    }

    public <Err, A> ZPipeline<Object, Nothing$, Exit<Err, A>, A> collectWhileSuccess(Object trace) {
        return this.collectWhile((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Exit<Err, A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Exit.Success) {
                    return (B1)((Exit.Success)x1).value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Exit<Err, A> x1) {
                return x1 instanceof Exit.Success;
            }
        }, trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> collectWhileZIO(PartialFunction<In, ZIO<Env, Err, Out>> pf, Object trace) {
        return new ZPipeline(ZPipeline$.loop$2(Chunk.ChunkIterator$.MODULE$.empty(), 0, pf, trace));
    }

    public <Err> ZPipeline<Object, Err, Object, Nothing$> drain(Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).drain(trace));
    }

    public <Err, In> ZPipeline<Object, Err, In, In> dropRight(Function0<Object> n, Object trace) {
        return this.suspend((Function0 & Serializable)() -> {
            if (n.apply$mcI$sp() <= 0) {
                return MODULE$.identity(trace);
            }
            LazyRef reader$lzy = new LazyRef();
            int apply_capacity = n.apply$mcI$sp();
            SingleThreadedRingBuffer queue = new SingleThreadedRingBuffer(apply_capacity);
            return new ZPipeline(ZPipeline$.reader$1(reader$lzy, queue, trace));
        });
    }

    public <In> ZPipeline<Object, Nothing$, In, In> debounce(Function0<Duration> d, Object trace) {
        return this.fromFunction((Function1 & Serializable)x$18 -> x$18.debounce(d, trace), trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> decodeStringWith(Function0<Charset> charset, Object trace) {
        return this.decodeCharsWith(charset, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> MODULE$.decodeCharsWith$default$2(), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.mapChunks((Function1 & Serializable)chars -> Chunk$.MODULE$.single((Object)new String((char[])chars.toArray((ClassTag)ClassTag$.MODULE$.Char()))), trace), trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, Object> decodeCharsWith(Function0<Charset> charset, Function0<Object> bufSize, Object trace) {
        return this.decodeCharsWithDecoder((Function0<CharsetDecoder>)(Function0 & Serializable)() -> ((Charset)charset.apply()).newDecoder(), bufSize, trace);
    }

    public int decodeCharsWith$default$2() {
        return 4096;
    }

    public ZPipeline<Object, CharacterCodingException, Object, Object> decodeCharsWithDecoder(Function0<CharsetDecoder> charsetDecoder, Function0<Object> bufSize, Object trace) {
        return this.suspend((Function0 & Serializable)() -> {
            CharsetDecoder decoder = (CharsetDecoder)charsetDecoder.apply();
            ByteBuffer byteBuffer = ByteBuffer.allocate(bufSize.apply$mcI$sp());
            CharBuffer charBuffer = CharBuffer.allocate(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufSize.apply$mcI$sp() * decoder.averageCharsPerByte())));
            Function1 & Serializable push = (Function1 & Serializable)x0$1 -> {
                if (x0$1 instanceof Some) {
                    return ZPipeline$.decodeChunk$1((Chunk)((Some)x0$1).value(), byteBuffer, trace, decoder, charBuffer);
                }
                if (None$.MODULE$.equals(x0$1)) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> byteBuffer.flip(), trace).flatMap((Function1 & Serializable)x$22 -> ZPipeline$.endOfInput$1(decoder, byteBuffer, charBuffer, trace).flatMap((Function1 & Serializable)decodedChars -> ZPipeline$.flushRemaining$1(decoder, charBuffer, trace, byteBuffer).map((Function1 & Serializable)remainingBytes -> {
                        Chunk result = decodedChars.$plus$plus(remainingBytes);
                        return new Tuple2(remainingBytes, (Object)result);
                    }, trace).flatMap((Function1 & Serializable)x$21 -> {
                        if (x$21 != null) {
                            Chunk result = (Chunk)x$21._2();
                            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                                byteBuffer.clear();
                                return charBuffer.clear();
                            }, trace).map((Function1 & Serializable)x$20 -> result, trace);
                        }
                        throw new MatchError(null);
                    }, trace), trace), trace);
                }
                throw new MatchError(x0$1);
            };
            ZIO createPush = ZIO$.MODULE$.succeed((Function0 & Serializable)() -> decoder.reset(), trace).map((Function1 & Serializable)x$23 -> push, trace);
            return MODULE$.fromPush((Function0 & Serializable)() -> createPush, trace);
        });
    }

    public int decodeCharsWithDecoder$default$2() {
        return 4096;
    }

    public <In> ZPipeline<Object, Nothing$, In, In> drop(Function0<Object> n, Object trace) {
        return this.suspend((Function0 & Serializable)() -> new ZPipeline(ZPipeline$.loop$3(n.apply$mcI$sp(), trace)));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> dropUntil(Function1<In, Object> f, Object trace) {
        return this.dropWhile((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ZPipeline$.$anonfun$dropUntil$2(f, x$25)), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.drop((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> 1, trace), trace);
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> dropUntilZIO(Function1<In, ZIO<Env, Err, Object>> p, Object trace) {
        LazyRef loop$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.loop$4(loop$lzy, p, trace));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> dropWhile(Function1<In, Object> f, Object trace) {
        return new ZPipeline(ZPipeline$.dropWhile$1(f, trace));
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, In> dropWhileZIO(Function1<In, ZIO<Env, Err, Object>> p, Object trace) {
        LazyRef loop$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.loop$5(loop$lzy, p, trace));
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> encodeStringWith(Function0<Charset> charset, Function0<Chunk<Object>> bom, Object trace) {
        ZPipeline<Object, CharacterCodingException, String, Object> withoutBOM = this.mapChunks((Function1 & Serializable)s -> (Chunk)s.foldLeft((Object)Chunk$.MODULE$.empty(), (Function2 & Serializable)(acc, str) -> acc.$plus$plus(Chunk$.MODULE$.fromArray((Object)str.toCharArray()))), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.encodeCharsWith(charset, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> MODULE$.encodeCharsWith$default$2(), trace), trace);
        if (((Chunk)bom.apply()).isEmpty()) {
            return withoutBOM;
        }
        return this.fromChannel((Function0 & Serializable)() -> ZChannel$.MODULE$.write(bom.apply(), trace).$times$greater((Function0 & Serializable)() -> withoutBOM.channel(), trace));
    }

    public Chunk<Object> encodeStringWith$default$2() {
        return Chunk$.MODULE$.empty();
    }

    public ZPipeline<Object, CharacterCodingException, Object, Object> encodeCharsWith(Function0<Charset> charset, Function0<Object> bufferSize, Object trace) {
        return this.suspend((Function0 & Serializable)() -> {
            CharsetEncoder encoder = ((Charset)charset.apply()).newEncoder();
            CharBuffer charBuffer = CharBuffer.allocate(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufferSize.apply$mcI$sp() / encoder.averageBytesPerChar())));
            ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize.apply$mcI$sp());
            Function1 & Serializable push = (Function1 & Serializable)x0$1 -> {
                Chunk inChunk;
                if (x0$1 instanceof Some && (inChunk = (Chunk)((Some)x0$1).value()) != null) {
                    return ZPipeline$.encodeChunk$1(inChunk, charBuffer, trace, encoder, byteBuffer);
                }
                if (None$.MODULE$.equals(x0$1)) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> charBuffer.flip(), trace).flatMap((Function1 & Serializable)x$31 -> ZPipeline$.endOfInput$2(encoder, charBuffer, byteBuffer, trace).flatMap((Function1 & Serializable)encodedBytes -> ZPipeline$.flushRemaining$2(encoder, byteBuffer, trace, charBuffer).map((Function1 & Serializable)remainingBytes -> {
                        Chunk result = encodedBytes.$plus$plus(remainingBytes);
                        return new Tuple2(remainingBytes, (Object)result);
                    }, trace).flatMap((Function1 & Serializable)x$30 -> {
                        if (x$30 != null) {
                            Chunk result = (Chunk)x$30._2();
                            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                                charBuffer.clear();
                                return byteBuffer.clear();
                            }, trace).map((Function1 & Serializable)x$29 -> result, trace);
                        }
                        throw new MatchError(null);
                    }, trace), trace), trace);
                }
                throw new MatchError(x0$1);
            };
            ZIO createPush = ZIO$.MODULE$.succeed((Function0 & Serializable)() -> encoder.reset(), trace).map((Function1 & Serializable)x$32 -> push, trace);
            return MODULE$.fromPush((Function0 & Serializable)() -> createPush, trace);
        });
    }

    public int encodeCharsWith$default$2() {
        return 4096;
    }

    public <Env> boolean environmentWithPipeline() {
        return ZPipeline$EnvironmentWithPipelinePartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    public <In> ZPipeline<Object, Nothing$, In, In> filter(Function1<In, Object> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).mapOut((Function1 & Serializable)x$33 -> x$33.filter(f), trace));
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> filterZIO(Function1<In, ZIO<Env, Err, Object>> f, Object trace) {
        return this.mapChunksZIO((Function1 & Serializable)x$34 -> x$34.filterZIO(f, trace), trace);
    }

    public <In> ZPipeline<Object, Nothing$, Chunk<In>, In> flattenChunks(Object trace) {
        return this.mapChunks((Function1 & Serializable)x$35 -> x$35.flatten(Predef$.MODULE$.$conforms()), trace);
    }

    public <Err, Out> ZPipeline<Object, Err, Exit<Err, Out>, Out> flattenExit(Object trace) {
        return this.mapZIO((Function1 & Serializable)x$36 -> ZIO$.MODULE$.done((Function0 & Serializable)() -> x$36, trace), trace);
    }

    public <Out> ZPipeline<Object, Nothing$, Iterable<Out>, Out> flattenIterables(Object trace) {
        return this.mapChunks((Function1 & Serializable)x$37 -> x$37.flatMap((Function1 & Serializable)it -> Chunk$.MODULE$.fromIterable(it)), trace);
    }

    public <Env, Err, Out> ZPipeline<Env, Err, ZStream<Env, Err, Out>, Out> flattenStreamsPar(Function0<Object> n, Function0<Object> outputBuffer, Object trace) {
        ZChannel qual$1 = ZChannel$.MODULE$.identity(trace).concatMap((Function1 & Serializable)x$38 -> ZChannel$.MODULE$.writeChunk(x$38, trace), trace);
        Function0 & Serializable x$3 = (Function0 & Serializable)() -> qual$1.mergeMap$default$3();
        Function1 & Serializable x$4 = (Function1 & Serializable)x$39 -> x$39.channel();
        return new ZPipeline(qual$1.mergeMap(n, outputBuffer, (Function0<ZChannel.MergeStrategy>)x$3, x$4, trace));
    }

    public <Env, Err, Out> int flattenStreamsPar$default$2() {
        return 16;
    }

    public <Err, Out> ZPipeline<Object, Err, Take<Err, Out>, Out> flattenTake(Object trace) {
        LazyRef channel$lzy = new LazyRef();
        return this.fromChannel((Function0 & Serializable)() -> ZPipeline$.channel$1(channel$lzy, trace));
    }

    public <In, Key> ZPipeline<Object, Nothing$, In, Tuple2<Key, NonEmptyChunk<In>>> groupAdjacentBy(Function1<In, Key> f, Object trace) {
        return this.fromChannel((Function0 & Serializable)() -> ZPipeline$.groupAdjacentBy$1((Option)None$.MODULE$, trace, f));
    }

    public <In> ZPipeline<Object, Nothing$, In, Chunk<In>> grouped(Function0<Object> chunkSize, Object trace) {
        return this.rechunk(chunkSize, trace).chunks(trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, Chunk<In>> groupedWithin(Function0<Object> chunkSize, Function0<Duration> within, Object trace) {
        return this.fromFunction((Function1 & Serializable)x$41 -> x$41.groupedWithin(chunkSize, within, trace), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> fromChannel(Function0<ZChannel<Env, Nothing$, Chunk<In>, Object, Err, Chunk<Out>, Object>> channel) {
        return new ZPipeline((ZChannel)channel.apply());
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> fromFunction(Function1<ZStream<Object, Nothing$, In>, ZStream<Env, Err, Out>> f, Object trace) {
        return new ZChannel.DeferedUpstream((Function1 & Serializable)upstream -> ZPipeline$.fc$1(upstream, f, trace)).toPipeline($less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl(), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> fromPush(Function0<ZIO<Scope, Nothing$, Function1<Option<Chunk<In>>, ZIO<Env, Err, Chunk<Out>>>>> push, Object trace) {
        ZChannel channel = ZChannel$UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(ZChannel$.MODULE$.unwrapScoped(), (Function0 & Serializable)() -> ((ZIO)push.apply()).map((Function1 & Serializable)push -> ZPipeline$.pull$1(push, trace), trace), trace);
        return new ZPipeline(channel);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> fromSink(Function0<ZSink<Env, Err, In, In, Out>> sink, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.suspend((Function0 & Serializable)() -> {
            LazyRef upstream$lzy = new LazyRef();
            LazyRef writeDone$lzy = new LazyRef();
            LazyRef transducer$lzy = new LazyRef();
            ObjectRef leftover = ObjectRef.create((Object)Chunk$.MODULE$.empty());
            BooleanRef upstreamDone = BooleanRef.create((boolean)false);
            return ZPipeline$.upstream$1(upstream$lzy, leftover, trace, upstreamDone).pipeToOrFail((Function0 & Serializable)() -> ZPipeline$.transducer$1(transducer$lzy, sink, trace, upstreamDone, leftover, writeDone$lzy), trace);
        }));
    }

    public ZPipeline<Object, EncodingException, Object, Object> hexDecode(Object trace) {
        return this.fromChannel((Function0 & Serializable)() -> ZPipeline$.decodeChannel$1(Chunk$.MODULE$.empty(), trace));
    }

    public ZPipeline<Object, Nothing$, Object, Object> hexEncode(Object trace) {
        char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        return this.fromPush((Function0 & Serializable)() -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> (Function1 & Serializable)inChunkOpt -> {
            if (None$.MODULE$.equals(inChunkOpt)) {
                return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace);
            }
            if (inChunkOpt instanceof Some) {
                Chunk bs = (Chunk)((Some)inChunkOpt).value();
                return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                    ChunkBuilder out = ChunkBuilder$.MODULE$.make(bs.size() * 2);
                    bs.foreach((Function1 & Serializable)b -> ZPipeline$.$anonfun$hexEncode$6(out, DIGITS, BoxesRunTime.unboxToByte((Object)b)));
                    return (Chunk)out.result();
                }, trace);
            }
            throw new MatchError(inChunkOpt);
        }, trace), trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, In> identity(Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace));
    }

    public <Err, In> ZPipeline<Object, Err, In, In> intersperse(Function0<In> middle, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.suspend((Function0 & Serializable)() -> ZPipeline$.writer$3(true, middle, trace)));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> intersperse(Function0<In> start, Function0<In> middle, Function0<In> end, Object trace) {
        return this.prepend((Function0 & Serializable)() -> Chunk$.MODULE$.single(start.apply()), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.intersperse(middle, trace), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.append((Function0 & Serializable)() -> Chunk$.MODULE$.single(end.apply()), trace), trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> iso_8859_1Decode(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.ISO_8859_1, trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> iso_8859_1Encode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.ISO_8859_1, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public <In, Out> ZPipeline<Object, Nothing$, In, Out> map(Function1<In, Out> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).mapOut((Function1 & Serializable)x$46 -> x$46.map(f), trace));
    }

    public <In, State, Out> ZPipeline<Object, Nothing$, In, Out> mapAccum(Function0<State> s2, Function2<State, In, Tuple2<State, Out>> f, Object trace) {
        return this.mapAccumZIO(s2, (Function2 & Serializable)(s, in) -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> (Tuple2)f.apply(s, in), trace), trace);
    }

    public <Env, Err, In, State, Out> ZPipeline<Env, Err, In, Out> mapAccumZIO(Function0<State> s, Function2<State, In, ZIO<Env, Err, Tuple2<State, Out>>> f, Object trace) {
        return this.suspend((Function0 & Serializable)() -> new ZPipeline(ZPipeline$.accumulator$1(s.apply(), trace, f)));
    }

    public <In, Out> ZPipeline<Object, Nothing$, In, Out> mapChunks(Function1<Chunk<In>, Chunk<Out>> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).mapOut(f, trace));
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapChunksZIO(Function1<Chunk<In>, ZIO<Env, Err, Chunk<Out>>> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).mapOutZIO(f, trace));
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapStream(Function1<In, ZStream<Env, Err, Out>> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).concatMap((Function1 & Serializable)x$48 -> (ZChannel)x$48.map(f).map((Function1 & Serializable)x$49 -> x$49.channel()).fold(ZChannel$.MODULE$.unit(), (Function2 & Serializable)(x$50, x$51) -> x$50.$times$greater((Function0 & Serializable)() -> x$51, trace)), trace));
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapZIO(Function1<In, ZIO<Env, Err, Out>> f, Object trace) {
        return new ZPipeline(ZPipeline$.loop$6(Chunk.ChunkIterator$.MODULE$.empty(), 0, f, trace));
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapZIOPar(Function0<Object> n, Function1<In, ZIO<Env, Err, Out>> f, Object trace) {
        return this.fromFunction((Function1 & Serializable)strm -> strm.mapZIOPar(n, f, trace), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapZIOPar(Function0<Object> n, Function0<Object> bufferSize, Function1<In, ZIO<Env, Err, Out>> f, Object trace) {
        return this.fromFunction((Function1 & Serializable)strm -> strm.mapZIOPar(n, bufferSize.apply$mcI$sp(), f, trace), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapZIOParUnordered(Function0<Object> n, Function1<In, ZIO<Env, Err, Out>> f, Object trace) {
        return this.fromFunction((Function1 & Serializable)strm -> strm.mapZIOParUnordered(n, f, trace), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> mapZIOParUnordered(Function0<Object> n, Function0<Object> bufferSize, Function1<In, ZIO<Env, Err, Out>> f, Object trace) {
        return this.fromFunction((Function1 & Serializable)strm -> strm.mapZIOParUnordered(n, bufferSize, f, trace), trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, In> prepend(Function0<Chunk<In>> values, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.write(values.apply(), trace).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace), trace));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> rechunk(Function0<Object> n, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> new ZStream.Rechunker(scala.math.package$.MODULE$.max(n.apply$mcI$sp(), 1)), trace).flatMap((Function1 & Serializable)rechunker -> ZPipeline$.loop$7(new LazyRef(), rechunker, trace), trace));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> sample(Function0<Object> p, Object trace) {
        double clamped = Double.isNaN(p.apply$mcD$sp()) || p.apply$mcD$sp() < 0.0 ? 0.0 : (p.apply$mcD$sp() > 1.0 ? 1.0 : p.apply$mcD$sp());
        ZChannel channel = ZChannel$.MODULE$.identity(trace).mapOutZIO((Function1 & Serializable)x$53 -> x$53.filterZIO((Function1 & Serializable)x$54 -> Random$.MODULE$.nextDoubleBetween((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, trace).map((Function1)(JFunction1.mcZD.sp & Serializable)x$55 -> x$55 < clamped, trace), trace), trace);
        return this.fromChannel((Function0 & Serializable)() -> channel);
    }

    public <In, Out> ZPipeline<Object, Nothing$, In, Out> scan(Function0<Out> s, Function2<Out, In, Out> f, Object trace) {
        return this.scanZIO(s, (Function2 & Serializable)(out, in) -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> f.apply(out, in), trace), trace);
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> scanZIO(Function0<Out> s, Function2<Out, In, ZIO<Env, Err, Out>> f, Object trace) {
        return this.suspend((Function0 & Serializable)() -> new ZPipeline(ZChannel$.MODULE$.write(Chunk$.MODULE$.single(s.apply()), trace).$times$greater((Function0 & Serializable)() -> MODULE$.mapAccumZIO(s, (Function2 & Serializable)(s2, a) -> ((ZIO)f.apply(s2, a)).map((Function1 & Serializable)s -> new Tuple2(s, s), trace), trace).channel(), trace)));
    }

    public <Service> boolean serviceWithPipeline() {
        return ZPipeline$ServiceWithPipelinePartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    public ZPipeline<Object, Nothing$, String, String> splitOn(Function0<String> delimiter, Object trace) {
        return this.mapChunks((Function1 & Serializable)x$56 -> x$56.flatMap((Function1 & Serializable)string -> Chunk$.MODULE$.fromArray(StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(string), (ClassTag)ClassTag$.MODULE$.Char()))), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.splitOnChunk((Function0 & Serializable)() -> Chunk$.MODULE$.fromArray(StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString((String)delimiter.apply()), (ClassTag)ClassTag$.MODULE$.Char())), trace), trace).$greater$greater$greater((Function0 & Serializable)() -> MODULE$.mapChunks((Function1 & Serializable)chunk -> Chunk$.MODULE$.single((Object)chunk.mkString("")), trace), trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, In> splitOnChunk(Function0<Chunk<In>> delimiter, Object trace) {
        return this.suspend((Function0 & Serializable)() -> new ZPipeline(ZPipeline$.next$1((Option)None$.MODULE$, 0, delimiter, trace)));
    }

    public ZPipeline<Object, Nothing$, String, String> splitLines(Object trace) {
        return this.suspend((Function0 & Serializable)() -> {
            LazyRef loop$lzy = new LazyRef();
            StringBuilder stringBuilder = new StringBuilder();
            BooleanRef midCRLF = BooleanRef.create((boolean)false);
            return new ZPipeline(ZPipeline$.loop$8(loop$lzy, trace, stringBuilder, midCRLF));
        });
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> suspend(Function0<ZPipeline<Env, Err, In, Out>> pipeline) {
        return new ZPipeline(ZChannel$.MODULE$.suspend((Function0 & Serializable)() -> ((ZPipeline)pipeline.apply()).channel()));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> take(Function0<Object> n, Object trace) {
        return this.suspend((Function0 & Serializable)() -> new ZPipeline(0L < n.apply$mcJ$sp() ? ZPipeline$.loop$9(n.apply$mcJ$sp(), trace) : ZChannel$.MODULE$.unit()));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> takeUntil(Function1<In, Object> f, Object trace) {
        LazyRef loop$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.loop$10(loop$lzy, f, trace));
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> takeUntilZIO(Function1<In, ZIO<Env, Err, Object>> f, Object trace) {
        LazyRef read$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.read$1(read$lzy, trace, f));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> takeWhile(Function1<In, Object> f, Object trace) {
        LazyRef loop$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.loop$11(loop$lzy, f, trace));
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> takeWhileZIO(Function1<In, ZIO<Env, Err, Object>> f, Object trace) {
        LazyRef read$lzy = new LazyRef();
        return new ZPipeline(ZPipeline$.read$2(read$lzy, trace, f));
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> tap(Function1<In, ZIO<Env, Err, Object>> f, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.identity(trace).mapOutZIO((Function1 & Serializable)x$61 -> x$61.mapZIO((Function1 & Serializable)in -> ((ZIO)f.apply(in)).as((Function0 & Serializable)() -> in, trace), trace), trace));
    }

    public <In> ZPipeline<Object, Nothing$, In, In> throttleEnforce(long units, Function0<Duration> duration, Function0<Object> burst, Function1<Chunk<In>, Object> costFn, Object trace) {
        return this.throttleEnforceZIO((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> units, duration, burst, costFn.andThen((Function1 & Serializable)x$62 -> ZIO$.MODULE$.succeed((Function0)(JFunction0.mcJ.sp & Serializable)() -> x$62, trace)), trace);
    }

    public <In> long throttleEnforce$default$3() {
        return 0L;
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> throttleEnforceZIO(Function0<Object> units, Function0<Duration> duration, Function0<Object> burst, Function1<Chunk<In>, ZIO<Env, Err, Object>> costFn, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> new Tuple3((Object)BoxesRunTime.boxToLong((long)units.apply$mcJ$sp()), duration.apply(), (Object)BoxesRunTime.boxToLong((long)burst.apply$mcJ$sp())), trace).flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long units = BoxesRunTime.unboxToLong((Object)x0$1._1());
                Duration duration = (Duration)x0$1._2();
                long burst = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> Clock$.MODULE$.nanoTime(trace).map((Function1 & Serializable)x$64 -> ZPipeline$.loop$12(units, BoxesRunTime.unboxToLong((Object)x$64), costFn, trace, duration, units, burst), trace), trace);
            }
            throw new MatchError(null);
        }, trace));
    }

    public <Env, Err, In> long throttleEnforceZIO$default$3() {
        return 0L;
    }

    public <In> ZPipeline<Object, Nothing$, In, In> throttleShape(Function0<Object> units, Function0<Duration> duration, long burst, Function1<Chunk<In>, Object> costFn, Object trace) {
        return this.throttleShapeZIO(units, duration, (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> burst, costFn.andThen((Function1 & Serializable)x$65 -> ZIO$.MODULE$.succeed((Function0)(JFunction0.mcJ.sp & Serializable)() -> x$65, trace)), trace);
    }

    public <In> long throttleShape$default$3() {
        return 0L;
    }

    public <Env, Err, In> ZPipeline<Env, Err, In, In> throttleShapeZIO(Function0<Object> units, Function0<Duration> duration, Function0<Object> burst, Function1<Chunk<In>, ZIO<Env, Err, Object>> costFn, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> new Tuple3((Object)BoxesRunTime.boxToLong((long)units.apply$mcJ$sp()), duration.apply(), (Object)BoxesRunTime.boxToLong((long)burst.apply$mcJ$sp())), trace).flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long units = BoxesRunTime.unboxToLong((Object)x0$1._1());
                Duration duration = (Duration)x0$1._2();
                long burst = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> Clock$.MODULE$.nanoTime(trace).map((Function1 & Serializable)x$67 -> ZPipeline$.loop$13(units, BoxesRunTime.unboxToLong((Object)x$67), costFn, trace, duration, units, burst), trace), trace);
            }
            throw new MatchError(null);
        }, trace));
    }

    public <Env, Err, In> long throttleShapeZIO$default$3() {
        return 0L;
    }

    public <Env, Err, In, Out> ZPipeline<Env, Err, In, Out> unwrap(ZIO<Env, Err, ZPipeline<Env, Err, In, Out>> zio, Object trace) {
        return new ZPipeline(ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> zio.map((Function1 & Serializable)x$68 -> x$68.channel(), trace), trace));
    }

    public <Env> boolean unwrapScoped() {
        return ZPipeline$UnwrapScopedPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> usASCIIDecode(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.US_ASCII, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utfDecode(Object trace) {
        return this.utfDecodeDetectingBom((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> 4, (Function1<Chunk<Object>, Tuple2<Chunk<Object>, ZPipeline<Object, CharacterCodingException, Object, String>>>)(Function1 & Serializable)x0$1 -> {
            Chunk<Object> chunk = CharacterSet$BOM$.MODULE$.Utf32BE();
            if (!(chunk != null ? !chunk.equals(x0$1) : x0$1 != null) && Charset.isSupported(CharacterSet$.MODULE$.CharsetUtf32BE().name())) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf32BEDecode(trace));
            }
            Chunk<Object> chunk2 = CharacterSet$BOM$.MODULE$.Utf32LE();
            if (!(chunk2 != null ? !chunk2.equals(x0$1) : x0$1 != null) && Charset.isSupported(CharacterSet$.MODULE$.CharsetUtf32LE().name())) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf32LEDecode(trace));
            }
            Chunk chunk3 = x0$1.take(3);
            Chunk<Object> chunk4 = CharacterSet$BOM$.MODULE$.Utf8();
            if (!(chunk3 != null ? !chunk3.equals(chunk4) : chunk4 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x0$1.drop(3)), MODULE$.utf8DecodeNoBom(trace));
            }
            Chunk chunk5 = x0$1.take(2);
            Chunk<Object> chunk6 = CharacterSet$BOM$.MODULE$.Utf16BE();
            if (!(chunk5 != null ? !chunk5.equals(chunk6) : chunk6 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x0$1.drop(2)), MODULE$.utf16BEDecode(trace));
            }
            Chunk chunk7 = x0$1.take(2);
            Chunk<Object> chunk8 = CharacterSet$BOM$.MODULE$.Utf16LE();
            if (!(chunk7 != null ? !chunk7.equals(chunk8) : chunk8 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x0$1.drop(2)), MODULE$.utf16LEDecode(trace));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf8DecodeNoBom(trace));
        }, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf8Decode(Object trace) {
        return this.utfDecodeDetectingBom((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> 3, (Function1<Chunk<Object>, Tuple2<Chunk<Object>, ZPipeline<Object, CharacterCodingException, Object, String>>>)(Function1 & Serializable)x0$1 -> {
            Chunk<Object> chunk = CharacterSet$BOM$.MODULE$.Utf8();
            if (!(chunk != null ? !chunk.equals(x0$1) : x0$1 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Chunk$.MODULE$.empty()), MODULE$.utf8DecodeNoBom(trace));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf8DecodeNoBom(trace));
        }, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf16Decode(Object trace) {
        return this.utfDecodeDetectingBom((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> 2, (Function1<Chunk<Object>, Tuple2<Chunk<Object>, ZPipeline<Object, CharacterCodingException, Object, String>>>)(Function1 & Serializable)x0$1 -> {
            Chunk<Object> chunk = CharacterSet$BOM$.MODULE$.Utf16BE();
            if (!(chunk != null ? !chunk.equals(x0$1) : x0$1 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Chunk$.MODULE$.empty()), MODULE$.utf16BEDecode(trace));
            }
            Chunk<Object> chunk2 = CharacterSet$BOM$.MODULE$.Utf16LE();
            if (!(chunk2 != null ? !chunk2.equals(x0$1) : x0$1 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Chunk$.MODULE$.empty()), MODULE$.utf16LEDecode(trace));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf16BEDecode(trace));
        }, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf16BEDecode(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_16BE, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf16LEDecode(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_16LE, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf32Decode(Object trace) {
        return this.utfDecodeDetectingBom((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> 4, (Function1<Chunk<Object>, Tuple2<Chunk<Object>, ZPipeline<Object, CharacterCodingException, Object, String>>>)(Function1 & Serializable)x0$1 -> {
            Chunk<Object> chunk = CharacterSet$BOM$.MODULE$.Utf32LE();
            if (!(chunk != null ? !chunk.equals(x0$1) : x0$1 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf32LEDecode(trace));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x0$1), MODULE$.utf32BEDecode(trace));
        }, trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf32BEDecode(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> CharacterSet$.MODULE$.CharsetUtf32BE(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, Object, String> utf32LEDecode(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> CharacterSet$.MODULE$.CharsetUtf32LE(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> usASCIIEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.US_ASCII, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf8Encode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_8, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf8WithBomEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_8, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> CharacterSet$BOM$.MODULE$.Utf8(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf16BEEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_16BE, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf16BEWithBomEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_16BE, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> CharacterSet$BOM$.MODULE$.Utf16BE(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf16LEEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_16LE, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf16LEWithBomEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_16LE, (Function0<Chunk<Object>>)(Function0 & Serializable)() -> CharacterSet$BOM$.MODULE$.Utf16LE(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf16Encode(Object trace) {
        return this.utf16BEWithBomEncode(trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf16WithBomEncode(Object trace) {
        return this.utf16BEWithBomEncode(trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf32BEEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> CharacterSet$.MODULE$.CharsetUtf32BE(), (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf32BEWithBomEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> CharacterSet$.MODULE$.CharsetUtf32BE(), (Function0<Chunk<Object>>)(Function0 & Serializable)() -> CharacterSet$BOM$.MODULE$.Utf32BE(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf32LEEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> CharacterSet$.MODULE$.CharsetUtf32LE(), (Function0<Chunk<Object>>)(Function0 & Serializable)() -> MODULE$.encodeStringWith$default$2(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf32LEWithBomEncode(Object trace) {
        return this.encodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> CharacterSet$.MODULE$.CharsetUtf32LE(), (Function0<Chunk<Object>>)(Function0 & Serializable)() -> CharacterSet$BOM$.MODULE$.Utf32LE(), trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf32Encode(Object trace) {
        return this.utf32BEEncode(trace);
    }

    public ZPipeline<Object, CharacterCodingException, String, Object> utf32WithBomEncode(Object trace) {
        return this.utf32BEWithBomEncode(trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, Tuple2<In, Object>> zipWithIndex(Object trace) {
        return this.mapAccum((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function2)(Function2 & Serializable)(index, a) -> ZPipeline$.$anonfun$zipWithIndex$3(BoxesRunTime.unboxToLong((Object)index), a), trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, Tuple2<In, Option<In>>> zipWithNext(Object trace) {
        return new ZPipeline(ZPipeline$.process$1((Option)None$.MODULE$, trace));
    }

    public <In> ZPipeline<Object, Nothing$, In, Tuple2<Option<In>, In>> zipWithPrevious(Object trace) {
        return this.mapAccum((Function0 & Serializable)() -> None$.MODULE$, (Function2 & Serializable)(prev, curr) -> new Tuple2((Object)new Some(curr), (Object)new Tuple2(prev, curr)), trace);
    }

    public <In> ZPipeline<Object, Nothing$, In, Tuple3<Option<In>, In, Option<In>>> zipWithPreviousAndNext(Object trace) {
        return this.zipWithPrevious(trace).zipWithNext(trace).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 tuple2 = (Tuple2)x0$1._1();
                Option next = (Option)x0$1._2();
                if (tuple2 != null) {
                    Option prev = (Option)tuple2._1();
                    Object curr = tuple2._2();
                    return new Tuple3((Object)prev, curr, (Object)next.map((Function1 & Serializable)x$72 -> x$72._2()));
                }
            }
            throw new MatchError(x0$1);
        }, trace);
    }

    private ZPipeline<Object, CharacterCodingException, Object, String> utfDecodeDetectingBom(Function0<Object> bomSize, Function1<Chunk<Object>, Tuple2<Chunk<Object>, ZPipeline<Object, CharacterCodingException, Object, String>>> processBom, Object trace) {
        return this.suspend((Function0 & Serializable)() -> new ZPipeline(ZPipeline$.lookingForBom$1(Chunk$.MODULE$.empty(), bomSize.apply$mcI$sp(), processBom, trace)));
    }

    private ZPipeline<Object, CharacterCodingException, Object, String> utf8DecodeNoBom(Object trace) {
        return this.decodeStringWith((Function0<Charset>)(Function0 & Serializable)() -> StandardCharsets.UTF_8, trace);
    }

    private static final ZChannel bufferring$1(Chunk acc, Function0 n$8, Object trace$67, Function1 f$26) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)inElem -> {
            if (acc.size() + inElem.size() >= n$8.apply$mcI$sp()) {
                void var7_7;
                void var6_6;
                Tuple2 tuple2 = inElem.splitAt(n$8.apply$mcI$sp() - acc.size());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Chunk b1 = (Chunk)tuple2._1();
                Chunk b2 = (Chunk)tuple2._2();
                return ZPipeline$.running$1(acc.$plus$plus((Chunk)var6_6), (Chunk)var7_7, trace$67, f$26);
            }
            return ZPipeline$.bufferring$1(acc.$plus$plus(inElem), n$8, trace$67, f$26);
        }, (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)done -> ZPipeline$.running$1(acc, Chunk$.MODULE$.empty(), trace$67, f$26), trace$67);
    }

    private static final ZChannel running$1(Chunk prefix, Chunk leftOver, Object trace$67, Function1 f$26) {
        ZPipeline nextUpstream = MODULE$.prepend((Function0 & Serializable)() -> leftOver, trace$67);
        ZPipeline pl = (ZPipeline)f$26.apply((Object)prefix);
        return nextUpstream.$greater$greater$greater((Function0 & Serializable)() -> pl, trace$67).toChannel();
    }

    public static final /* synthetic */ boolean $anonfun$changes$2(Object x$6, Object x$7) {
        return BoxesRunTime.equals((Object)x$6, (Object)x$7);
    }

    public static final /* synthetic */ ZChannel $anonfun$changesWith$4(Option newLast$1, Function2 f$27, Object trace$68) {
        return ZPipeline$.writer$1(newLast$1, f$27, trace$68);
    }

    private static final ZChannel writer$1(Option last, Function2 f$27, Object trace$68) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)chunk -> {
            void var5_5;
            void var6_6;
            Tuple2 tuple2 = (Tuple2)chunk.foldLeft((Object)new Tuple2((Object)last, (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (x0$1 != null) {
                    Object o;
                    Option option = (Option)x0$1._1();
                    Chunk os = (Chunk)x0$1._2();
                    if (option instanceof Some && BoxesRunTime.unboxToBoolean((Object)f$27.apply(o = ((Some)option).value(), x1$1))) {
                        return new Tuple2((Object)new Some(x1$1), (Object)os);
                    }
                }
                if (x0$1 != null) {
                    Chunk os = (Chunk)x0$1._2();
                    return new Tuple2((Object)new Some(x1$1), os.$colon$plus(x1$1));
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option newLast = (Option)tuple2._1();
            Chunk newChunk = (Chunk)tuple2._2();
            return ZChannel$.MODULE$.write(var6_6, trace$68).$times$greater(() -> ZPipeline$.$anonfun$changesWith$4((Option)var5_5, f$27, trace$68), trace$68);
        }, (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$9 -> ZChannel$.MODULE$.unit(), trace$68);
    }

    public static final /* synthetic */ Tuple2 $anonfun$changesWithZIO$5(Object o1$1, Chunk os$1, boolean b) {
        if (b) {
            return new Tuple2((Object)new Some(o1$1), (Object)os$1);
        }
        return new Tuple2((Object)new Some(o1$1), os$1.$colon$plus(o1$1));
    }

    private static final ZChannel writer$2(Option last, Function2 f$28, Object trace$69) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)chunk -> ZChannel$.MODULE$.fromZIO((Function0 & Serializable)() -> chunk.foldZIO((Object)new Tuple2((Object)last, (Object)Chunk$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x0$1 != null) {
                Option option = (Option)x0$1._1();
                Chunk os = (Chunk)x0$1._2();
                if (option instanceof Some) {
                    Object o = ((Some)option).value();
                    return ((ZIO)f$28.apply(o, x1$1)).map((Function1 & Serializable)b -> ZPipeline$.$anonfun$changesWithZIO$5(x1$1, os, BoxesRunTime.unboxToBoolean((Object)b)), trace$69);
                }
            }
            if (x0$1 != null) {
                Chunk os = (Chunk)x0$1._2();
                return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> new Tuple2((Object)new Some(x1$1), os.$colon$plus(x1$1)), trace$69);
            }
            throw new MatchError((Object)tuple2);
        }, trace$69), trace$69).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Option newLast = (Option)x0$2._1();
                Chunk newChunk = (Chunk)x0$2._2();
                return ZChannel$.MODULE$.write(newChunk, trace$69).$times$greater((Function0 & Serializable)() -> ZPipeline$.writer$2(newLast, f$28, trace$69), trace$69);
            }
            throw new MatchError(null);
        }, trace$69), (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$10 -> ZChannel$.MODULE$.unit(), trace$69);
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$1(LazyRef loop$lzy$1, PartialFunction pf$4, Object trace$70) {
        synchronized (loop$lzy$1) {
            ZChannel zChannel = loop$lzy$1.initialized() ? (ZChannel)loop$lzy$1.value() : (ZChannel)loop$lzy$1.initialize(ZChannel$.MODULE$.readWith((Function1 & Serializable)in -> {
                Chunk mapped = in.collectWhile(pf$4);
                if (mapped.size() == in.size()) {
                    return ZChannel$.MODULE$.write(mapped, trace$70).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$1(loop$lzy$1, pf$4, trace$70), trace$70);
                }
                return ZChannel$.MODULE$.write(mapped, trace$70);
            }, (Function1 & Serializable)x$13 -> ZChannel$.MODULE$.fail((Function0 & Serializable)() -> x$13, trace$70), (Function1 & Serializable)x$14 -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> x$14, trace$70), trace$70));
            return zChannel;
        }
    }

    private static final ZChannel loop$1(LazyRef loop$lzy$1, PartialFunction pf$4, Object trace$70) {
        if (loop$lzy$1.initialized()) {
            return (ZChannel)loop$lzy$1.value();
        }
        return ZPipeline$.loop$lzycompute$1(loop$lzy$1, pf$4, trace$70);
    }

    private static final ZChannel loop$2(Chunk.ChunkIterator chunkIterator, int index, PartialFunction pf$5, Object trace$71) {
        if (chunkIterator.hasNextAt(index)) {
            return ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> {
                Object a = chunkIterator.nextAt(index);
                return (ZIO)pf$5.andThen((Function1 & Serializable)x$15 -> x$15.map((Function1 & Serializable)a1 -> ZChannel$.MODULE$.write(Chunk$.MODULE$.single(a1), trace$71).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$2(chunkIterator, index + 1, pf$5, trace$71), trace$71), trace$71)).applyOrElse(a, (Function1 & Serializable)x$16 -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> ZChannel$.MODULE$.unit(), trace$71));
            }, trace$71);
        }
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)elem -> ZPipeline$.loop$2(elem.chunkIterator(), 0, pf$5, trace$71), (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)done -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$71), trace$71);
    }

    private static final /* synthetic */ ZChannel reader$lzycompute$1(LazyRef reader$lzy$1, SingleThreadedRingBuffer queue$1, Object trace$72) {
        synchronized (reader$lzy$1) {
            ZChannel zChannel = reader$lzy$1.initialized() ? (ZChannel)reader$lzy$1.value() : (ZChannel)reader$lzy$1.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
                Chunk outs = in.flatMap((Function1 & Serializable)elem -> {
                    Option head = queue$1.head();
                    queue$1.put(elem);
                    return head;
                });
                return ZChannel$.MODULE$.write(outs, trace$72).$times$greater((Function0 & Serializable)() -> ZPipeline$.reader$1(reader$lzy$1, queue$1, trace$72), trace$72);
            }, (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$17 -> ZChannel$.MODULE$.unit(), trace$72));
            return zChannel;
        }
    }

    private static final ZChannel reader$1(LazyRef reader$lzy$1, SingleThreadedRingBuffer queue$1, Object trace$72) {
        if (reader$lzy$1.initialized()) {
            return (ZChannel)reader$lzy$1.value();
        }
        return ZPipeline$.reader$lzycompute$1(reader$lzy$1, queue$1, trace$72);
    }

    private static final ZIO handleCoderResult$1(CoderResult coderResult, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1, Object trace$75) {
        if (coderResult.isUnderflow() || coderResult.isOverflow()) {
            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                byteBuffer$1.compact();
                charBuffer$1.flip();
                char[] array = new char[charBuffer$1.remaining()];
                charBuffer$1.get(array);
                charBuffer$1.clear();
                return Chunk$.MODULE$.fromArray((Object)array);
            }, trace$75);
        }
        if (coderResult.isMalformed()) {
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new MalformedInputException(coderResult.length()), trace$75);
        }
        if (coderResult.isUnmappable()) {
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new UnmappableCharacterException(coderResult.length()), trace$75);
        }
        return ZIO$.MODULE$.dieMessage((Function0 & Serializable)() -> new java.lang.StringBuilder(25).append("Unexpected coder result: ").append(coderResult).toString(), trace$75);
    }

    private static final ZIO decodeChunk$1(Chunk inBytes, ByteBuffer byteBuffer$1, Object trace$75, CharsetDecoder decoder$1, CharBuffer charBuffer$1) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
            void var5_5;
            void var4_4;
            Tuple2 tuple2;
            int bufRemaining = byteBuffer$1.remaining();
            Tuple2 tuple22 = tuple2 = inBytes.length() > bufRemaining ? inBytes.splitAt(bufRemaining) : new Tuple2((Object)inBytes, (Object)Chunk$.MODULE$.empty());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Chunk decodeBytes = (Chunk)tuple2._1();
            Chunk remainingBytes = (Chunk)tuple2._2();
            byteBuffer$1.put((byte[])var4_4.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
            byteBuffer$1.flip();
            return var5_5;
        }, trace$75).flatMap((Function1 & Serializable)remainingBytes -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> decoder$1.decode(byteBuffer$1, charBuffer$1, false), trace$75).flatMap((Function1 & Serializable)result -> ZPipeline$.handleCoderResult$1(result, byteBuffer$1, charBuffer$1, trace$75).flatMap((Function1 & Serializable)decodedChars -> (remainingBytes.isEmpty() ? ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace$75) : ZPipeline$.decodeChunk$1(remainingBytes, byteBuffer$1, trace$75, decoder$1, charBuffer$1)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace$75), trace$75), trace$75), trace$75);
    }

    private static final ZIO endOfInput$1(CharsetDecoder decoder$1, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1, Object trace$75) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> decoder$1.decode(byteBuffer$1, charBuffer$1, true), trace$75).flatMap((Function1 & Serializable)result -> ZPipeline$.handleCoderResult$1(result, byteBuffer$1, charBuffer$1, trace$75).flatMap((Function1 & Serializable)decodedChars -> (result.isOverflow() ? ZPipeline$.endOfInput$1(decoder$1, byteBuffer$1, charBuffer$1, trace$75) : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace$75)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace$75), trace$75), trace$75);
    }

    private static final ZIO flushRemaining$1(CharsetDecoder decoder$1, CharBuffer charBuffer$1, Object trace$75, ByteBuffer byteBuffer$1) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> decoder$1.flush(charBuffer$1), trace$75).flatMap((Function1 & Serializable)result -> ZPipeline$.handleCoderResult$1(result, byteBuffer$1, charBuffer$1, trace$75).flatMap((Function1 & Serializable)decodedChars -> (result.isOverflow() ? ZPipeline$.flushRemaining$1(decoder$1, charBuffer$1, trace$75, byteBuffer$1) : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace$75)).map((Function1 & Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace$75), trace$75), trace$75);
    }

    private static final ZChannel loop$3(int r, Object trace$76) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
            Chunk dropped = in.drop(r);
            int leftover = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(r - in.length()), 0);
            if (in.isEmpty() || leftover > 0) {
                return ZPipeline$.loop$3(leftover, trace$76);
            }
            return ZChannel$.MODULE$.write(dropped, trace$76).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace$76), trace$76);
        }, (Function1 & Serializable)e -> ZChannel$.MODULE$.refailCause(e), (Function1 & Serializable)x$24 -> ZChannel$.MODULE$.unit(), trace$76);
    }

    public static final /* synthetic */ boolean $anonfun$dropUntil$2(Function1 f$30, Object x$25) {
        return !BoxesRunTime.unboxToBoolean((Object)f$30.apply(x$25));
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$2(LazyRef loop$lzy$2, Function1 p$1, Object trace$78) {
        synchronized (loop$lzy$2) {
            ZChannel zChannel = loop$lzy$2.initialized() ? (ZChannel)loop$lzy$2.value() : (ZChannel)loop$lzy$2.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> in.dropUntilZIO(p$1, trace$78).map((Function1 & Serializable)leftover -> {
                if (leftover.isEmpty()) {
                    return ZPipeline$.loop$4(loop$lzy$2, p$1, trace$78);
                }
                return ZChannel$.MODULE$.write(leftover, trace$78).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace$78), trace$78);
            }, trace$78), trace$78), (Function1 & Serializable)e -> ZChannel$.MODULE$.refailCause(e), (Function1 & Serializable)x$26 -> ZChannel$.MODULE$.unit(), trace$78));
            return zChannel;
        }
    }

    private static final ZChannel loop$4(LazyRef loop$lzy$2, Function1 p$1, Object trace$78) {
        if (loop$lzy$2.initialized()) {
            return (ZChannel)loop$lzy$2.value();
        }
        return ZPipeline$.loop$lzycompute$2(loop$lzy$2, p$1, trace$78);
    }

    private static final ZChannel dropWhile$1(Function1 f, Object trace$79) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
            Chunk out = in.dropWhile(f);
            if (out.isEmpty()) {
                return ZPipeline$.dropWhile$1(f, trace$79);
            }
            return ZChannel$.MODULE$.write(out, trace$79).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace$79), trace$79);
        }, (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)out -> ZChannel$.MODULE$.succeedNow(out, trace$79), trace$79);
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$3(LazyRef loop$lzy$3, Function1 p$2, Object trace$80) {
        synchronized (loop$lzy$3) {
            ZChannel zChannel = loop$lzy$3.initialized() ? (ZChannel)loop$lzy$3.value() : (ZChannel)loop$lzy$3.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> in.dropWhileZIO(p$2, trace$80).map((Function1 & Serializable)leftover -> {
                if (leftover.isEmpty()) {
                    return ZPipeline$.loop$5(loop$lzy$3, p$2, trace$80);
                }
                return ZChannel$.MODULE$.write(leftover, trace$80).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace$80), trace$80);
            }, trace$80), trace$80), (Function1 & Serializable)e -> ZChannel$.MODULE$.refailCause(e), (Function1 & Serializable)x$27 -> ZChannel$.MODULE$.unit(), trace$80));
            return zChannel;
        }
    }

    private static final ZChannel loop$5(LazyRef loop$lzy$3, Function1 p$2, Object trace$80) {
        if (loop$lzy$3.initialized()) {
            return (ZChannel)loop$lzy$3.value();
        }
        return ZPipeline$.loop$lzycompute$3(loop$lzy$3, p$2, trace$80);
    }

    private static final ZIO handleCoderResult$2(CoderResult coderResult, CharBuffer charBuffer$2, ByteBuffer byteBuffer$2, Object trace$82) {
        if (coderResult.isUnderflow() || coderResult.isOverflow()) {
            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
                charBuffer$2.compact();
                byteBuffer$2.flip();
                byte[] array = new byte[byteBuffer$2.remaining()];
                byteBuffer$2.get(array);
                byteBuffer$2.clear();
                return Chunk$.MODULE$.fromArray((Object)array);
            }, trace$82);
        }
        if (coderResult.isMalformed()) {
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new MalformedInputException(coderResult.length()), trace$82);
        }
        if (coderResult.isUnmappable()) {
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new UnmappableCharacterException(coderResult.length()), trace$82);
        }
        return ZIO$.MODULE$.dieMessage((Function0 & Serializable)() -> "Invalid CoderResult state", trace$82);
    }

    private static final ZIO encodeChunk$1(Chunk inChars, CharBuffer charBuffer$2, Object trace$82, CharsetEncoder encoder$1, ByteBuffer byteBuffer$2) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> {
            void var5_5;
            void var4_4;
            Tuple2 tuple2;
            int bufRemaining = charBuffer$2.remaining();
            Tuple2 tuple22 = tuple2 = inChars.length() > bufRemaining ? inChars.splitAt(bufRemaining) : new Tuple2((Object)inChars, (Object)Chunk$.MODULE$.empty());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Chunk decodeChars = (Chunk)tuple2._1();
            Chunk remainingChars = (Chunk)tuple2._2();
            charBuffer$2.put((char[])var4_4.toArray((ClassTag)ClassTag$.MODULE$.Char()));
            charBuffer$2.flip();
            return var5_5;
        }, trace$82).flatMap((Function1 & Serializable)remainingChars -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> encoder$1.encode(charBuffer$2, byteBuffer$2, false), trace$82).flatMap((Function1 & Serializable)result -> ZPipeline$.handleCoderResult$2(result, charBuffer$2, byteBuffer$2, trace$82).flatMap((Function1 & Serializable)encodedBytes -> (remainingChars.isEmpty() ? ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace$82) : ZPipeline$.encodeChunk$1(remainingChars, charBuffer$2, trace$82, encoder$1, byteBuffer$2)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes), trace$82), trace$82), trace$82), trace$82);
    }

    private static final ZIO endOfInput$2(CharsetEncoder encoder$1, CharBuffer charBuffer$2, ByteBuffer byteBuffer$2, Object trace$82) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> encoder$1.encode(charBuffer$2, byteBuffer$2, true), trace$82).flatMap((Function1 & Serializable)result -> ZPipeline$.handleCoderResult$2(result, charBuffer$2, byteBuffer$2, trace$82).flatMap((Function1 & Serializable)encodedBytes -> (result.isOverflow() ? ZPipeline$.endOfInput$2(encoder$1, charBuffer$2, byteBuffer$2, trace$82) : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace$82)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes), trace$82), trace$82), trace$82);
    }

    private static final ZIO flushRemaining$2(CharsetEncoder encoder$1, ByteBuffer byteBuffer$2, Object trace$82, CharBuffer charBuffer$2) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> encoder$1.flush(byteBuffer$2), trace$82).flatMap((Function1 & Serializable)result -> ZPipeline$.handleCoderResult$2(result, charBuffer$2, byteBuffer$2, trace$82).flatMap((Function1 & Serializable)encodedBytes -> (result.isOverflow() ? ZPipeline$.flushRemaining$2(encoder$1, byteBuffer$2, trace$82, charBuffer$2) : ZIO$.MODULE$.succeed((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), trace$82)).map((Function1 & Serializable)remainderBytes -> encodedBytes.$plus$plus(remainderBytes), trace$82), trace$82), trace$82);
    }

    private static final /* synthetic */ ZChannel channel$lzycompute$1(LazyRef channel$lzy$1, Object trace$86) {
        synchronized (channel$lzy$1) {
            ZChannel zChannel = channel$lzy$1.initialized() ? (ZChannel)channel$lzy$1.value() : (ZChannel)channel$lzy$1.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
                ChunkBuilder chunkBuilder = ChunkBuilder$.MODULE$.make();
                Chunk.ChunkIterator chunkIterator = in.chunkIterator();
                Option failureOption = Option$.MODULE$.empty();
                int index = 0;
                boolean loop = true;
                while (loop && chunkIterator.hasNextAt(index)) {
                    Exit take = ((Take)chunkIterator.nextAt(index)).exit();
                    if (take instanceof Exit.Success) {
                        Chunk chunk = (Chunk)((Exit.Success)take).value();
                        chunkBuilder.$plus$eq((Object)chunk);
                    } else if (take instanceof Exit.Failure) {
                        Cause cause = ((Exit.Failure)take).cause();
                        failureOption = new Some((Object)cause);
                        loop = false;
                    } else {
                        throw new MatchError(new Take(take));
                    }
                    ++index;
                }
                Chunk chunk = (Chunk)chunkBuilder.result();
                if (failureOption instanceof Some) {
                    Cause cause = (Cause)((Some)failureOption).value();
                    Option option = Cause$.MODULE$.flipCauseOption(cause);
                    if (option instanceof Some) {
                        Cause err = (Cause)((Some)option).value();
                        if (chunk.isEmpty()) {
                            return ZChannel$.MODULE$.refailCause(err);
                        }
                        return ZChannel$.MODULE$.writeChunk(chunk, trace$86).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.refailCause(err), trace$86);
                    }
                    if (None$.MODULE$.equals(option)) {
                        if (chunk.isEmpty()) {
                            return ZChannel$.MODULE$.unit();
                        }
                        return ZChannel$.MODULE$.writeChunk(chunk, trace$86);
                    }
                    throw new MatchError((Object)option);
                }
                if (None$.MODULE$.equals(failureOption)) {
                    if (chunk.isEmpty()) {
                        return ZPipeline$.channel$1(channel$lzy$1, trace$86);
                    }
                    return ZChannel$.MODULE$.writeChunk(chunk, trace$86).$times$greater((Function0 & Serializable)() -> ZPipeline$.channel$1(channel$lzy$1, trace$86), trace$86);
                }
                throw new MatchError((Object)failureOption);
            }, (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)done -> ZChannel$.MODULE$.succeedNow(done, trace$86), trace$86));
            return zChannel;
        }
    }

    private static final ZChannel channel$1(LazyRef channel$lzy$1, Object trace$86) {
        if (channel$lzy$1.initialized()) {
            return (ZChannel)channel$lzy$1.value();
        }
        return ZPipeline$.channel$lzycompute$1(channel$lzy$1, trace$86);
    }

    private static final Tuple2 groupAdjacentByChunk$1(Option state, Chunk chunk, Function1 f$34) {
        Object key;
        Tuple2 tuple2;
        if (chunk.isEmpty()) {
            return new Tuple2((Object)state, (Object)Chunk$.MODULE$.empty());
        }
        ChunkBuilder chunkBuilder = ChunkBuilder$.MODULE$.make();
        Chunk.ChunkIterator chunkIterator = chunk.chunkIterator();
        int from = 0;
        int until = 0;
        Chunk previousChunk = Chunk$.MODULE$.empty();
        if (state instanceof Some && (tuple2 = (Tuple2)((Some)state).value()) != null) {
            Object previousKey = tuple2._1();
            NonEmptyChunk nonEmptyChunk = (NonEmptyChunk)tuple2._2();
            key = previousKey;
            boolean loop = true;
            while (chunkIterator.hasNextAt(until) && loop) {
                Object in = chunkIterator.nextAt(until);
                Object updatedKey = f$34.apply(in);
                if (!BoxesRunTime.equals((Object)key, (Object)updatedKey)) {
                    chunkBuilder.$plus$eq((Object)new Tuple2(key, (Object)nonEmptyChunk.$plus$plus(NonEmptyChunk$.MODULE$.toChunk(NonEmptyChunk$.MODULE$.nonEmpty(chunk.slice(from, until))))));
                    key = updatedKey;
                    from = until;
                    loop = false;
                }
                ++until;
            }
            if (loop) {
                previousChunk = nonEmptyChunk.toChunk();
            }
        } else if (None$.MODULE$.equals(state)) {
            key = f$34.apply(chunkIterator.nextAt(until));
            ++until;
        } else {
            throw new MatchError((Object)state);
        }
        while (chunkIterator.hasNextAt(until)) {
            Object in = chunkIterator.nextAt(until);
            Object updatedKey = f$34.apply(in);
            if (!BoxesRunTime.equals((Object)key, (Object)updatedKey)) {
                chunkBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)NonEmptyChunk$.MODULE$.nonEmpty(chunk.slice(from, until))));
                key = updatedKey;
                from = until;
            }
            ++until;
        }
        NonEmptyChunk nonEmptyChunk = previousChunk.$plus$plus(NonEmptyChunk$.MODULE$.nonEmpty(chunk.slice(from, until)));
        Chunk out = (Chunk)chunkBuilder.result();
        return new Tuple2((Object)new Some((Object)new Tuple2(key, (Object)nonEmptyChunk)), (Object)out);
    }

    public static final /* synthetic */ ZChannel $anonfun$groupAdjacentBy$2(Option updatedState$1, Object trace$87, Function1 f$34) {
        return ZPipeline$.groupAdjacentBy$1(updatedState$1, trace$87, f$34);
    }

    private static final ZChannel groupAdjacentBy$1(Option state, Object trace$87, Function1 f$34) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
            void var5_5;
            void var6_6;
            Tuple2 tuple2 = ZPipeline$.groupAdjacentByChunk$1(state, in, f$34);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option updatedState = (Option)tuple2._1();
            Chunk out = (Chunk)tuple2._2();
            if (var6_6.isEmpty()) {
                return ZPipeline$.groupAdjacentBy$1((Option)var5_5, trace$87, f$34);
            }
            return ZChannel$.MODULE$.write(var6_6, trace$87).$times$greater(() -> ZPipeline$.$anonfun$groupAdjacentBy$2((Option)var5_5, trace$87, f$34), trace$87);
        }, (Function1 & Serializable)err -> {
            if (state instanceof Some) {
                Tuple2 out = (Tuple2)((Some)state).value();
                return ZChannel$.MODULE$.write(Chunk$.MODULE$.single((Object)out), trace$87).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.refailCause(err), trace$87);
            }
            if (None$.MODULE$.equals(state)) {
                return ZChannel$.MODULE$.refailCause(err);
            }
            throw new MatchError((Object)state);
        }, (Function1 & Serializable)done -> {
            if (state instanceof Some) {
                Tuple2 out = (Tuple2)((Some)state).value();
                return ZChannel$.MODULE$.write(Chunk$.MODULE$.single((Object)out), trace$87).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.succeedNow(done, trace$87), trace$87);
            }
            if (None$.MODULE$.equals(state)) {
                return ZChannel$.MODULE$.succeedNow(done, trace$87);
            }
            throw new MatchError((Object)state);
        }, trace$87);
    }

    private static final ZChannel fc$1(ZChannel upstream, Function1 f$35, Object trace$89) {
        return ((ZStream)f$35.apply(upstream.toStream($less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl(), trace$89))).toChannel();
    }

    private static final ZChannel pull$1(Function1 push, Object trace$90) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> ZChannel$.MODULE$.fromZIO((Function0 & Serializable)() -> (ZIO)push.apply((Object)new Some(in)), trace$90).flatMap((Function1 & Serializable)out -> ZChannel$.MODULE$.write(out, trace$90), trace$90).$times$greater((Function0 & Serializable)() -> ZPipeline$.pull$1(push, trace$90), trace$90), (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)x$42 -> ZChannel$.MODULE$.fromZIO((Function0 & Serializable)() -> (ZIO)push.apply((Object)None$.MODULE$), trace$90).flatMap((Function1 & Serializable)out -> ZChannel$.MODULE$.write(out, trace$90), trace$90), trace$90);
    }

    private static final /* synthetic */ ZChannel upstream$lzycompute$1(LazyRef upstream$lzy$1, ObjectRef leftover$1, Object trace$91, BooleanRef upstreamDone$1) {
        synchronized (upstream$lzy$1) {
            ZChannel zChannel = upstream$lzy$1.initialized() ? (ZChannel)upstream$lzy$1.value() : (ZChannel)upstream$lzy$1.initialize(ZChannel$.MODULE$.suspend((Function0 & Serializable)() -> {
                Chunk l = (Chunk)leftover$1.elem;
                if (l.isEmpty()) {
                    return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)c -> ZChannel$.MODULE$.write(c, trace$91).$times$greater((Function0 & Serializable)() -> ZPipeline$.upstream$1(upstream$lzy$1, leftover$1, trace$91, upstreamDone$1), trace$91), (Function1 & Serializable)e -> ZChannel$.MODULE$.refailCause(e), (Function1 & Serializable)done -> {
                        upstreamDone$1.elem = true;
                        return ZChannel$.MODULE$.succeedNow(done, trace$91);
                    }, trace$91);
                }
                leftover$1.elem = Chunk$.MODULE$.empty();
                return ZChannel$.MODULE$.write(l, trace$91).$times$greater((Function0 & Serializable)() -> ZPipeline$.upstream$1(upstream$lzy$1, leftover$1, trace$91, upstreamDone$1), trace$91);
            }));
            return zChannel;
        }
    }

    private static final ZChannel upstream$1(LazyRef upstream$lzy$1, ObjectRef leftover$1, Object trace$91, BooleanRef upstreamDone$1) {
        if (upstream$lzy$1.initialized()) {
            return (ZChannel)upstream$lzy$1.value();
        }
        return ZPipeline$.upstream$lzycompute$1(upstream$lzy$1, leftover$1, trace$91, upstreamDone$1);
    }

    private static final /* synthetic */ ZChannel writeDone$lzycompute$1(LazyRef writeDone$lzy$1, ObjectRef leftover$1, Object trace$91) {
        synchronized (writeDone$lzy$1) {
            ZChannel zChannel = writeDone$lzy$1.initialized() ? (ZChannel)writeDone$lzy$1.value() : (ZChannel)writeDone$lzy$1.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)elem -> {
                leftover$1.elem = ((Chunk)leftover$1.elem).$plus$plus(elem);
                return ZPipeline$.writeDone$1(writeDone$lzy$1, leftover$1, trace$91);
            }, (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)out -> ZChannel$.MODULE$.write(Chunk$.MODULE$.single(out), trace$91), trace$91));
            return zChannel;
        }
    }

    private static final ZChannel writeDone$1(LazyRef writeDone$lzy$1, ObjectRef leftover$1, Object trace$91) {
        if (writeDone$lzy$1.initialized()) {
            return (ZChannel)writeDone$lzy$1.value();
        }
        return ZPipeline$.writeDone$lzycompute$1(writeDone$lzy$1, leftover$1, trace$91);
    }

    private static final /* synthetic */ ZChannel transducer$lzycompute$1(LazyRef transducer$lzy$1, Function0 sink$7, Object trace$91, BooleanRef upstreamDone$1, ObjectRef leftover$1, LazyRef writeDone$lzy$1) {
        synchronized (transducer$lzy$1) {
            ZChannel zChannel = transducer$lzy$1.initialized() ? (ZChannel)transducer$lzy$1.value() : (ZChannel)transducer$lzy$1.initialize(((ZSink)sink$7.apply()).channel().pipeTo((Function0 & Serializable)() -> ZPipeline$.writeDone$1(writeDone$lzy$1, leftover$1, trace$91), trace$91).flatMap((Function1 & Serializable)x$43 -> {
                if (upstreamDone$1.elem && ((Chunk)leftover$1.elem).isEmpty()) {
                    return ZChannel$.MODULE$.unit();
                }
                return ZPipeline$.transducer$1(transducer$lzy$1, sink$7, trace$91, upstreamDone$1, leftover$1, writeDone$lzy$1);
            }, trace$91));
            return zChannel;
        }
    }

    private static final ZChannel transducer$1(LazyRef transducer$lzy$1, Function0 sink$7, Object trace$91, BooleanRef upstreamDone$1, ObjectRef leftover$1, LazyRef writeDone$lzy$1) {
        if (transducer$lzy$1.initialized()) {
            return (ZChannel)transducer$lzy$1.value();
        }
        return ZPipeline$.transducer$lzycompute$1(transducer$lzy$1, sink$7, trace$91, upstreamDone$1, leftover$1, writeDone$lzy$1);
    }

    private static final int digitValue$1(char c) {
        switch (c) {
            default: 
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    public static final /* synthetic */ Object $anonfun$hexDecode$1(ObjectRef bad$1, Chunk cs$1, ChunkBuilder temp$1, int i) {
        if (((Option)bad$1.elem).isEmpty()) {
            char ch = BoxesRunTime.unboxToChar((Object)cs$1.apply(i));
            int h = ZPipeline$.digitValue$1(ch);
            if (h < 0) {
                bad$1.elem = new Some((Object)BoxesRunTime.boxToCharacter((char)ch));
                return BoxedUnit.UNIT;
            }
            char cl = BoxesRunTime.unboxToChar((Object)cs$1.apply(i + 1));
            int l = ZPipeline$.digitValue$1(cl);
            if (l < 0) {
                bad$1.elem = new Some((Object)BoxesRunTime.boxToCharacter((char)cl));
                return BoxedUnit.UNIT;
            }
            byte b = (byte)(h << 4 | l);
            return temp$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)b));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ ZChannel $anonfun$hexDecode$2(Chunk newSpare$1, Object trace$92) {
        return ZPipeline$.decodeChannel$1(newSpare$1, trace$92);
    }

    /*
     * WARNING - void declaration
     */
    private static final ZChannel in$4(Chunk in, Chunk spare$1, Object trace$92) {
        void var6_6;
        Tuple2 tuple2;
        Chunk toProcess = spare$1.$plus$plus(in);
        if (toProcess.isEmpty()) {
            return ZChannel$.MODULE$.unit();
        }
        int l = toProcess.size();
        Tuple2 tuple22 = tuple2 = l % 2 == 0 ? new Tuple2((Object)toProcess, (Object)Chunk$.MODULE$.empty()) : toProcess.splitAt(l - 1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Chunk cs = (Chunk)tuple2._1();
        Chunk newSpare = (Chunk)tuple2._2();
        ChunkBuilder temp = ChunkBuilder$.MODULE$.make(l / 2);
        ObjectRef bad = ObjectRef.create((Object)None$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), var6_6.size()).by(2).foreach(arg_0 -> ZPipeline$.$anonfun$hexDecode$1$adapted(bad, (Chunk)var6_6, temp, arg_0));
        Option option = (Option)bad.elem;
        if (None$.MODULE$.equals(option)) {
            void var7_7;
            return ZChannel$.MODULE$.write(temp.result(), trace$92).$times$greater(() -> ZPipeline$.$anonfun$hexDecode$2((Chunk)var7_7, trace$92), trace$92);
        }
        if (option instanceof Some) {
            char e = BoxesRunTime.unboxToChar((Object)((Some)option).value());
            return ZChannel$.MODULE$.fail((Function0 & Serializable)() -> EncodingException$.MODULE$.apply(new java.lang.StringBuilder(25).append("Not a valid hex digit: '").append(e).append("'").toString(), EncodingException$.MODULE$.apply$default$2()), trace$92);
        }
        throw new MatchError((Object)option);
    }

    private static final ZChannel err$3(Object z, Object trace$92) {
        return ZChannel$.MODULE$.fail((Function0 & Serializable)() -> EncodingException$.MODULE$.apply("Input stream should be infallible", EncodingException$.MODULE$.apply$default$2()), trace$92);
    }

    private static final ZChannel done$3(Object u, Chunk spare$1, Object trace$92) {
        if (spare$1.isEmpty()) {
            return ZChannel$.MODULE$.succeed((JFunction0.mcV.sp & Serializable)() -> {}, trace$92);
        }
        return ZChannel$.MODULE$.fail((Function0 & Serializable)() -> EncodingException$.MODULE$.apply("Extra input at end after last fully encoded byte", EncodingException$.MODULE$.apply$default$2()), trace$92);
    }

    private static final ZChannel decodeChannel$1(Chunk spare, Object trace$92) {
        return ZChannel$.MODULE$.readWith((Function1 & Serializable)in -> ZPipeline$.in$4(in, spare, trace$92), (Function1 & Serializable)z -> ZPipeline$.err$3(z, trace$92), (Function1 & Serializable)u -> ZPipeline$.done$3(u, spare, trace$92), trace$92);
    }

    public static final /* synthetic */ ChunkBuilder $anonfun$hexEncode$6(ChunkBuilder out$1, char[] DIGITS$1, byte b) {
        out$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)DIGITS$1[b >>> 4 & 0xF]));
        return (ChunkBuilder)out$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)DIGITS$1[b >>> 0 & 0xF]));
    }

    private static final ZChannel writer$3(boolean isFirst, Function0 middle$3, Object trace$94) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)chunk -> {
            ChunkBuilder builder = ChunkBuilder$.MODULE$.make();
            BooleanRef flagResult = BooleanRef.create((boolean)isFirst);
            chunk.foreach((Function1 & Serializable)o -> {
                if (flagResult$1.elem) {
                    flagResult$1.elem = false;
                    return (ChunkBuilder)builder.$plus$eq(o);
                }
                builder.$plus$eq(middle$3.apply());
                return (ChunkBuilder)builder.$plus$eq(o);
            });
            return ZChannel$.MODULE$.write(builder.result(), trace$94).$times$greater((Function0 & Serializable)() -> ZPipeline$.writer$3(flagResult$1.elem, middle$3, trace$94), trace$94);
        }, (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)x$45 -> ZChannel$.MODULE$.unit(), trace$94);
    }

    private static final ZChannel accumulator$1(Object s, Object trace$97, Function2 f$38) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> ZIO$.MODULE$.suspendSucceed((Function0 & Serializable)() -> {
            ChunkBuilder outputChunk = ChunkBuilder$.MODULE$.make(in.size());
            Function1 & Serializable emit = (Function1 & Serializable)o -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> (ChunkBuilder)outputChunk.$plus$eq(o), trace$97).unit(trace$97);
            return ZIO$.MODULE$.foldLeft((Function0 & Serializable)() -> in, (Function0 & Serializable)() -> s, (Function2 & Serializable)(s1, a) -> ((ZIO)f$38.apply(s1, a)).flatMap((Function1 & Serializable)sa -> ((ZIO)emit.apply(sa._2())).as((Function0 & Serializable)() -> sa._1(), trace$97), trace$97), trace$97).fold((Function1 & Serializable)failure -> {
                Chunk partialResult = (Chunk)outputChunk.result();
                if (partialResult.nonEmpty()) {
                    return ZChannel$.MODULE$.write(partialResult, trace$97).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.fail((Function0 & Serializable)() -> failure, trace$97), trace$97);
                }
                return ZChannel$.MODULE$.fail((Function0 & Serializable)() -> failure, trace$97);
            }, (Function1 & Serializable)out -> ZChannel$.MODULE$.write(outputChunk.result(), trace$97).$times$greater((Function0 & Serializable)() -> ZPipeline$.accumulator$1(out, trace$97, f$38), trace$97), CanFail$.MODULE$.canFail(), trace$97);
        }, trace$97), trace$97), (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$47 -> ZChannel$.MODULE$.unit(), trace$97);
    }

    private static final ZChannel loop$6(Chunk.ChunkIterator chunkIterator, int index, Function1 f$40, Object trace$99) {
        if (chunkIterator.hasNextAt(index)) {
            return ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> {
                Object a = chunkIterator.nextAt(index);
                return ((ZIO)f$40.apply(a)).map((Function1 & Serializable)a1 -> ZChannel$.MODULE$.write(Chunk$.MODULE$.single(a1), trace$99).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$6(chunkIterator, index + 1, f$40, trace$99), trace$99), trace$99);
            }, trace$99);
        }
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)elem -> ZPipeline$.loop$6(elem.chunkIterator(), 0, f$40, trace$99), (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)done -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$99), trace$99);
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$4(LazyRef loop$lzy$4, ZStream.Rechunker rechunker$1, Object trace$105) {
        synchronized (loop$lzy$4) {
            ZChannel zChannel = loop$lzy$4.initialized() ? (ZChannel)loop$lzy$4.value() : (ZChannel)loop$lzy$4.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
                ZChannel out = rechunker$1.rechunk(in, trace$105);
                if (out != null) {
                    return out.$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$7(loop$lzy$4, rechunker$1, trace$105), trace$105);
                }
                return ZPipeline$.loop$7(loop$lzy$4, rechunker$1, trace$105);
            }, (Function1 & Serializable)cause -> rechunker$1.done(trace$105).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.refailCause(cause), trace$105), (Function1 & Serializable)x$52 -> rechunker$1.done(trace$105), trace$105));
            return zChannel;
        }
    }

    private static final ZChannel loop$7(LazyRef loop$lzy$4, ZStream.Rechunker rechunker$1, Object trace$105) {
        if (loop$lzy$4.initialized()) {
            return (ZChannel)loop$lzy$4.value();
        }
        return ZPipeline$.loop$lzycompute$4(loop$lzy$4, rechunker$1, trace$105);
    }

    private static final ZChannel next$1(Option leftover, int delimiterIndex, Function0 delimiter$2, Object trace$110) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)inputChunk -> {
            ObjectRef buffer = ObjectRef.create(null);
            Tuple2 tuple2 = (Tuple2)inputChunk.foldLeft((Object)new Tuple2(leftover.getOrElse((Function0 & Serializable)() -> Chunk$.MODULE$.empty()), (Object)BoxesRunTime.boxToInteger((int)delimiterIndex)), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (x0$1 != null) {
                    Chunk carry = (Chunk)x0$1._1();
                    int delimiterCursor = x0$1._2$mcI$sp();
                    Chunk concatenated = (Chunk)carry.$colon$plus(x1$1);
                    if (delimiterCursor < ((SeqOps)delimiter$2.apply()).length() && BoxesRunTime.equals((Object)x1$1, (Object)((SeqOps)delimiter$2.apply()).apply(delimiterCursor))) {
                        if (delimiterCursor + 1 == ((SeqOps)delimiter$2.apply()).length()) {
                            if ((ArrayBuffer)buffer$1.elem == null) {
                                buffer$1.elem = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                            ((ArrayBuffer)buffer$1.elem).$plus$eq((Object)concatenated.take(concatenated.length() - ((SeqOps)delimiter$2.apply()).length()));
                            return new Tuple2((Object)Chunk$.MODULE$.empty(), (Object)BoxesRunTime.boxToInteger((int)0));
                        }
                        return new Tuple2((Object)concatenated, (Object)BoxesRunTime.boxToInteger((int)(delimiterCursor + 1)));
                    }
                    return new Tuple2((Object)concatenated, (Object)(BoxesRunTime.equals((Object)x1$1, (Object)((SeqOps)delimiter$2.apply()).apply(0)) ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0)));
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 != null) {
                Chunk carry = (Chunk)tuple2._1();
                int delimiterCursor = tuple2._2$mcI$sp();
                return ZChannel$.MODULE$.writeChunk((ArrayBuffer)buffer.elem == null ? Chunk$.MODULE$.empty() : Chunk$.MODULE$.fromArray(((ArrayBuffer)buffer.elem).toArray(ClassTag$.MODULE$.apply(Chunk.class))), trace$110).$times$greater((Function0 & Serializable)() -> ZPipeline$.next$1((Option)(carry.nonEmpty() ? new Some((Object)carry) : None$.MODULE$), delimiterCursor, delimiter$2, trace$110), trace$110);
            }
            throw new MatchError(null);
        }, (Function1 & Serializable)halt -> {
            if (leftover instanceof Some) {
                Chunk chunk = (Chunk)((Some)leftover).value();
                return ZChannel$.MODULE$.write(chunk, trace$110).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.refailCause(halt), trace$110);
            }
            if (None$.MODULE$.equals(leftover)) {
                return ZChannel$.MODULE$.refailCause(halt);
            }
            throw new MatchError((Object)leftover);
        }, (Function1 & Serializable)done -> {
            if (leftover instanceof Some) {
                Chunk chunk = (Chunk)((Some)leftover).value();
                return ZChannel$.MODULE$.write(chunk, trace$110).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$110), trace$110);
            }
            if (None$.MODULE$.equals(leftover)) {
                return ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$110);
            }
            throw new MatchError((Object)leftover);
        }, trace$110);
    }

    private static final Chunk splitLinesChunk$1(Chunk chunk, BooleanRef midCRLF$1, StringBuilder stringBuilder$1) {
        ChunkBuilder chunkBuilder = ChunkBuilder$.MODULE$.make();
        chunk.foreach((Function1 & Serializable)string -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string))) {
                int from = 0;
                int indexOfCR = string.indexOf(13);
                int indexOfLF = string.indexOf(10);
                if (midCRLF$1.elem) {
                    if (indexOfLF == 0) {
                        chunkBuilder.$plus$eq((Object)stringBuilder$1.result());
                        stringBuilder$1.clear();
                        from = 1;
                        indexOfLF = string.indexOf(10, from);
                    } else {
                        stringBuilder$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\r'));
                    }
                    midCRLF$1.elem = false;
                }
                while (indexOfCR != -1 || indexOfLF != -1) {
                    if (indexOfCR == -1 || indexOfLF != -1 && indexOfLF < indexOfCR) {
                        if (stringBuilder$1.isEmpty()) {
                            chunkBuilder.$plus$eq((Object)string.substring(from, indexOfLF));
                        } else {
                            stringBuilder$1.append(string.substring(from, indexOfLF));
                            chunkBuilder.$plus$eq((Object)stringBuilder$1.result());
                            stringBuilder$1.clear();
                        }
                        from = indexOfLF + 1;
                        indexOfLF = string.indexOf(10, from);
                        continue;
                    }
                    if (string.length() == indexOfCR + 1) {
                        midCRLF$1.elem = true;
                        indexOfCR = -1;
                        continue;
                    }
                    if (indexOfLF == indexOfCR + 1) {
                        if (stringBuilder$1.isEmpty()) {
                            chunkBuilder.$plus$eq((Object)string.substring(from, indexOfCR));
                        } else {
                            stringBuilder$1.append(string.substring(from, indexOfCR));
                            chunkBuilder.$plus$eq((Object)stringBuilder$1.result());
                            stringBuilder$1.clear();
                        }
                        from = indexOfCR + 2;
                        indexOfCR = string.indexOf(13, from);
                        indexOfLF = string.indexOf(10, from);
                        continue;
                    }
                    indexOfCR = string.indexOf(13, indexOfCR + 1);
                }
                if (midCRLF$1.elem) {
                    return stringBuilder$1.append(string.substring(from, string.length() - 1));
                }
                return stringBuilder$1.append(string.substring(from, string.length()));
            }
            return BoxedUnit.UNIT;
        });
        return (Chunk)chunkBuilder.result();
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$5(LazyRef loop$lzy$5, Object trace$111, StringBuilder stringBuilder$1, BooleanRef midCRLF$1) {
        synchronized (loop$lzy$5) {
            ZChannel zChannel = loop$lzy$5.initialized() ? (ZChannel)loop$lzy$5.value() : (ZChannel)loop$lzy$5.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
                Chunk out = ZPipeline$.splitLinesChunk$1(in, midCRLF$1, stringBuilder$1);
                if (out.isEmpty()) {
                    return ZPipeline$.loop$8(loop$lzy$5, trace$111, stringBuilder$1, midCRLF$1);
                }
                return ZChannel$.MODULE$.write(out, trace$111).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$8(loop$lzy$5, trace$111, stringBuilder$1, midCRLF$1), trace$111);
            }, (Function1 & Serializable)err -> {
                if (stringBuilder$1.isEmpty()) {
                    return ZChannel$.MODULE$.refailCause(err);
                }
                return ZChannel$.MODULE$.write(Chunk$.MODULE$.single((Object)stringBuilder$1.result()), trace$111).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.refailCause(err), trace$111);
            }, (Function1 & Serializable)done -> {
                if (stringBuilder$1.isEmpty()) {
                    return ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$111);
                }
                return ZChannel$.MODULE$.write(Chunk$.MODULE$.single((Object)stringBuilder$1.result()), trace$111).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$111), trace$111);
            }, trace$111));
            return zChannel;
        }
    }

    private static final ZChannel loop$8(LazyRef loop$lzy$5, Object trace$111, StringBuilder stringBuilder$1, BooleanRef midCRLF$1) {
        if (loop$lzy$5.initialized()) {
            return (ZChannel)loop$lzy$5.value();
        }
        return ZPipeline$.loop$lzycompute$5(loop$lzy$5, trace$111, stringBuilder$1, midCRLF$1);
    }

    private static final ZChannel loop$9(long n, Object trace$112) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)chunk -> {
            Chunk taken = chunk.take((int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(n), Integer.MAX_VALUE));
            long leftover = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(n - (long)taken.length()), 0L);
            if (leftover > 0L) {
                return ZChannel$.MODULE$.write(taken, trace$112).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$9(leftover, trace$112), trace$112);
            }
            return ZChannel$.MODULE$.write(taken, trace$112);
        }, (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$57 -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> x$57, trace$112), trace$112);
    }

    public static final /* synthetic */ boolean $anonfun$takeUntil$3(Function1 f$47, Object x$58) {
        return !BoxesRunTime.unboxToBoolean((Object)f$47.apply(x$58));
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$6(LazyRef loop$lzy$6, Function1 f$47, Object trace$113) {
        synchronized (loop$lzy$6) {
            ZChannel zChannel = loop$lzy$6.initialized() ? (ZChannel)loop$lzy$6.value() : (ZChannel)loop$lzy$6.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)chunk -> {
                Chunk taken = chunk.takeWhile((Function1 & Serializable)x$58 -> BoxesRunTime.boxToBoolean((boolean)ZPipeline$.$anonfun$takeUntil$3(f$47, x$58)));
                Chunk last = chunk.drop(taken.length()).take(1);
                if (last.isEmpty()) {
                    return ZChannel$.MODULE$.write(taken, trace$113).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$10(loop$lzy$6, f$47, trace$113), trace$113);
                }
                return ZChannel$.MODULE$.write(taken.$plus$plus(last), trace$113);
            }, (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$59 -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> x$59, trace$113), trace$113));
            return zChannel;
        }
    }

    private static final ZChannel loop$10(LazyRef loop$lzy$6, Function1 f$47, Object trace$113) {
        if (loop$lzy$6.initialized()) {
            return (ZChannel)loop$lzy$6.value();
        }
        return ZPipeline$.loop$lzycompute$6(loop$lzy$6, f$47, trace$113);
    }

    private static final /* synthetic */ ZChannel read$lzycompute$1(LazyRef read$lzy$1, Object trace$114, Function1 f$48) {
        synchronized (read$lzy$1) {
            ZChannel zChannel = read$lzy$1.initialized() ? (ZChannel)read$lzy$1.value() : (ZChannel)read$lzy$1.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)elem -> ZPipeline$.write$1(elem.chunkIterator(), 0, f$48, trace$114, read$lzy$1), (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)done -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$114), trace$114));
            return zChannel;
        }
    }

    private static final ZChannel read$1(LazyRef read$lzy$1, Object trace$114, Function1 f$48) {
        if (read$lzy$1.initialized()) {
            return (ZChannel)read$lzy$1.value();
        }
        return ZPipeline$.read$lzycompute$1(read$lzy$1, trace$114, f$48);
    }

    public static final /* synthetic */ ZChannel $anonfun$takeUntilZIO$7(Object a$1, Object trace$114, Chunk.ChunkIterator chunkIterator$3, int index$3, Function1 f$48, LazyRef read$lzy$1, boolean b) {
        if (b) {
            return ZChannel$.MODULE$.write(Chunk$.MODULE$.single(a$1), trace$114);
        }
        return ZChannel$.MODULE$.write(Chunk$.MODULE$.single(a$1), trace$114).$times$greater((Function0 & Serializable)() -> ZPipeline$.write$1(chunkIterator$3, index$3 + 1, f$48, trace$114, read$lzy$1), trace$114);
    }

    private static final ZChannel write$1(Chunk.ChunkIterator chunkIterator, int index, Function1 f$48, Object trace$114, LazyRef read$lzy$1) {
        if (chunkIterator.hasNextAt(index)) {
            return ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> {
                Object a = chunkIterator.nextAt(index);
                return ((ZIO)f$48.apply(a)).map((Function1 & Serializable)b -> ZPipeline$.$anonfun$takeUntilZIO$7(a, trace$114, chunkIterator, index, f$48, read$lzy$1, BoxesRunTime.unboxToBoolean((Object)b)), trace$114);
            }, trace$114);
        }
        return ZPipeline$.read$1(read$lzy$1, trace$114, f$48);
    }

    private static final /* synthetic */ ZChannel loop$lzycompute$7(LazyRef loop$lzy$7, Function1 f$49, Object trace$115) {
        synchronized (loop$lzy$7) {
            ZChannel zChannel = loop$lzy$7.initialized() ? (ZChannel)loop$lzy$7.value() : (ZChannel)loop$lzy$7.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)chunk -> {
                Chunk taken = chunk.takeWhile(f$49);
                if (taken.length() == chunk.length()) {
                    return ZChannel$.MODULE$.write(taken, trace$115).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$11(loop$lzy$7, f$49, trace$115), trace$115);
                }
                return ZChannel$.MODULE$.write(taken, trace$115);
            }, (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$60 -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> x$60, trace$115), trace$115));
            return zChannel;
        }
    }

    private static final ZChannel loop$11(LazyRef loop$lzy$7, Function1 f$49, Object trace$115) {
        if (loop$lzy$7.initialized()) {
            return (ZChannel)loop$lzy$7.value();
        }
        return ZPipeline$.loop$lzycompute$7(loop$lzy$7, f$49, trace$115);
    }

    private static final /* synthetic */ ZChannel read$lzycompute$2(LazyRef read$lzy$2, Object trace$116, Function1 f$50) {
        synchronized (read$lzy$2) {
            ZChannel zChannel = read$lzy$2.initialized() ? (ZChannel)read$lzy$2.value() : (ZChannel)read$lzy$2.initialize(ZChannel$.MODULE$.readWithCause((Function1 & Serializable)elem -> ZPipeline$.write$2(elem.chunkIterator(), 0, f$50, trace$116, read$lzy$2), (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)done -> ZChannel$.MODULE$.succeed((Function0 & Serializable)() -> done, trace$116), trace$116));
            return zChannel;
        }
    }

    private static final ZChannel read$2(LazyRef read$lzy$2, Object trace$116, Function1 f$50) {
        if (read$lzy$2.initialized()) {
            return (ZChannel)read$lzy$2.value();
        }
        return ZPipeline$.read$lzycompute$2(read$lzy$2, trace$116, f$50);
    }

    public static final /* synthetic */ ZChannel $anonfun$takeWhileZIO$7(Object a$2, Object trace$116, Chunk.ChunkIterator chunkIterator$4, int index$4, Function1 f$50, LazyRef read$lzy$2, boolean b) {
        if (b) {
            return ZChannel$.MODULE$.write(Chunk$.MODULE$.single(a$2), trace$116).$times$greater((Function0 & Serializable)() -> ZPipeline$.write$2(chunkIterator$4, index$4 + 1, f$50, trace$116, read$lzy$2), trace$116);
        }
        return ZChannel$.MODULE$.unit();
    }

    private static final ZChannel write$2(Chunk.ChunkIterator chunkIterator, int index, Function1 f$50, Object trace$116, LazyRef read$lzy$2) {
        if (chunkIterator.hasNextAt(index)) {
            return ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> {
                Object a = chunkIterator.nextAt(index);
                return ((ZIO)f$50.apply(a)).map((Function1 & Serializable)b -> ZPipeline$.$anonfun$takeWhileZIO$7(a, trace$116, chunkIterator, index, f$50, read$lzy$2, BoxesRunTime.unboxToBoolean((Object)b)), trace$116);
            }, trace$116);
        }
        return ZPipeline$.read$2(read$lzy$2, trace$116, f$50);
    }

    private static final ZChannel loop$12(long tokens, long timestamp, Function1 costFn$5, Object trace$119, Duration duration$6, long units$7, long burst$6) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> ((ZIO)costFn$5.apply(in)).$less$times$greater((Function0 & Serializable)() -> Clock$.MODULE$.nanoTime(trace$119), Zippable$.MODULE$.Zippable2(), trace$119).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long available;
                long weight = x0$1._1$mcJ$sp();
                long current = x0$1._2$mcJ$sp();
                double cycles = (double)(current - timestamp) / (double)duration$6.toNanos();
                long sum = tokens + (long)(cycles * (double)units$7);
                long max = units$7 + burst$6 < 0L ? Long.MAX_VALUE : units$7 + burst$6;
                long l = available = sum < 0L ? max : scala.math.package$.MODULE$.min(sum, max);
                if (weight <= available) {
                    return ZChannel$.MODULE$.write(in, trace$119).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$12(available - weight, current, costFn$5, trace$119, duration$6, units$7, burst$6), trace$119);
                }
                return ZPipeline$.loop$12(tokens, timestamp, costFn$5, trace$119, duration$6, units$7, burst$6);
            }
            throw new MatchError(null);
        }, trace$119), trace$119), (Function1 & Serializable)e -> ZChannel$.MODULE$.refailCause(e), (Function1 & Serializable)x$63 -> ZChannel$.MODULE$.unit(), trace$119);
    }

    public static final /* synthetic */ ZChannel $anonfun$throttleShapeZIO$7(long timestamp$2, Duration duration$8, long tokens$2, long units$9, long burst$9, long weight$2, Object trace$121, Chunk in$10, Function1 costFn$6, long current) {
        double cycles = (double)(current - timestamp$2) / (double)duration$8.toNanos();
        long sum = tokens$2 + (long)(cycles * (double)units$9);
        long max = units$9 + burst$9 < 0L ? Long.MAX_VALUE : units$9 + burst$9;
        long remaining = (sum < 0L ? max : scala.math.package$.MODULE$.min(sum, max)) - weight$2;
        double waitCycles = remaining >= 0L ? 0.0 : -((double)remaining) / (double)units$9;
        Duration delay = Duration.Finite$.MODULE$.apply((long)(waitCycles * (double)duration$8.toNanos()));
        if (DurationOps$.MODULE$.$greater$extension(package$.MODULE$.duration2DurationOps(delay), Duration$.MODULE$.Zero())) {
            return ZChannel$.MODULE$.fromZIO((Function0 & Serializable)() -> Clock$.MODULE$.sleep((Function0 & Serializable)() -> delay, trace$121), trace$121).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.write(in$10, trace$121), trace$121).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$13(remaining, current, costFn$6, trace$121, duration$8, units$9, burst$9), trace$121);
        }
        return ZChannel$.MODULE$.write(in$10, trace$121).$times$greater((Function0 & Serializable)() -> ZPipeline$.loop$13(remaining, current, costFn$6, trace$121, duration$8, units$9, burst$9), trace$121);
    }

    public static final /* synthetic */ ZIO $anonfun$throttleShapeZIO$6(Object trace$121, long timestamp$2, Duration duration$8, long tokens$2, long units$9, long burst$9, Chunk in$10, Function1 costFn$6, long weight) {
        return Clock$.MODULE$.nanoTime(trace$121).map((Function1 & Serializable)current -> ZPipeline$.$anonfun$throttleShapeZIO$7(timestamp$2, duration$8, tokens$2, units$9, burst$9, weight, trace$121, in$10, costFn$6, BoxesRunTime.unboxToLong((Object)current)), trace$121);
    }

    private static final ZChannel loop$13(long tokens, long timestamp, Function1 costFn$6, Object trace$121, Duration duration$8, long units$9, long burst$9) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> ZChannel$.MODULE$.unwrap((Function0 & Serializable)() -> ((ZIO)costFn$6.apply(in)).flatMap((Function1 & Serializable)weight -> ZPipeline$.$anonfun$throttleShapeZIO$6(trace$121, timestamp, duration$8, tokens, units$9, burst$9, in, costFn$6, BoxesRunTime.unboxToLong((Object)weight)), trace$121), trace$121), (Function1 & Serializable)e -> ZChannel$.MODULE$.refailCause(e), (Function1 & Serializable)x$66 -> ZChannel$.MODULE$.unit(), trace$121);
    }

    public static final /* synthetic */ Tuple2 $anonfun$zipWithIndex$3(long index, Object a) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(index + 1L)), (Object)new Tuple2(a, (Object)BoxesRunTime.boxToLong((long)index)));
    }

    public static final /* synthetic */ ZChannel $anonfun$zipWithNext$5(Option newLast$3, Object trace$127) {
        return ZPipeline$.process$1(newLast$3, trace$127);
    }

    private static final ZChannel process$1(Option last, Object trace$127) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)in -> {
            void var4_4;
            void var5_5;
            Tuple2 tuple2 = in.mapAccum((Object)last, (Function2 & Serializable)(prev, curr) -> new Tuple2((Object)new Some(curr), (Object)prev.map((Function1 & Serializable)x$69 -> new Tuple2(x$69, curr))));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option newLast = (Option)tuple2._1();
            Chunk chunk = (Chunk)tuple2._2();
            Chunk out = var5_5.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Option<Tuple2<In, In>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Tuple2 tuple2;
                    if (x1 instanceof Some && (tuple2 = (Tuple2)((Some)x1).value()) != null) {
                        Object prev = tuple2._1();
                        Object curr = tuple2._2();
                        return (B1)new Tuple2(prev, (Object)new Some(curr));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Option<Tuple2<In, In>> x1) {
                    return x1 instanceof Some && (Tuple2)((Some)x1).value() != null;
                }
            });
            return ZChannel$.MODULE$.write(out, trace$127).$times$greater(() -> ZPipeline$.$anonfun$zipWithNext$5((Option)var4_4, trace$127), trace$127);
        }, (Function1 & Serializable)err -> ZChannel$.MODULE$.refailCause(err), (Function1 & Serializable)x$71 -> {
            if (last instanceof Some) {
                Object value = ((Some)last).value();
                return ZChannel$.MODULE$.write(Chunk$.MODULE$.single((Object)new Tuple2(value, (Object)None$.MODULE$)), trace$127).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.unit(), trace$127);
            }
            if (None$.MODULE$.equals(last)) {
                return ZChannel$.MODULE$.unit();
            }
            throw new MatchError((Object)last);
        }, trace$127);
    }

    public static final /* synthetic */ ZChannel $anonfun$utfDecodeDetectingBom$8(ZPipeline decodingPipeline$1) {
        return decodingPipeline$1.channel();
    }

    private static final ZChannel lookingForBom$1(Chunk buffer, int bomSize, Function1 processBom$1, Object trace$128) {
        return ZChannel$.MODULE$.readWithCause((Function1 & Serializable)received -> {
            Chunk data = buffer.$plus$plus(received);
            if (data.length() >= bomSize) {
                void var8_8;
                void var10_10;
                void var11_11;
                void var7_7;
                Tuple2 tuple2 = data.splitAt(bomSize);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Chunk bom = (Chunk)tuple2._1();
                Chunk rest = (Chunk)tuple2._2();
                Tuple2 tuple22 = (Tuple2)processBom$1.apply((Object)var7_7);
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Chunk bomRemainder = (Chunk)tuple22._1();
                ZPipeline decodingPipeline = (ZPipeline)tuple22._2();
                ZChannel decoderChannel = var11_11.channel();
                return ZChannel$.MODULE$.write(var10_10.$plus$plus((Chunk)var8_8), trace$128).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace$128), trace$128).$greater$greater$greater((Function0 & Serializable)() -> decoderChannel, trace$128);
            }
            return ZPipeline$.lookingForBom$1(data, bomSize, processBom$1, trace$128);
        }, (Function1 & Serializable)cause -> ZChannel$.MODULE$.refailCause(cause), (Function1 & Serializable)x$75 -> {
            void var6_6;
            void var5_5;
            if (buffer.isEmpty()) {
                return ZChannel$.MODULE$.unit();
            }
            Tuple2 tuple2 = (Tuple2)processBom$1.apply((Object)buffer);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Chunk bomRemainder = (Chunk)tuple2._1();
            ZPipeline decodingPipeline = (ZPipeline)tuple2._2();
            return ZChannel$.MODULE$.write(var5_5, trace$128).$times$greater((Function0 & Serializable)() -> ZChannel$.MODULE$.identity(trace$128), trace$128).$greater$greater$greater(() -> ZPipeline$.$anonfun$utfDecodeDetectingBom$8((ZPipeline)var6_6), trace$128);
        }, trace$128);
    }

    private ZPipeline$() {
    }

    public static final /* synthetic */ Object $anonfun$hexDecode$1$adapted(ObjectRef bad$1, Chunk cs$1, ChunkBuilder temp$1, Object i) {
        return ZPipeline$.$anonfun$hexDecode$1(bad$1, cs$1, temp$1, BoxesRunTime.unboxToInt((Object)i));
    }
}

