/*
 * Decompiled with CFR 0.152.
 */
package zio.stream.compression;

import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.compression.CompressionLevel;
import zio.stream.compression.CompressionStrategy;
import zio.stream.compression.Deflate$;
import zio.stream.compression.FlushMode;
import zio.stream.compression.Gzipper$;

public class Gzipper {
    private final FlushMode flushMode;
    private final CRC32 crc;
    private final byte[] buffer;
    private boolean headerSent;
    private long inputSize;
    private final Deflater deflater;

    public static ZIO<Object, Nothing$, Gzipper> make(int n, CompressionLevel compressionLevel, CompressionStrategy compressionStrategy, FlushMode flushMode) {
        return Gzipper$.MODULE$.make(n, compressionLevel, compressionStrategy, flushMode);
    }

    public Gzipper(int bufferSize, CompressionLevel level, CompressionStrategy strategy, FlushMode flushMode) {
        this.flushMode = flushMode;
        this.crc = new CRC32();
        this.buffer = new byte[bufferSize];
        this.headerSent = false;
        this.inputSize = 0L;
        Deflater deflater = new Deflater(level.jValue(), true);
        deflater.setStrategy(strategy.jValue());
        this.deflater = deflater;
    }

    public ZIO<Object, Nothing$, Chunk<Object>> onNone() {
        return ZIO$.MODULE$.effectTotal(this::onNone$$anonfun$1);
    }

    public ZIO<Object, Nothing$, Chunk<Object>> onChunk(Chunk<Object> chunk) {
        return ZIO$.MODULE$.effectTotal(() -> this.onChunk$$anonfun$1(chunk));
    }

    public Chunk<Object> getTrailer() {
        long v = this.crc.getValue();
        long s = this.inputSize & 0xFFFFFFFFL;
        return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{Gzipper.byte$1(v, 0), Gzipper.byte$1(v, 1), Gzipper.byte$1(v, 2), Gzipper.byte$1(v, 3), Gzipper.byte$1(s, 0), Gzipper.byte$1(s, 1), Gzipper.byte$1(s, 2), Gzipper.byte$1(s, 3)}));
    }

    public void close() {
        this.deflater.finish();
    }

    /*
     * WARNING - void declaration
     */
    private final Chunk onNone$$anonfun$1() {
        void var2_2;
        this.deflater.finish();
        Chunk restAndTrailer = Deflate$.MODULE$.pullOutput(this.deflater, this.buffer, this.flushMode).$plus$plus(this.getTrailer());
        Chunk lastChunk = this.headerSent ? restAndTrailer : Gzipper$.zio$stream$compression$Gzipper$$$header.$plus$plus(restAndTrailer);
        this.deflater.reset();
        this.crc.reset();
        this.inputSize = 0L;
        this.headerSent = false;
        return var2_2;
    }

    private final Chunk onChunk$$anonfun$1(Chunk chunk$1) {
        Chunk chunk;
        byte[] input = (byte[])chunk$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        this.inputSize += (long)input.length;
        this.crc.update(input);
        this.deflater.setInput(input);
        Chunk deflated = Deflate$.MODULE$.pullOutput(this.deflater, this.buffer, this.flushMode);
        if (this.headerSent) {
            chunk = deflated;
        } else {
            this.headerSent = true;
            chunk = Gzipper$.zio$stream$compression$Gzipper$$$header.$plus$plus(deflated);
        }
        return chunk;
    }

    private static final byte byte$1(long v, int n) {
        return (byte)(v >> n * 8 & 0xFFL);
    }
}

