/*
 * Decompiled with CFR 0.152.
 */
package zio.stream.internal;

import java.io.InputStream;
import scala.Option;
import scala.collection.Iterator;
import scala.package$;
import scala.runtime.BoxesRunTime;
import zio.Chunk;
import zio.Chunk$;
import zio.Runtime;
import zio.ZIO;
import zio.stream.internal.ZInputStream$;

public class ZInputStream
extends InputStream {
    private Iterator chunks;
    private Chunk<Object> current;
    private int currentPos;
    private int currentChunkLen;
    private boolean done;

    public static <R> ZInputStream fromPull(Runtime<R> runtime, ZIO<R, Option<Throwable>, Chunk<Object>> zIO) {
        return ZInputStream$.MODULE$.fromPull(runtime, zIO);
    }

    public ZInputStream(Iterator<Chunk<Object>> chunks) {
        this.chunks = chunks;
        this.current = Chunk$.MODULE$.empty();
        this.currentPos = 0;
        this.currentChunkLen = 0;
        this.done = false;
    }

    private Iterator<Chunk<Object>> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(Iterator<Chunk<Object>> x$0) {
        this.chunks = x$0;
    }

    private int availableInCurrentChunk() {
        return this.currentChunkLen - this.currentPos;
    }

    /*
     * WARNING - void declaration
     */
    private byte readOne() {
        void var1_1;
        byte res = BoxesRunTime.unboxToByte((Object)this.current.apply(this.currentPos));
        ++this.currentPos;
        return (byte)var1_1;
    }

    private void loadNext() {
        if (this.chunks().hasNext()) {
            this.current = (Chunk)this.chunks().next();
            this.currentChunkLen = this.current.length();
            this.currentPos = 0;
        } else {
            this.done = true;
        }
    }

    @Override
    public int read() {
        return this.go$1();
    }

    @Override
    public int read(byte[] bytes, int off, int len) {
        int written;
        int n = this.done ? -1 : (len != 0 ? ((written = this.doRead(bytes, off, len, 0)) == 0 ? -1 : written) : 0);
        return n;
    }

    private int doRead(byte[] bytes, int off, int len, int written) {
        int n;
        ZInputStream zInputStream = this;
        int n2 = written;
        int n3 = len;
        int n4 = off;
        while (true) {
            if (n3 <= zInputStream.availableInCurrentChunk()) {
                zInputStream.readFromCurrentChunk(bytes, n4, n3);
                n = n2 + n3;
                break;
            }
            int av = zInputStream.availableInCurrentChunk();
            zInputStream.readFromCurrentChunk(bytes, n4, av);
            zInputStream.loadNext();
            if (zInputStream.done) {
                n = n2 + av;
                break;
            }
            ZInputStream zInputStream2 = zInputStream;
            int n5 = n4 + av;
            int n6 = n3 - av;
            int n7 = n2 + av;
            zInputStream = zInputStream2;
            n4 = n5;
            n3 = n6;
            n2 = n7;
        }
        return n;
    }

    private void readFromCurrentChunk(byte[] bytes, int off, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[off + i] = this.readOne();
        }
    }

    @Override
    public int available() {
        return this.availableInCurrentChunk();
    }

    @Override
    public void close() {
        this.chunks_$eq((Iterator<Chunk<Object>>)package$.MODULE$.Iterator().empty());
        this.loadNext();
    }

    private final int go$1() {
        int n;
        while (true) {
            if (this.done) {
                n = -1;
                break;
            }
            if (this.availableInCurrentChunk() > 0) {
                n = this.readOne() & 0xFF;
                break;
            }
            this.loadNext();
        }
        return n;
    }
}

