/*
 * Decompiled with CFR 0.152.
 */
package zio.test.sbt;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.portablescala.reflect.LoadableModuleClass;
import org.portablescala.reflect.Reflect$;
import sbt.testing.Runner;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import zio.Console;
import zio.Runtime;
import zio.Scope$;
import zio.Trace$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIOAppArgs;
import zio.ZIOAppArgs$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.test.ExecutionEventPrinter$;
import zio.test.Summary;
import zio.test.Summary$;
import zio.test.TestArgs;
import zio.test.TestArgs$;
import zio.test.TestOutput;
import zio.test.TestOutput$;
import zio.test.ZIOSpecAbstract;
import zio.test.sbt.Colors$;
import zio.test.sbt.TestRunner$;
import zio.test.sbt.TestTask;
import zio.test.sbt.ZTestTask;

public abstract class TestRunner
implements Runner {
    private final String[] args;
    private final String[] remoteArgs0;
    private final ClassLoader testClassLoader;
    private final String runnerType;
    private volatile boolean isDone;
    private final TestArgs testArgs;
    private final ConcurrentLinkedQueue<Runtime.Scoped<TestOutput>> sharedRuntimes;
    private final ConcurrentLinkedQueue<Summary> summaries;

    public static String moduleName(String string) {
        return TestRunner$.MODULE$.moduleName(string);
    }

    public TestRunner(String[] args, String[] remoteArgs0, ClassLoader testClassLoader, String runnerType) {
        this.args = args;
        this.remoteArgs0 = remoteArgs0;
        this.testClassLoader = testClassLoader;
        this.runnerType = runnerType;
        this.isDone = false;
        this.testArgs = TestArgs$.MODULE$.parse(args);
        this.sharedRuntimes = new ConcurrentLinkedQueue();
        this.summaries = new ConcurrentLinkedQueue();
    }

    public final String[] args() {
        return this.args;
    }

    private void verifyNonDone() {
        if (this.isDone) {
            throw new IllegalStateException("Runner " + this + " is already done!");
        }
    }

    public final String[] remoteArgs() {
        return this.remoteArgs0;
    }

    public abstract boolean sharedRuntimeSupported();

    public final void addSummary(Summary summary) {
        this.summaries.offer(summary);
    }

    public abstract void sendSummary(Summary var1);

    public abstract boolean returnSummary();

    public final Task[] tasks(TaskDef[] taskDefs) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.tasks(taskDefs, (Console)Console.ConsoleLive$.MODULE$, Trace$.MODULE$.empty()));
        return (Task[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(Task.class));
    }

    public final TestTask[] tasks(TaskDef[] taskDefs, Console console, Object trace) {
        None$ none$;
        this.verifyNonDone();
        Object object = Predef$.MODULE$.refArrayOps((Object[])taskDefs);
        Object[] withSpecs = (Tuple2[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)taskDef -> {
            TaskDef taskDef2 = (TaskDef)Predef$.MODULE$.ArrowAssoc(taskDef);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)taskDef2, (Object)this.loadSpec((TaskDef)taskDef));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        if (!this.sharedRuntimeSupported()) {
            none$ = None$.MODULE$;
        } else {
            Object object2 = Predef$.MODULE$.refArrayOps(withSpecs);
            Runtime.Scoped<TestOutput> sharedRuntime = this.getSharedRuntime((ZIOSpecAbstract[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$1 -> (ZIOSpecAbstract)_$1._2(), ClassTag$.MODULE$.apply(ZIOSpecAbstract.class)), console, trace);
            this.sharedRuntimes.offer(sharedRuntime);
            none$ = Some$.MODULE$.apply(sharedRuntime);
        }
        None$ sharedRuntime = none$;
        Object object3 = Predef$.MODULE$.refArrayOps(withSpecs);
        return (TestTask[])ArrayOps$.MODULE$.map$extension(object3, arg_0 -> this.tasks$$anonfun$1((Option)sharedRuntime, arg_0), ClassTag$.MODULE$.apply(TestTask.class));
    }

    private Runtime.Scoped<TestOutput> getSharedRuntime(ZIOSpecAbstract[] specs, Console console, Object trace) {
        ZLayer zLayer = ZLayer$.MODULE$.ZLayerProvideSomeOps(ExecutionEventPrinter$.MODULE$.live(console, this.testArgs.testEventRenderer(), this.testArgs.reportsParent()));
        ZLayer sharedTestOutputLayer = ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(zLayer, TestRunner::$anonfun$3, trace);
        ZLayer zLayer2 = ZLayer$.MODULE$.ZLayerProvideSomeOps(Scope$.MODULE$.default().$plus$plus(TestRunner::$anonfun$4, Tag$.MODULE$.apply(ZIOAppArgs.class, LightTypeTag$.MODULE$.parse(-735904144, "\u0004\u0000\u0001\u000ezio.ZIOAppArgs\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u000ezio.ZIOAppArgs\u0001\u0001\u0003\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 30))));
        ZLayer sharedLayerFromSpecs = ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(zLayer2, () -> TestRunner.$anonfun$5(specs), trace);
        ZLayer sharedLayer = sharedLayerFromSpecs.$plus$bang$plus(() -> TestRunner.$anonfun$6(sharedTestOutputLayer));
        return Runtime.unsafe$.MODULE$.fromLayer(sharedLayer, trace, (Unsafe)Unsafe$.MODULE$);
    }

    private TestTask toTask(TaskDef taskDef, ZIOSpecAbstract spec, Option<Runtime.Scoped<TestOutput>> sharedRuntime) {
        return new ZTestTask(taskDef, spec, this.runnerType, (Function1<Summary, BoxedUnit>)(JProcedure1 & Serializable)summary -> this.sendSummary((Summary)summary), this.testArgs, sharedRuntime);
    }

    public final TestTask toTask(TaskDef taskDef) {
        return this.toTask(taskDef, this.loadSpec(taskDef), (Option<Runtime.Scoped<TestOutput>>)None$.MODULE$);
    }

    private ZIOSpecAbstract loadSpec(TaskDef taskDef) {
        String fqcn = TestRunner$.MODULE$.moduleName(taskDef.fullyQualifiedName());
        return (ZIOSpecAbstract)((LoadableModuleClass)Reflect$.MODULE$.lookupLoadableModuleClass(fqcn, this.testClassLoader).getOrElse(() -> TestRunner.loadSpec$$anonfun$1(fqcn))).loadModule();
    }

    public final String done() {
        String summary;
        String string;
        this.verifyNonDone();
        this.isDone = true;
        this.sharedRuntimes.forEach((Consumer<Runtime.Scoped<TestOutput>>)((Consumer<Runtime.Scoped>)_$5 -> _$5.unsafe().shutdown((Unsafe)Unsafe$.MODULE$)));
        IndexedSeq summaries = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)this.summaries.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Summary.class))));
        int total = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)summaries.map((Function1 & Serializable)_$6 -> _$6.total())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int ignore = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)summaries.map((Function1 & Serializable)_$7 -> _$7.ignore())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (summaries.nonEmpty() && total != ignore) {
            Summary compositeSummary = (Summary)summaries.foldLeft((Object)Summary$.MODULE$.empty(), (Function2 & Serializable)(_$8, _$9) -> _$8.add(_$9));
            String renderedSummary = this.testArgs.testRenderer().renderSummary(compositeSummary);
            string = Colors$.MODULE$.coloredLines(renderedSummary);
        } else {
            string = summary = ignore > 0 ? (String)Colors$.MODULE$.yellow().apply((Object)"All eligible tests are currently ignored") : (String)Colors$.MODULE$.yellow().apply((Object)"No tests were executed");
        }
        if (this.returnSummary()) {
            return summary;
        }
        if (summaries.nonEmpty()) {
            Predef$.MODULE$.println((Object)summary);
        }
        return "Completed tests";
    }

    private final /* synthetic */ TestTask tasks$$anonfun$1(Option sharedRuntime$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            TaskDef taskDef = (TaskDef)tuple2._1();
            ZIOSpecAbstract spec = (ZIOSpecAbstract)tuple2._2();
            return this.toTask(taskDef, spec, (Option<Runtime.Scoped<TestOutput>>)sharedRuntime$1);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final ZLayer $anonfun$3() {
        return TestOutput$.MODULE$.live();
    }

    private static final ZLayer $anonfun$4() {
        return ZIOAppArgs$.MODULE$.empty();
    }

    private static final ZLayer $anonfun$5$$anonfun$2$$anonfun$1(ZLayer _$4$1) {
        return _$4$1;
    }

    private static final ZLayer $anonfun$5(ZIOSpecAbstract[] specs$1) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])specs$1);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.bootstrap(), ClassTag$.MODULE$.apply(ZLayer.class)));
        return (ZLayer)ArrayOps$.MODULE$.foldLeft$extension(object2, (Object)ZLayer$.MODULE$.empty(), (Function2 & Serializable)(_$3, _$4) -> _$3.$plus$bang$plus(() -> TestRunner.$anonfun$5$$anonfun$2$$anonfun$1(_$4)));
    }

    private static final ZLayer $anonfun$6(ZLayer sharedTestOutputLayer$1) {
        return sharedTestOutputLayer$1;
    }

    private static final LoadableModuleClass loadSpec$$anonfun$1(String fqcn$1) {
        throw new ClassNotFoundException("failed to load object: " + fqcn$1);
    }
}

