/*
 * Decompiled with CFR 0.152.
 */
package zio.test.sbt;

import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.util.concurrent.ConcurrentLinkedQueue;
import sbt.testing.Runner;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.ZIO;
import zio.test.Summary;
import zio.test.TestArgs$;
import zio.test.sbt.SummaryProtocol$;
import zio.test.sbt.ZTestTask$;
import zio.test.sbt.package$;

public abstract class ZTestRunnerNative
implements Runner {
    private final String[] args;
    private final String[] remoteArgs0;
    private final ClassLoader testClassLoader;
    private final String runnerType;
    private final ConcurrentLinkedQueue summaries;

    public ZTestRunnerNative(String[] args, String[] remoteArgs0, ClassLoader testClassLoader, String runnerType) {
        this.args = args;
        this.remoteArgs0 = remoteArgs0;
        this.testClassLoader = testClassLoader;
        this.runnerType = runnerType;
        this.summaries = new ConcurrentLinkedQueue();
    }

    public String[] args() {
        return this.args;
    }

    public String[] remoteArgs() {
        return this.remoteArgs0;
    }

    public abstract ZIO<Summary, Nothing$, BoxedUnit> sendSummary();

    public ConcurrentLinkedQueue<Summary> summaries() {
        return this.summaries;
    }

    public String done() {
        boolean isEmpty;
        StringBuilder log = new StringBuilder();
        Summary summary = this.summaries().poll();
        int total = 0;
        int ignore = 0;
        boolean bl = isEmpty = summary == null;
        while (summary != null) {
            total += summary.total();
            ignore += summary.ignore();
            String details = summary.failureDetails();
            if (!details.isBlank()) {
                log.append(package$.MODULE$.colored(details));
                log.append('\n');
            }
            summary = this.summaries().poll();
        }
        if (isEmpty || total == ignore) {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u001b[33mNo tests were executed\u001b[0m"});
        }
        return log.append("Done").result();
    }

    public Task[] tasks(TaskDef[] defs) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])defs);
        return (Task[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> ZTestTask$.MODULE$.apply((TaskDef)_$1, this.testClassLoader, this.runnerType, this.sendSummary(), TestArgs$.MODULE$.parse(this.args())), ClassTag$.MODULE$.apply(Task.class));
    }

    public Option<String> receiveMessage(String summary) {
        SummaryProtocol$.MODULE$.deserialize(summary).foreach((Function1 & Serializable)x$0 -> this.summaries().offer((Summary)x$0));
        return None$.MODULE$;
    }

    public String serializeTask(Task task, Function1<TaskDef, String> serializer) {
        return (String)serializer.apply((Object)task.taskDef());
    }

    public Task deserializeTask(String task, Function1<String, TaskDef> deserializer) {
        return ZTestTask$.MODULE$.apply((TaskDef)deserializer.apply((Object)task), this.testClassLoader, this.runnerType, this.sendSummary(), TestArgs$.MODULE$.parse(this.args()));
    }
}

