/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause;
import zio.Exit;
import zio.internal.ansi;
import zio.test.ConsoleUtils$;
import zio.test.CustomAssertion;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.PrettyPrint$;
import zio.test.Result$;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.TestTrace;
import zio.test.TestTrace$;
import zio.test.TestTrace$Node$;
import zio.test.diff.Diff;
import zio.test.diff.DiffResult;
import zio.test.internal.OptionalImplicit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$ {
    public static final SmartAssertions$ MODULE$ = new SmartAssertions$();
    private static final TestArrow<Object, Object> anything = TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> TestTrace$.MODULE$.boolean(true, ErrorMessage$.MODULE$.was().$plus("anything")));
    private static final TestArrow<Object, Throwable> throws = TestArrow$.MODULE$.makeEither((Function1 & Serializable)value -> TestTrace$.MODULE$.succeed(value), (Function1 & Serializable)x$8 -> TestTrace$.MODULE$.fail("Expected failure"));

    public TestArrow<Object, Object> anything() {
        return anything;
    }

    public <A> TestArrow<A, Object> approximatelyEquals(A reference, A tolerance, Numeric<A> evidence$1) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)actual -> {
            Numeric referenceType = (Numeric)Predef$.MODULE$.implicitly((Object)evidence$1);
            Object max = referenceType.plus(reference, tolerance);
            Object min = referenceType.minus(reference, tolerance);
            boolean result = referenceType.gteq(actual, min) && referenceType.lteq(actual, max);
            return TestTrace$.MODULE$.boolean(result, ErrorMessage$.MODULE$.pretty(actual).$plus(ErrorMessage$.MODULE$.did()).$plus("approximately equal").$plus(ErrorMessage$.MODULE$.pretty(reference)).$plus("with a tolerance of").$plus(ErrorMessage$.MODULE$.pretty(tolerance)));
        });
    }

    public <A, B> TestArrow<A, B> custom(CustomAssertion<A, B> customAssertion) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Either either = (Either)customAssertion.run().apply(a);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return TestTrace$.MODULE$.fail(error);
            }
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            throw new MatchError((Object)either);
        });
    }

    public <A> TestArrow<Option<A>, A> isSome() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Some) {
                Object value = ((Some)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(x0$1)) {
                return TestTrace$.MODULE$.fail("Option was None");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Either<Object, A>, A> asRight() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Right) {
                Object value = ((Right)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Left) {
                return TestTrace$.MODULE$.fail("Either was Left");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Either<A, Object>, A> asLeft() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Left) {
                Object value = ((Left)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Right) {
                return TestTrace$.MODULE$.fail("Either was Right");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Iterable<A>, Object> isEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(as.isEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringBuilder(7).append("(size ").append(as.size()).append(")").toString()))));
    }

    public TestArrow<String, Object> isEmptyString() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.isEmpty(), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringBuilder(9).append("(length ").append(string.length()).append(")").toString()))));
    }

    public TestArrow<Iterable<Object>, Object> isNonEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(as.nonEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public TestArrow<String, Object> isNonEmptyString() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string)), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public TestArrow<Option<Object>, Object> isEmptyOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isEmpty(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("empty")));
    }

    public TestArrow<Option<Object>, Object> isDefinedOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isDefined(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("defined")));
    }

    public <A> TestArrow<Iterable<A>, Object> forallIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Iterable failures = (Iterable)((Iterable)seq.map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure($less$colon$less$.MODULE$.refl())));
            String elements = failures.size() == 1 ? "element" : "elements";
            return new TestTrace.Node<Boolean>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)failures.isEmpty())), ErrorMessage$.MODULE$.pretty(BoxesRunTime.boxToInteger((int)failures.size())).$plus(ErrorMessage$.MODULE$.text(new StringBuilder(21).append(elements).append(" failed the predicate").toString())), (Option<TestTrace<Object>>)(failures.isEmpty() ? None$.MODULE$ : new Some(failures.reduce((Function2 & Serializable)(x$3, x$4) -> x$3.$amp$amp((TestTrace<Object>)x$4, $less$colon$less$.MODULE$.refl())))), TestTrace$Node$.MODULE$.apply$default$4(), TestTrace$Node$.MODULE$.apply$default$5(), TestTrace$Node$.MODULE$.apply$default$6(), TestTrace$Node$.MODULE$.apply$default$7(), TestTrace$Node$.MODULE$.apply$default$8(), TestTrace$Node$.MODULE$.apply$default$9(), TestTrace$Node$.MODULE$.apply$default$10(), TestTrace$Node$.MODULE$.apply$default$11());
        });
    }

    public <A> TestArrow<Iterable<A>, Object> existsIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Option result = ((IterableOnceOps)seq.view().map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)))).find((Function1 & Serializable)tt -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$existsIterable$3(tt)));
            Option success = result.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isSuccess($less$colon$less$.MODULE$.refl())));
            String elements = success.nonEmpty() ? "element" : "elements";
            ErrorMessage elementsSatisfiedPredicateMsg = result.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDie())) ? ErrorMessage$.MODULE$.text(new StringBuilder(53).append(elements).append(" satisfied the predicate before it threw an exception").toString()) : ErrorMessage$.MODULE$.text(new StringBuilder(24).append(elements).append(" satisfied the predicate").toString());
            return new TestTrace.Node<Boolean>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)success.nonEmpty())), ErrorMessage$.MODULE$.pretty(BoxesRunTime.boxToInteger((int)Option$.MODULE$.option2Iterable(success).size())).$plus(elementsSatisfiedPredicateMsg), (Option<TestTrace<Object>>)result, TestTrace$Node$.MODULE$.apply$default$4(), TestTrace$Node$.MODULE$.apply$default$5(), TestTrace$Node$.MODULE$.apply$default$6(), TestTrace$Node$.MODULE$.apply$default$7(), TestTrace$Node$.MODULE$.apply$default$8(), TestTrace$Node$.MODULE$.apply$default$9(), TestTrace$Node$.MODULE$.apply$default$10(), TestTrace$Node$.MODULE$.apply$default$11());
        });
    }

    public <A, B> TestArrow<Seq<B>, Object> containsSeq(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.contains(value), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Iterable<A>, Object> containsIterable(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$containsIterable$2(value, x$7))), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <E> TestArrow<Cause<E>, Object> containsCause(Cause<E> expected) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)cause -> TestTrace$.MODULE$.boolean(cause.contains(expected), ErrorMessage$.MODULE$.pretty(cause).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(expected))));
    }

    public <A> TestArrow<Option<A>, Object> containsOption(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.contains(value), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public TestArrow<String, Object> containsString(String value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)str -> TestTrace$.MODULE$.boolean(str.contains(value), ErrorMessage$.MODULE$.pretty(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Seq<A>, A> hasAt(int index) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> as.apply(index)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Invalid index").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)index))).$plus("for").$plus(MODULE$.className((Iterable)as)).$plus("of size").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)as.length()))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, B> hasField(String name, Function1<A, B> proj) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.succeed(proj.apply(a)));
    }

    public <K, V> TestArrow<Map<K, V>, V> hasKey(K key) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)mapKV -> {
            Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> mapKV.apply(key)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Missing key").$plus(ErrorMessage$.MODULE$.pretty(key)));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> head() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = as.headOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> last() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = as.lastOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<A, Object> isEven(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(0)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even")));
    }

    public <A> TestArrow<A, Object> isOdd(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(1)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd")));
    }

    public <A> TestArrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option<String> option;
            DiffResult diffResult;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option2 = diff.value();
            return TestTrace$.MODULE$.boolean(result, option2 instanceof Some && !(diff = (Diff)((Some)option2).value()).isLowPriority() && !result ? ((diffResult = diff.diff(that, a)) instanceof DiffResult.Different && None$.MODULE$.equals(option = ((DiffResult.Different)diffResult).customRender()) ? ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)) : ErrorMessage$.MODULE$.choice("There was no difference", "There was a difference").$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected"))).$plus$plus(ErrorMessage$.MODULE$.custom(PrettyPrint$.MODULE$.apply(that))).$plus$plus(ErrorMessage$.MODULE$.custom(new StringBuilder(0).append(ConsoleUtils$.MODULE$.underlined("Diff")).append(ansi.AnsiStringOps$.MODULE$.withAnsi$extension(" \u001b[31m-expected \u001b[32m+obtained", (ansi.AnsiCode)ansi.Style$.Faint$.MODULE$)).toString())).$plus$plus(ErrorMessage$.MODULE$.custom(new StringBuilder(4).append("\u001b[0m").append(diffResult.render()).toString()))) : ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)));
        });
    }

    public <E> TestArrow<Cause<E>, Throwable> asCauseDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1.dieOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(x0$1.dieOption().get());
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Die")));
        });
    }

    public <E> TestArrow<Cause<E>, E> asCauseFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1.failureOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(x0$1.failureOption().get());
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Fail")));
        });
    }

    public <E> TestArrow<Cause<E>, Object> asCauseInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1.isInterrupted()) {
                return TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Interrupt")));
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Throwable> asExitDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.dieOption().isDefined()) {
                    return TestTrace$.MODULE$.succeed(cause.dieOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            if (bl) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E> TestArrow<Exit<E, Object>, Cause<E>> asExitCause() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Failure) {
                Cause cause = ((Exit.Failure)x0$1).cause();
                return TestTrace$.MODULE$.succeed(cause);
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E> TestArrow<Exit<E, Object>, E> asExitFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.failureOption().isDefined()) {
                    return TestTrace$.MODULE$.succeed(cause.failureOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Failure")));
            }
            if (bl) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Fail")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Object> asExitInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                if (((Exit.Failure)x0$1).cause().isInterrupted()) {
                    return TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
            }
            if (bl) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Interrupt")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, A> asExitSuccess() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Success) {
                Object value = ((Exit.Success)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Exit.Failure) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Success")));
            }
            throw new MatchError(x0$1);
        });
    }

    public TestArrow<Object, Throwable> throws() {
        return throws;
    }

    public <A, B> TestArrow<A, B> as(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option option = CB.unapply(a);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus("is not an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, Object> is(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(CB.unapply(a).isDefined(), ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus(ErrorMessage$.MODULE$.was()).$plus("an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB)))));
    }

    public <A> TestArrow<Seq<A>, Object> startsWithSeq(Seq<A> prefix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.startsWith((IterableOnce)prefix, seq.startsWith$default$2()), ErrorMessage$.MODULE$.pretty(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.pretty(prefix))));
    }

    public TestArrow<String, Object> startsWithString(String prefix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.startsWith(prefix), ErrorMessage$.MODULE$.value(string).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.value(prefix))));
    }

    public <A> TestArrow<Seq<A>, Object> endsWithSeq(Seq<A> postfix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.endsWith((Iterable)postfix), ErrorMessage$.MODULE$.value(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(seq))));
    }

    public TestArrow<String, Object> endsWithString(String postfix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.endsWith(postfix), ErrorMessage$.MODULE$.value(string).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(postfix))));
    }

    private <A> String className(ClassTag<A> C) {
        try {
            return C.runtimeClass().getSimpleName();
        }
        catch (Throwable throwable) {
            if (throwable instanceof InternalError) {
                String string = ((InternalError)throwable).getMessage();
                String string2 = "Malformed class name";
                if (string != null && string.equals(string2)) {
                    return C.runtimeClass().getName();
                }
            }
            throw throwable;
        }
    }

    private <A> ErrorMessage className(Iterable<A> a) {
        return ErrorMessage$.MODULE$.value(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(a.toString()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$1(BoxesRunTime.unboxToChar((Object)x$9)))));
    }

    private <A> ErrorMessage className(Option<A> a) {
        return ErrorMessage$.MODULE$.value(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(a.toString()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$2(BoxesRunTime.unboxToChar((Object)x$10)))));
    }

    public static final /* synthetic */ boolean $anonfun$existsIterable$3(TestTrace tt) {
        return tt.isSuccess($less$colon$less$.MODULE$.refl()) || tt.isDie();
    }

    public static final /* synthetic */ boolean $anonfun$containsIterable$2(Object value$2, Object x$7) {
        return BoxesRunTime.equals((Object)x$7, (Object)value$2);
    }

    public static final /* synthetic */ boolean $anonfun$className$1(char x$9) {
        return x$9 != '(';
    }

    public static final /* synthetic */ boolean $anonfun$className$2(char x$10) {
        return x$10 != '(';
    }

    private SmartAssertions$() {
    }
}

