/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.ansi;
import zio.test.ConsoleUtils$;
import zio.test.FailureCase;
import zio.test.PrettyPrint$;
import zio.test.Result;
import zio.test.TestArrow;
import zio.test.TestTrace;
import zio.test.render.LogLine;

public final class FailureCase$
implements Serializable {
    public static final FailureCase$ MODULE$ = new FailureCase$();

    public String highlight(String string, TestArrow.Span span, Option<TestArrow.Span> parentSpan, Function1<String, String> color, Function1<String, String> normalColor) {
        TestArrow.Span span2;
        if (parentSpan instanceof Some && (span2 = (TestArrow.Span)((Some)parentSpan).value()) != null) {
            int pStart = span2.start();
            int pEnd = span2.end();
            if (pStart <= span.start() && pEnd >= span.end()) {
                String part1 = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(string), pStart);
                String part2 = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(string), pStart, span.start());
                String part3 = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(string), span.start(), span.end());
                String part4 = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(string), span.end(), pEnd);
                String part5 = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(string), pEnd);
                return new StringBuilder(0).append(part1).append(ConsoleUtils$.MODULE$.bold(part2)).append(ConsoleUtils$.MODULE$.bold((String)color.apply((Object)part3))).append(ConsoleUtils$.MODULE$.bold(part4)).append(part5).toString();
            }
        }
        return new StringBuilder(0).append(ConsoleUtils$.MODULE$.bold((String)normalColor.apply((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(string), span.start())))).append(ConsoleUtils$.MODULE$.bold((String)color.apply((Object)StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(string), span.start(), span.end())))).append(ConsoleUtils$.MODULE$.bold((String)normalColor.apply((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(string), span.end())))).toString();
    }

    public Option<TestArrow.Span> highlight$default$3() {
        return None$.MODULE$;
    }

    public Function1<String, String> highlight$default$5() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public TestTrace.Node<Object> rightmostNode(TestTrace<Object> trace) {
        while (true) {
            if (trace instanceof TestTrace.Node) {
                return (TestTrace.Node)trace;
            }
            if (trace instanceof TestTrace.AndThen) {
                trace = ((TestTrace.AndThen)trace).right();
                continue;
            }
            if (trace instanceof TestTrace.And) {
                trace = ((TestTrace.And)trace).right();
                continue;
            }
            if (trace instanceof TestTrace.Or) {
                trace = ((TestTrace.Or)trace).right();
                continue;
            }
            if (!(trace instanceof TestTrace.Not)) break;
            trace = ((TestTrace.Not)trace).trace();
        }
        throw new MatchError(trace);
    }

    public Chunk<Tuple2<String, String>> getPath(TestTrace<?> trace) {
        if (trace instanceof TestTrace.Node) {
            TestTrace.Node node = (TestTrace.Node)trace;
            return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node.code()), (Object)PrettyPrint$.MODULE$.apply(node.renderResult()))}));
        }
        if (trace instanceof TestTrace.AndThen) {
            TestTrace.AndThen andThen = (TestTrace.AndThen)trace;
            TestTrace left = andThen.left();
            TestTrace right = andThen.right();
            return this.getPath(left).$plus$plus(this.getPath(right));
        }
        return Chunk$.MODULE$.empty();
    }

    public Chunk<FailureCase> fromTrace(TestTrace<Object> trace, Chunk<Tuple2<String, String>> path) {
        while (true) {
            if (trace instanceof TestTrace.Node) {
                TestTrace.Node node = (TestTrace.Node)trace;
                return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FailureCase[]{this.fromNode(node, (Chunk<Tuple2<String, String>>)((Chunk)path.reverse()))}));
            }
            if (trace instanceof TestTrace.AndThen) {
                TestTrace.AndThen andThen = (TestTrace.AndThen)trace;
                TestTrace left = andThen.left();
                path = path.$plus$plus(this.getPath(left));
                trace = andThen.right();
                continue;
            }
            if (trace instanceof TestTrace.And) {
                TestTrace.And and = (TestTrace.And)trace;
                TestTrace<Object> left = and.left();
                TestTrace<Object> right = and.right();
                return this.fromTrace(left, (Chunk<Tuple2<String, String>>)path).$plus$plus(this.fromTrace(right, (Chunk<Tuple2<String, String>>)path));
            }
            if (trace instanceof TestTrace.Or) {
                TestTrace.Or or = (TestTrace.Or)trace;
                TestTrace<Object> left = or.left();
                TestTrace<Object> right = or.right();
                return this.fromTrace(left, (Chunk<Tuple2<String, String>>)path).$plus$plus(this.fromTrace(right, (Chunk<Tuple2<String, String>>)path));
            }
            if (!(trace instanceof TestTrace.Not)) break;
            trace = ((TestTrace.Not)trace).trace();
        }
        throw new MatchError(trace);
    }

    private FailureCase fromNode(TestTrace.Node<Object> node, Chunk<Tuple2<String, String>> path) {
        String string;
        Function1 & Serializable color = node.result() instanceof Result.Die ? (Function1 & Serializable)s -> ConsoleUtils$.MODULE$.red((String)s) : (Function1 & Serializable)s -> ConsoleUtils$.MODULE$.yellow((String)s);
        LogLine.Message message = node.message().render(node.isSuccess((.less.colon.less<Object, Object>)$less$colon$less$.MODULE$.refl()));
        Option<String> option = node.completeCode();
        if (option instanceof Some) {
            String completeCode = (String)((Some)option).value();
            int idx = completeCode.indexOf(node.code());
            string = idx >= 0 && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(node.code())) ? this.highlight(completeCode, new TestArrow.Span(idx, idx + node.code().length()), (Option<TestArrow.Span>)None$.MODULE$, (Function1<String, String>)color, (Function1<String, String>)(Function1 & Serializable)x$1 -> ansi.AnsiStringOps$.MODULE$.withAnsi$extension(x$1, (ansi.AnsiCode)ansi.Color$.Cyan$.MODULE$)) : completeCode;
        } else if (None$.MODULE$.equals(option)) {
            string = this.highlight((String)node.fullCode().getOrElse((Function0 & Serializable)() -> "<CODE>"), (TestArrow.Span)node.span().getOrElse((Function0 & Serializable)() -> new TestArrow.Span(0, 0)), node.parentSpan(), (Function1<String, String>)color, this.highlight$default$5());
        } else {
            throw new MatchError(option);
        }
        return new FailureCase(message, string, (String)node.location().getOrElse((Function0 & Serializable)() -> "<LOCATION>"), path, (TestArrow.Span)node.span().getOrElse((Function0 & Serializable)() -> new TestArrow.Span(0, 0)), (Chunk<FailureCase>)((Chunk)node.children().map((Function1 & Serializable)x$2 -> MODULE$.fromTrace((TestTrace<Object>)x$2, (Chunk<Tuple2<String, String>>)Chunk$.MODULE$.empty())).getOrElse((Function0 & Serializable)() -> Chunk$.MODULE$.empty())), node.result(), node.customLabel());
    }

    public FailureCase apply(LogLine.Message errorMessage, String codeString, String location, Chunk<Tuple2<String, String>> path, TestArrow.Span span, Chunk<FailureCase> nestedFailures, Object result, Option<String> customLabel) {
        return new FailureCase(errorMessage, codeString, location, path, span, nestedFailures, result, customLabel);
    }

    public Option<Tuple8<LogLine.Message, String, String, Chunk<Tuple2<String, String>>, TestArrow.Span, Chunk<FailureCase>, Object, Option<String>>> unapply(FailureCase x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.errorMessage(), (Object)x$0.codeString(), (Object)x$0.location(), x$0.path(), (Object)x$0.span(), x$0.nestedFailures(), x$0.result(), x$0.customLabel()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FailureCase$.class);
    }

    private FailureCase$() {
    }
}

