/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import zio.Cause;
import zio.Exit;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.test.ConsoleUtils$;
import zio.test.CustomAssertion;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.PrettyPrint$;
import zio.test.Result$;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.TestTrace;
import zio.test.TestTrace$;
import zio.test.TestTrace$Node$;
import zio.test.diff.Diff;
import zio.test.diff.DiffResult;
import zio.test.internal.OptionalImplicit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$ {
    public static final SmartAssertions$ MODULE$ = new SmartAssertions$();
    private static final TestArrow<Object, Object> anything = TestArrow$.MODULE$.make((Function1 & Serializable)x$1 -> TestTrace$.MODULE$.boolean(true, ErrorMessage$.MODULE$.was().$plus("anything")));
    private static final TestArrow<Object, Throwable> throws = TestArrow$.MODULE$.makeEither((Function1 & Serializable)value -> TestTrace$.MODULE$.succeed(value), (Function1 & Serializable)x$8 -> TestTrace$.MODULE$.fail("Expected failure"));

    public TestArrow<Object, Object> anything() {
        return anything;
    }

    public <A> TestArrow<A, Object> approximatelyEquals(A reference, A tolerance, Numeric<A> evidence$1) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)actual -> {
            Object max = evidence$1.plus(reference, tolerance);
            Object min = evidence$1.minus(reference, tolerance);
            boolean result = evidence$1.gteq(actual, min) && evidence$1.lteq(actual, max);
            return TestTrace$.MODULE$.boolean(result, ErrorMessage$.MODULE$.pretty(actual).$plus(ErrorMessage$.MODULE$.did()).$plus("approximately equal").$plus(ErrorMessage$.MODULE$.pretty(reference)).$plus("with a tolerance of").$plus(ErrorMessage$.MODULE$.pretty(tolerance)));
        });
    }

    public <A, B> TestArrow<A, B> custom(CustomAssertion<A, B> customAssertion) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Either either = (Either)customAssertion.run().apply(a);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return TestTrace$.MODULE$.fail(error);
            }
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            throw new MatchError((Object)either);
        });
    }

    public <A> TestArrow<Option<A>, A> isSome() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Some) {
                Object value = ((Some)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(x0$1)) {
                return TestTrace$.MODULE$.fail("Option was None");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Try<A>, A> asTrySuccess() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Failure) {
                return TestTrace$.MODULE$.fail("Try was Failure");
            }
            if (x0$1 instanceof Success) {
                Object value = ((Success)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Try<A>, Throwable> asTryFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Failure) {
                Throwable exception = ((Failure)x0$1).exception();
                return TestTrace$.MODULE$.succeed(exception);
            }
            if (x0$1 instanceof Success) {
                return TestTrace$.MODULE$.fail("Try was Success");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Either<Object, A>, A> asRight() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Right) {
                Object value = ((Right)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Left) {
                return TestTrace$.MODULE$.fail("Either was Left");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Either<A, Object>, A> asLeft() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Left) {
                Object value = ((Left)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Right) {
                return TestTrace$.MODULE$.fail("Either was Right");
            }
            throw new MatchError(x0$1);
        });
    }

    public <A> TestArrow<Iterable<A>, Object> isEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(as.isEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text("(size " + as.size() + ")"))));
    }

    public TestArrow<String, Object> isEmptyString() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.isEmpty(), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text("(length " + string.length() + ")"))));
    }

    public TestArrow<Iterable<Object>, Object> isNonEmptyIterable() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> TestTrace$.MODULE$.boolean(as.nonEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public TestArrow<String, Object> isNonEmptyString() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(!string.isEmpty(), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public TestArrow<Option<Object>, Object> isEmptyOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isEmpty(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("empty")));
    }

    public TestArrow<Option<Object>, Object> isDefinedOption() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isDefined(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("defined")));
    }

    public <A> TestArrow<Iterable<A>, Object> forallIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Iterable failures = (Iterable)((Iterable)seq.map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, new Right(a)))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure($less$colon$less$.MODULE$.refl())));
            String elements = failures.size() == 1 ? "element" : "elements";
            return new TestTrace.Node<Boolean>(Result$.MODULE$.succeed(failures.isEmpty()), ErrorMessage$.MODULE$.pretty(failures.size()).$plus(ErrorMessage$.MODULE$.text(elements + " failed the predicate")), (Option<TestTrace<Object>>)(failures.isEmpty() ? None$.MODULE$ : new Some(failures.reduce((Function2 & Serializable)(x$3, x$4) -> x$3.$amp$amp((TestTrace<Object>)x$4, $less$colon$less$.MODULE$.refl())))), TestTrace$Node$.MODULE$.apply$default$4(), TestTrace$Node$.MODULE$.apply$default$5(), TestTrace$Node$.MODULE$.apply$default$6(), TestTrace$Node$.MODULE$.apply$default$7(), TestTrace$Node$.MODULE$.apply$default$8(), TestTrace$Node$.MODULE$.apply$default$9(), TestTrace$Node$.MODULE$.apply$default$10(), TestTrace$Node$.MODULE$.apply$default$11());
        });
    }

    public <A> TestArrow<Iterable<A>, Object> existsIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Option result = ((IterableOnceOps)seq.view().map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, new Right(a)))).find((Function1 & Serializable)tt -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$existsIterable$3(tt)));
            if (result == null) {
                throw null;
            }
            Option success = result.isEmpty() || BoxesRunTime.unboxToBoolean((Object)SmartAssertions$.$anonfun$existsIterable$4$adapted((TestTrace)result.get())) ? result : None$.MODULE$;
            String elements = success.isDefined() ? "element" : "elements";
            ErrorMessage elementsSatisfiedPredicateMsg = !result.isEmpty() && BoxesRunTime.unboxToBoolean((Object)SmartAssertions$.$anonfun$existsIterable$5$adapted((TestTrace)result.get())) ? ErrorMessage$.MODULE$.text(elements + " satisfied the predicate before it threw an exception") : ErrorMessage$.MODULE$.text(elements + " satisfied the predicate");
            return new TestTrace.Node<Boolean>(Result$.MODULE$.succeed(success.isDefined()), ErrorMessage$.MODULE$.pretty(Option$.MODULE$.option2Iterable(success).size()).$plus(elementsSatisfiedPredicateMsg), (Option<TestTrace<Object>>)result, TestTrace$Node$.MODULE$.apply$default$4(), TestTrace$Node$.MODULE$.apply$default$5(), TestTrace$Node$.MODULE$.apply$default$6(), TestTrace$Node$.MODULE$.apply$default$7(), TestTrace$Node$.MODULE$.apply$default$8(), TestTrace$Node$.MODULE$.apply$default$9(), TestTrace$Node$.MODULE$.apply$default$10(), TestTrace$Node$.MODULE$.apply$default$11());
        });
    }

    public <A, B> TestArrow<Seq<B>, Object> containsSeq(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.contains(value), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Iterable<A>, Object> containsIterable(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$containsIterable$2(value, x$7))), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <E> TestArrow<Cause<E>, Object> containsCause(Cause<E> expected) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)cause -> TestTrace$.MODULE$.boolean(cause.contains(expected), ErrorMessage$.MODULE$.pretty(cause).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(expected))));
    }

    public <A> TestArrow<Option<A>, Object> containsOption(A value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.contains(value), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public TestArrow<String, Object> containsString(String value) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)str -> TestTrace$.MODULE$.boolean(str.contains(value), ErrorMessage$.MODULE$.pretty(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value))));
    }

    public <A> TestArrow<Seq<A>, A> hasAt(int index) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Success success;
            try {
                Object apply_r1 = as.apply(index);
                success = new Success(apply_r1);
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    success = new Failure(throwable);
                }
                throw throwable;
            }
            Object var4_2 = null;
            Object var5_4 = null;
            Option option = success.toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Invalid index").$plus(ErrorMessage$.MODULE$.value(index)).$plus("for").$plus(MODULE$.className((Iterable)as)).$plus("of size").$plus(ErrorMessage$.MODULE$.value(as.length())));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, B> hasField(String name, Function1<A, B> proj) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.succeed(proj.apply(a)));
    }

    public <K, V> TestArrow<Map<K, V>, V> hasKey(K key) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)mapKV -> {
            Success success;
            try {
                Object apply_r1 = mapKV.apply(key);
                success = new Success(apply_r1);
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    success = new Failure(throwable);
                }
                throw throwable;
            }
            Object var4_2 = null;
            Object var5_4 = null;
            Option option = success.toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Missing key").$plus(ErrorMessage$.MODULE$.pretty(key)));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> head() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = as.headOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<Iterable<A>, A> last() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)as -> {
            Option option = as.lastOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> TestArrow<A, Object> isEven(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(0)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even")));
    }

    public <A> TestArrow<A, Object> isOdd(Integral<A> integral) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(1)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd")));
    }

    public <A> TestArrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> greaterThanL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> greaterThanOrEqualToL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> lessThanL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> lessThanOrEqualToL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> greaterThanR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> greaterThanOrEqualToR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> lessThanR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A, B> TestArrow<A, Object> lessThanOrEqualToR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that))));
    }

    public <A> TestArrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option<String> option;
            DiffResult diffResult;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option2 = diff.value();
            return TestTrace$.MODULE$.boolean(result, option2 instanceof Some && !(diff = (Diff)((Some)option2).value()).isLowPriority() && !result ? ((diffResult = diff.diff(that, a)) instanceof DiffResult.Different && None$.MODULE$.equals(option = ((DiffResult.Different)diffResult).customRender()) ? ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)) : ErrorMessage$.MODULE$.choice("There was no difference", "There was a difference").$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected"))).$plus$plus(ErrorMessage$.MODULE$.custom(PrettyPrint$.MODULE$.apply(that))).$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Diff") + ansi.AnsiStringOps$.MODULE$.faint$extension(ansi$.MODULE$.AnsiStringOps(" \u001b[31m-expected \u001b[32m+obtained")))).$plus$plus(ErrorMessage$.MODULE$.custom("\u001b[0m" + diffResult.render()))) : ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)));
        });
    }

    public <A, B> TestArrow<A, Object> equalToL(B that, OptionalImplicit<Diff<B>> diff, Function1<A, B> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option<String> option;
            DiffResult diffResult;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option2 = diff.value();
            return TestTrace$.MODULE$.boolean(result, option2 instanceof Some && !(diff = (Diff)((Some)option2).value()).isLowPriority() && !result ? ((diffResult = diff.diff(that, conv.apply(a))) instanceof DiffResult.Different && None$.MODULE$.equals(option = ((DiffResult.Different)diffResult).customRender()) ? ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)) : ErrorMessage$.MODULE$.choice("There was no difference", "There was a difference").$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected"))).$plus$plus(ErrorMessage$.MODULE$.custom(PrettyPrint$.MODULE$.apply(that))).$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Diff") + ansi.AnsiStringOps$.MODULE$.faint$extension(ansi$.MODULE$.AnsiStringOps(" \u001b[31m-expected \u001b[32m+obtained")))).$plus$plus(ErrorMessage$.MODULE$.custom("\u001b[0m" + diffResult.render()))) : ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)));
        });
    }

    public <A, B> TestArrow<A, Object> equalToR(B that, OptionalImplicit<Diff<A>> diff, Function1<B, A> conv) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option<String> option;
            DiffResult diffResult;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option2 = diff.value();
            return TestTrace$.MODULE$.boolean(result, option2 instanceof Some && !(diff = (Diff)((Some)option2).value()).isLowPriority() && !result ? ((diffResult = diff.diff(conv.apply(that), a)) instanceof DiffResult.Different && None$.MODULE$.equals(option = ((DiffResult.Different)diffResult).customRender()) ? ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)) : ErrorMessage$.MODULE$.choice("There was no difference", "There was a difference").$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected"))).$plus$plus(ErrorMessage$.MODULE$.custom(PrettyPrint$.MODULE$.apply(that))).$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Diff") + ansi.AnsiStringOps$.MODULE$.faint$extension(ansi$.MODULE$.AnsiStringOps(" \u001b[31m-expected \u001b[32m+obtained")))).$plus$plus(ErrorMessage$.MODULE$.custom("\u001b[0m" + diffResult.render()))) : ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that)));
        });
    }

    public <E> TestArrow<Cause<E>, Throwable> asCauseDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1.dieOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(x0$1.dieOption().get());
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Die")));
        });
    }

    public <E> TestArrow<Cause<E>, E> asCauseFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1.failureOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(x0$1.failureOption().get());
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Fail")));
        });
    }

    public <E> TestArrow<Cause<E>, Object> asCauseInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1.isInterrupted()) {
                return TestTrace$.MODULE$.succeed(true);
            }
            return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Interrupt")));
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Throwable> asExitDie() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.dieOption().isDefined()) {
                    return TestTrace$.MODULE$.succeed(cause.dieOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            if (bl) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E> TestArrow<Exit<E, Object>, Cause<E>> asExitCause() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Failure) {
                Cause cause = ((Exit.Failure)x0$1).cause();
                return TestTrace$.MODULE$.succeed(cause);
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E> TestArrow<Exit<E, Object>, E> asExitFailure() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.failureOption().isDefined()) {
                    return TestTrace$.MODULE$.succeed(cause.failureOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Failure")));
            }
            if (bl) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Fail")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Object> asExitInterrupted() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                if (((Exit.Failure)x0$1).cause().isInterrupted()) {
                    return TestTrace$.MODULE$.succeed(true);
                }
            }
            if (x0$1 instanceof Exit.Success) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
            }
            if (bl) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Interrupt")));
            }
            throw new MatchError(x0$1);
        });
    }

    public <E, A> TestArrow<Exit<E, A>, A> asExitSuccess() {
        return TestArrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Success) {
                Object value = ((Exit.Success)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Exit.Failure) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Success")));
            }
            throw new MatchError(x0$1);
        });
    }

    public TestArrow<Object, Throwable> throws() {
        return throws;
    }

    public <A, B> TestArrow<A, B> as(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> {
            Option option = CB.unapply(a);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus("is not an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A, B> TestArrow<A, Object> is(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(CB.unapply(a).isDefined(), ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus(ErrorMessage$.MODULE$.was()).$plus("an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB)))));
    }

    public <A> TestArrow<Seq<A>, Object> startsWithSeq(Seq<A> prefix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.startsWith((IterableOnce)prefix, seq.startsWith$default$2()), ErrorMessage$.MODULE$.pretty(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.pretty(prefix))));
    }

    public TestArrow<String, Object> startsWithString(String prefix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.startsWith(prefix), ErrorMessage$.MODULE$.value(string).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.value(prefix))));
    }

    public <A> TestArrow<Seq<A>, Object> endsWithSeq(Seq<A> postfix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.endsWith((Iterable)postfix), ErrorMessage$.MODULE$.value(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(seq))));
    }

    public TestArrow<String, Object> endsWithString(String postfix) {
        return TestArrow$.MODULE$.make((Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.endsWith(postfix), ErrorMessage$.MODULE$.value(string).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(postfix))));
    }

    private <A> String className(ClassTag<A> C) {
        try {
            return C.runtimeClass().getSimpleName();
        }
        catch (Throwable throwable) {
            if (throwable instanceof InternalError) {
                String string = ((InternalError)throwable).getMessage();
                String string2 = "Malformed class name";
                if (string != null && string.equals(string2)) {
                    return C.runtimeClass().getName();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A> ErrorMessage className(Iterable<A> a) {
        String string;
        int n;
        void takeWhile$extension_$this;
        block4: {
            Object var2_2;
            String augmentString_x = a.toString();
            void v0 = var2_2;
            var2_2 = null;
            takeWhile$extension_$this = v0;
            int takeWhile$extension_indexWhere$extension_from = 0;
            int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
            for (int takeWhile$extension_indexWhere$extension_i = takeWhile$extension_indexWhere$extension_from; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                if (!(!BoxesRunTime.unboxToBoolean((Object)SmartAssertions$.$anonfun$className$1$adapted(Character.valueOf(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))))) continue;
                n = takeWhile$extension_indexWhere$extension_i;
                break block4;
            }
            n = -1;
        }
        int n2 = n;
        switch (n2) {
            case -1: {
                string = takeWhile$extension_$this;
                break;
            }
            default: {
                string = takeWhile$extension_$this.substring(0, n2);
            }
        }
        Object var3_3 = null;
        return ErrorMessage$.MODULE$.value(string);
    }

    /*
     * WARNING - void declaration
     */
    private <A> ErrorMessage className(Option<A> a) {
        String string;
        int n;
        void takeWhile$extension_$this;
        block4: {
            Object var2_2;
            String augmentString_x = a.toString();
            void v0 = var2_2;
            var2_2 = null;
            takeWhile$extension_$this = v0;
            int takeWhile$extension_indexWhere$extension_from = 0;
            int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
            for (int takeWhile$extension_indexWhere$extension_i = takeWhile$extension_indexWhere$extension_from; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                if (!(!BoxesRunTime.unboxToBoolean((Object)SmartAssertions$.$anonfun$className$2$adapted(Character.valueOf(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))))) continue;
                n = takeWhile$extension_indexWhere$extension_i;
                break block4;
            }
            n = -1;
        }
        int n2 = n;
        switch (n2) {
            case -1: {
                string = takeWhile$extension_$this;
                break;
            }
            default: {
                string = takeWhile$extension_$this.substring(0, n2);
            }
        }
        Object var3_3 = null;
        return ErrorMessage$.MODULE$.value(string);
    }

    public static final /* synthetic */ boolean $anonfun$existsIterable$3(TestTrace tt) {
        return tt.isSuccess($less$colon$less$.MODULE$.refl()) || tt.isDie();
    }

    public static final /* synthetic */ boolean $anonfun$containsIterable$2(Object value$2, Object x$7) {
        return BoxesRunTime.equals((Object)x$7, (Object)value$2);
    }

    public static final /* synthetic */ boolean $anonfun$className$1(char x$9) {
        return x$9 != '(';
    }

    public static final /* synthetic */ boolean $anonfun$className$2(char x$10) {
        return x$10 != '(';
    }

    private SmartAssertions$() {
    }

    public static final /* synthetic */ Object $anonfun$className$1$adapted(Object x$9) {
        return BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$1(BoxesRunTime.unboxToChar((Object)x$9)));
    }

    public static final /* synthetic */ Object $anonfun$className$2$adapted(Object x$10) {
        return BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$2(BoxesRunTime.unboxToChar((Object)x$10)));
    }

    public static final /* synthetic */ Object $anonfun$existsIterable$4$adapted(TestTrace x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.isSuccess($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Object $anonfun$existsIterable$5$adapted(TestTrace x$6) {
        return BoxesRunTime.boxToBoolean((boolean)x$6.isDie());
    }
}

