/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.internal.ansi;
import zio.test.PrettyPrintVersionSpecific;

public final class PrettyPrint$
implements PrettyPrintVersionSpecific {
    public static final PrettyPrint$ MODULE$ = new PrettyPrint$();
    private static final int maxListLength;

    static {
        PrettyPrintVersionSpecific.$init$(MODULE$);
        maxListLength = 10;
    }

    @Override
    public Iterator<String> labels(Product product) {
        return PrettyPrintVersionSpecific.labels$(this, product);
    }

    private int maxListLength() {
        return maxListLength;
    }

    public String apply(Object any) {
        if (any instanceof NonEmptyChunk) {
            NonEmptyChunk nonEmptyChunk = (NonEmptyChunk)any;
            return this.prettyPrintIterator((Iterator<Object>)NonEmptyChunk$.MODULE$.toChunk(nonEmptyChunk).iterator(), NonEmptyChunk$.MODULE$.toChunk(nonEmptyChunk).size(), "NonEmptyChunk");
        }
        if (any instanceof Chunk) {
            Chunk chunk = (Chunk)any;
            return this.prettyPrintIterator((Iterator<Object>)chunk.iterator(), chunk.size(), "Chunk");
        }
        if (ScalaRunTime$.MODULE$.isArray(any, 1)) {
            return this.prettyPrintIterator((Iterator<Object>)ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(any)), ScalaRunTime$.MODULE$.array_length(any), "Array");
        }
        if (any instanceof Some) {
            Object a = ((Some)any).value();
            return new StringBuilder(6).append("Some(").append(this.apply(a)).append(")").toString();
        }
        if (None$.MODULE$.equals(any)) {
            return "None";
        }
        if (Nil$.MODULE$.equals(any)) {
            return "Nil";
        }
        if (any instanceof Set) {
            Set set = (Set)any;
            return this.prettyPrintIterator((Iterator<Object>)set.iterator(), set.size(), this.className(set));
        }
        if (any instanceof Seq) {
            Seq seq = (Seq)any;
            return this.prettyPrintIterator((Iterator<Object>)seq.iterator(), seq.size(), this.className(seq));
        }
        if (any instanceof Map) {
            Iterable body = (Iterable)((Map)any).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Object key = x0$1._1();
                    Object value = x0$1._2();
                    return new StringBuilder(4).append(MODULE$.apply(key)).append(" -> ").append(MODULE$.apply(value)).toString();
                }
                throw new MatchError(null);
            });
            return new StringBuilder(7).append("Map(\n").append(this.indent(body.mkString(",\n"), this.indent$default$2())).append("\n)").toString();
        }
        if (any instanceof Product) {
            Product product = (Product)any;
            String name = product.productPrefix();
            String body = this.labels(product).zip((IterableOnce)product.productIterator()).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    Object value = x0$2._2();
                    return new StringBuilder(1).append(ansi.AnsiStringOps$.MODULE$.withAnsi$extension(new StringBuilder(2).append(key).append(" =").toString(), (ansi.AnsiCode)ansi.Style$.Faint$.MODULE$)).append(" ").append(MODULE$.apply(value)).toString();
                }
                throw new MatchError(null);
            }).toList().mkString(",\n");
            boolean isMultiline = body.split("\n").length > 1;
            String indentedBody = this.indent(body, isMultiline ? 2 : 0);
            String spacer = isMultiline ? "\n" : "";
            return new StringBuilder(2).append(name).append("(").append(spacer).append(indentedBody).append(spacer).append(")").toString();
        }
        if (any instanceof String) {
            String string = (String)any;
            String surround = string.split("\n").length > 1 ? "\"\"\"" : "\"";
            return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(string.replace("\"", "\\\"")), surround, "", surround);
        }
        if (any instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)any);
            return new StringBuilder(2).append("'").append(Character.toString(c)).append("'").toString();
        }
        if (any == null) {
            return "<null>";
        }
        return any.toString();
    }

    private String prettyPrintIterator(Iterator<Object> iterator, int length, String className) {
        String suffix = length > this.maxListLength() ? new StringBuilder(9).append(" + ").append(length - this.maxListLength()).append(" more)").toString() : ")";
        return iterator.take(this.maxListLength()).map((Function1 & Serializable)any -> MODULE$.apply(any)).mkString(new StringBuilder(1).append(className).append("(").toString(), ", ", suffix);
    }

    private String indent(String string, int n) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])string.split("\n")), (Function1 & Serializable)x$1 -> new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).append((String)x$1).toString(), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    private int indent$default$2() {
        return 2;
    }

    private String className(Object any) {
        if (any instanceof List) {
            return "List";
        }
        return any.getClass().getSimpleName();
    }

    private PrettyPrint$() {
    }
}

