/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import zio.Cause;
import zio.Exit;
import zio.internal.ansi;
import zio.test.ConsoleUtils$;
import zio.test.CustomAssertion;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.GenFailureDetails;
import zio.test.PrettyPrint$;
import zio.test.Result;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.TestTrace;
import zio.test.TestTrace$;
import zio.test.TestTrace$Node$;
import zio.test.diff.Diff;
import zio.test.diff.DiffResult;
import zio.test.internal.OptionalImplicit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$ {
    public static final SmartAssertions$ MODULE$ = new SmartAssertions$();
    private static final TestArrow<Object, Object> anything;
    private static final TestArrow<Object, Throwable> throws;

    static {
        Function1 & Serializable make_f = (Function1 & Serializable)x$1 -> TestTrace$.MODULE$.boolean(true, ErrorMessage$.MODULE$.was().$plus("anything"));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        Object var1_1 = null;
        Object var0 = null;
        anything = new TestArrow.TestArrowF<Object, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
        Function1 & Serializable makeEither_onSucceed = (Function1 & Serializable)x$8 -> TestTrace$.MODULE$.fail("Expected failure");
        Function1 & Serializable makeEither_onFail = (Function1 & Serializable)value -> TestTrace$.MODULE$.succeed(value);
        throws = new TestArrow.TestArrowF<Object, Throwable>(arg_0 -> TestArrow$.$anonfun$makeEither$1(makeEither_onFail, makeEither_onSucceed, arg_0));
    }

    public TestArrow<Object, Object> anything() {
        return anything;
    }

    public <A> TestArrow<A, Object> approximatelyEquals(A reference, A tolerance, Numeric<A> evidence$1) {
        Function1 & Serializable make_f = (Function1 & Serializable)actual -> {
            Object max = evidence$1.plus(reference, tolerance);
            Object min = evidence$1.minus(reference, tolerance);
            boolean result = evidence$1.gteq(actual, min) && evidence$1.lteq(actual, max);
            return TestTrace$.MODULE$.boolean(result, ErrorMessage$.MODULE$.pretty(actual).$plus(ErrorMessage$.MODULE$.did()).$plus("approximately equal").$plus(ErrorMessage$.MODULE$.pretty(reference)).$plus("with a tolerance of").$plus(ErrorMessage$.MODULE$.pretty(tolerance)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, B> custom(CustomAssertion<A, B> customAssertion) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> {
            Either either = (Either)customAssertion.run().apply(a);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return TestTrace$.MODULE$.fail(error);
            }
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            throw new MatchError((Object)either);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Option<A>, A> isSome() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Some) {
                Object value = ((Some)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(x0$1)) {
                return TestTrace$.MODULE$.fail("Option was None");
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Try<A>, A> asTrySuccess() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Failure) {
                return TestTrace$.MODULE$.fail("Try was Failure");
            }
            if (x0$1 instanceof Success) {
                Object value = ((Success)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Try<A>, Throwable> asTryFailure() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Failure) {
                Throwable exception = ((Failure)x0$1).exception();
                return TestTrace$.MODULE$.succeed(exception);
            }
            if (x0$1 instanceof Success) {
                return TestTrace$.MODULE$.fail("Try was Success");
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Try<A>, Throwable>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Either<Object, A>, A> asRight() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Right) {
                Object value = ((Right)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Left) {
                return TestTrace$.MODULE$.fail("Either was Left");
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Either<A, Object>, A> asLeft() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Left) {
                Object value = ((Left)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Right) {
                return TestTrace$.MODULE$.fail("Either was Right");
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Iterable<A>, Object> isEmptyIterable() {
        Function1 & Serializable make_f = (Function1 & Serializable)as -> {
            String text_string = new StringBuilder(7).append("(size ").append(as.size()).append(")").toString();
            Object var1_1 = null;
            return TestTrace$.MODULE$.boolean(as.isEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(new ErrorMessage.Choice(text_string, text_string)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Iterable<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<String, Object> isEmptyString() {
        Function1 & Serializable make_f = (Function1 & Serializable)string -> {
            String text_string = new StringBuilder(9).append("(length ").append(string.length()).append(")").toString();
            Object var1_1 = null;
            return TestTrace$.MODULE$.boolean(string.isEmpty(), ErrorMessage$.MODULE$.pretty(string).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(new ErrorMessage.Choice(text_string, text_string)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<String, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<Iterable<Object>, Object> isNonEmptyIterable() {
        Function1 & Serializable make_f = (Function1 & Serializable)as -> {
            String choice_failure = "was";
            String choice_success = "was not";
            Object var1_2 = null;
            Object var2_1 = null;
            return TestTrace$.MODULE$.boolean(as.nonEmpty(), MODULE$.className((Iterable)as).$plus(new ErrorMessage.Choice(choice_success, choice_failure)).$plus("empty"));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Iterable<Object>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<String, Object> isNonEmptyString() {
        Function1 & Serializable make_f = (Function1 & Serializable)string -> {
            String choice_failure = "was";
            String choice_success = "was not";
            Object var1_2 = null;
            Object var2_1 = null;
            return TestTrace$.MODULE$.boolean(!string.isEmpty(), ErrorMessage$.MODULE$.pretty(string).$plus(new ErrorMessage.Choice(choice_success, choice_failure)).$plus("empty"));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<String, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<Option<Object>, Object> isEmptyOption() {
        Function1 & Serializable make_f = (Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isEmpty(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("empty"));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Option<Object>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<Option<Object>, Object> isDefinedOption() {
        Function1 & Serializable make_f = (Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.isDefined(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("defined"));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Option<Object>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Iterable<A>, Object> forallIterable(TestArrow<A, Object> predicate) {
        Function1 & Serializable make_f = (Function1 & Serializable)seq -> {
            Iterable failures = (Iterable)((Iterable)seq.map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, new Right(a)))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure($less$colon$less$.MODULE$.refl())));
            String elements = failures.size() == 1 ? "element" : "elements";
            Boolean succeed_value = failures.isEmpty();
            Object var4_4 = null;
            String text_string = new StringBuilder(21).append(elements).append(" failed the predicate").toString();
            Object var5_5 = null;
            return new TestTrace.Node<Boolean>(new Result.Succeed<Boolean>(succeed_value), ErrorMessage$.MODULE$.pretty(failures.size()).$plus(new ErrorMessage.Choice(text_string, text_string)), (Option<TestTrace<Object>>)(failures.isEmpty() ? None$.MODULE$ : new Some(failures.reduce((Function2 & Serializable)(x$3, x$4) -> {
                $less$colon$less$.MODULE$.refl();
                return new TestTrace.And((TestTrace<Object>)x$3, (TestTrace<Object>)x$4);
            }))), (Option<TestArrow.Span>)None$.MODULE$, (Option<TestArrow.Span>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, TestTrace$Node$.MODULE$.apply$default$8(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<GenFailureDetails>)None$.MODULE$);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Iterable<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Iterable<A>, Object> existsIterable(TestArrow<A, Object> predicate) {
        Function1 & Serializable make_f = (Function1 & Serializable)seq -> {
            ErrorMessage.Choice choice;
            Option result = ((IterableOnceOps)seq.view().map((Function1 & Serializable)a -> TestArrow$.MODULE$.run(predicate, new Right(a)))).find((Function1 & Serializable)tt -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$existsIterable$3(tt)));
            if (result == null) {
                throw null;
            }
            Option success = result.isEmpty() || ((TestTrace)result.get()).isSuccess($less$colon$less$.MODULE$.refl()) ? result : None$.MODULE$;
            String elements = success.isDefined() ? "element" : "elements";
            if (!result.isEmpty() && ((TestTrace)result.get()).isDie()) {
                String text_string = new StringBuilder(53).append(elements).append(" satisfied the predicate before it threw an exception").toString();
                choice = new ErrorMessage.Choice(text_string, text_string);
                Object var7_5 = null;
            } else {
                String text_string = new StringBuilder(24).append(elements).append(" satisfied the predicate").toString();
                choice = new ErrorMessage.Choice(text_string, text_string);
                Object var8_6 = null;
            }
            ErrorMessage.Choice elementsSatisfiedPredicateMsg = choice;
            Boolean succeed_value = success.isDefined();
            Object var6_8 = null;
            return new TestTrace.Node<Boolean>(new Result.Succeed<Boolean>(succeed_value), ErrorMessage$.MODULE$.pretty(Option$.MODULE$.option2Iterable(success).size()).$plus(elementsSatisfiedPredicateMsg), (Option<TestTrace<Object>>)result, (Option<TestArrow.Span>)None$.MODULE$, (Option<TestArrow.Span>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, TestTrace$Node$.MODULE$.apply$default$8(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<GenFailureDetails>)None$.MODULE$);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Iterable<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<Seq<B>, Object> containsSeq(A value) {
        Function1 & Serializable make_f = (Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.contains(value), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Seq<B>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Iterable<A>, Object> containsIterable(A value) {
        Function1 & Serializable make_f = (Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$containsIterable$2(value, x$7))), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Iterable<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E> TestArrow<Cause<E>, Object> containsCause(Cause<E> expected) {
        Function1 & Serializable make_f = (Function1 & Serializable)cause -> TestTrace$.MODULE$.boolean(cause.contains(expected), ErrorMessage$.MODULE$.pretty(cause).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(expected)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Cause<E>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Option<A>, Object> containsOption(A value) {
        Function1 & Serializable make_f = (Function1 & Serializable)option -> TestTrace$.MODULE$.boolean(option.contains(value), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Option<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<String, Object> containsString(String value) {
        Function1 & Serializable make_f = (Function1 & Serializable)str -> TestTrace$.MODULE$.boolean(str.contains(value), ErrorMessage$.MODULE$.pretty(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(value)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<String, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Seq<A>, A> hasAt(int index) {
        Function1 & Serializable make_f = (Function1 & Serializable)as -> {
            Success success;
            try {
                Object apply_r1 = as.apply(index);
                success = new Success(apply_r1);
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    success = new Failure(throwable);
                }
                throw throwable;
            }
            Object var4_2 = null;
            Object var5_4 = null;
            Option option = success.toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                String text_string = "Invalid index";
                Object var8_7 = null;
                Integer value_value = index;
                Object var6_8 = null;
                Integer value_value2 = as.length();
                Object var7_9 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Choice(text_string, text_string), new ErrorMessage.Value(value_value)).$plus("for").$plus(MODULE$.className((Iterable)as)).$plus("of size").$plus(new ErrorMessage.Value(value_value2)));
            }
            throw new MatchError((Object)option);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, B> hasField(String name, Function1<A, B> proj) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.succeed(proj.apply(a));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <K, V> TestArrow<Map<K, V>, V> hasKey(K key) {
        Function1 & Serializable make_f = (Function1 & Serializable)mapKV -> {
            Success success;
            try {
                Object apply_r1 = mapKV.apply(key);
                success = new Success(apply_r1);
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    success = new Failure(throwable);
                }
                throw throwable;
            }
            Object var4_2 = null;
            Object var5_4 = null;
            Option option = success.toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                String text_string = "Missing key";
                Object var6_7 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Choice(text_string, text_string), ErrorMessage$.MODULE$.pretty(key)));
            }
            throw new MatchError((Object)option);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Iterable<A>, A> head() {
        Function1 & Serializable make_f = (Function1 & Serializable)as -> {
            Option option = as.headOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Iterable<A>, A> last() {
        Function1 & Serializable make_f = (Function1 & Serializable)as -> {
            Option option = as.lastOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                return TestTrace$.MODULE$.fail(MODULE$.className((Iterable)as).$plus("was empty"));
            }
            throw new MatchError((Object)option);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> isEven(Integral<A> integral) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(0)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even"));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> isOdd(Integral<A> integral) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(1)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd"));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(a, that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> greaterThanL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> greaterThanOrEqualToL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> lessThanL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> lessThanOrEqualToL(B that, Ordering<B> ordering, Function1<A, B> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(conv.apply(a), that), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> greaterThanR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gt(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> greaterThanOrEqualToR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.gteq(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> lessThanR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lt(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> lessThanOrEqualToR(B that, Ordering<A> ordering, Function1<B, A> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> TestTrace$.MODULE$.boolean(ordering.lteq(a, conv.apply(that)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(that)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> {
            ErrorMessage errorMessage;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option = diff.value();
            if (option instanceof Some && !(diff = (Diff)((Some)option).value()).isLowPriority() && !result) {
                Option<String> option2;
                DiffResult diffResult = diff.diff(that, a);
                if (diffResult instanceof DiffResult.Different && None$.MODULE$.equals(option2 = ((DiffResult.Different)diffResult).customRender())) {
                    errorMessage = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that));
                } else {
                    void $plus$plus_that;
                    void $plus$plus_that2;
                    void $plus$plus_that3;
                    void $plus$plus_that4;
                    void choice_failure;
                    String string = "There was a difference";
                    String choice_success = "There was no difference";
                    Object var8_9 = null;
                    string = null;
                    String custom_string = ConsoleUtils$.MODULE$.underlined("Expected");
                    Object var10_10 = null;
                    ErrorMessage.Custom custom = new ErrorMessage.Custom(custom_string);
                    ErrorMessage.Choice $plus$plus_this = new ErrorMessage.Choice(choice_success, (String)choice_failure);
                    Object var14_12 = null;
                    custom = null;
                    String custom_string2 = PrettyPrint$.MODULE$.apply(that);
                    Object var11_13 = null;
                    ErrorMessage.Custom custom2 = new ErrorMessage.Custom(custom_string2);
                    ErrorMessage.CombineMessage $plus$plus_this2 = new ErrorMessage.CombineMessage($plus$plus_this, (ErrorMessage)$plus$plus_that4);
                    Object var16_15 = null;
                    custom2 = null;
                    String custom_string3 = new StringBuilder(0).append(ConsoleUtils$.MODULE$.underlined("Diff")).append(ansi.AnsiStringOps$.MODULE$.withAnsi$extension(" \u001b[31m-expected \u001b[32m+obtained", (ansi.AnsiCode)ansi.Style$.Faint$.MODULE$)).toString();
                    Object var12_16 = null;
                    ErrorMessage.Custom custom3 = new ErrorMessage.Custom(custom_string3);
                    ErrorMessage.CombineMessage $plus$plus_this3 = new ErrorMessage.CombineMessage($plus$plus_this2, (ErrorMessage)$plus$plus_that3);
                    Object var18_18 = null;
                    custom3 = null;
                    String custom_string4 = new StringBuilder(4).append("\u001b[0m").append(diffResult.render()).toString();
                    Object var13_19 = null;
                    ErrorMessage.Custom custom4 = new ErrorMessage.Custom(custom_string4);
                    ErrorMessage.CombineMessage $plus$plus_this4 = new ErrorMessage.CombineMessage($plus$plus_this3, (ErrorMessage)$plus$plus_that2);
                    errorMessage = new ErrorMessage.CombineMessage($plus$plus_this4, (ErrorMessage)$plus$plus_that);
                    Object var20_21 = null;
                    custom4 = null;
                }
            } else {
                errorMessage = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that));
            }
            return TestTrace$.MODULE$.boolean(result, errorMessage);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> equalToL(B that, OptionalImplicit<Diff<B>> diff, Function1<A, B> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> {
            ErrorMessage errorMessage;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option = diff.value();
            if (option instanceof Some && !(diff = (Diff)((Some)option).value()).isLowPriority() && !result) {
                Option<String> option2;
                DiffResult diffResult = diff.diff(that, conv.apply(a));
                if (diffResult instanceof DiffResult.Different && None$.MODULE$.equals(option2 = ((DiffResult.Different)diffResult).customRender())) {
                    errorMessage = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that));
                } else {
                    void $plus$plus_that;
                    void $plus$plus_that2;
                    void $plus$plus_that3;
                    void $plus$plus_that4;
                    void choice_failure;
                    String string = "There was a difference";
                    String choice_success = "There was no difference";
                    Object var9_10 = null;
                    string = null;
                    String custom_string = ConsoleUtils$.MODULE$.underlined("Expected");
                    Object var11_11 = null;
                    ErrorMessage.Custom custom = new ErrorMessage.Custom(custom_string);
                    ErrorMessage.Choice $plus$plus_this = new ErrorMessage.Choice(choice_success, (String)choice_failure);
                    Object var15_13 = null;
                    custom = null;
                    String custom_string2 = PrettyPrint$.MODULE$.apply(that);
                    Object var12_14 = null;
                    ErrorMessage.Custom custom2 = new ErrorMessage.Custom(custom_string2);
                    ErrorMessage.CombineMessage $plus$plus_this2 = new ErrorMessage.CombineMessage($plus$plus_this, (ErrorMessage)$plus$plus_that4);
                    Object var17_16 = null;
                    custom2 = null;
                    String custom_string3 = new StringBuilder(0).append(ConsoleUtils$.MODULE$.underlined("Diff")).append(ansi.AnsiStringOps$.MODULE$.withAnsi$extension(" \u001b[31m-expected \u001b[32m+obtained", (ansi.AnsiCode)ansi.Style$.Faint$.MODULE$)).toString();
                    Object var13_17 = null;
                    ErrorMessage.Custom custom3 = new ErrorMessage.Custom(custom_string3);
                    ErrorMessage.CombineMessage $plus$plus_this3 = new ErrorMessage.CombineMessage($plus$plus_this2, (ErrorMessage)$plus$plus_that3);
                    Object var19_19 = null;
                    custom3 = null;
                    String custom_string4 = new StringBuilder(4).append("\u001b[0m").append(diffResult.render()).toString();
                    Object var14_20 = null;
                    ErrorMessage.Custom custom4 = new ErrorMessage.Custom(custom_string4);
                    ErrorMessage.CombineMessage $plus$plus_this4 = new ErrorMessage.CombineMessage($plus$plus_this3, (ErrorMessage)$plus$plus_that2);
                    errorMessage = new ErrorMessage.CombineMessage($plus$plus_this4, (ErrorMessage)$plus$plus_that);
                    Object var21_22 = null;
                    custom4 = null;
                }
            } else {
                errorMessage = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that));
            }
            return TestTrace$.MODULE$.boolean(result, errorMessage);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> equalToR(B that, OptionalImplicit<Diff<A>> diff, Function1<B, A> conv) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> {
            ErrorMessage errorMessage;
            Diff diff;
            boolean result = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option = diff.value();
            if (option instanceof Some && !(diff = (Diff)((Some)option).value()).isLowPriority() && !result) {
                Option<String> option2;
                DiffResult diffResult = diff.diff(conv.apply(that), a);
                if (diffResult instanceof DiffResult.Different && None$.MODULE$.equals(option2 = ((DiffResult.Different)diffResult).customRender())) {
                    errorMessage = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that));
                } else {
                    void $plus$plus_that;
                    void $plus$plus_that2;
                    void $plus$plus_that3;
                    void $plus$plus_that4;
                    void choice_failure;
                    String string = "There was a difference";
                    String choice_success = "There was no difference";
                    Object var9_10 = null;
                    string = null;
                    String custom_string = ConsoleUtils$.MODULE$.underlined("Expected");
                    Object var11_11 = null;
                    ErrorMessage.Custom custom = new ErrorMessage.Custom(custom_string);
                    ErrorMessage.Choice $plus$plus_this = new ErrorMessage.Choice(choice_success, (String)choice_failure);
                    Object var15_13 = null;
                    custom = null;
                    String custom_string2 = PrettyPrint$.MODULE$.apply(that);
                    Object var12_14 = null;
                    ErrorMessage.Custom custom2 = new ErrorMessage.Custom(custom_string2);
                    ErrorMessage.CombineMessage $plus$plus_this2 = new ErrorMessage.CombineMessage($plus$plus_this, (ErrorMessage)$plus$plus_that4);
                    Object var17_16 = null;
                    custom2 = null;
                    String custom_string3 = new StringBuilder(0).append(ConsoleUtils$.MODULE$.underlined("Diff")).append(ansi.AnsiStringOps$.MODULE$.withAnsi$extension(" \u001b[31m-expected \u001b[32m+obtained", (ansi.AnsiCode)ansi.Style$.Faint$.MODULE$)).toString();
                    Object var13_17 = null;
                    ErrorMessage.Custom custom3 = new ErrorMessage.Custom(custom_string3);
                    ErrorMessage.CombineMessage $plus$plus_this3 = new ErrorMessage.CombineMessage($plus$plus_this2, (ErrorMessage)$plus$plus_that3);
                    Object var19_19 = null;
                    custom3 = null;
                    String custom_string4 = new StringBuilder(4).append("\u001b[0m").append(diffResult.render()).toString();
                    Object var14_20 = null;
                    ErrorMessage.Custom custom4 = new ErrorMessage.Custom(custom_string4);
                    ErrorMessage.CombineMessage $plus$plus_this4 = new ErrorMessage.CombineMessage($plus$plus_this3, (ErrorMessage)$plus$plus_that2);
                    errorMessage = new ErrorMessage.CombineMessage($plus$plus_this4, (ErrorMessage)$plus$plus_that);
                    Object var21_22 = null;
                    custom4 = null;
                }
            } else {
                errorMessage = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(that));
            }
            return TestTrace$.MODULE$.boolean(result, errorMessage);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E> TestArrow<Cause<E>, Throwable> asCauseDie() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1.dieOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(x0$1.dieOption().get());
            }
            String value_value = "Cause";
            Object var1_1 = null;
            String value_value2 = "Die";
            Object var2_2 = null;
            return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value2)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Cause<E>, Throwable>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E> TestArrow<Cause<E>, E> asCauseFailure() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1.failureOption().isDefined()) {
                return TestTrace$.MODULE$.succeed(x0$1.failureOption().get());
            }
            String value_value = "Cause";
            Object var1_1 = null;
            String value_value2 = "Fail";
            Object var2_2 = null;
            return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value2)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E> TestArrow<Cause<E>, Object> asCauseInterrupted() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1.isInterrupted()) {
                return TestTrace$.MODULE$.succeed(true);
            }
            String value_value = "Cause";
            Object var1_1 = null;
            String value_value2 = "Interrupt";
            Object var2_2 = null;
            return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value2)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Cause<E>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E, A> TestArrow<Exit<E, A>, Throwable> asExitDie() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.dieOption().isDefined()) {
                    return TestTrace$.MODULE$.succeed(cause.dieOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                String value_value = "Exit.Success";
                Object var3_3 = null;
                String value_value2 = "Cause.Die";
                Object var4_4 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.was()).$plus("a").$plus(new ErrorMessage.Value(value_value2)));
            }
            if (bl) {
                String value_value = "Exit.Failure";
                Object var5_5 = null;
                String value_value3 = "Cause.Die";
                Object var6_6 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value3)));
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Exit<E, A>, Throwable>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E> TestArrow<Exit<E, Object>, Cause<E>> asExitCause() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Failure) {
                Cause cause = ((Exit.Failure)x0$1).cause();
                return TestTrace$.MODULE$.succeed(cause);
            }
            if (x0$1 instanceof Exit.Success) {
                String value_value = "Exit.Success";
                Object var2_2 = null;
                String value_value2 = "Cause";
                Object var3_3 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value2)));
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Exit<E, Object>, Cause<E>>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E> TestArrow<Exit<E, Object>, E> asExitFailure() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                Cause cause = ((Exit.Failure)x0$1).cause();
                if (cause.failureOption().isDefined()) {
                    return TestTrace$.MODULE$.succeed(cause.failureOption().get());
                }
            }
            if (x0$1 instanceof Exit.Success) {
                String value_value = "Exit.Success";
                Object var3_3 = null;
                String value_value2 = "Failure";
                Object var4_4 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.was()).$plus("a").$plus(new ErrorMessage.Value(value_value2)));
            }
            if (bl) {
                String value_value = "Exit.Failure";
                Object var5_5 = null;
                String value_value3 = "Cause.Fail";
                Object var6_6 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value3)));
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E, A> TestArrow<Exit<E, A>, Object> asExitInterrupted() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            if (x0$1 instanceof Exit.Failure) {
                bl = true;
                if (((Exit.Failure)x0$1).cause().isInterrupted()) {
                    return TestTrace$.MODULE$.succeed(true);
                }
            }
            if (x0$1 instanceof Exit.Success) {
                String value_value = "Exit.Success";
                Object var2_2 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.was()).$plus("interrupted"));
            }
            if (bl) {
                String value_value = "Exit.Failure";
                Object var3_3 = null;
                String value_value2 = "Cause.Interrupt";
                Object var4_4 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(new ErrorMessage.Value(value_value2)));
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Exit<E, A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <E, A> TestArrow<Exit<E, A>, A> asExitSuccess() {
        Function1 & Serializable make_f = (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof Exit.Success) {
                Object value = ((Exit.Success)x0$1).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (x0$1 instanceof Exit.Failure) {
                String value_value = "Exit";
                Object var2_2 = null;
                String value_value2 = "Success";
                Object var3_3 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.was()).$plus("a").$plus(new ErrorMessage.Value(value_value2)));
            }
            throw new MatchError(x0$1);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<Object, Throwable> throws() {
        return throws;
    }

    public <A, B> TestArrow<A, B> as(ClassTag<B> CB) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> {
            Option option = CB.unapply(a);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                return TestTrace$.MODULE$.succeed(value);
            }
            if (None$.MODULE$.equals(option)) {
                String value_value = a.getClass().getSimpleName();
                Object var4_4 = null;
                String value_value2 = MODULE$.className(CB);
                Object var5_5 = null;
                return TestTrace$.MODULE$.fail(ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), "is not an instance of").$plus(new ErrorMessage.Value(value_value2)));
            }
            throw new MatchError((Object)option);
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A, B> TestArrow<A, Object> is(ClassTag<B> CB) {
        Function1 & Serializable make_f = (Function1 & Serializable)a -> {
            String value_value = a.getClass().getSimpleName();
            Object var2_2 = null;
            String value_value2 = MODULE$.className(CB);
            Object var3_3 = null;
            return TestTrace$.MODULE$.boolean(CB.unapply(a).isDefined(), ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(value_value), ErrorMessage$.MODULE$.was()).$plus("an instance of").$plus(new ErrorMessage.Value(value_value2)));
        };
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Seq<A>, Object> startsWithSeq(Seq<A> prefix) {
        Function1 & Serializable make_f = (Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.startsWith((IterableOnce)prefix, seq.startsWith$default$2()), ErrorMessage$.MODULE$.pretty(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.pretty(prefix)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Seq<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<String, Object> startsWithString(String prefix) {
        Function1 & Serializable make_f = (Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.startsWith(prefix), ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(string), ErrorMessage$.MODULE$.did()).$plus("start with").$plus(new ErrorMessage.Value(prefix)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<String, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public <A> TestArrow<Seq<A>, Object> endsWithSeq(Seq<A> postfix) {
        Function1 & Serializable make_f = (Function1 & Serializable)seq -> TestTrace$.MODULE$.boolean(seq.endsWith((Iterable)postfix), ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(seq), ErrorMessage$.MODULE$.did()).$plus("end with").$plus(new ErrorMessage.Value(seq)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<Seq<A>, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    public TestArrow<String, Object> endsWithString(String postfix) {
        Function1 & Serializable make_f = (Function1 & Serializable)string -> TestTrace$.MODULE$.boolean(string.endsWith(postfix), ErrorMessage.$plus$((ErrorMessage)new ErrorMessage.Value(string), ErrorMessage$.MODULE$.did()).$plus("end with").$plus(new ErrorMessage.Value(postfix)));
        Function1 & Serializable make_makeEither_onFail = TestArrow$::$anonfun$make$1;
        return new TestArrow.TestArrowF<String, Object>(arg_0 -> TestArrow$.$anonfun$makeEither$1(make_makeEither_onFail, make_f, arg_0));
    }

    private <A> String className(ClassTag<A> C) {
        try {
            return C.runtimeClass().getSimpleName();
        }
        catch (Throwable throwable) {
            if (throwable instanceof InternalError) {
                String string = ((InternalError)throwable).getMessage();
                String string2 = "Malformed class name";
                if (string != null && string.equals(string2)) {
                    return C.runtimeClass().getName();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <A> ErrorMessage className(Iterable<A> a) {
        String string;
        int n;
        void takeWhile$extension_$this;
        block4: {
            Object var2_2;
            String augmentString_x = a.toString();
            void v0 = var2_2;
            var2_2 = null;
            takeWhile$extension_$this = v0;
            int takeWhile$extension_indexWhere$extension_from = 0;
            int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
            for (int takeWhile$extension_indexWhere$extension_i = takeWhile$extension_indexWhere$extension_from; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                if (!(!SmartAssertions$.$anonfun$className$1(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))) continue;
                n = takeWhile$extension_indexWhere$extension_i;
                break block4;
            }
            n = -1;
        }
        int n2 = n;
        switch (n2) {
            case -1: {
                string = takeWhile$extension_$this;
                break;
            }
            default: {
                string = takeWhile$extension_$this.substring(0, n2);
            }
        }
        Object var3_3 = null;
        String value_value = string;
        return new ErrorMessage.Value(value_value);
    }

    /*
     * WARNING - void declaration
     */
    private <A> ErrorMessage className(Option<A> a) {
        String string;
        int n;
        void takeWhile$extension_$this;
        block4: {
            Object var2_2;
            String augmentString_x = a.toString();
            void v0 = var2_2;
            var2_2 = null;
            takeWhile$extension_$this = v0;
            int takeWhile$extension_indexWhere$extension_from = 0;
            int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
            for (int takeWhile$extension_indexWhere$extension_i = takeWhile$extension_indexWhere$extension_from; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                if (!(!SmartAssertions$.$anonfun$className$2(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))) continue;
                n = takeWhile$extension_indexWhere$extension_i;
                break block4;
            }
            n = -1;
        }
        int n2 = n;
        switch (n2) {
            case -1: {
                string = takeWhile$extension_$this;
                break;
            }
            default: {
                string = takeWhile$extension_$this.substring(0, n2);
            }
        }
        Object var3_3 = null;
        String value_value = string;
        return new ErrorMessage.Value(value_value);
    }

    public static final /* synthetic */ boolean $anonfun$existsIterable$3(TestTrace tt) {
        return tt.isSuccess($less$colon$less$.MODULE$.refl()) || tt.isDie();
    }

    public static final /* synthetic */ boolean $anonfun$containsIterable$2(Object value$2, Object x$7) {
        return BoxesRunTime.equals((Object)x$7, (Object)value$2);
    }

    public static final /* synthetic */ Object $anonfun$hasAt$2(Seq as$1, int index$1) {
        return as$1.apply(index$1);
    }

    public static final /* synthetic */ Object $anonfun$hasKey$2(Map mapKV$1, Object key$1) {
        return mapKV$1.apply(key$1);
    }

    public static final /* synthetic */ boolean $anonfun$className$1(char x$9) {
        return x$9 != '(';
    }

    public static final /* synthetic */ boolean $anonfun$className$2(char x$10) {
        return x$10 != '(';
    }

    private SmartAssertions$() {
    }

    public static final /* synthetic */ Object $anonfun$className$1$adapted(Object x$9) {
        return BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$1(BoxesRunTime.unboxToChar((Object)x$9)));
    }

    public static final /* synthetic */ Object $anonfun$className$2$adapted(Object x$10) {
        return BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$2(BoxesRunTime.unboxToChar((Object)x$10)));
    }

    public static final /* synthetic */ Object $anonfun$existsIterable$4$adapted(TestTrace x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.isSuccess($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Object $anonfun$existsIterable$5$adapted(TestTrace x$6) {
        return BoxesRunTime.boxToBoolean((boolean)x$6.isDie());
    }
}

